/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.ws;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.transport.http.CommonsTransportHeaders;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.KerberosConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.jaggeryjs.hostobjects.ws.PasswordCallbackHandler;
import org.jaggeryjs.hostobjects.ws.WSRequestCallback;
import org.jaggeryjs.hostobjects.ws.WebServiceErrorHostObject;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.w3c.dom.Document;
import org.wso2.javascript.xmlimpl.QName;
import org.wso2.javascript.xmlimpl.XML;

public class WSRequestHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(WSRequestHostObject.class);
    private static final long serialVersionUID = -4540679471306518117L;
    private static final String IN_OUT = "in-out";
    private static final String IN_ONLY = "in-only";
    private static final String CLIENT_REPOSITORY_LOCATION = "Axis2Config.ClientRepositoryLocation";
    private static final String CLIENT_AXIS2_XML_LOCATION = "Axis2Config.clientAxis2XmlLocation";
    private static final String RAMPART = "rampart";
    private static final String ADDRESSING = "addressing";
    String responseText = null;
    Scriptable responseXML = null;
    int readyState = 0;
    Function onReadyStateChangeFunction;
    private Context context;
    private boolean async = true;
    private ServiceClient sender = null;
    WebServiceErrorHostObject error = null;
    private boolean wsdlMode = false;
    private String targetNamespace;
    private String mep = "in-out";
    private NativeArray soapHeaders = null;
    private NativeArray httpHeaders = null;
    private NativeObject rampartConfig = null;
    private XML policy = null;
    private CommonsTransportHeaders transportHeaders = null;
    private static ConfigurationContext configurationContext = null;

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        WSRequestHostObject wsRequest = new WSRequestHostObject();
        wsRequest.context = cx;
        return wsRequest;
    }

    public String getClassName() {
        return "WSRequest";
    }

    public static void jsFunction_open(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        WSRequestHostObject wsRequest = WSRequestHostObject.checkInstance(thisObj);
        if (wsRequest.readyState > 0 && wsRequest.readyState < 4) {
            throw new ScriptException("Invalid readyState for WSRequest Hostobject : " + wsRequest.readyState);
        }
        if (wsRequest.readyState == 4) {
            wsRequest.reset();
        }
        try {
            wsRequest.sender = new ServiceClient(configurationContext, null);
        }
        catch (Exception axisFault) {
            log.error((Object)"Error creating ServiceClient for WSRequest Hostobject", (Throwable)axisFault);
            throw new ScriptException(axisFault);
        }
        WSRequestHostObject.setCommonProperties(cx, wsRequest, arguments, WSRequestHostObject.setOptionsOpen(wsRequest, arguments));
    }

    public static void jsFunction_openWSDL(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        WSRequestHostObject wsRequest = WSRequestHostObject.checkInstance(thisObj);
        if (wsRequest.readyState > 0 && wsRequest.readyState < 4) {
            throw new ScriptException("Invalid readyState for WSRequest Hostobject : " + wsRequest.readyState);
        }
        if (wsRequest.readyState == 4) {
            wsRequest.reset();
        }
        wsRequest.wsdlMode = true;
        WSRequestHostObject.setCommonProperties(cx, wsRequest, arguments, WSRequestHostObject.setOptionsOpenWSDL(wsRequest, arguments));
    }

    private static String getBaseURI(String currentURI) {
        try {
            File file = new File(currentURI);
            if (file.exists()) {
                return file.getCanonicalFile().getParentFile().toURI().toString();
            }
            String uriFragment = currentURI.substring(0, currentURI.lastIndexOf("/"));
            return uriFragment + (uriFragment.endsWith("/") ? "" : "/");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void jsFunction_send(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException, AxisFault {
        String message;
        Object payload;
        WSRequestHostObject wsRequest = (WSRequestHostObject)thisObj;
        javax.xml.namespace.QName operationName = ServiceClient.ANON_OUT_IN_OP;
        if (wsRequest.wsdlMode && arguments.length != 2) {
            throw new ScriptException("When the openWSDL method of WSRequest is used the send function should be called with 2 parameters. The operation to invoke and the payload");
        }
        if (arguments.length == 1) {
            payload = arguments[0];
        } else if (arguments.length == 2) {
            if (arguments[0] instanceof QName) {
                QName qName = (QName)arguments[0];
                String uri = (String)qName.get("uri", (Scriptable)qName);
                String localName = (String)qName.get("localName", (Scriptable)qName);
                operationName = new javax.xml.namespace.QName(uri, localName);
            } else if (arguments[0] instanceof String) {
                if (wsRequest.targetNamespace == null) {
                    throw new ScriptException("The targetNamespace of the service is null, please specify a QName for the operation name");
                }
                String localName = (String)arguments[0];
                operationName = new javax.xml.namespace.QName(wsRequest.targetNamespace, localName);
            } else {
                throw new ScriptException("Invalid parameter type for the WSRequest.send() method");
            }
            payload = arguments[1];
        } else {
            throw new ScriptException("Invalid no. of parameters for the WSRequest.send() method");
        }
        OMElement payloadElement = null;
        if (wsRequest.readyState != 1) {
            throw new ScriptException("Invalid readyState for the WSRequest Hostobject : " + wsRequest.readyState);
        }
        if (payload instanceof String) {
            try {
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader((String)payload));
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                payloadElement = builder.getDocumentElement();
            }
            catch (Exception e) {
                message = "Invalid input for the payload in WSRequest Hostobject : " + payload;
                log.error((Object)message, (Throwable)e);
                throw new ScriptException(message, e);
            }
        }
        if (payload instanceof XML) {
            try {
                OMNode node = ((XML)payload).getAxiomFromXML();
                if (!(node instanceof OMElement)) {
                    throw new ScriptException("Invalid input for the payload in WSRequest Hostobject : " + payload);
                }
                payloadElement = (OMElement)node;
            }
            catch (Exception e) {
                message = "Invalid input for the payload in WSRequest Hostobject : " + payload;
                log.error((Object)message, (Throwable)e);
                throw new ScriptException(message, e);
            }
        }
        try {
            if (wsRequest.async) {
                WSRequestCallback callback = new WSRequestCallback(wsRequest);
                WSRequestHostObject.setRampartConfigs(wsRequest, operationName);
                if (wsRequest.wsdlMode) {
                    if (IN_ONLY.equalsIgnoreCase(wsRequest.mep)) {
                        wsRequest.sender.fireAndForget(operationName, payloadElement);
                        wsRequest.readyState = 4;
                    } else {
                        wsRequest.sender.sendReceiveNonBlocking(operationName, payloadElement, (AxisCallback)callback);
                        wsRequest.readyState = 2;
                    }
                } else if (IN_ONLY.equalsIgnoreCase(wsRequest.mep)) {
                    wsRequest.sender.fireAndForget(payloadElement);
                    wsRequest.readyState = 4;
                } else {
                    wsRequest.sender.sendReceiveNonBlocking(payloadElement, (AxisCallback)callback);
                    wsRequest.readyState = 2;
                }
            } else {
                wsRequest.readyState = 2;
                WSRequestHostObject.setRampartConfigs(wsRequest, operationName);
                if (wsRequest.wsdlMode) {
                    if (IN_ONLY.equalsIgnoreCase(wsRequest.mep)) {
                        wsRequest.sender.fireAndForget(operationName, payloadElement);
                    } else {
                        wsRequest.updateResponse(wsRequest.sender.sendReceive(operationName, payloadElement));
                    }
                    wsRequest.readyState = 4;
                } else {
                    if (IN_ONLY.equalsIgnoreCase(wsRequest.mep)) {
                        wsRequest.sender.fireAndForget(payloadElement);
                    } else {
                        wsRequest.updateResponse(wsRequest.sender.sendReceive(operationName, payloadElement));
                        wsRequest.transportHeaders = (CommonsTransportHeaders)wsRequest.sender.getLastOperationContext().getMessageContext("In").getProperty("TRANSPORT_HEADERS");
                    }
                    wsRequest.readyState = 4;
                }
            }
            if (wsRequest.onReadyStateChangeFunction != null) {
                wsRequest.onReadyStateChangeFunction.call(cx, (Scriptable)wsRequest, (Scriptable)wsRequest, new Object[0]);
            }
        }
        catch (AxisFault e) {
            javax.xml.namespace.QName faultCode;
            wsRequest.error = new WebServiceErrorHostObject();
            OMElement detail = e.getDetail();
            if (detail != null) {
                wsRequest.error.jsSet_detail(detail.toString());
            }
            if ((faultCode = e.getFaultCode()) != null) {
                wsRequest.error.jsSet_code(faultCode.toString());
            }
            wsRequest.error.jsSet_reason(e.getReason());
            String message2 = "Error occured while invoking the service";
            log.error((Object)message2, (Throwable)e);
            throw new ScriptException(message2, (Exception)((Object)e));
        }
        catch (Exception e) {
            wsRequest.error = new WebServiceErrorHostObject();
            wsRequest.error.jsSet_detail(e.getMessage());
            message = "Error occured while invoking the service";
            log.error((Object)message, (Throwable)e);
            throw new ScriptException(message, e);
        }
        finally {
            wsRequest.sender.cleanupTransport();
        }
    }

    public String jsGet_responseText() {
        return this.responseText;
    }

    protected void updateResponse(OMElement response) {
        if (response instanceof OMSourcedElementImpl) {
            OMSourcedElementImpl sourcedElement = (OMSourcedElementImpl)response;
            this.setJSONAsXML(sourcedElement);
        } else if (response != null) {
            Object[] objects = new Object[]{response};
            this.responseXML = this.context.newObject((Scriptable)this, "XML", objects);
            this.responseText = response.toString();
        }
    }

    public static String jsFunction_getResponseHeader(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        WSRequestHostObject wsRequest = (WSRequestHostObject)thisObj;
        if (arguments.length != 1) {
            throw new ScriptException("invalid number of arguments");
        }
        return (String)wsRequest.transportHeaders.get((Object)((String)arguments[0]));
    }

    private void setJSONAsXML(OMSourcedElementImpl response) {
        if (response.getDataSource() != null) {
            try {
                String jsonString;
                this.responseText = jsonString = response.toStringWithConsume();
                while (jsonString.indexOf("<?") == 0) {
                    jsonString = jsonString.substring(jsonString.indexOf("?>") + 2);
                }
                Object[] objects = new Object[]{jsonString};
                this.responseXML = this.context.newObject((Scriptable)this, "XML", objects);
            }
            catch (XMLStreamException e) {
                String message = "Error while converting JSON into XML";
                log.error((Object)message, (Throwable)e);
            }
        }
    }

    public Scriptable jsGet_responseE4X() throws ScriptException {
        return this.responseXML;
    }

    public Scriptable jsGet_responseXML() throws ScriptException {
        return this.responseXML;
    }

    public Scriptable jsGet_onreadystatechange() {
        return this.onReadyStateChangeFunction;
    }

    public void jsSet_onreadystatechange(Function function) {
        this.onReadyStateChangeFunction = function;
    }

    public int jsGet_readyState() {
        return this.readyState;
    }

    public Scriptable jsGet_error() {
        if (this.error != null) {
            Object[] objects = new Object[]{this.error};
            return this.context.newObject((Scriptable)this, "WebServiceError", objects);
        }
        return null;
    }

    private void reset() {
        this.async = true;
        this.sender = null;
        this.readyState = 0;
    }

    private static WSRequestHostObject checkInstance(Scriptable obj) {
        if (obj == null || !(obj instanceof WSRequestHostObject)) {
            throw Context.reportRuntimeError((String)"called on incompatible object");
        }
        return (WSRequestHostObject)obj;
    }

    private static void setCommonProperties(Context cx, WSRequestHostObject wsRequest, Object[] args, NativeArray optionsArray) throws ScriptException {
        Options options;
        wsRequest.responseText = null;
        wsRequest.responseXML = null;
        wsRequest.error = null;
        wsRequest.readyState = 1;
        if (wsRequest.onReadyStateChangeFunction != null) {
            wsRequest.onReadyStateChangeFunction.call(cx, (Scriptable)wsRequest, (Scriptable)wsRequest, new Object[0]);
        }
        if ((options = wsRequest.sender.getOptions()) == null) {
            options = new Options();
        }
        int timeout = 60000;
        if (optionsArray != null) {
            Object policyObject;
            Object rampartConfigObject;
            Object httpHeadersObject;
            Object soapHeadersObject;
            Object timeoutObject;
            Object mepObject = optionsArray.get("mep", (Scriptable)optionsArray);
            if (mepObject != null && !(mepObject instanceof Undefined) && !(mepObject instanceof UniqueTag)) {
                String mepValue = mepObject.toString();
                if (IN_OUT.equalsIgnoreCase(mepValue) || IN_ONLY.equalsIgnoreCase(mepValue)) {
                    wsRequest.mep = mepValue;
                } else {
                    throw new ScriptException("Invalid value for mep. Supported values are in-out and in-only");
                }
            }
            if ((timeoutObject = optionsArray.get("timeout", (Scriptable)optionsArray)) != null && !(timeoutObject instanceof Undefined) && !(timeoutObject instanceof UniqueTag)) {
                timeout = Integer.parseInt(timeoutObject.toString());
            }
            if ((soapHeadersObject = optionsArray.get("SOAPHeaders", (Scriptable)optionsArray)) != null && !(soapHeadersObject instanceof Undefined) && !(soapHeadersObject instanceof UniqueTag) && soapHeadersObject instanceof NativeArray) {
                wsRequest.soapHeaders = (NativeArray)soapHeadersObject;
            }
            if ((httpHeadersObject = optionsArray.get("HTTPHeaders", (Scriptable)optionsArray)) != null && !(httpHeadersObject instanceof Undefined) && !(httpHeadersObject instanceof UniqueTag) && httpHeadersObject instanceof NativeArray) {
                wsRequest.httpHeaders = (NativeArray)httpHeadersObject;
            }
            if ((rampartConfigObject = optionsArray.get(RAMPART, (Scriptable)optionsArray)) != null && !(rampartConfigObject instanceof Undefined) && !(rampartConfigObject instanceof UniqueTag) && rampartConfigObject instanceof NativeObject) {
                wsRequest.rampartConfig = (NativeObject)rampartConfigObject;
            }
            if ((policyObject = optionsArray.get("policy", (Scriptable)optionsArray)) != null && !(policyObject instanceof Undefined) && !(policyObject instanceof UniqueTag) && policyObject instanceof XML) {
                wsRequest.policy = (XML)policyObject;
            }
        }
        options.setProperty("SO_TIMEOUT", (Object)timeout);
        options.setProperty("CONNECTION_TIMEOUT", (Object)timeout);
        if (wsRequest.httpHeaders != null) {
            ArrayList<Header> httpHeaders = new ArrayList<Header>();
            String msg = "Invalid declaration for HTTPHeaders property";
            int i = 0;
            while ((long)i < wsRequest.httpHeaders.getLength()) {
                NativeObject headerObject;
                if (wsRequest.httpHeaders.get(i, (Scriptable)wsRequest.httpHeaders) instanceof NativeObject) {
                    headerObject = (NativeObject)wsRequest.httpHeaders.get(i, (Scriptable)wsRequest.httpHeaders);
                    if (!(headerObject.get("name", (Scriptable)headerObject) instanceof String) || !(headerObject.get("value", (Scriptable)headerObject) instanceof String)) {
                        log.error((Object)msg);
                        throw new ScriptException(msg);
                    }
                } else {
                    log.error((Object)msg);
                    throw new ScriptException(msg);
                }
                httpHeaders.add(new Header((String)headerObject.get("name", (Scriptable)headerObject), (String)headerObject.get("value", (Scriptable)headerObject)));
                ++i;
            }
            options.setProperty("HTTP_HEADERS", httpHeaders);
        }
        if (wsRequest.soapHeaders != null) {
            int i = 0;
            while ((long)i < wsRequest.soapHeaders.getLength()) {
                Object soapHeaderObject = wsRequest.soapHeaders.get(i, (Scriptable)wsRequest.soapHeaders);
                if (soapHeaderObject instanceof String) {
                    String header = (String)soapHeaderObject;
                    try {
                        OMElement soapHeaderOM = AXIOMUtil.stringToOM((String)header);
                        wsRequest.sender.addHeader(soapHeaderOM);
                    }
                    catch (XMLStreamException e) {
                        String message = "Error creating XML from the soap header : " + header;
                        log.error((Object)message, (Throwable)e);
                        throw new ScriptException(message, (Exception)e);
                    }
                } else if (soapHeaderObject instanceof XML) {
                    wsRequest.sender.addHeader((OMElement)((XML)soapHeaderObject).getAxiomFromXML());
                } else if (soapHeaderObject instanceof NativeObject) {
                    NativeObject soapHeader = (NativeObject)soapHeaderObject;
                    if (!(soapHeader.get("qName", (Scriptable)soapHeader) instanceof QName)) {
                        throw new ScriptException("No qName property found for the soap headers");
                    }
                    QName qName = (QName)soapHeader.get("qName", (Scriptable)soapHeader);
                    String uri = (String)qName.get("uri", (Scriptable)qName);
                    String localName = (String)qName.get("localName", (Scriptable)qName);
                    if (soapHeader.get("value", (Scriptable)soapHeader) instanceof String) {
                        try {
                            wsRequest.sender.addStringHeader(new javax.xml.namespace.QName(uri, localName), (String)soapHeader.get("value", (Scriptable)soapHeader));
                        }
                        catch (AxisFault e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                            throw new ScriptException((Exception)((Object)e));
                        }
                    } else if (soapHeader.get("value", (Scriptable)soapHeader) instanceof XML) {
                        OMNamespace omNamespace = OMAbstractFactory.getOMFactory().createOMNamespace(uri, null);
                        SOAPHeaderBlock headerBlock = OMAbstractFactory.getSOAP12Factory().createSOAPHeaderBlock(localName, omNamespace);
                        headerBlock.addChild(((XML)soapHeader.get("value", (Scriptable)soapHeader)).getAxiomFromXML());
                        wsRequest.sender.addHeader(headerBlock);
                    } else {
                        throw new ScriptException("Invalid property found for the soap headers");
                    }
                }
                ++i;
            }
        }
    }

    private static NativeArray setOptionsOpen(WSRequestHostObject wsRequest, Object[] args) throws ScriptException {
        NativeArray optionsArray = null;
        Options options = wsRequest.sender.getOptions();
        String httpMethod = "post";
        String useSOAP = "true";
        String useWSA = null;
        String action = null;
        String username = null;
        String password = null;
        String httpLocation = null;
        String httpLocationIgnoreUncited = null;
        String httpQueryParameterSeparator = "&";
        String httpInputSerialization = null;
        String httpContentEncoding = null;
        switch (args.length) {
            case 0: {
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
            }
            case 1: {
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
            }
            case 2: {
                break;
            }
            case 3: {
                if (args[2] instanceof Boolean) {
                    wsRequest.async = (Boolean)args[2];
                    break;
                }
                if (args[2] instanceof String) {
                    username = (String)args[2];
                    break;
                }
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
            }
            case 4: {
                if (args[2] instanceof String) {
                    username = (String)args[2];
                    if (args[3] instanceof String) {
                        password = (String)args[3];
                        break;
                    }
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                if (args[2] instanceof Boolean) {
                    wsRequest.async = (Boolean)args[2];
                    if (args[3] instanceof String) {
                        username = (String)args[3];
                        break;
                    }
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
            }
            case 5: {
                if (!(args[2] instanceof Boolean)) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                wsRequest.async = (Boolean)args[2];
                if (!(args[3] instanceof String)) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                username = (String)args[3];
                if (args[4] instanceof String) {
                    password = (String)args[4];
                    break;
                }
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
            }
            default: {
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
            }
        }
        if (!(args[1] instanceof String)) {
            throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
        }
        String url = (String)args[1];
        if (args[0] instanceof String) {
            httpMethod = (String)args[0];
            useSOAP = "false";
        } else if (args[0] instanceof NativeArray) {
            Object HTTPContentEncodingObject;
            Object httpInputSerializationObject;
            Object httpQueryParameterSeparatorObject;
            Object httpLocationIgnoreUncitedObject;
            Object httpLocationObject;
            Object actionObject;
            Object hTTPMethodObject;
            Object useWSAObject;
            optionsArray = (NativeArray)args[0];
            Object useSOAPObject = optionsArray.get("useSOAP", (Scriptable)optionsArray);
            if (useSOAPObject != null && !(useSOAPObject instanceof Undefined) && !(useSOAPObject instanceof UniqueTag)) {
                useSOAP = useSOAPObject.toString();
            }
            if ((useWSAObject = optionsArray.get("useWSA", (Scriptable)optionsArray)) != null && !(useWSAObject instanceof Undefined) && !(useWSAObject instanceof UniqueTag)) {
                useWSA = useWSAObject.toString();
            }
            if ((hTTPMethodObject = optionsArray.get("HTTPMethod", (Scriptable)optionsArray)) != null && !(hTTPMethodObject instanceof Undefined) && !(hTTPMethodObject instanceof UniqueTag)) {
                httpMethod = hTTPMethodObject.toString();
            }
            if ((actionObject = optionsArray.get("action", (Scriptable)optionsArray)) != null && !(actionObject instanceof Undefined) && !(actionObject instanceof UniqueTag)) {
                action = actionObject.toString();
            }
            if ((httpLocationObject = optionsArray.get("HTTPLocation", (Scriptable)optionsArray)) != null && !(httpLocationObject instanceof Undefined) && !(httpLocationObject instanceof UniqueTag)) {
                httpLocation = httpLocationObject.toString();
            }
            if ((httpLocationIgnoreUncitedObject = optionsArray.get("HTTPLocationIgnoreUncited", (Scriptable)optionsArray)) != null && !(httpLocationIgnoreUncitedObject instanceof Undefined) && !(httpLocationIgnoreUncitedObject instanceof UniqueTag)) {
                httpLocationIgnoreUncited = httpLocationIgnoreUncitedObject.toString();
            }
            if ((httpQueryParameterSeparatorObject = optionsArray.get("HTTPQueryParameterSeparator", (Scriptable)optionsArray)) != null && !(httpQueryParameterSeparatorObject instanceof Undefined) && !(httpQueryParameterSeparatorObject instanceof UniqueTag)) {
                httpQueryParameterSeparator = httpQueryParameterSeparatorObject.toString();
            }
            if ((httpInputSerializationObject = optionsArray.get("HTTPInputSerialization", (Scriptable)optionsArray)) != null && !(httpInputSerializationObject instanceof Undefined) && !(httpInputSerializationObject instanceof UniqueTag)) {
                httpInputSerialization = httpInputSerializationObject.toString();
            }
            if ((HTTPContentEncodingObject = optionsArray.get("HTTPContentEncoding", (Scriptable)optionsArray)) != null && !(HTTPContentEncodingObject instanceof Undefined) && !(HTTPContentEncodingObject instanceof UniqueTag)) {
                httpContentEncoding = HTTPContentEncodingObject.toString();
            }
        }
        options.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        options.setProperty("COOKIE_POLICY", (Object)"ignoreCookies");
        EndpointReference targetEPR = new EndpointReference(url);
        options.setTo(targetEPR);
        if (username != null) {
            HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
            authenticator.setUsername(username);
            if (password != null) {
                authenticator.setPassword(password);
            }
            authenticator.setPreemptiveAuthentication(true);
            options.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
        }
        if (useSOAP.equalsIgnoreCase("1.1")) {
            options.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        } else if (useSOAP.equalsIgnoreCase("1.2") || useSOAP.equalsIgnoreCase("true")) {
            options.setSoapVersionURI("http://www.w3.org/2003/05/soap-envelope");
        } else if (useSOAP.equalsIgnoreCase("false")) {
            options.setProperty("enableREST", (Object)"true");
        } else {
            throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
        }
        if (httpMethod != null) {
            if (httpMethod.equalsIgnoreCase("GET")) {
                if (!useSOAP.equalsIgnoreCase("false")) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION. Cannot have the value of useSOAP true, when the HTTPMethod is 'GET'");
                }
                options.setProperty("HTTP_METHOD", (Object)"GET");
                options.setProperty("enableREST", (Object)"true");
            } else if (httpMethod.equalsIgnoreCase("POST")) {
                options.setProperty("HTTP_METHOD", (Object)"POST");
            } else if (httpMethod.equalsIgnoreCase("DELETE")) {
                if (!useSOAP.equalsIgnoreCase("false")) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION. Cannot have the value of useSOAP true, when the HTTPMethod is 'DELETE'");
                }
                options.setProperty("HTTP_METHOD", (Object)"DELETE");
                options.setProperty("enableREST", (Object)"true");
            } else if (httpMethod.equalsIgnoreCase("PUT")) {
                if (!useSOAP.equalsIgnoreCase("false")) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION. Cannot have the value of useSOAP true, when the HTTPMethod is 'PUT'");
                }
                options.setProperty("HTTP_METHOD", (Object)"PUT");
                options.setProperty("enableREST", (Object)"true");
            } else {
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION. Unsupported HTTP method.");
            }
        }
        if (httpLocation != null) {
            options.setProperty("whttp:location", httpLocation);
        }
        if (httpLocationIgnoreUncited != null) {
            options.setProperty("whttp:ignoreUncited", (Object)JavaUtils.isTrueExplicitly(httpLocationIgnoreUncited));
        }
        if (httpQueryParameterSeparator != null) {
            options.setProperty("whttp:queryParameterSeparator", (Object)httpQueryParameterSeparator);
        }
        if (httpInputSerialization != null) {
            options.setProperty("whttp:inputSerialization", httpInputSerialization);
            options.setProperty("messageType", httpInputSerialization);
        }
        if (httpContentEncoding != null && ("gzip".equals(httpContentEncoding) || "compress".equals(httpContentEncoding))) {
            options.setProperty("HTTPConstants.MC_GZIP_REQUEST", (Object)"true");
        }
        if (useWSA != null && (useWSA.equalsIgnoreCase("1.0") || useWSA.equalsIgnoreCase("true") || useWSA.equalsIgnoreCase("submission"))) {
            if (useWSA.equalsIgnoreCase("submission")) {
                options.setProperty("WSAddressingVersion", (Object)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
            } else {
                options.setProperty("WSAddressingVersion", (Object)"http://www.w3.org/2005/08/addressing");
            }
            if (action != null) {
                try {
                    wsRequest.sender.engageModule(ADDRESSING);
                }
                catch (AxisFault axisFault) {
                    throw new ScriptException((Exception)((Object)axisFault));
                }
            } else {
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION. Action is NULL when useWSA is true.");
            }
            options.setAction(action);
            if (optionsArray != null) {
                Object faultToObject;
                Object replyToObject;
                Object fromObject = optionsArray.get("from", (Scriptable)optionsArray);
                if (fromObject != null && !(fromObject instanceof Undefined) && !(fromObject instanceof UniqueTag)) {
                    options.setFrom(new EndpointReference(fromObject.toString()));
                }
                if ((replyToObject = optionsArray.get("replyTo", (Scriptable)optionsArray)) != null && !(replyToObject instanceof Undefined) && !(replyToObject instanceof UniqueTag)) {
                    options.setReplyTo(new EndpointReference(replyToObject.toString()));
                }
                if ((faultToObject = optionsArray.get("faultTo", (Scriptable)optionsArray)) != null && !(faultToObject instanceof Undefined) && !(faultToObject instanceof UniqueTag)) {
                    options.setFaultTo(new EndpointReference(faultToObject.toString()));
                }
            }
        } else {
            wsRequest.sender.disengageModule(ADDRESSING);
            if (action != null) {
                options.setProperty("disableSoapAction", (Object)"false");
                options.setAction(action);
            }
        }
        return optionsArray;
    }

    private static NativeArray setOptionsOpenWSDL(WSRequestHostObject wsRequest, Object[] args) throws ScriptException {
        String message;
        String wsdlURL;
        NativeArray optionsArray = null;
        javax.xml.namespace.QName serviceQName = null;
        String endpointName = null;
        switch (args.length) {
            case 0: {
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
            }
            case 1: {
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
            }
            case 2: {
                if (!(args[0] instanceof String)) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                wsdlURL = (String)args[0];
                if (args[1] instanceof Boolean) {
                    wsRequest.async = (Boolean)args[1];
                    break;
                }
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
            }
            case 3: {
                if (!(args[0] instanceof String)) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                wsdlURL = (String)args[0];
                if (!(args[1] instanceof Boolean)) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                wsRequest.async = (Boolean)args[1];
                if (args[2] instanceof NativeArray) {
                    optionsArray = (NativeArray)args[2];
                    break;
                }
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
            }
            case 5: {
                if (!(args[0] instanceof String)) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                wsdlURL = (String)args[0];
                if (!(args[1] instanceof Boolean)) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                wsRequest.async = (Boolean)args[1];
                if (!(args[2] instanceof NativeArray)) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                optionsArray = (NativeArray)args[2];
                if (!(args[3] instanceof QName)) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                QName qName = (QName)args[3];
                String uri = (String)qName.get("uri", (Scriptable)qName);
                String localName = (String)qName.get("localName", (Scriptable)qName);
                serviceQName = new javax.xml.namespace.QName(uri, localName);
                if (!(args[4] instanceof String)) {
                    throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
                }
                endpointName = (String)args[4];
                wsRequest.wsdlMode = true;
                break;
            }
            default: {
                throw Context.reportRuntimeError((String)"INVALID_SYNTAX_EXCEPTION");
            }
        }
        GetMethod method = new GetMethod(wsdlURL);
        try {
            int statusCode = HostObjectUtil.getURL((String)wsdlURL, null, null);
            if (statusCode != 200) {
                throw new ScriptException("An error occured while getting the resource at " + wsdlURL + ". Reason :" + method.getStatusLine());
            }
            Document doc = XMLUtils.newDocument((InputStream)method.getResponseBodyAsStream());
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            Definition definition = reader.readWSDL(WSRequestHostObject.getBaseURI(wsdlURL), doc);
            wsRequest.targetNamespace = definition.getTargetNamespace();
            if (serviceQName == null) {
                Port port;
                Object o;
                Map services = definition.getServices();
                Service service = null;
                Iterator i$ = services.values().iterator();
                while (i$.hasNext() && (service = (Service)(o = i$.next())).getPorts().size() <= 0) {
                }
                if (service == null) {
                    throw Context.reportRuntimeError((String)"The WSDL given does not contain any services that has ports");
                }
                Map ports = service.getPorts();
                Port returnPort = null;
                Iterator portsIterator = ports.values().iterator();
                block14: while (portsIterator.hasNext() && returnPort == null) {
                    port = (Port)portsIterator.next();
                    List extensibilityElements = port.getExtensibilityElements();
                    for (Object extElement : extensibilityElements) {
                        if (!(extElement instanceof SOAPAddress)) continue;
                        returnPort = port;
                        String location = ((SOAPAddress)extElement).getLocationURI().trim();
                        if (location == null || !location.startsWith("http:")) continue;
                        continue block14;
                    }
                }
                if (returnPort == null) {
                    String location;
                    List extensibilityElements;
                    block16: for (Object o2 : ports.values()) {
                        port = (Port)o2;
                        extensibilityElements = port.getExtensibilityElements();
                        for (Object extElement : extensibilityElements) {
                            if (!(extElement instanceof SOAP12Address)) continue;
                            returnPort = port;
                            location = ((SOAP12Address)extElement).getLocationURI().trim();
                            if (location == null || !location.startsWith("http:")) continue;
                            continue block16;
                        }
                    }
                    if (returnPort == null) {
                        block18: for (Object o2 : ports.values()) {
                            port = (Port)o2;
                            extensibilityElements = port.getExtensibilityElements();
                            for (Object extElement : extensibilityElements) {
                                if (!(extElement instanceof HTTPAddress)) continue;
                                returnPort = port;
                                location = ((HTTPAddress)extElement).getLocationURI().trim();
                                if (location == null || !location.startsWith("http:")) continue;
                                continue block18;
                            }
                        }
                    }
                }
                if (returnPort == null) {
                    throw Context.reportRuntimeError((String)"The WSDL given does not contain any ports that use the http transport");
                }
                serviceQName = service.getQName();
                endpointName = returnPort.getName();
            }
            wsRequest.sender = new ServiceClient(null, definition, serviceQName, endpointName);
        }
        catch (MalformedURLException e) {
            message = "Malformed URL : " + wsdlURL;
            log.error((Object)message, (Throwable)e);
            throw new ScriptException(message, (Exception)e);
        }
        catch (Exception e) {
            message = "Error occurred while reading the WSDL content from the URL : " + wsdlURL;
            log.error((Object)message, (Throwable)e);
            throw new ScriptException(message, e);
        }
        finally {
            method.releaseConnection();
        }
        return optionsArray;
    }

    private static String getObjectProperty(NativeObject object, String property) {
        if (object.get(property, (Scriptable)object) instanceof String) {
            return (String)object.get(property, (Scriptable)object);
        }
        return null;
    }

    private static CryptoConfig getCryptoConfig(WSRequestHostObject wsRequest, NativeObject crypto) throws ScriptException {
        Properties merlinProp = new Properties();
        File file = new File(FilenameUtils.normalizeNoEndSeparator((String)WSRequestHostObject.getObjectProperty(crypto, "file")));
        merlinProp.put("org.apache.ws.security.crypto.merlin.file", file.getAbsolutePath());
        merlinProp.put("org.apache.ws.security.crypto.merlin.keystore.type", WSRequestHostObject.getObjectProperty(crypto, "type"));
        merlinProp.put("org.apache.ws.security.crypto.merlin.keystore.password", WSRequestHostObject.getObjectProperty(crypto, "password"));
        CryptoConfig cryptoConfig = new CryptoConfig();
        cryptoConfig.setProvider("org.apache.ws.security.components.crypto.Merlin");
        cryptoConfig.setProp(merlinProp);
        Object property = crypto.get("enableCryptoCaching", (Scriptable)crypto);
        if (property instanceof Boolean && ((Boolean)property).booleanValue() || property instanceof String && Boolean.parseBoolean((String)property)) {
            cryptoConfig.setCacheEnabled(true);
            cryptoConfig.setCryptoKey("org.apache.ws.security.crypto.merlin.file");
        } else if (property != null && !(property instanceof Undefined) && !(property instanceof UniqueTag)) {
            throw new ScriptException("Invalid value for property 'enableCryptoCaching' in rampart configuration");
        }
        property = crypto.get("cacheRefreshInterval", (Scriptable)crypto);
        if (property instanceof Integer) {
            cryptoConfig.setCacheRefreshInterval(Integer.toString((Integer)property));
        } else if (property instanceof String) {
            cryptoConfig.setCacheRefreshInterval((String)property);
        } else if (property != null && !(property instanceof Undefined) && !(property instanceof UniqueTag)) {
            throw new ScriptException("Invalid value for property 'cacheRefreshInterval' in rampart configuration");
        }
        return cryptoConfig;
    }

    private static KerberosConfig getKerberosConfigs(WSRequestHostObject wsRequest, NativeObject configs) throws ScriptException {
        Object[] objects;
        KerberosConfig kerberosConfig = new KerberosConfig();
        Properties properties = new Properties();
        for (Object object : objects = NativeObject.getPropertyIds((Scriptable)configs)) {
            Object value;
            String property;
            if (object instanceof String) {
                property = (String)object;
                value = configs.get(property, (Scriptable)configs);
                if (!(value instanceof String)) {
                    throw new ScriptException("Invalid config value for the property : " + property + " in Kerberos Config");
                }
            } else {
                throw new ScriptException("Invalid property in Kerberos Config");
            }
            properties.setProperty(property, (String)value);
        }
        kerberosConfig.setProp(properties);
        return kerberosConfig;
    }

    private static void setRampartConfigs(WSRequestHostObject wsRequest, javax.xml.namespace.QName operationName) throws AxisFault, ScriptException {
        RampartConfig rampartConfig = null;
        boolean useUT = false;
        Policy policy = null;
        if (wsRequest.policy != null) {
            OMNode node = wsRequest.policy.getAxiomFromXML();
            if (!(node instanceof OMElement)) {
                throw new Error("INVALID_INPUT_EXCEPTION. Invalid input was : " + wsRequest.policy);
            }
            OMElement policyElement = (OMElement)node;
            policy = PolicyEngine.getPolicy((OMElement)policyElement);
            List list = (List)policy.getAlternatives().next();
            for (Object o : list) {
                if (!(o instanceof RampartConfig)) continue;
                rampartConfig = (RampartConfig)o;
                WSRequestHostObject.filterRampartConfig(wsRequest, rampartConfig);
                break;
            }
        }
        if (wsRequest.rampartConfig != null) {
            if (rampartConfig == null) {
                Object kerberosConfig;
                Object obj;
                rampartConfig = new RampartConfig();
                String property = WSRequestHostObject.getObjectProperty(wsRequest.rampartConfig, "userCertAlias");
                if (property != null) {
                    rampartConfig.setUserCertAlias(property);
                }
                if ((property = WSRequestHostObject.getObjectProperty(wsRequest.rampartConfig, "stsAlias")) != null) {
                    rampartConfig.setStsAlias(property);
                }
                if ((property = WSRequestHostObject.getObjectProperty(wsRequest.rampartConfig, "encryptionUser")) != null) {
                    rampartConfig.setEncryptionUser(property);
                }
                if ((obj = wsRequest.rampartConfig.get("timestampTTL", (Scriptable)wsRequest.rampartConfig)) instanceof Integer) {
                    rampartConfig.setTimestampTTL(Integer.toString((Integer)obj));
                } else if (obj instanceof String) {
                    rampartConfig.setTimestampTTL((String)obj);
                } else if (obj != null && !(obj instanceof Undefined) && !(obj instanceof UniqueTag)) {
                    throw new ScriptException("Invalid value for property 'timestampTTL' in rampart configuration");
                }
                obj = wsRequest.rampartConfig.get("timestampMaxSkew", (Scriptable)wsRequest.rampartConfig);
                if (obj instanceof Integer) {
                    rampartConfig.setTimestampMaxSkew(Integer.toString((Integer)obj));
                } else if (obj instanceof String) {
                    rampartConfig.setTimestampMaxSkew((String)obj);
                } else if (obj != null && !(obj instanceof Undefined) && !(obj instanceof UniqueTag)) {
                    throw new ScriptException("Invalid value for property 'timestampMaxSkew' in rampart configuration");
                }
                obj = wsRequest.rampartConfig.get("timestampPrecisionInMilliseconds", (Scriptable)wsRequest.rampartConfig);
                if (obj instanceof Integer) {
                    rampartConfig.setTimestampPrecisionInMilliseconds(Integer.toString((Integer)obj));
                } else if (obj instanceof String) {
                    rampartConfig.setTimestampPrecisionInMilliseconds((String)obj);
                } else if (obj != null && !(obj instanceof Undefined) && !(obj instanceof UniqueTag)) {
                    throw new ScriptException("Invalid value for property 'timestampPrecisionInMilliseconds' in rampart configuration");
                }
                Object cryptoObject = wsRequest.rampartConfig.get("signatureCrypto", (Scriptable)wsRequest.rampartConfig);
                if (cryptoObject instanceof NativeObject) {
                    rampartConfig.setSigCryptoConfig(WSRequestHostObject.getCryptoConfig(wsRequest, (NativeObject)cryptoObject));
                }
                if ((cryptoObject = wsRequest.rampartConfig.get("encryptionCrypto", (Scriptable)wsRequest.rampartConfig)) instanceof NativeObject) {
                    rampartConfig.setEncrCryptoConfig(WSRequestHostObject.getCryptoConfig(wsRequest, (NativeObject)cryptoObject));
                }
                if ((cryptoObject = wsRequest.rampartConfig.get("decryptionCrypto", (Scriptable)wsRequest.rampartConfig)) instanceof NativeObject) {
                    rampartConfig.setEncrCryptoConfig(WSRequestHostObject.getCryptoConfig(wsRequest, (NativeObject)cryptoObject));
                }
                if ((cryptoObject = wsRequest.rampartConfig.get("stsCrypto", (Scriptable)wsRequest.rampartConfig)) instanceof NativeObject) {
                    rampartConfig.setSigCryptoConfig(WSRequestHostObject.getCryptoConfig(wsRequest, (NativeObject)cryptoObject));
                }
                if ((kerberosConfig = wsRequest.rampartConfig.get("kerberosConfig", (Scriptable)wsRequest.rampartConfig)) instanceof NativeObject) {
                    rampartConfig.setKerberosConfig(WSRequestHostObject.getKerberosConfigs(wsRequest, (NativeObject)kerberosConfig));
                }
            }
            PasswordCallbackHandler passwordCallbackHandler = new PasswordCallbackHandler();
            wsRequest.sender.getAxisService().addParameter("passwordCallbackRef", (Object)passwordCallbackHandler);
            String property = WSRequestHostObject.getObjectProperty(wsRequest.rampartConfig, "user");
            if (property != null) {
                rampartConfig.setUser(property);
                useUT = true;
            }
            if ((property = WSRequestHostObject.getObjectProperty(wsRequest.rampartConfig, "userPassword")) != null) {
                passwordCallbackHandler.setUserPassword(property);
            }
            if ((property = WSRequestHostObject.getObjectProperty(wsRequest.rampartConfig, "keyPassword")) != null) {
                passwordCallbackHandler.setKeyPassword(property);
            }
        }
        if (policy == null) {
            if (wsRequest.wsdlMode) {
                AxisService axisService = wsRequest.sender.getAxisService();
                if (axisService.getChild((Object)operationName) == null) {
                    throw new ScriptException("No operation with the name " + operationName.getLocalPart() + " found in the service been called");
                }
                AxisEndpoint axisEndpoint = axisService.getEndpoint(axisService.getEndpointName());
                AxisBindingMessage axisBindingMessage = (AxisBindingMessage)axisEndpoint.getBinding().getChild((Object)operationName).getChild((Object)"In");
                policy = axisBindingMessage.getEffectivePolicy();
            } else if (useUT) {
                String xmlPath = "scenarios/scenario1-policy.xml";
                try {
                    InputStream policyXMLStream = WSRequestHostObject.class.getClassLoader().getResourceAsStream(xmlPath);
                    StAXOMBuilder builder = new StAXOMBuilder(policyXMLStream);
                    policy = PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
                }
                catch (XMLStreamException e) {
                    String message = "Error loading/parsing default UT policy from the server";
                    log.error((Object)message, (Throwable)e);
                    throw new ScriptException(message, (Exception)e);
                }
            }
        }
        if (policy != null) {
            if (rampartConfig == null) {
                throw new ScriptException("A policy has been specified either in your mashup or in the WSDL. But the Rampart Configuration cannot be found.");
            }
            policy.addAssertion((Assertion)rampartConfig);
            wsRequest.sender.getOptions().setProperty("rampartPolicy", (Object)policy);
            wsRequest.sender.engageModule(RAMPART);
            wsRequest.sender.engageModule(ADDRESSING);
        }
    }

    private static void filterRampartConfig(WSRequestHostObject wsRequest, RampartConfig config) {
        KerberosConfig kerberosConfig;
        CryptoConfig crypto = config.getSigCryptoConfig();
        if (crypto != null) {
            WSRequestHostObject.filterCryptoConfig(wsRequest, crypto);
        }
        if ((crypto = config.getEncrCryptoConfig()) != null) {
            WSRequestHostObject.filterCryptoConfig(wsRequest, crypto);
        }
        if ((crypto = config.getDecCryptoConfig()) != null) {
            WSRequestHostObject.filterCryptoConfig(wsRequest, crypto);
        }
        if ((crypto = config.getStsCryptoConfig()) != null) {
            WSRequestHostObject.filterCryptoConfig(wsRequest, crypto);
        }
        if ((kerberosConfig = config.getKerberosConfig()) != null) {
            Properties properties = kerberosConfig.getProp();
            for (String key : properties.stringPropertyNames()) {
                properties.setProperty(key, properties.getProperty(key));
            }
        }
    }

    private static void filterCryptoConfig(WSRequestHostObject wsRequest, CryptoConfig config) {
        Properties properties = config.getProp();
        properties.setProperty("org.apache.ws.security.crypto.merlin.file", properties.getProperty("org.apache.ws.security.crypto.merlin.file"));
    }

    static {
        try {
            configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
            configurationContext.getAxisConfiguration().addModule(new AxisModule(RAMPART));
            configurationContext.getAxisConfiguration().addModule(new AxisModule(ADDRESSING));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

