/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.registry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.registry.CollectionHostObject;
import org.jaggeryjs.hostobjects.registry.RegistryHostObjectContext;
import org.jaggeryjs.hostobjects.registry.ResourceHostObject;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.registry.api.Collection;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(RegistryHostObject.class);
    private static final String hostObjectName = "MetadataStore";
    private Registry registry = null;

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        int argsCount = args.length;
        if (args.length != 2 && args[0] instanceof String && args[1] instanceof String) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)hostObjectName, (int)argsCount, (boolean)true);
        }
        RegistryHostObject rho = new RegistryHostObject();
        rho.registry = RegistryHostObject.getRegistry((String)args[0], (String)args[1]);
        return rho;
    }

    public String getClassName() {
        return hostObjectName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void jsFunction_remove(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject rho = (RegistryHostObject)thisObj;
        if (arguments.length != 1) throw new ScriptException("Invalid no. of arguments for delete() method");
        if (!(arguments[0] instanceof String)) throw new ScriptException("Path argument of method delete() should be a string");
        try {
            rho.registry.delete((String)arguments[0]);
            return;
        }
        catch (RegistryException e) {
            throw new ScriptException("Registry error occurred while executing delete() operation", (Exception)((Object)e));
        }
    }

    public static Scriptable jsFunction_get(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject rho = (RegistryHostObject)thisObj;
        if (arguments.length == 1) {
            if (arguments[0] instanceof String) {
                try {
                    Resource resource = rho.registry.get((String)arguments[0]);
                    Scriptable hostObject = resource instanceof Collection ? cx.newObject((Scriptable)rho, "Collection", new Object[]{resource}) : cx.newObject((Scriptable)rho, "Resource", new Object[]{resource});
                    return hostObject;
                }
                catch (RegistryException e) {
                    throw new ScriptException("Registry error occurred while executing get() operation", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Path argument of method get() should be a string");
        }
        if (arguments.length == 3) {
            if (arguments[0] instanceof String && arguments[1] instanceof Number && arguments[2] instanceof Number) {
                try {
                    Collection collection = rho.registry.get((String)arguments[0], ((Number)arguments[1]).intValue(), ((Number)arguments[2]).intValue());
                    CollectionHostObject cho = (CollectionHostObject)cx.newObject((Scriptable)rho, "Collection", new Object[]{collection});
                    return cho;
                }
                catch (RegistryException e) {
                    throw new ScriptException("Registry error occurred while executing get() operation", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Invalid argument types for get() method");
        }
        throw new ScriptException("Invalid no. of arguments for get() method");
    }

    public static String jsFunction_put(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject rho = (RegistryHostObject)thisObj;
        if (arguments.length == 2) {
            if (arguments[0] instanceof String && arguments[1] instanceof Scriptable) {
                ResourceHostObject reho = (ResourceHostObject)((Object)arguments[1]);
                try {
                    return rho.registry.put((String)arguments[0], reho.getResource());
                }
                catch (RegistryException e) {
                    throw new ScriptException("Registry error occurred while executing get() operation", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Invalid argument types for put() method");
        }
        throw new ScriptException("Invalid no. of arguments for put() method");
    }

    public static Scriptable jsFunction_newCollection(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject rho = (RegistryHostObject)thisObj;
        if (arguments.length == 0) {
            if (rho.registry != null) {
                try {
                    Collection collection = rho.registry.newCollection();
                    CollectionHostObject cho = (CollectionHostObject)cx.newObject((Scriptable)rho, "Collection", new Object[]{collection});
                    return cho;
                }
                catch (RegistryException e) {
                    throw new ScriptException("Error occurred while creating a new Collection", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Registry has not initialized");
        }
        throw new ScriptException("newCollection() Method doesn't accept arguments");
    }

    public static Scriptable jsFunction_newResource(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length == 0) {
            if (registryHostObject.registry != null) {
                try {
                    Resource resource = registryHostObject.registry.newResource();
                    ResourceHostObject rho = (ResourceHostObject)cx.newObject((Scriptable)registryHostObject, "Resource", new Object[]{resource});
                    return rho;
                }
                catch (RegistryException e) {
                    throw new ScriptException("Error occurred while creating a new Resource", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Registry has not initialized");
        }
        throw new ScriptException("newResource() Method doesn't accept arguments");
    }

    public static boolean jsFunction_resourceExists(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length == 1) {
            if (arguments[0] instanceof String) {
                try {
                    return registryHostObject.registry.resourceExists((String)arguments[0]);
                }
                catch (RegistryException e) {
                    throw new ScriptException("Error occurred while creating a new Resource", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Invalid argument types for resourceExists() method");
        }
        throw new ScriptException("Invalid no. of arguments");
    }

    private static Registry getRegistry(String username, String password) throws ScriptException {
        UserRegistry registry;
        RegistryService registryService = RegistryHostObjectContext.getRegistryService();
        try {
            registry = registryService.getGovernanceUserRegistry(username, password);
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)((Object)e));
        }
        if (registry == null) {
            String msg = "User governance registry cannot be retrieved";
            throw new ScriptException(msg);
        }
        return registry;
    }
}

