/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.web;

import com.google.gson.Gson;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ResponseHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(ResponseHostObject.class);
    private static final String hostObjectName = "Response";
    private HttpServletResponse response;
    private int status = 0;
    private String content = null;

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)hostObjectName, (int)argsCount, (boolean)true);
        }
        if (!(args[0] instanceof HttpServletResponse)) {
            HostObjectUtil.getReservedHostObjectWarn((String)hostObjectName);
        }
        ResponseHostObject rho = new ResponseHostObject();
        rho.response = (HttpServletResponse)args[0];
        return rho;
    }

    public String getClassName() {
        return hostObjectName;
    }

    public void jsSet_content(Object object) throws ScriptException {
        try {
            String content = HostObjectUtil.serializeObject((Object)object);
            this.response.getOutputStream().print(content);
        }
        catch (IOException e) {
            String msg = "Error occurred while reading Servlet OutputStream";
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    public String jsGet_content() throws ScriptException {
        return this.content;
    }

    public void jsSet_contentType(Object object) throws ScriptException {
        if (!(object instanceof String)) {
            HostObjectUtil.invalidProperty((String)hostObjectName, (String)"contentType", (String)"string", (Object)object);
        }
        this.response.setContentType((String)object);
    }

    public String jsGet_contentType() throws ScriptException {
        return this.response.getContentType();
    }

    public void jsSet_status(Object object) throws ScriptException {
        if (!(object instanceof Integer)) {
            HostObjectUtil.invalidProperty((String)hostObjectName, (String)"status", (String)"integer", (Object)object);
        }
        this.status = (Integer)object;
        this.response.setStatus(this.status);
    }

    public int jsGet_status() throws ScriptException {
        return this.status;
    }

    public static void jsFunction_addHeader(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "addHeader";
        int argsCount = args.length;
        if (argsCount != 2) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if (!(args[1] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"string", (Object)args[1], (boolean)false);
        }
        ResponseHostObject rho = (ResponseHostObject)thisObj;
        rho.response.addHeader((String)args[0], (String)args[1]);
    }

    public static void jsFunction_sendError(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "sendError";
        int argsCount = args.length;
        if (argsCount > 2 || argsCount < 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof Integer)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"integer", (Object)args[0], (boolean)false);
        }
        ResponseHostObject rho = (ResponseHostObject)thisObj;
        if (argsCount == 2) {
            if (!(args[1] instanceof String)) {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"string", (Object)args[1], (boolean)false);
            }
            try {
                rho.response.sendError(((Integer)args[0]).intValue(), (String)args[1]);
            }
            catch (IOException e) {
                String msg = "Error sending error. Status : " + args[0] + ", Message : " + args[1];
                log.warn((Object)msg, (Throwable)e);
                throw new ScriptException(msg, (Exception)e);
            }
        }
        try {
            rho.response.sendError(((Integer)args[0]).intValue());
        }
        catch (IOException e) {
            String msg = "Error sending error. Status : " + args[0];
            log.warn((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    public static void jsFunction_sendRedirect(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "sendRedirect";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        ResponseHostObject rho = (ResponseHostObject)thisObj;
        try {
            rho.response.sendRedirect((String)args[0]);
        }
        catch (IOException e) {
            String msg = "Error sending redirect : " + args[0];
            log.warn((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    public static void jsFunction_addCookie(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "addCookie";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof NativeObject)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        NativeObject jcookie = (NativeObject)args[0];
        Gson gson = new Gson();
        Cookie cookie = (Cookie)gson.fromJson(HostObjectUtil.serializeJSON((Object)jcookie), Cookie.class);
        ResponseHostObject rho = (ResponseHostObject)thisObj;
        rho.response.addCookie(cookie);
    }
}

