/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.manager;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.core.ScriptReader;
import org.jaggeryjs.jaggery.core.manager.CommonManager;
import org.jaggeryjs.jaggery.core.manager.JaggeryContext;
import org.jaggeryjs.scriptengine.cache.CacheManager;
import org.jaggeryjs.scriptengine.engine.JavaScriptHostObject;
import org.jaggeryjs.scriptengine.engine.JavaScriptMethod;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class CommandLineManager
extends CommonManager {
    private static final Log log = LogFactory.getLog(CommandLineManager.class);
    private static final RhinoEngine RHINO_ENGINE;
    public static final int ENV_WEBAPP = 0;
    public static final int ENV_COMMAND_LINE = 1;
    public static final String JAGGERY_CONTEXT = "jaggeryContext";

    public CommandLineManager(String jaggeryDir) throws ScriptException {
        super(jaggeryDir);
    }

    public static RhinoEngine getCommandLineEngine() {
        return RHINO_ENGINE;
    }

    protected static void initEngine() {
        try {
            InputStream inputStream = CommandLineManager.class.getClassLoader().getResourceAsStream("META-INF/hostobjects.xml");
            StAXOMBuilder builder = new StAXOMBuilder(inputStream);
            OMElement document = builder.getDocumentElement();
            Iterator itr = document.getChildrenWithLocalName("hostObject");
            String msg = "Error while registering HostObject : ";
            while (itr.hasNext()) {
                OMElement hostObject = (OMElement)itr.next();
                String name = hostObject.getFirstChildWithName(new QName(null, "name")).getText();
                String className = hostObject.getFirstChildWithName(new QName(null, "className")).getText();
                JavaScriptHostObject ho = new JavaScriptHostObject(name);
                try {
                    ho.setClazz(Class.forName(className));
                    RHINO_ENGINE.defineHostObject(ho);
                }
                catch (ClassNotFoundException e) {
                    msg = msg + name + " " + e.getMessage();
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error while reading the hostobjects.xml", (Throwable)e);
        }
        CommandLineManager.initGlobalProperties();
    }

    private static void initGlobalProperties() {
        JavaScriptMethod method = new JavaScriptMethod("print");
        method.setMethodName("print");
        method.setClazz(CommandLineManager.class);
        RHINO_ENGINE.defineMethod(method);
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "print";
        JaggeryContext jaggeryContext = CommandLineManager.getJaggeryContext();
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)"CarbonTopLevel", (String)functionName, (int)argsCount, (boolean)false);
        }
        PrintWriter writer = new PrintWriter(jaggeryContext.getOutputStream());
        writer.write(HostObjectUtil.serializeObject((Object)args[0]));
        writer.flush();
    }

    public static JaggeryContext getJaggeryContext() {
        return (JaggeryContext)RhinoEngine.getContextProperty((Object)JAGGERY_CONTEXT);
    }

    public static void setJaggeryContext(JaggeryContext jaggeryContext) {
        RhinoEngine.putContextProperty((Object)JAGGERY_CONTEXT, (Object)jaggeryContext);
    }

    public static void include(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "include";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)"CarbonTopLevel", (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)"CarbonTopLevel", (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        Stack<String> includesCallstack = jaggeryContext.getIncludesCallstack();
        Map<String, Boolean> includedScripts = jaggeryContext.getIncludedScripts();
        String parent = (String)includesCallstack.lastElement();
        String fileURL = (String)args[0];
        if (CommandLineManager.isHTTP(fileURL) || CommandLineManager.isHTTP(parent)) {
            CommonManager.include(cx, thisObj, args, funObj);
            return;
        }
        ScriptableObject scope = jaggeryContext.getScope();
        RhinoEngine engine = jaggeryContext.getEngine();
        fileURL = fileURL.startsWith("/") ? (String)includesCallstack.firstElement() + fileURL : FilenameUtils.getFullPath((String)parent) + fileURL;
        if (includesCallstack.search(fileURL = FilenameUtils.normalize((String)fileURL)) != -1) {
            return;
        }
        ScriptReader source = null;
        try {
            source = new ScriptReader(new FileInputStream(fileURL));
            includedScripts.put(fileURL, true);
            includesCallstack.push(fileURL);
            engine.exec((Reader)source, scope, null);
            includesCallstack.pop();
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public static void include_once(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "include_once";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)"CarbonTopLevel", (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)"CarbonTopLevel", (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        Stack<String> includesCallstack = jaggeryContext.getIncludesCallstack();
        Map<String, Boolean> includedScripts = jaggeryContext.getIncludedScripts();
        String parent = (String)includesCallstack.lastElement();
        String fileURL = (String)args[0];
        if (CommandLineManager.isHTTP(fileURL) || CommandLineManager.isHTTP(parent)) {
            CommonManager.include_once(cx, thisObj, args, funObj);
            return;
        }
        ScriptableObject scope = jaggeryContext.getScope();
        RhinoEngine engine = jaggeryContext.getEngine();
        fileURL = fileURL.startsWith("/") ? (String)includesCallstack.firstElement() + fileURL : FilenameUtils.getFullPath((String)parent) + fileURL;
        if (includesCallstack.search(fileURL = FilenameUtils.normalize((String)fileURL)) != -1) {
            return;
        }
        if (includedScripts.get(fileURL) != null) {
            return;
        }
        try {
            ScriptReader source = new ScriptReader(new FileInputStream(fileURL));
            includedScripts.put(fileURL, true);
            includesCallstack.push(fileURL);
            engine.exec((Reader)source, scope, null);
            includesCallstack.pop();
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    static {
        String dir = System.getProperty("java.io.tmpdir");
        if (dir != null) {
            RHINO_ENGINE = new RhinoEngine(new CacheManager("jaggery", dir));
            CommandLineManager.initEngine();
        } else {
            RHINO_ENGINE = null;
            String msg = "Please specify java.io.tmpdir system property";
            log.error((Object)msg);
        }
    }
}

