/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.core.task.JaggeryTaskAdmin;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.service.TaskService;

public class JaggeryCoreServiceComponent {
    private static final Log log = LogFactory.getLog(JaggeryCoreServiceComponent.class);
    private static TaskService taskService;
    private static Map<String, Object> taskMap;

    protected void activate(ComponentContext context) {
        JaggeryTaskAdmin taskAdmin = new JaggeryTaskAdmin();
        taskMap = new HashMap<String, Object>();
        try {
            taskAdmin.deleteAllTasks();
        }
        catch (TaskException e) {
            log.error((Object)("Unable to delete job : " + e.getMessage()));
        }
        try {
            JaggeryCoreServiceComponent.getTaskService().registerTaskType("JAGGERY_TASK");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Jaggery task bundle is activated ");
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
    }

    protected void setTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Task Service");
        }
        JaggeryCoreServiceComponent.taskService = taskService;
    }

    protected void unsetTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Task Service");
        }
        JaggeryCoreServiceComponent.taskService = null;
    }

    public static TaskService getTaskService() {
        return taskService;
    }

    public static Map<String, Object> getTaskMap() {
        if (taskMap == null) {
            taskMap = new HashMap<String, Object>();
        }
        return taskMap;
    }

    public static void setTaskMap(Map<String, Object> taskMap) {
        JaggeryCoreServiceComponent.taskMap = taskMap;
    }
}

