/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.scriptengine.cache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.cache.CachingContext;
import org.jaggeryjs.scriptengine.cache.CompilationContext;
import org.jaggeryjs.scriptengine.cache.ContextWrapper;
import org.jaggeryjs.scriptengine.cache.PackageWrapper;
import org.jaggeryjs.scriptengine.cache.ScriptCachingContext;
import org.jaggeryjs.scriptengine.cache.TenantWrapper;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.optimizer.ClassCompiler;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class CacheManager {
    private static final Log log = LogFactory.getLog(CacheManager.class);
    private static final String PACKAGE_NAME = "org.wso2.carbon.rhino";
    private ClassCompiler compiler;
    private String name;
    private String cacheManagerDir;
    private String cacheDir;
    private ConcurrentMap<String, TenantWrapper> tenants = new ConcurrentHashMap<String, TenantWrapper>();
    private final Object lock0 = new Object();
    private final Object lock1 = new Object();

    public CacheManager(String name, String cacheDir, CompilerEnvirons compilerEnv) {
        this.name = name;
        this.cacheManagerDir = CacheManager.filterNameForDir(name);
        this.cacheDir = cacheDir;
        if (compilerEnv == null) {
            compilerEnv = new CompilerEnvirons();
            compilerEnv.setErrorReporter((ErrorReporter)new ToolErrorReporter(true));
        }
        this.compiler = new ClassCompiler(compilerEnv);
    }

    public CacheManager(String name, String cacheDir) {
        this(name, cacheDir, null);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(ScriptCachingContext sctx) throws ScriptException {
        Object object = this.lock0;
        synchronized (object) {
            CachingContext ctx = this.getCachingContext(sctx);
            if (ctx == null) {
                return;
            }
            String location = ctx.getClassFilePath();
            File classFile = new File(location);
            if (classFile.exists() && !classFile.delete()) {
                String msg = "Unable to delete the file " + location;
                log.warn((Object)msg);
                throw new ScriptException(msg);
            }
            TenantWrapper tenant = (TenantWrapper)this.tenants.get(ctx.getTenantId());
            tenant.removeCachingContext(sctx);
        }
    }

    public synchronized void cacheScript(Reader scriptReader, ScriptCachingContext sctx) throws ScriptException {
        String classLocation;
        String className;
        if (scriptReader == null) {
            String msg = "Unable to find the Reader for script source in CachingContext";
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        TenantWrapper tenant = this.initContexts(sctx);
        CachingContext ctx = this.getCachingContext(sctx);
        if (ctx != null) {
            if (sctx.getSourceModifiedTime() <= ctx.getSourceModifiedTime()) {
                return;
            }
            className = ctx.getClassName();
            classLocation = ctx.getClassFilePath();
            this.invalidateCache(sctx);
            ctx.setSourceModifiedTime(0L);
            ctx.setCacheUpdatedTime(0L);
        } else {
            className = CacheManager.getClassName(tenant, sctx);
            classLocation = this.getClassLocation(sctx, className);
            ctx = new CachingContext(sctx.getContext(), sctx.getPath(), sctx.getCacheKey());
            ctx.setTenantId(sctx.getTenantId());
            ctx.setContext(sctx.getContext());
            ctx.setPath(sctx.getPath());
            ctx.setCacheKey(sctx.getCacheKey());
            ctx.setClassName(className);
            ctx.setClassFilePath(classLocation);
        }
        try {
            String scriptPath = sctx.getContext() + sctx.getPath() + sctx.getCacheKey();
            Object[] compiled = this.compiler.compileToClassFiles(HostObjectUtil.readerToString(scriptReader), scriptPath, 1, className);
            this.writeClass(classLocation, (byte[])compiled[1]);
            this.updateContexts(className, ctx, sctx);
            tenant.setCachingContext(ctx);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public Script getScriptObject(Reader scriptReader, ScriptCachingContext sctx) throws ScriptException {
        CachingContext ctx = this.getCachingContext(sctx);
        if (ctx == null) {
            return null;
        }
        if (sctx.getSourceModifiedTime() > ctx.getSourceModifiedTime()) {
            this.cacheScript(scriptReader, sctx);
            ctx = this.getCachingContext(sctx);
        }
        return ctx.getScript();
    }

    public boolean isCached(ScriptCachingContext sctx) {
        return this.getCachingContext(sctx) != null;
    }

    public boolean isOlder(ScriptCachingContext sctx) {
        CachingContext ctx = this.getCachingContext(sctx);
        return ctx == null || sctx.getSourceModifiedTime() > ctx.getSourceModifiedTime();
    }

    private void writeClass(String classLocation, byte[] classBytes) throws ScriptException {
        FileOutputStream classFileStream = null;
        try {
            String parentDir = classLocation.substring(0, classLocation.lastIndexOf(File.separator));
            File parent = new File(parentDir);
            if (!parent.exists() && !parent.mkdirs()) {
                String msg = "Error while creating the directory : " + parentDir;
                throw new ScriptException(msg);
            }
            classFileStream = new FileOutputStream(classLocation);
            classFileStream.write(classBytes);
        }
        catch (FileNotFoundException e) {
            String msg = "Error while creating the file file " + classLocation;
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, e);
        }
        catch (IOException e) {
            String msg = "Error while writing the file " + classLocation;
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, e);
        }
        finally {
            if (classFileStream != null) {
                try {
                    classFileStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompilationContext getCompilationContext(ScriptCachingContext sctx) throws ScriptException {
        TenantWrapper tenant = this.initContexts(sctx);
        CompilationContext cCtx = tenant.getCompilationContext(sctx);
        if (cCtx != null) {
            return cCtx;
        }
        Object object = this.lock1;
        synchronized (object) {
            cCtx = tenant.getCompilationContext(sctx);
            if (cCtx != null) {
                return cCtx;
            }
            cCtx = new CompilationContext();
            String url = "file:" + this.getSourceDir(sctx) + File.separator;
            cCtx.setClassLoader(this.createClassLoader(url));
            cCtx.setClassPath(url);
            tenant.setCompilationContext(sctx, cCtx);
            return cCtx;
        }
    }

    private ClassLoader createClassLoader(String classpath) throws ScriptException {
        try {
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            return URLClassLoader.newInstance(new URL[]{new URL(classpath)}, parent);
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new ScriptException(e);
        }
    }

    private TenantWrapper initContexts(ScriptCachingContext sctx) {
        PackageWrapper packageWrapper;
        ContextWrapper context;
        TenantWrapper tenant = (TenantWrapper)this.tenants.get(sctx.getTenantId());
        if (tenant == null) {
            tenant = new TenantWrapper();
            this.tenants.put(sctx.getTenantId(), tenant);
        }
        if ((context = tenant.getContext(sctx)) == null) {
            context = new ContextWrapper();
            tenant.setContext(sctx, context);
        }
        if ((packageWrapper = context.getPackage(sctx.getPath())) == null) {
            packageWrapper = new PackageWrapper();
            context.setPackage(sctx.getPath(), packageWrapper);
        }
        return tenant;
    }

    private void updateContexts(String className, CachingContext ctx, ScriptCachingContext sctx) throws ScriptException {
        CompilationContext cCtx = this.getCompilationContext(sctx);
        ClassLoader classLoader = this.createClassLoader(cCtx.getClassPath());
        cCtx.setClassLoader(classLoader);
        ctx.setCompilationContext(cCtx);
        ctx.setScript(CacheManager.loadScript(classLoader, className));
        ctx.setCacheUpdatedTime(System.currentTimeMillis());
        ctx.setSourceModifiedTime(sctx.getSourceModifiedTime());
    }

    protected static Script loadScript(ClassLoader classLoader, String className) throws ScriptException {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (Script)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            String msg = "Cached *.class file of " + className + " cannot be found";
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "Error invoking constructor of " + className;
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = "Error instantiating object of " + className;
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Error accessing the constructor of " + className;
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, e);
        }
        catch (NoSuchMethodException e) {
            String msg = "Empty contructor cannot be found for " + className;
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, e);
        }
    }

    private String getClassLocation(ScriptCachingContext sctx, String className) {
        String classLocation = className.replace(".", File.separator);
        return this.getSourceDir(sctx) + File.separator + classLocation + ".class";
    }

    private String getSourceDir(ScriptCachingContext sctx) {
        String filteredTenantId = CacheManager.filterNameForDir(sctx.getTenantId());
        String filteredContext = CacheManager.filterNameForDir(sctx.getContext());
        return this.cacheDir + this.cacheManagerDir + filteredTenantId + filteredContext;
    }

    private static String getClassName(TenantWrapper tenant, ScriptCachingContext sctx) throws ScriptException {
        String filteredPath = CacheManager.getPackage(sctx.getPath());
        PackageWrapper packageWrapper = tenant.getPath(sctx);
        long classIndex = packageWrapper.getClassIndex();
        packageWrapper.setClassIndex(classIndex + 1L);
        return PACKAGE_NAME + filteredPath + ".c" + classIndex;
    }

    public static String getPackage(String path) {
        path = CacheManager.normalizePath(path);
        path = path.replaceAll("[-\\(\\)\\s]", "_").replace("/", ".").replaceAll("(.)([0-9])", "$1_$2");
        return path;
    }

    public static String filterNameForDir(String path) {
        path = CacheManager.normalizePath(path);
        return path.replace("/", File.separator);
    }

    public static String normalizePath(String path) {
        if (path.equals("") || path.equals("/")) {
            return "";
        }
        return path.startsWith("/") ? path : "/" + path;
    }

    private CachingContext getCachingContext(ScriptCachingContext sctx) {
        TenantWrapper tenant = (TenantWrapper)this.tenants.get(sctx.getTenantId());
        if (tenant == null) {
            return null;
        }
        return tenant.getCachingContext(sctx);
    }
}

