/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.deployer;

import java.io.File;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.app.mgt.TomcatJaggeryWebappsDeployer;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.webapp.deployer.WebappDeployer;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;

public class JaggeryDeployer
extends WebappDeployer {
    private static final Log log = LogFactory.getLog(JaggeryDeployer.class);

    public void init(ConfigurationContext configCtx) {
        this.configContext = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
        String repoPath = configCtx.getAxisConfiguration().getRepository().getPath();
        File webappsDirFile = new File(repoPath + File.separator + this.webappsDir);
        if (!webappsDirFile.exists() && !webappsDirFile.mkdirs()) {
            log.warn((Object)("Could not create directory " + webappsDirFile.getAbsolutePath()));
        }
        SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configCtx);
        int tenantId = carbonContext.getTenantId();
        String tenantDomain = carbonContext.getTenantDomain();
        String webContextPrefix = tenantDomain != null ? "/t/" + tenantDomain + "/" + "jaggeryapps" + "/" : "";
        this.webappsHolder = (WebApplicationsHolder)configCtx.getProperty("carbon.webapps.holder");
        if (this.webappsHolder == null) {
            this.webappsHolder = new WebApplicationsHolder(new File(this.webappsDir));
            configCtx.setProperty("carbon.webapps.holder", (Object)this.webappsHolder);
        }
        configCtx.setProperty("servlet.context.parameters.list", (Object)this.servletContextParameters);
        this.tomcatWebappDeployer = new TomcatJaggeryWebappsDeployer(webContextPrefix, tenantId, tenantDomain, this.webappsHolder, this.configContext);
        configCtx.setProperty("tomcatGenericWebappsDeplyer", (Object)this.tomcatWebappDeployer);
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        WebApplication deployedWebapp;
        super.deploy(deploymentFileData);
        WebApplicationsHolder webappsHolder = (WebApplicationsHolder)this.configContext.getProperty("carbon.webapps.holder");
        if (webappsHolder != null && (deployedWebapp = (WebApplication)webappsHolder.getStartedWebapps().get(deploymentFileData.getFile().getName())) != null) {
            deployedWebapp.setProperty("webappFilter", (Object)"jaggeryWebapp");
        }
    }

    public void undeploy(String fileName) throws DeploymentException {
        if (!new File(fileName).exists()) {
            super.undeploy(fileName);
        }
    }
}

