CREATE TABLE REG_CLUSTER_LOCK (
             REG_LOCK_NAME VARCHAR (20),
             REG_LOCK_STATUS VARCHAR (20),
             REG_LOCKED_TIME TIMESTAMP,
             REG_TENANT_ID INTEGER DEFAULT 0,
             PRIMARY KEY (REG_LOCK_NAME)
)/

CREATE TABLE REG_LOG (
             REG_LOG_ID INTEGER DEFAULT 0,
             REG_PATH VARCHAR (2000),
             REG_USER_ID VARCHAR (31) NOT NULL,
             REG_LOGGED_TIME TIMESTAMP NOT NULL,
             REG_ACTION INTEGER NOT NULL,
             REG_ACTION_DATA VARCHAR (500),
             REG_TENANT_ID INTEGER DEFAULT 0,
             PRIMARY KEY (REG_LOG_ID, REG_TENANT_ID)
)/

CREATE SEQUENCE PUB.REG_LOG_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER REG_LOG_TRIGGER
			AFTER INSERT ON REG_LOG
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE REG_LOG SET REG_LOG_ID = PUB.REG_LOG_SEQUENCE.NEXTVAL WHERE REG_LOG_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE REG_PATH(
             REG_PATH_ID INTEGER DEFAULT 0,
             REG_PATH_VALUE VARCHAR(2000) NOT NULL,
             REG_PATH_PARENT_ID INT,
             REG_TENANT_ID INTEGER DEFAULT 0,
             CONSTRAINT PK_REG_PATH PRIMARY KEY(REG_PATH_ID, REG_TENANT_ID)
)/

CREATE SEQUENCE PUB.REG_PATH_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER REG_PATH_TRIGGER
			AFTER INSERT ON REG_PATH
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE REG_PATH SET REG_PATH_ID = PUB.REG_PATH_SEQUENCE.NEXTVAL WHERE REG_PATH_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/
CREATE INDEX REG_PI_BY_NAME ON REG_PATH(REG_PATH_VALUE, REG_TENANT_ID)/
CREATE INDEX REG_PI_BY_PARENT_ID ON REG_PATH(REG_PATH_PARENT_ID, REG_TENANT_ID)/


CREATE TABLE REG_CONTENT (
             REG_CONTENT_ID INTEGER DEFAULT 0,
             REG_CONTENT_DATA BLOB(1073741823),
             REG_TENANT_ID INTEGER DEFAULT 0,
             CONSTRAINT PK_REG_CONTENT PRIMARY KEY(REG_CONTENT_ID, REG_TENANT_ID)
)/

CREATE SEQUENCE PUB.REG_CONTENT_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TABLE REG_CONTENT_HISTORY (
             REG_CONTENT_ID INTEGER NOT NULL,
             REG_CONTENT_DATA BLOB (1073741823),
             REG_DELETED   SMALLINT,
             REG_TENANT_ID INTEGER DEFAULT 0,
             CONSTRAINT PK_REG_CONTENT_HISTORY PRIMARY KEY(REG_CONTENT_ID, REG_TENANT_ID)
)/

CREATE TABLE REG_RESOURCE (
            REG_PATH_ID         INTEGER NOT NULL,
            REG_NAME            VARCHAR(256),
            REG_VERSION         INTEGER DEFAULT 0,
            REG_MEDIA_TYPE      VARCHAR(500),
            REG_CREATOR         VARCHAR(31) NOT NULL,
            REG_CREATED_TIME    TIMESTAMP NOT NULL,
            REG_LAST_UPDATOR    VARCHAR(31),
            REG_LAST_UPDATED_TIME    TIMESTAMP NOT NULL,
            REG_DESCRIPTION     VARCHAR(1000),
            REG_CONTENT_ID      INTEGER,
            REG_TENANT_ID INTEGER DEFAULT 0,
            REG_UUID VARCHAR(100) NOT NULL,
            CONSTRAINT PK_REG_RESOURCE PRIMARY KEY(REG_VERSION, REG_TENANT_ID)
)/

CREATE SEQUENCE PUB.REG_RESOURCE_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER REG_RESOURCE_TRIGGER
			AFTER INSERT ON REG_RESOURCE
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE REG_RESOURCE SET REG_VERSION = PUB.REG_RESOURCE_SEQUENCE.NEXTVAL WHERE REG_VERSION = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

ALTER TABLE REG_RESOURCE ADD CONSTRAINT REG_R_FK_BY_PATH_ID FOREIGN KEY (REG_PATH_ID, REG_TENANT_ID) REFERENCES REG_PATH (REG_PATH_ID, REG_TENANT_ID)/
ALTER TABLE REG_RESOURCE ADD CONSTRAINT REG_R_FK_BY_CONTENT_ID FOREIGN KEY (REG_CONTENT_ID, REG_TENANT_ID) REFERENCES REG_CONTENT (REG_CONTENT_ID, REG_TENANT_ID)/
CREATE INDEX REG_R_IND_BY_NAME ON REG_RESOURCE(REG_NAME, REG_TENANT_ID)/
CREATE INDEX REG_R_IND_BY_PATH_ID_NAME ON REG_RESOURCE(REG_PATH_ID, REG_NAME, REG_TENANT_ID)/

CREATE TABLE REG_RESOURCE_HISTORY (
            REG_PATH_ID         INTEGER NOT NULL,
            REG_NAME            VARCHAR(256),
            REG_VERSION         INTEGER NOT NULL,
            REG_MEDIA_TYPE      VARCHAR(500),
            REG_CREATOR         VARCHAR(31) NOT NULL,
            REG_CREATED_TIME    TIMESTAMP NOT NULL,
            REG_LAST_UPDATOR    VARCHAR(31),
            REG_LAST_UPDATED_TIME    TIMESTAMP NOT NULL,
            REG_DESCRIPTION     VARCHAR(1000),
            REG_CONTENT_ID      INTEGER,
            REG_DELETED         SMALLINT,
            REG_TENANT_ID INTEGER DEFAULT 0,
            REG_UUID VARCHAR(100) NOT NULL,
            CONSTRAINT PK_REG_RESOURCE_HISTORY PRIMARY KEY(REG_VERSION, REG_TENANT_ID)
)/

ALTER TABLE REG_RESOURCE_HISTORY ADD CONSTRAINT REG_RH_FK_BY_PATHID FOREIGN KEY (REG_PATH_ID, REG_TENANT_ID) REFERENCES REG_PATH (REG_PATH_ID, REG_TENANT_ID)/
ALTER TABLE REG_RESOURCE_HISTORY ADD CONSTRAINT REG_RH_FK_BY_CONTENT_ID FOREIGN KEY (REG_CONTENT_ID, REG_TENANT_ID) REFERENCES REG_CONTENT_HISTORY (REG_CONTENT_ID, REG_TENANT_ID)/
CREATE INDEX REG_RH_IND_BY_NAME ON REG_RESOURCE_HISTORY(REG_NAME, REG_TENANT_ID)/
CREATE INDEX REG_RH_IND_BY_PATH_ID_NAME ON REG_RESOURCE(REG_PATH_ID, REG_NAME, REG_TENANT_ID)/

CREATE TABLE REG_COMMENT (
            REG_ID        INTEGER DEFAULT 0,
            REG_COMMENT_TEXT      VARCHAR(500) NOT NULL,
            REG_USER_ID           VARCHAR(31) NOT NULL,
            REG_COMMENTED_TIME    TIMESTAMP NOT NULL,
            REG_TENANT_ID INTEGER DEFAULT 0,
            CONSTRAINT PK_REG_COMMENT PRIMARY KEY(REG_ID, REG_TENANT_ID)
)/

CREATE SEQUENCE PUB.REG_COMMENT_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER REG_COMMENT_TRIGGER
			AFTER INSERT ON REG_COMMENT
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE REG_COMMENT SET REG_ID = PUB.REG_COMMENT_SEQUENCE.NEXTVAL WHERE REG_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE REG_RESOURCE_COMMENT (
            REG_COMMENT_ID          INTEGER NOT NULL,
            REG_VERSION             INTEGER,
            REG_PATH_ID             INTEGER,
            REG_RESOURCE_NAME       VARCHAR(256),
            REG_TENANT_ID INTEGER DEFAULT 0
)/

ALTER TABLE REG_RESOURCE_COMMENT ADD CONSTRAINT REG_RC_FK_BY_PATH_ID FOREIGN KEY (REG_PATH_ID, REG_TENANT_ID) REFERENCES REG_PATH (REG_PATH_ID, REG_TENANT_ID)/
ALTER TABLE REG_RESOURCE_COMMENT ADD CONSTRAINT REG_RC_FK_BY_COMMENT_ID FOREIGN KEY (REG_COMMENT_ID, REG_TENANT_ID) REFERENCES REG_COMMENT (REG_ID, REG_TENANT_ID)/
CREATE INDEX REG_RC_IND_BY_PATH_ID_AND_RN ON REG_RESOURCE_COMMENT(REG_PATH_ID, REG_RESOURCE_NAME, REG_TENANT_ID)/
CREATE INDEX REG_RC_IND_BY_VERSION ON REG_RESOURCE_COMMENT(REG_VERSION, REG_TENANT_ID)/

CREATE TABLE REG_RATING (
            REG_ID     INTEGER DEFAULT 0,
            REG_RATING        INTEGER NOT NULL,
            REG_USER_ID       VARCHAR(31) NOT NULL,
            REG_RATED_TIME    TIMESTAMP NOT NULL,
            REG_TENANT_ID INTEGER DEFAULT 0,
            CONSTRAINT PK_REG_RATING PRIMARY KEY(REG_ID, REG_TENANT_ID)
)/

CREATE SEQUENCE PUB.REG_RATING_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER REG_RATING_TRIGGER
			AFTER INSERT ON REG_RATING
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE REG_RATING SET REG_ID = PUB.REG_RATING_SEQUENCE.NEXTVAL WHERE REG_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE REG_RESOURCE_RATING (
            REG_RATING_ID           INTEGER NOT NULL,
            REG_VERSION             INTEGER,
            REG_PATH_ID             INTEGER,
            REG_RESOURCE_NAME       VARCHAR(256),
            REG_TENANT_ID INTEGER DEFAULT 0
)/

ALTER TABLE REG_RESOURCE_RATING ADD CONSTRAINT REG_RR_FK_BY_PATH_ID FOREIGN KEY (REG_PATH_ID, REG_TENANT_ID) REFERENCES REG_PATH (REG_PATH_ID, REG_TENANT_ID)/
ALTER TABLE REG_RESOURCE_RATING ADD CONSTRAINT REG_RR_FK_BY_RATING_ID FOREIGN KEY (REG_RATING_ID, REG_TENANT_ID) REFERENCES REG_RATING (REG_ID, REG_TENANT_ID)/
CREATE INDEX REG_RR_IND_BY_PATH_ID_AND_RN ON REG_RESOURCE_RATING(REG_PATH_ID, REG_RESOURCE_NAME, REG_TENANT_ID)/
CREATE INDEX REG_RR_IND_BY_VERSION ON REG_RESOURCE_RATING(REG_VERSION, REG_TENANT_ID)/


CREATE TABLE REG_TAG (
            REG_ID         INTEGER DEFAULT 0,
            REG_TAG_NAME       VARCHAR(500) NOT NULL,
            REG_USER_ID        VARCHAR(31) NOT NULL,
            REG_TAGGED_TIME    TIMESTAMP NOT NULL,
            REG_TENANT_ID INTEGER DEFAULT 0,
            CONSTRAINT PK_REG_TAG PRIMARY KEY(REG_ID, REG_TENANT_ID)
)/

CREATE SEQUENCE PUB.REG_TAG_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER REG_TAG_TRIGGER
			AFTER INSERT ON REG_TAG
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE REG_TAG SET REG_ID = PUB.REG_TAG_SEQUENCE.NEXTVAL WHERE REG_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE REG_RESOURCE_TAG (
            REG_TAG_ID              INTEGER NOT NULL,
            REG_VERSION             INTEGER,
            REG_PATH_ID             INTEGER,
            REG_RESOURCE_NAME       VARCHAR(256),
            REG_TENANT_ID INTEGER DEFAULT 0
)/

ALTER TABLE REG_RESOURCE_TAG ADD CONSTRAINT REG_RT_FK_BY_PATH_ID FOREIGN KEY (REG_PATH_ID, REG_TENANT_ID) REFERENCES REG_PATH (REG_PATH_ID, REG_TENANT_ID)/
ALTER TABLE REG_RESOURCE_TAG ADD CONSTRAINT REG_RT_FK_BY_TAG_ID FOREIGN KEY (REG_TAG_ID, REG_TENANT_ID) REFERENCES REG_TAG (REG_ID, REG_TENANT_ID)/
CREATE INDEX REG_RT_IND_BY_PATH_ID_AND_RN ON REG_RESOURCE_TAG(REG_PATH_ID, REG_RESOURCE_NAME, REG_TENANT_ID)/
CREATE INDEX REG_RT_IND_BY_VERSION ON REG_RESOURCE_TAG(REG_VERSION, REG_TENANT_ID)/

CREATE TABLE REG_PROPERTY (
            REG_ID         INTEGER DEFAULT 0,
            REG_NAME       VARCHAR(100) NOT NULL,
            REG_VALUE        VARCHAR(1000),
            REG_TENANT_ID INTEGER DEFAULT 0,
            CONSTRAINT PK_REG_PROPERTY PRIMARY KEY(REG_ID, REG_TENANT_ID)
)/

CREATE SEQUENCE PUB.REG_PROPERTY_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER REG_PROPERTY_TRIGGER
			AFTER INSERT ON REG_PROPERTY
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE REG_PROPERTY SET REG_ID = PUB.REG_PROPERTY_SEQUENCE.NEXTVAL WHERE REG_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE REG_RESOURCE_PROPERTY (
            REG_PROPERTY_ID         INTEGER NOT NULL,
            REG_VERSION             INTEGER,
            REG_PATH_ID             INTEGER,
            REG_RESOURCE_NAME       VARCHAR(256),
            REG_TENANT_ID INTEGER DEFAULT 0
)/

ALTER TABLE REG_RESOURCE_PROPERTY ADD CONSTRAINT REG_RP_FK_BY_PATH_ID FOREIGN KEY (REG_PATH_ID, REG_TENANT_ID) REFERENCES REG_PATH (REG_PATH_ID, REG_TENANT_ID)/
ALTER TABLE REG_RESOURCE_PROPERTY ADD CONSTRAINT REG_RP_FK_BY_TAG_ID FOREIGN KEY (REG_PROPERTY_ID, REG_TENANT_ID) REFERENCES REG_PROPERTY (REG_ID, REG_TENANT_ID)/
CREATE INDEX REG_RP_IND_BY_PATH_ID_AND_RN ON REG_RESOURCE_PROPERTY(REG_PATH_ID, REG_RESOURCE_NAME, REG_TENANT_ID)/
CREATE INDEX REG_RP_IND_BY_VERSION ON REG_RESOURCE_PROPERTY(REG_VERSION, REG_TENANT_ID)/

CREATE TABLE REG_ASSOCIATION (
            REG_ASSOCIATION_ID INTEGER DEFAULT 0,
            REG_SOURCEPATH VARCHAR (2000) NOT NULL,
            REG_TARGETPATH VARCHAR (2000) NOT NULL,
            REG_ASSOCIATION_TYPE VARCHAR (2000) NOT NULL,
            REG_TENANT_ID INTEGER DEFAULT 0,
            PRIMARY KEY (REG_ASSOCIATION_ID, REG_TENANT_ID)
)/

CREATE SEQUENCE PUB.REG_ASSOCIATION_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER REG_ASSOCIATION_TRIGGER
			AFTER INSERT ON REG_ASSOCIATION
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE REG_ASSOCIATION SET REG_ASSOCIATION_ID = PUB.REG_ASSOCIATION_SEQUENCE.NEXTVAL WHERE REG_ASSOCIATION_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE REG_SNAPSHOT (
            REG_SNAPSHOT_ID     INTEGER DEFAULT 0,
            REG_PATH_ID            INTEGER NOT NULL,
            REG_RESOURCE_NAME VARCHAR (256),
            REG_RESOURCE_VIDS BLOB(1073741823) NOT NULL,
            REG_TENANT_ID INTEGER DEFAULT 0,
            CONSTRAINT PK_REG_SNAPSHOT PRIMARY KEY(REG_SNAPSHOT_ID, REG_TENANT_ID)
)/

CREATE SEQUENCE PUB.REG_SNAPSHOT_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/


ALTER TABLE REG_SNAPSHOT ADD CONSTRAINT REG_S_FK_BY_PATH_ID FOREIGN KEY (REG_PATH_ID, REG_TENANT_ID) REFERENCES REG_PATH (REG_PATH_ID, REG_TENANT_ID)/
CREATE INDEX REG_S_IND_BY_PATH_ID_AND_RN ON REG_SNAPSHOT(REG_PATH_ID, REG_RESOURCE_NAME, REG_TENANT_ID)/

CREATE TABLE UM_TENANT (
			UM_ID INTEGER DEFAULT 0,
			UM_DOMAIN_NAME VARCHAR(255) NOT NULL,
	        UM_EMAIL VARCHAR(255),
	        UM_ACTIVE BIT DEFAULT 0,
	        UM_CREATED_DATE TIMESTAMP NOT NULL,
			PRIMARY KEY (UM_ID),
			UNIQUE(UM_DOMAIN_NAME))/

CREATE SEQUENCE PUB.UM_TENANT_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_TENANT_TRIGGER
			AFTER INSERT ON UM_TENANT
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_TENANT SET UM_ID = PUB.UM_TENANT_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE INDEX INDEX_UMT_UM_DOMAIN_NAME ON UM_TENANT (UM_DOMAIN_NAME)/ 

CREATE TABLE UM_USER (
			UM_ID INTEGER DEFAULT 0,
			UM_USER_NAME VARCHAR(255) NOT NULL,
			UM_USER_PASSWORD VARCHAR(255) NOT NULL,
			UM_SALT_VALUE VARCHAR(31),
			UM_REQUIRE_CHANGE BIT DEFAULT 0,
            UM_CHANGED_TIME TIMESTAMP NOT NULL,
			UM_TENANT_ID INTEGER DEFAULT 0,
			PRIMARY KEY (UM_ID, UM_TENANT_ID),
			UNIQUE(UM_USER_NAME, UM_TENANT_ID))/

CREATE SEQUENCE PUB.UM_USER_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_USER_TRIGGER
			AFTER INSERT ON UM_USER
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_USER SET UM_ID = PUB.UM_USER_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_USER_ATTRIBUTE (
			UM_ID INTEGER DEFAULT 0,
			UM_ATTR_NAME VARCHAR(255) NOT NULL,
			UM_ATTR_VALUE VARCHAR(1024),
            UM_PROFILE_ID VARCHAR(255),
            UM_USER_ID INTEGER,
            UM_TENANT_ID INTEGER DEFAULT 0,
			PRIMARY KEY (UM_ID, UM_TENANT_ID),
			FOREIGN KEY (UM_USER_ID, UM_TENANT_ID) REFERENCES UM_USER(UM_ID, UM_TENANT_ID))/

CREATE SEQUENCE PUB.UM_USER_ATTRIBUTE_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_USER_ATTRIBUTE_TRIGGER
			AFTER INSERT ON UM_USER_ATTRIBUTE
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_USER_ATTRIBUTE SET UM_ID = PUB.UM_USER_ATTRIBUTE_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_ROLE (
			UM_ID INTEGER DEFAULT 0,
			UM_ROLE_NAME VARCHAR(255) NOT NULL,
			UM_TENANT_ID INTEGER DEFAULT 0,
			UM_SHARED_ROLE BIT DEFAULT 0,
			PRIMARY KEY (UM_ID, UM_TENANT_ID),
			UNIQUE(UM_ROLE_NAME, UM_TENANT_ID))/

CREATE SEQUENCE PUB.UM_ROLE_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_ROLE_TRIGGER
			AFTER INSERT ON UM_ROLE
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_ROLE SET UM_ID = PUB.UM_ROLE_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_MODULE(
	UM_ID INTEGER  DEFAULT 0,
	UM_MODULE_NAME VARCHAR(100),
	UNIQUE(UM_MODULE_NAME),
	PRIMARY KEY(UM_ID)
)/

CREATE SEQUENCE PUB.UM_MODULE_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_MODULE_TRIGGER
			AFTER INSERT ON UM_MODULE
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_MODULE SET UM_ID = PUB.UM_MODULE_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_MODULE_ACTIONS(
	UM_ACTION VARCHAR(255) NOT NULL,
	UM_MODULE_ID INTEGER NOT NULL,
	PRIMARY KEY(UM_ACTION, UM_MODULE_ID),
	FOREIGN KEY (UM_MODULE_ID) REFERENCES UM_MODULE(UM_ID) ON DELETE CASCADE
)/

CREATE TABLE UM_PERMISSION (
			UM_ID INTEGER DEFAULT 0,
			UM_RESOURCE_ID VARCHAR(255) NOT NULL,
			UM_ACTION VARCHAR(255) NOT NULL,
			UM_TENANT_ID INTEGER DEFAULT 0,
			UM_MODULE_ID INTEGER DEFAULT 0,
			PRIMARY KEY (UM_ID, UM_TENANT_ID))/

CREATE SEQUENCE PUB.UM_PERMISSION_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_PERMISSION_TRIGGER
			AFTER INSERT ON UM_PERMISSION
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_PERMISSION SET UM_ID = PUB.UM_PERMISSION_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE INDEX INDEX_UMP_UM_RESOURCE_ID_UA ON UM_PERMISSION (UM_RESOURCE_ID, UM_ACTION, UM_TENANT_ID)/

CREATE TABLE UM_ROLE_PERMISSION (
			UM_ID INTEGER DEFAULT 0,
			UM_PERMISSION_ID INTEGER NOT NULL,
			UM_ROLE_NAME VARCHAR(255) NOT NULL,
            UM_IS_ALLOWED SMALLINT NOT NULL,
			UM_TENANT_ID INTEGER DEFAULT 0,
			UNIQUE (UM_PERMISSION_ID, UM_ROLE_NAME, UM_TENANT_ID),
			FOREIGN KEY (UM_PERMISSION_ID, UM_TENANT_ID) REFERENCES UM_PERMISSION(UM_ID, UM_TENANT_ID),
			PRIMARY KEY (UM_ID, UM_TENANT_ID))/

CREATE SEQUENCE PUB.UM_ROLE_PERMISSION_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_ROLE_PERMISSION_TRIGGER
			AFTER INSERT ON UM_ROLE_PERMISSION
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_ROLE_PERMISSION SET UM_ID = PUB.UM_ROLE_PERMISSION_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_USER_PERMISSION (
			UM_ID INTEGER DEFAULT 0,
			UM_PERMISSION_ID INTEGER NOT NULL,
			UM_USER_NAME VARCHAR(255) NOT NULL,
            UM_IS_ALLOWED SMALLINT NOT NULL,
			UM_TENANT_ID INTEGER DEFAULT 0,
			UNIQUE (UM_PERMISSION_ID, UM_USER_NAME, UM_TENANT_ID),
			FOREIGN KEY (UM_PERMISSION_ID, UM_TENANT_ID) REFERENCES UM_PERMISSION(UM_ID, UM_TENANT_ID),
			PRIMARY KEY (UM_ID, UM_TENANT_ID))/

CREATE SEQUENCE PUB.UM_USER_PERMISSION_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_USER_PERMISSION_TRIGGER
			AFTER INSERT ON UM_USER_PERMISSION
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_USER_PERMISSION SET UM_ID = PUB.UM_USER_PERMISSION_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_USER_ROLE (
			UM_ID INTEGER DEFAULT 0,
			UM_ROLE_ID INTEGER NOT NULL,
			UM_USER_ID INTEGER NOT NULL,
			UM_TENANT_ID INTEGER DEFAULT 0,
			UNIQUE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID),
			FOREIGN KEY (UM_ROLE_ID, UM_TENANT_ID) REFERENCES UM_ROLE(UM_ID, UM_TENANT_ID),
			FOREIGN KEY (UM_USER_ID, UM_TENANT_ID) REFERENCES UM_USER(UM_ID, UM_TENANT_ID),
			PRIMARY KEY (UM_ID, UM_TENANT_ID))/

CREATE SEQUENCE PUB.UM_USER_ROLE_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_USER_ROLE_TRIGGER
			AFTER INSERT ON UM_USER_ROLE
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_USER_ROLE SET UM_ID = PUB.UM_USER_ROLE_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/


CREATE TABLE UM_SHARED_USER_ROLE(
    UM_ROLE_ID INTEGER NOT NULL,
    UM_USER_ID INTEGER NOT NULL,
    UM_USER_TENANT_ID INTEGER NOT NULL,
    UM_ROLE_TENANT_ID INTEGER NOT NULL,
    UNIQUE(UM_USER_ID,UM_ROLE_ID,UM_USER_TENANT_ID, UM_ROLE_TENANT_ID),
    FOREIGN KEY(UM_ROLE_ID,UM_ROLE_TENANT_ID) REFERENCES UM_ROLE(UM_ID,UM_TENANT_ID) ON DELETE CASCADE ,
    FOREIGN KEY(UM_USER_ID,UM_USER_TENANT_ID) REFERENCES UM_USER(UM_ID,UM_TENANT_ID) ON DELETE CASCADE
)/

CREATE TABLE UM_DIALECT(
            UM_ID INTEGER DEFAULT 0,
            UM_DIALECT_URI VARCHAR(255) NOT NULL,
            UM_TENANT_ID INTEGER DEFAULT 0,
            UNIQUE (UM_DIALECT_URI, UM_TENANT_ID),
            PRIMARY KEY (UM_ID, UM_TENANT_ID)
)/

CREATE SEQUENCE PUB.UM_DIALECT_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_DIALECT_TRIGGER
			AFTER INSERT ON UM_DIALECT
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_DIALECT SET UM_ID = PUB.UM_DIALECT_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/


CREATE TABLE UM_ACCOUNT_MAPPING(
	UM_ID INTEGER  DEFAULT 0,
	UM_USER_NAME VARCHAR(255) NOT NULL,
	UM_TENANT_ID INTEGER NOT NULL,
	UM_USER_STORE_DOMAIN VARCHAR(100),
	UM_ACC_LINK_ID INTEGER NOT NULL,
	UNIQUE(UM_USER_NAME, UM_TENANT_ID, UM_USER_STORE_DOMAIN, UM_ACC_LINK_ID),
	FOREIGN KEY (UM_TENANT_ID) REFERENCES UM_TENANT(UM_ID) ON DELETE CASCADE,
	PRIMARY KEY (UM_ID)
)/

CREATE SEQUENCE PUB.UM_ACCOUNT_MAPPING_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_ACCOUNT_MAPPING_TRIGGER
			AFTER INSERT ON UM_ACCOUNT_MAPPING
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_ACCOUNT_MAPPING SET UM_ID = PUB.UM_ACCOUNT_MAPPING_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_CLAIM(
            UM_ID INTEGER DEFAULT 0,
            UM_DIALECT_ID INTEGER NOT NULL,
            UM_CLAIM_URI VARCHAR(255) NOT NULL,
            UM_DISPLAY_TAG VARCHAR(255),
            UM_DESCRIPTION VARCHAR(255),
            UM_MAPPED_ATTRIBUTE VARCHAR(255),
            UM_REG_EX VARCHAR(255),
            UM_SUPPORTED SMALLINT,
            UM_REQUIRED SMALLINT,
            UM_DISPLAY_ORDER INTEGER,
	    UM_CHECKED_ATTRIBUTE SMALLINT,
	    UM_READ_ONLY SMALLINT,
            UM_TENANT_ID INTEGER DEFAULT 0,
            UNIQUE (UM_DIALECT_ID, UM_CLAIM_URI, UM_TENANT_ID),
            FOREIGN KEY (UM_DIALECT_ID, UM_TENANT_ID) REFERENCES UM_DIALECT(UM_ID, UM_TENANT_ID),
            PRIMARY KEY (UM_ID, UM_TENANT_ID)
)/
CREATE SEQUENCE PUB.UM_CLAIM_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_CLAIM_TRIGGER
			AFTER INSERT ON UM_CLAIM
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_CLAIM SET UM_ID = PUB.UM_CLAIM_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_PROFILE_CONFIG(
            UM_ID INTEGER DEFAULT 0,
            UM_DIALECT_ID INTEGER,
            UM_PROFILE_NAME VARCHAR(255),
            UM_TENANT_ID INTEGER DEFAULT 0,
            FOREIGN KEY (UM_DIALECT_ID, UM_TENANT_ID) REFERENCES UM_DIALECT(UM_ID, UM_TENANT_ID),
            PRIMARY KEY (UM_ID, UM_TENANT_ID)
)/
CREATE SEQUENCE PUB.UM_PROFILE_CONFIG_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_PROFILE_CONFIG_TRIGGER
			AFTER INSERT ON UM_PROFILE_CONFIG
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_PROFILE_CONFIG SET UM_ID = PUB.UM_PROFILE_CONFIG_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_CLAIM_BEHAVIOR(
            UM_ID INTEGER DEFAULT 0,
            UM_PROFILE_ID INTEGER,
            UM_CLAIM_ID INTEGER,
            UM_BEHAVIOUR SMALLINT,
            UM_TENANT_ID INTEGER DEFAULT 0,
            FOREIGN KEY (UM_PROFILE_ID, UM_TENANT_ID) REFERENCES UM_PROFILE_CONFIG(UM_ID, UM_TENANT_ID),
            FOREIGN KEY (UM_CLAIM_ID, UM_TENANT_ID) REFERENCES UM_CLAIM(UM_ID, UM_TENANT_ID),
            PRIMARY KEY (UM_ID, UM_TENANT_ID)
)/
CREATE SEQUENCE PUB.UM_CLAIM_BEHAVIOR_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_CLAIM_BEHAVIOR_TRIGGER
			AFTER INSERT ON UM_CLAIM_BEHAVIOR
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_CLAIM_BEHAVIOR SET UM_ID = PUB.UM_CLAIM_BEHAVIOR_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_HYBRID_ROLE(
            UM_ID INTEGER DEFAULT 0,
            UM_ROLE_NAME VARCHAR(255),
            UM_TENANT_ID INTEGER DEFAULT 0,
            PRIMARY KEY (UM_ID, UM_TENANT_ID)
)/
CREATE SEQUENCE PUB.UM_HYBRID_ROLE_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_HYBRID_ROLE_TRIGGER
			AFTER INSERT ON UM_HYBRID_ROLE
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_HYBRID_ROLE SET UM_ID = PUB.UM_HYBRID_ROLE_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_HYBRID_USER_ROLE(
            UM_ID INTEGER DEFAULT 0,
            UM_USER_NAME VARCHAR(255),
            UM_ROLE_ID INTEGER NOT NULL,
            UM_TENANT_ID INTEGER DEFAULT 0,
            UNIQUE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID),
            FOREIGN KEY (UM_ROLE_ID, UM_TENANT_ID) REFERENCES UM_HYBRID_ROLE(UM_ID, UM_TENANT_ID),
            PRIMARY KEY (UM_ID, UM_TENANT_ID)
)/
CREATE SEQUENCE PUB.UM_HYBRID_USER_ROLE_SEQUENCE
			START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_HYBRID_USER_ROLE_TRIGGER
			AFTER INSERT ON UM_HYBRID_USER_ROLE
            		IMPORT
		        import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_HYBRID_USER_ROLE SET UM_ID = PUB.UM_HYBRID_USER_ROLE_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

CREATE TABLE UM_HYBRID_REMEMBER_ME(
            UM_ID INTEGER DEFAULT 0,
	        UM_USER_NAME VARCHAR(255) NOT NULL,
	        UM_COOKIE_VALUE VARCHAR(1024),
	        UM_CREATED_TIME TIMESTAMP,
            UM_TENANT_ID INTEGER DEFAULT 0,
	        PRIMARY KEY (UM_ID, UM_TENANT_ID)
)/
CREATE SEQUENCE PUB.UM_HYBRID_REMEMBER_ME_SEQUENCE 
                        START WITH 1, INCREMENT BY 1, NOCYCLE/

CREATE TRIGGER UM_HYBRID_REMEMBER_ME_TRIGGER
                    AFTER INSERT ON UM_HYBRID_REMEMBER_ME
            		IMPORT
		            import java.sql.*;
            		BEGIN
            		String stmt = "UPDATE UM_HYBRID_REMEMBER_ME SET UM_ID = PUB.UM_HYBRID_REMEMBER_ME_SEQUENCE.NEXTVAL WHERE UM_ID = 0" ;
            		SQLIStatement update_stmt = new SQLIStatement(stmt) ;
            		update_stmt.execute() ;
			END/

