/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.ui;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.feature.mgt.stub.ProvisioningAdminServiceCallbackHandler;
import org.wso2.carbon.feature.mgt.stub.ProvisioningAdminServiceStub;
import org.wso2.carbon.feature.mgt.stub.prov.data.Feature;
import org.wso2.carbon.feature.mgt.stub.prov.data.FeatureInfo;
import org.wso2.carbon.feature.mgt.stub.prov.data.LicenseInfo;
import org.wso2.carbon.feature.mgt.stub.prov.data.ProfileHistory;
import org.wso2.carbon.feature.mgt.stub.prov.data.ProvisioningActionInfo;
import org.wso2.carbon.feature.mgt.stub.prov.data.ProvisioningActionResultInfo;
import org.wso2.carbon.feature.mgt.ui.FeatureWrapper;
import org.wso2.carbon.feature.mgt.ui.util.Utils;
import org.wso2.carbon.utils.CarbonUtils;

public class ProvisioningAdminClient {
    private static final Log log = LogFactory.getLog(ProvisioningAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.feature.mgt.ui.i18n.Resources";
    private ResourceBundle bundle;
    public static String INSTALLED_FEATURES = "installed.features";
    public static String ENABLED = "Enabled";
    public static String DISABLED = "Disabled";
    private boolean isComplete = false;
    private boolean isError = false;
    private Exception exception;
    private ProfileHistory[] profileHistories = new ProfileHistory[0];
    public ProvisioningAdminServiceStub provAdminStub;
    ProvisioningAdminServiceCallbackHandler callback = new ProvisioningAdminServiceCallbackHandler(){

        public void receiveResultperformProvisioningAction(boolean result) {
            ProvisioningAdminClient.this.isComplete = true;
        }

        public void receiveErrorperformProvisioningAction(Exception e) {
            ProvisioningAdminClient.this.isError = true;
            ProvisioningAdminClient.this.exception = e;
        }

        public void receiveResultremoveAllConsoleFeatures(boolean result) {
            ProvisioningAdminClient.this.isComplete = true;
        }

        public void receiveErrorremoveAllConsoleFeatures(Exception e) {
            ProvisioningAdminClient.this.isError = true;
            ProvisioningAdminClient.this.exception = e;
        }

        public void receiveResultremoveAllServerFeatures(boolean result) {
            ProvisioningAdminClient.this.isComplete = true;
        }

        public void receiveErrorremoveAllServerFeatures(Exception e) {
            ProvisioningAdminClient.this.isError = true;
            ProvisioningAdminClient.this.exception = e;
        }

        public void receiveResultgetProfileHistory(ProfileHistory[] result) {
            ProvisioningAdminClient.access$302(ProvisioningAdminClient.this, Arrays.copyOf(result, result.length));
            ProvisioningAdminClient.this.isComplete = true;
        }

        public void receiveErrorgetProfileHistory(Exception e) {
            ProvisioningAdminClient.this.isError = true;
            ProvisioningAdminClient.this.exception = e;
        }
    };

    public ProvisioningAdminClient(String cookie, String backendServerURL, ConfigurationContext configContext, Locale locale) throws Exception {
        try {
            this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
            String serviceURL = backendServerURL + "ProvisioningAdminService";
            this.provAdminStub = new ProvisioningAdminServiceStub(configContext, serviceURL);
            ServiceClient client = this.provAdminStub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public ProvisioningActionResultInfo reviewInstallFeaturesAction(FeatureInfo[] features) throws Exception {
        ProvisioningActionResultInfo provisioningActionResultInfo = null;
        try {
            ProvisioningActionInfo provisioningActionInfo = new ProvisioningActionInfo();
            provisioningActionInfo.setFeaturesToInstall(features);
            provisioningActionInfo.setActionType("org.wso2.carbon.prov.action.install");
            provisioningActionResultInfo = this.provAdminStub.reviewProvisioningAction(provisioningActionInfo);
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(this.bundle.getString(e.getFaultCode().getLocalPart()), (Exception)((Object)e));
            }
            this.handleException(this.bundle.getString("failed.review.prov.action"), (Exception)((Object)e));
        }
        return provisioningActionResultInfo;
    }

    public FeatureInfo getInstalledFeatureDetails(String featureID, String featureVersion) throws Exception {
        FeatureInfo featureInfo = null;
        try {
            featureInfo = this.provAdminStub.getInstalledFeatureInfo(featureID, featureVersion);
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(MessageFormat.format(this.bundle.getString(e.getFaultCode().getLocalPart()), featureID, featureVersion), (Exception)((Object)e));
            }
            this.handleException(MessageFormat.format(this.bundle.getString("failed.get.feature.information"), featureID, featureVersion), (Exception)((Object)e));
        }
        return featureInfo;
    }

    public LicenseInfo[] getLicensingInformation() throws Exception {
        LicenseInfo[] licenseInfo = null;
        try {
            licenseInfo = this.provAdminStub.getLicensingInformation();
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(this.bundle.getString(e.getFaultCode().getLocalPart()), (Exception)((Object)e));
            }
            this.handleException(this.bundle.getString("failed.get.license.info"), (Exception)((Object)e));
        }
        return licenseInfo;
    }

    public void performInstallation(String actionType) throws Exception {
        try {
            if (CarbonUtils.isRunningOnLocalTransportMode()) {
                this.provAdminStub.performProvisioningAction(actionType);
            } else {
                ServiceClient client = this.provAdminStub._getServiceClient();
                client.engageModule("addressing");
                Options options = client.getOptions();
                options.setUseSeparateListener(true);
                options.setTransportInProtocol("http");
                this.provAdminStub.startperformProvisioningAction(actionType, this.callback);
                this.handleCallback();
            }
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(this.bundle.getString(e.getFaultCode().getLocalPart()), (Exception)((Object)e));
            }
            this.handleException(this.bundle.getString("failed.perform.prov.action"), (Exception)((Object)e));
        }
    }

    public FeatureWrapper[] getInstalledFeatures() throws Exception {
        FeatureWrapper[] featureWrappers = null;
        try {
            Feature[] features = this.provAdminStub.getAllInstalledFeatures();
            featureWrappers = Utils.processFeatureTree(features, false, 0);
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(this.bundle.getString(e.getFaultCode().getLocalPart()), (Exception)((Object)e));
            }
            this.handleException(this.bundle.getString("failed.get.installed.features"), (Exception)((Object)e));
        }
        return featureWrappers;
    }

    public FeatureInfo[] getInstalledFeaturesWithProperty(String key, String value) throws Exception {
        FeatureInfo[] featureInfos = null;
        try {
            featureInfos = this.provAdminStub.getInstalledFeaturesWithProperty(key, value);
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(MessageFormat.format(this.bundle.getString(e.getFaultCode().getLocalPart()), key, value), (Exception)((Object)e));
            }
            this.handleException(MessageFormat.format(this.bundle.getString("failed.get.installed.feature.with.prop"), key, value), (Exception)((Object)e));
        }
        return featureInfos;
    }

    public ProvisioningActionResultInfo reviewUninstallFeaturesAction(FeatureInfo[] features) throws Exception {
        ProvisioningActionResultInfo provisioningActionResultInfo = null;
        try {
            ProvisioningActionInfo provisioningActionInfo = new ProvisioningActionInfo();
            provisioningActionInfo.setFeaturesToUninstall(features);
            provisioningActionInfo.setActionType("org.wso2.carbon.prov.action.uninstall");
            return this.provAdminStub.reviewProvisioningAction(provisioningActionInfo);
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(this.bundle.getString(e.getFaultCode().getLocalPart()), (Exception)((Object)e));
            } else {
                this.handleException(this.bundle.getString("failed.review.prov.action"), (Exception)((Object)e));
            }
            return provisioningActionResultInfo;
        }
    }

    public ProfileHistory[] getProfileHistory() throws Exception {
        try {
            if (CarbonUtils.isRunningOnLocalTransportMode()) {
                this.profileHistories = this.provAdminStub.getProfileHistory();
            } else {
                ServiceClient client = this.provAdminStub._getServiceClient();
                client.engageModule("addressing");
                Options options = client.getOptions();
                options.setUseSeparateListener(true);
                options.setTransportInProtocol("http");
                this.provAdminStub.startgetProfileHistory(this.callback);
                this.handleCallback();
            }
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(this.bundle.getString(e.getFaultCode().getLocalPart()), (Exception)((Object)e));
            }
            this.handleException(this.bundle.getString("failed.get.profile.history"), (Exception)((Object)e));
        }
        return this.profileHistories;
    }

    public ProvisioningActionResultInfo reviewRevertPlan(String timestampString) throws Exception {
        ProvisioningActionResultInfo provisioningActionResultInfo = null;
        try {
            ProvisioningActionInfo provisioningActionInfo = new ProvisioningActionInfo();
            provisioningActionInfo.setTimestamp(Long.parseLong(timestampString));
            provisioningActionInfo.setActionType("org.wso2.carbon.prov.action.revert");
            provisioningActionResultInfo = this.provAdminStub.reviewProvisioningAction(provisioningActionInfo);
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(this.bundle.getString(e.getFaultCode().getLocalPart()), (Exception)((Object)e));
            }
            this.handleException(this.bundle.getString("failed.review.prov.action"), (Exception)((Object)e));
        }
        return provisioningActionResultInfo;
    }

    public void removeAllFeaturesWithProperty(String key, String value) throws Exception {
        try {
            if (CarbonUtils.isRunningOnLocalTransportMode()) {
                if ("org.wso2.carbon.p2.category.type".equals(key) && "server".equalsIgnoreCase(value)) {
                    this.provAdminStub.removeAllServerFeatures();
                } else if ("org.wso2.carbon.p2.category.type".equals(key) && "console".equalsIgnoreCase(value)) {
                    this.provAdminStub.removeAllConsoleFeatures();
                }
            } else {
                ServiceClient client = this.provAdminStub._getServiceClient();
                client.engageModule("addressing");
                Options options = client.getOptions();
                options.setUseSeparateListener(true);
                options.setTransportInProtocol("http");
                if ("org.wso2.carbon.p2.category.type".equals(key) && "server".equalsIgnoreCase(value)) {
                    this.provAdminStub.startremoveAllServerFeatures(this.callback);
                    this.handleCallback();
                } else if ("org.wso2.carbon.p2.category.type".equals(key) && "console".equalsIgnoreCase(value)) {
                    this.provAdminStub.startremoveAllConsoleFeatures(this.callback);
                    this.handleCallback();
                }
            }
        }
        catch (AxisFault e) {
            if (e.getFaultCode() != null) {
                this.handleException(this.bundle.getString(e.getFaultCode().getLocalPart()), (Exception)((Object)e));
            }
            this.handleException(this.bundle.getString("failed.remove.server.console.features"), (Exception)((Object)e));
        }
    }

    public String getInstallActionType() {
        return "org.wso2.carbon.prov.action.install";
    }

    public String getUninstallActionType() {
        return "org.wso2.carbon.prov.action.uninstall";
    }

    public String getRevertActionType() {
        return "org.wso2.carbon.prov.action.revert";
    }

    private void handleCallback() throws Exception {
        int i = 0;
        while (!this.isComplete && !this.isError) {
            Thread.sleep(500L);
            if (++i <= 288000) continue;
            throw new Exception("Response not received within 4 hours");
        }
        if (this.isError) {
            this.isError = false;
            throw this.exception;
        }
        this.isComplete = false;
    }

    private void handleException(String msg, Exception e) throws Exception {
        log.error((Object)msg, (Throwable)e);
        throw new Exception(msg, e);
    }

    static /* synthetic */ ProfileHistory[] access$302(ProvisioningAdminClient x0, ProfileHistory[] x1) {
        x0.profileHistories = x1;
        return x1;
    }
}

