/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.services.prov;

import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.wso2.carbon.feature.mgt.core.ResolutionResult;
import org.wso2.carbon.feature.mgt.core.operations.OperationFactory;
import org.wso2.carbon.feature.mgt.core.operations.ProfileChangeOperation;
import org.wso2.carbon.feature.mgt.core.util.IUPropertyUtils;
import org.wso2.carbon.feature.mgt.core.util.ProvisioningUtils;
import org.wso2.carbon.feature.mgt.services.prov.data.Feature;
import org.wso2.carbon.feature.mgt.services.prov.data.FeatureInfo;
import org.wso2.carbon.feature.mgt.services.prov.data.LicenseInfo;
import org.wso2.carbon.feature.mgt.services.prov.data.ProfileHistory;
import org.wso2.carbon.feature.mgt.services.prov.data.ProvisioningActionInfo;
import org.wso2.carbon.feature.mgt.services.prov.data.ProvisioningActionResultInfo;
import org.wso2.carbon.feature.mgt.services.prov.utils.ProvWSUtils;

public class ProvisioningAdminService {
    private static final Log log = LogFactory.getLog(ProvisioningAdminService.class);

    public Feature[] getAllInstalledFeatures() throws AxisFault {
        Feature[] features = null;
        try {
            features = ProvWSUtils.wrapInstalledFeatures(ProvisioningUtils.getAllInstalledRootFeatures((IQueryable)ProvisioningUtils.getProfile()).toArray(new IInstallableUnit[0]), (IQueryable)ProvisioningUtils.getProfile());
        }
        catch (Exception e) {
            this.handleException("Error occurred querying installed features", "failed.get.installed.features", e);
        }
        return features;
    }

    public boolean removeAllServerFeatures() throws AxisFault {
        try {
            this.removeConsoleOrServerFeatures("server");
        }
        catch (Exception e) {
            this.handleException("Error occurred while removing server features", "failed.remove.server.features", e);
        }
        return true;
    }

    public boolean removeAllConsoleFeatures() throws AxisFault {
        try {
            this.removeConsoleOrServerFeatures("console");
        }
        catch (Exception e) {
            this.handleException("Error occurred while removing console features", "failed.remove.console.features", e);
        }
        return true;
    }

    public FeatureInfo[] getInstalledFeaturesWithProperty(String key, String value) throws AxisFault {
        return null;
    }

    public FeatureInfo getInstalledFeatureInfo(String featureID, String featureVersion) throws AxisFault {
        FeatureInfo featureInfo = null;
        try {
            IQuery query = QueryUtil.createIUQuery((String)featureID, (Version)Version.create((String)featureVersion));
            IInstallableUnit[] installableUnits = (IInstallableUnit[])ProvisioningUtils.getProfile().query(query, (IProgressMonitor)new NullProgressMonitor()).toArray(IInstallableUnit.class);
            if (installableUnits == null || installableUnits.length == 0) {
                log.error((Object)("Error occurred while querying feature information :" + featureID + "-" + featureVersion));
                throw new AxisFault("failed.get.feature.information");
            }
            IInstallableUnit iu = installableUnits[0];
            ILicense license = IUPropertyUtils.getLicense((IInstallableUnit)iu);
            ICopyright copyright = IUPropertyUtils.getCopyright((IInstallableUnit)iu);
            featureInfo = ProvWSUtils.wrapIUsAsFeaturesWithDetails(iu, license, copyright);
        }
        catch (Exception e) {
            this.handleException("Error occurred while querying feature information :" + featureID + "-" + featureVersion, "failed.get.feature.information", e);
        }
        return featureInfo;
    }

    public ProvisioningActionResultInfo reviewProvisioningAction(ProvisioningActionInfo provActionInfo) throws AxisFault {
        ProfileChangeOperation profileChangeOperation = OperationFactory.getProfileChangeOperation((String)provActionInfo.getActionType());
        if (profileChangeOperation == null) {
            this.handleException("Error occurred while reviewing provisioning action", "failed.review.prov.action");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reviewing the provisioning action: " + profileChangeOperation.getActionType()));
        }
        ProvisioningActionResultInfo provisioningActionResultInfo = null;
        try {
            IInstallableUnit[] repositoryIUs = ProvWSUtils.deriveRepositoryIUsFromFeatures(provActionInfo.getFeaturesToInstall());
            profileChangeOperation.setIusToInstall(repositoryIUs);
            IInstallableUnit[] profileIUs = ProvWSUtils.deriveProfileIUsFromFeatures(provActionInfo.getFeaturesToUninstall());
            profileChangeOperation.setIusToUninstall(profileIUs);
            profileChangeOperation.setTimestamp(provActionInfo.getTimestamp());
            ResolutionResult resolutionResult = profileChangeOperation.reviewProfileChangeAction(ProvisioningUtils.getProfile());
            provisioningActionResultInfo = ProvWSUtils.wrapResolutionResult(resolutionResult);
            int severity = resolutionResult.getSummaryStatus().getSeverity();
            if (severity == 4) {
                provisioningActionResultInfo.setProceedWithInstallation(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed to proceed with the provisioning action due an error," + resolutionResult.getSummaryReport()));
                }
            } else {
                provisioningActionResultInfo.setProceedWithInstallation(true);
                ProvWSUtils.saveResolutionResult(profileChangeOperation.getActionType(), resolutionResult, MessageContext.getCurrentMessageContext());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Successfully reviewed the provisioning action");
                }
            }
        }
        catch (Exception e) {
            this.handleException("Error occurred while reviewing provisioning action", "failed.review.prov.action", e);
        }
        return provisioningActionResultInfo;
    }

    public LicenseInfo[] getLicensingInformation() throws AxisFault {
        LicenseInfo[] licenseInfo = null;
        try {
            ResolutionResult resolutionResult = ProvWSUtils.getResolutionResult("org.wso2.carbon.prov.action.install", MessageContext.getCurrentMessageContext());
            if (resolutionResult == null) {
                return new LicenseInfo[0];
            }
            ILicense[] licenses = ProvisioningUtils.getLicensingInformation((IProvisioningPlan)resolutionResult.getProvisioningPlan());
            licenseInfo = ProvWSUtils.wrapP2LicensesAsLicenses(licenses);
        }
        catch (Exception e) {
            this.handleException("Error occurred while querying license information", "failed.get.license.info", e);
        }
        return licenseInfo;
    }

    public boolean performProvisioningAction(String actionType) throws AxisFault {
        try {
            ResolutionResult resolutionResult = ProvWSUtils.getResolutionResult(actionType, MessageContext.getCurrentMessageContext());
            if (resolutionResult == null) {
                this.handleException("Error occurred while performing provisioning action", "failed.perform.prov.action");
            }
            ProvisioningUtils.performProvisioningAction((ResolutionResult)resolutionResult);
        }
        catch (Exception e) {
            this.handleException("Error occurred while performing provisioning action", "failed.perform.prov.action", e);
        }
        return true;
    }

    public ProfileHistory[] getProfileHistory() throws AxisFault {
        int installableFeatures = 0;
        int uninstallableFeatures = 0;
        ArrayList<ProfileHistory> profileHistoryList = new ArrayList<ProfileHistory>();
        try {
            long[] timestamps = ProvisioningUtils.getProfileTimestamps((String)"_SELF_");
            ProfileChangeOperation profileChangeOperation = OperationFactory.getProfileChangeOperation((String)"org.wso2.carbon.prov.action.revert");
            for (long timestamp : timestamps) {
                profileChangeOperation.setTimestamp(timestamp);
                ResolutionResult resolutionResult = profileChangeOperation.reviewProfileChangeAction(ProvisioningUtils.getProfile());
                if (resolutionResult.getReviewedInstallableUnits() != null) {
                    installableFeatures = resolutionResult.getReviewedInstallableUnits().length;
                }
                if (resolutionResult.getReviewedUninstallableUnits() != null) {
                    uninstallableFeatures = resolutionResult.getReviewedUninstallableUnits().length;
                }
                if (installableFeatures == 0 && uninstallableFeatures == 0) continue;
                ProfileHistory history = ProvWSUtils.getProfileHistoryFromTimestamp(timestamp);
                profileHistoryList.add(history);
            }
        }
        catch (Exception e) {
            this.handleException("Error occurred while querying profile history", "failed.get.profile.history", e);
        }
        return profileHistoryList.toArray(new ProfileHistory[profileHistoryList.size()]);
    }

    private void removeConsoleOrServerFeatures(String propertyValue) throws Exception {
        IInstallableUnit[] allInstalledIUs;
        ArrayList<IInstallableUnit> iusToUninstall = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> iusToInstall = new ArrayList<IInstallableUnit>();
        for (IInstallableUnit iu : allInstalledIUs = ProvisioningUtils.getAllInstalledIUs()) {
            String categoryPropValue = iu.getProperty("org.wso2.carbon.p2.category.type");
            if (iu.getId().startsWith("org.wso2.carbon.core.runtime") || iu.getId().startsWith("carbon.product")) continue;
            if (categoryPropValue != null && !categoryPropValue.equalsIgnoreCase(propertyValue)) {
                iusToInstall.add(iu);
                continue;
            }
            iusToUninstall.add(iu);
        }
        ProfileChangeOperation profileChangeOperation = OperationFactory.getProfileChangeOperation((String)"org.wso2.carbon.prov.action.uninstall");
        profileChangeOperation.setIusToUninstall(iusToUninstall.toArray(new IInstallableUnit[iusToUninstall.size()]));
        ResolutionResult resolutionResult = profileChangeOperation.reviewProfileChangeAction(ProvisioningUtils.getProfile());
        ProvisioningUtils.performProvisioningAction((ResolutionResult)resolutionResult);
        profileChangeOperation = OperationFactory.getProfileChangeOperation((String)"org.wso2.carbon.prov.action.install");
        profileChangeOperation.setIusToInstall(iusToInstall.toArray(new IInstallableUnit[iusToInstall.size()]));
        resolutionResult = profileChangeOperation.reviewProfileChangeAction(ProvisioningUtils.getProfile());
        ProvisioningUtils.performProvisioningAction((ResolutionResult)resolutionResult);
    }

    private void handleException(String msg, String faultCode, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, faultCode, (Throwable)e);
    }

    private void handleException(String msg, String faultCode) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg, faultCode);
    }
}

