/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.bootup.validator;

import com.jezhumble.javasysmon.JavaSysMon;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.bootup.validator.ConfigurationValidator;
import org.wso2.carbon.core.bootup.validator.util.UnknownParameterException;
import org.wso2.carbon.core.bootup.validator.util.ValidationResult;

public class SystemValidator
extends ConfigurationValidator {
    private static final Log log = LogFactory.getLog(SystemValidator.class);
    private MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private JavaSysMon sys = new JavaSysMon();
    public static final String CPU_PARAM = "CPU";
    public static final String RAM_PARAM = "RAM";
    public static final String SWAP_PARAM = "swap";
    public static final String MAX_FREE_DISK_PARAM = "freeDisk";
    public static final String OPEN_FILES_PARAM = "ulimit";
    public static final String CERT_FINGERPRINT_PARAM = "certFingerprint";
    public static final int MB_BASE = 0x100000;
    public static final int MHz_BASE = 1000000;
    private static final String IBM_J9_VM = "IBM J9 VM";

    @Override
    public Map<String, ValidationResult> validate() {
        Map<String, String> recommendedConfigs = this.getRecommendedConfigurations();
        HashMap<String, ValidationResult> validationResults = new HashMap<String, ValidationResult>();
        for (String paramName : recommendedConfigs.keySet()) {
            try {
                ValidationResult result = this.validateConfiguration(paramName);
                validationResults.put(paramName, result);
            }
            catch (Exception e) {
                log.warn((Object)("Could not validate the system for configuration parameter : " + paramName));
                log.debug((Object)("Error occured while trying to validate configuration parameter : " + paramName), (Throwable)e);
            }
        }
        return validationResults;
    }

    protected ValidationResult validateConfiguration(String parameterName) throws MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        ValidationResult result;
        if (CPU_PARAM.equals(parameterName)) {
            String recommendedCpu = this.getRecommendedConfigurations().get(parameterName);
            long systemCpu = this.getCpuMhz();
            result = this.validateCPU(systemCpu, Long.parseLong(recommendedCpu));
        } else if (RAM_PARAM.equals(parameterName)) {
            String recommendedRAM = this.getRecommendedConfigurations().get(parameterName);
            long systemRAM = this.getRAM();
            result = this.validateRAM(systemRAM, Long.parseLong(recommendedRAM));
        } else if (SWAP_PARAM.equals(parameterName)) {
            String recommendedTotalSwap = this.getRecommendedConfigurations().get(parameterName);
            long systemTotalSwap = this.getSwap();
            result = this.validateSwap(systemTotalSwap, Long.parseLong(recommendedTotalSwap));
        } else if (OPEN_FILES_PARAM.equals(parameterName)) {
            if (this.isWindows()) {
                String windowsUlimitMsg = "Windows OS doesn't support ulimit query";
                result = new ValidationResult(true, windowsUlimitMsg);
            } else {
                String recommendedFDCount = this.getRecommendedConfigurations().get(parameterName);
                long systemFDCount = this.getOpenFilesLimit();
                result = this.validateOpenFilesLimit(systemFDCount, Long.parseLong(recommendedFDCount));
            }
        } else if (MAX_FREE_DISK_PARAM.equals(parameterName)) {
            String recommendedDiskSpace = this.getRecommendedConfigurations().get(parameterName);
            long systemDiskSpace = this.getMaxFreeDiskSpace();
            result = this.validateDiskSpace(systemDiskSpace, Long.parseLong(recommendedDiskSpace));
        } else if (CERT_FINGERPRINT_PARAM.equals(parameterName)) {
            String certFingerprint = this.getRecommendedConfigurations().get(parameterName);
            result = this.validateKeystoreFingerprint(certFingerprint);
        } else {
            throw new UnknownParameterException(" Unknown paramater :" + parameterName);
        }
        return result;
    }

    private ValidationResult validateRAM(long systemRam, long minReq) {
        boolean isValid;
        ValidationResult result = new ValidationResult();
        String msg = null;
        if (systemRam >= minReq) {
            isValid = true;
        } else {
            msg = "RAM size (MB): " + systemRam + " of the system is below the recommended minimum size :" + minReq;
            isValid = false;
        }
        result.setValidationMessage(msg);
        result.setValid(isValid);
        return result;
    }

    private ValidationResult validateSwap(long systemSwap, long minReq) {
        boolean isValid;
        ValidationResult result = new ValidationResult();
        String msg = null;
        if (systemSwap >= minReq) {
            isValid = true;
        } else {
            msg = "Swap Memory size (MB): " + systemSwap + " of the system is below the recommended minimum size :" + minReq;
            isValid = false;
        }
        result.setValidationMessage(msg);
        result.setValid(isValid);
        return result;
    }

    private ValidationResult validateCPU(long systemCPU, long minReq) {
        boolean isValid;
        ValidationResult result = new ValidationResult();
        String msg = null;
        if (systemCPU >= minReq) {
            isValid = true;
        } else {
            msg = "CPU speed (MHz): " + systemCPU + " of the system is below the recommended minimum speed :" + minReq;
            isValid = false;
        }
        result.setValidationMessage(msg);
        result.setValid(isValid);
        return result;
    }

    private ValidationResult validateOpenFilesLimit(long openFileLimit, long minLimit) {
        boolean isValid;
        ValidationResult result = new ValidationResult();
        String msg = null;
        if (openFileLimit >= minLimit) {
            isValid = true;
        } else {
            msg = "Open files limit :" + openFileLimit + " of the system is below the recommended minimum count :" + minLimit;
            isValid = false;
        }
        result.setValidationMessage(msg);
        result.setValid(isValid);
        return result;
    }

    private ValidationResult validateDiskSpace(long systemDisk, long minReq) {
        boolean isValid;
        ValidationResult result = new ValidationResult();
        String msg = null;
        if (systemDisk >= minReq) {
            isValid = true;
        } else {
            msg = "Maximum free Disk Space (MB): " + systemDisk + " of the system is below the recommended minimum size :" + minReq;
            isValid = false;
        }
        result.setValidationMessage(msg);
        result.setValid(isValid);
        return result;
    }

    private ValidationResult validateKeystoreFingerprint(String certFingerprint) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        boolean isValid;
        ValidationResult result = new ValidationResult();
        String msg = null;
        KeyStore primaryKeyStore = this.getPrimaryKeyStore();
        X509Certificate wso2CarbonCert = null;
        if (primaryKeyStore != null) {
            wso2CarbonCert = (X509Certificate)primaryKeyStore.getCertificate("wso2carbon");
        } else {
            log.error((Object)"Error loading primary keystore, cannot validate keystore");
        }
        if (wso2CarbonCert != null && this.getCertFingerprint(wso2CarbonCert).equalsIgnoreCase(certFingerprint)) {
            msg = "The default keystore (wso2carbon.jks) is currently being used. To maximize security when deploying to a production environment, configure a new keystore with a unique password in the production server profile.";
            isValid = false;
        } else {
            isValid = true;
        }
        result.setValidationMessage(msg);
        result.setValid(isValid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getPrimaryKeyStore() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore primaryKeyStore;
        ServerConfiguration config = ServerConfiguration.getInstance();
        String file = new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath();
        KeyStore store = KeyStore.getInstance(config.getFirstProperty("Security.KeyStore.Type"));
        String password = config.getFirstProperty("Security.KeyStore.Password");
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            store.load(in, password.toCharArray());
            primaryKeyStore = store;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return primaryKeyStore;
    }

    private String getCertFingerprint(X509Certificate certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        MessageDigest digestValue = MessageDigest.getInstance("MD5");
        byte[] der = certificate.getEncoded();
        digestValue.update(der);
        byte[] digestInBytes = digestValue.digest();
        return this.hexify(digestInBytes);
    }

    private String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF] + ":");
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    private long getCpuMhz() {
        return this.sys.cpuFrequencyInHz() / 1000000L * (long)this.sys.numCpus();
    }

    private long getRAM() throws MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        Long ramValue = null;
        ObjectName osBean = new ObjectName("java.lang:type=OperatingSystem");
        ramValue = IBM_J9_VM.equals(System.getProperty("java.vm.name")) ? (Long)this.mBeanServer.getAttribute(osBean, "TotalPhysicalMemory") : (Long)this.mBeanServer.getAttribute(osBean, "TotalPhysicalMemorySize");
        return ramValue / 0x100000L;
    }

    private long getSwap() throws MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ObjectName osBean = new ObjectName("java.lang:type=OperatingSystem");
        Long swapValue = (Long)this.mBeanServer.getAttribute(osBean, "TotalSwapSpaceSize");
        return swapValue / 0x100000L;
    }

    private long getOpenFilesLimit() throws MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ObjectName osBean = new ObjectName("java.lang:type=OperatingSystem");
        Long maxFDValue = (Long)this.mBeanServer.getAttribute(osBean, "MaxFileDescriptorCount");
        return maxFDValue;
    }

    private long getMaxFreeDiskSpace() {
        File[] roots;
        long maxFreeSpace = 0L;
        for (File disk : roots = File.listRoots()) {
            long diskFreeSpace = disk.getFreeSpace() / 0x100000L;
            if (!disk.isDirectory() || diskFreeSpace <= maxFreeSpace) continue;
            maxFreeSpace = diskFreeSpace;
        }
        return maxFreeSpace;
    }

    private boolean isWindows() {
        boolean isWindows = false;
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            isWindows = true;
        }
        return isWindows;
    }
}

