/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine.phases;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CertificateChecker {
    private ArrayList<File> artifacts;
    private final IProvisioningAgent agent;

    public CertificateChecker() {
        this(null);
    }

    public CertificateChecker(IProvisioningAgent agent) {
        this.agent = agent;
        this.artifacts = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus start() {
        BundleContext context = EngineActivator.getContext();
        ServiceReference contentFactoryRef = context.getServiceReference(SignedContentFactory.class);
        SignedContentFactory verifierFactory = (SignedContentFactory)context.getService(contentFactoryRef);
        try {
            IStatus iStatus = this.checkCertificates(verifierFactory);
            return iStatus;
        }
        finally {
            context.ungetService(contentFactoryRef);
        }
    }

    private IStatus checkCertificates(SignedContentFactory verifierFactory) {
        Certificate[][] unTrustedCertificateChains;
        String[] details;
        int i;
        UIServices serviceUI = (UIServices)this.agent.getService(UIServices.SERVICE_NAME);
        SignedContent content = null;
        SignerInfo[] signerInfo = null;
        ArrayList<Certificate> untrusted = new ArrayList<Certificate>();
        ArrayList<File> unsigned = new ArrayList<File>();
        ArrayList<Certificate[]> untrustedChain = new ArrayList<Certificate[]>();
        IStatus status = Status.OK_STATUS;
        if (this.artifacts.size() == 0 || serviceUI == null) {
            return status;
        }
        for (File artifact : this.artifacts) {
            try {
                content = verifierFactory.getSignedContent(artifact);
                if (!content.isSigned()) {
                    unsigned.add(artifact);
                    continue;
                }
                signerInfo = content.getSignerInfos();
            }
            catch (GeneralSecurityException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentError, (Throwable)e);
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentIOError, (Throwable)e);
            }
            for (i = 0; i < signerInfo.length; ++i) {
                Certificate[] certificateChain;
                if (signerInfo[i].isTrusted() || untrusted.contains((certificateChain = signerInfo[i].getCertificateChain())[0])) continue;
                untrusted.add(certificateChain[0]);
                untrustedChain.add(certificateChain);
            }
        }
        String policy = this.getUnsignedContentPolicy();
        if (!unsigned.isEmpty() && "fail".equals(policy)) {
            return new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.CertificateChecker_UnsignedNotAllowed, unsigned));
        }
        if ("allow".equals(policy) || unsigned.isEmpty()) {
            details = null;
        } else {
            details = new String[unsigned.size()];
            for (i = 0; i < details.length; ++i) {
                details[i] = ((File)unsigned.get(i)).toString();
            }
        }
        if (untrusted.isEmpty()) {
            unTrustedCertificateChains = null;
        } else {
            unTrustedCertificateChains = new Certificate[untrustedChain.size()][];
            for (int i2 = 0; i2 < untrustedChain.size(); ++i2) {
                unTrustedCertificateChains[i2] = (Certificate[])untrustedChain.get(i2);
            }
        }
        if (details == null && unTrustedCertificateChains == null) {
            return status;
        }
        UIServices.TrustInfo trustInfo = serviceUI.getTrustInfo(unTrustedCertificateChains, details);
        if (!trustInfo.trustUnsignedContent()) {
            return Status.CANCEL_STATUS;
        }
        Certificate[] trustedCertificates = trustInfo.getTrustedCertificates();
        if (unTrustedCertificateChains != null && trustedCertificates == null) {
            return new Status(8, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        if (trustedCertificates != null) {
            for (int i3 = 0; i3 < trustedCertificates.length; ++i3) {
                untrusted.remove(trustedCertificates[i3]);
            }
        }
        if (untrusted.size() > 0) {
            return new Status(8, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        if (trustInfo.persistTrust()) {
            return this.persistTrustedCertificates(trustedCertificates);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus persistTrustedCertificates(Certificate[] trustedCertificates) {
        if (trustedCertificates == null) {
            return new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        ServiceTracker trustEngineTracker = new ServiceTracker(EngineActivator.getContext(), TrustEngine.class, null);
        trustEngineTracker.open();
        Object[] trustEngines = trustEngineTracker.getServices();
        try {
            if (trustEngines == null) {
                IStatus iStatus = null;
                return iStatus;
            }
            block9: for (Certificate trustedCertificate : trustedCertificates) {
                for (Object engine : trustEngines) {
                    TrustEngine trustEngine = (TrustEngine)engine;
                    if (trustEngine.isReadOnly()) continue;
                    try {
                        trustEngine.addTrustAnchor(trustedCertificate, trustedCertificate.toString());
                        continue block9;
                    }
                    catch (IOException e) {
                        Status status = new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_KeystoreConnectionError, (Throwable)e);
                        trustEngineTracker.close();
                        return status;
                    }
                    catch (GeneralSecurityException e) {
                        Status status = new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateError, (Throwable)e);
                        trustEngineTracker.close();
                        return status;
                    }
                }
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                        return Status.OK_STATUS;
                    }
                }
            }
        }
        finally {
            trustEngineTracker.close();
        }
    }

    private String getUnsignedContentPolicy() {
        String policy = EngineActivator.getContext().getProperty("eclipse.p2.unsignedPolicy");
        if (policy == null) {
            policy = "prompt";
        }
        return policy;
    }

    public void add(File toAdd) {
        this.artifacts.add(toAdd);
    }

    public void add(Object[] toAdd) {
        for (int i = 0; i < toAdd.length; ++i) {
            if (!(toAdd[i] instanceof File)) continue;
            this.add((File)toAdd[i]);
        }
    }
}

