/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.engine.ActionManager;
import org.eclipse.equinox.internal.p2.engine.EngineSession;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.osgi.util.NLS;

public class PhaseSet
implements IPhaseSet {
    private final Phase[] phases;

    public PhaseSet(Phase[] phases) {
        if (phases == null) {
            throw new IllegalArgumentException(Messages.null_phases);
        }
        this.phases = phases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MultiStatus perform(EngineSession session, Operand[] operands, IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        int[] weights = this.getProgressWeights(operands);
        int totalWork = this.getTotalWork(weights);
        SubMonitor pm = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
        try {
            for (int i = 0; i < this.phases.length; ++i) {
                MultiStatus result;
                if (pm.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    MultiStatus multiStatus = status;
                    return multiStatus;
                }
                Phase phase = this.phases[i];
                phase.actionManager = (ActionManager)session.getAgent().getService(ActionManager.SERVICE_NAME);
                try {
                    phase.perform(status, session, operands, (IProgressMonitor)pm.newChild(weights[i]));
                }
                catch (OperationCanceledException e) {
                    status.add((IStatus)new Status(8, "org.eclipse.equinox.p2.engine", e.getMessage(), (Throwable)e));
                }
                catch (RuntimeException e) {
                    status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", e.getMessage(), (Throwable)e));
                }
                catch (LinkageError e) {
                    status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", e.getMessage(), (Throwable)e));
                }
                finally {
                    phase.actionManager = null;
                }
                if (status.matches(8)) {
                    result = new MultiStatus("org.eclipse.equinox.p2.engine", 8, Messages.Engine_Operation_Canceled_By_User, null);
                    result.merge((IStatus)status);
                    MultiStatus multiStatus = result;
                    return multiStatus;
                }
                if (!status.matches(4)) continue;
                result = new MultiStatus("org.eclipse.equinox.p2.engine", 4, phase.getProblemMessage(), null);
                result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", session.getContextString(), null));
                result.merge((IStatus)status);
                MultiStatus multiStatus = result;
                return multiStatus;
            }
        }
        finally {
            pm.done();
        }
        return status;
    }

    /*
     * Exception decompiling
     */
    public final IStatus validate(ActionManager actionManager, IProfile profile, Operand[] operands, ProvisioningContext context, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getContextString(IProfile profile, Phase phase, Operand operand) {
        return NLS.bind((String)Messages.session_context, (Object[])new Object[]{profile.getProfileId(), phase.getClass().getName(), operand.toString(), ""});
    }

    private int getTotalWork(int[] weights) {
        int sum = 0;
        for (int i = 0; i < weights.length; ++i) {
            sum += weights[i];
        }
        return sum;
    }

    private int[] getProgressWeights(Operand[] operands) {
        int[] weights = new int[this.phases.length];
        for (int i = 0; i < this.phases.length; ++i) {
            weights[i] = operands.length > 0 ? this.phases[i].weight * this.countApplicable(this.phases[i], operands) / operands.length : this.phases[i].weight;
        }
        return weights;
    }

    private int countApplicable(Phase phase, Operand[] operands) {
        int count = 0;
        for (int i = 0; i < operands.length; ++i) {
            if (!phase.isApplicable(operands[i])) continue;
            ++count;
        }
        return count;
    }

    @Override
    public String[] getPhaseIds() {
        String[] ids = new String[this.phases.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this.phases[i].phaseId;
        }
        return ids;
    }

    public Phase[] getPhases() {
        return this.phases;
    }
}

