/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.server.internal;

import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.server.internal.Utils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class RegistryServerServiceComponent {
    private static Log log = LogFactory.getLog(RegistryServerServiceComponent.class);

    protected void activate(ComponentContext context) {
        log.debug((Object)"Registry Service bundle is activated ");
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Registry Service bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
        Utils.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Utils.setRegistryService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        try {
            if (contextService.getServerConfigContext() != null && contextService.getServerConfigContext().getAxisConfiguration() != null) {
                contextService.getServerConfigContext().getAxisConfiguration().engageModule("pagination");
            } else {
                log.error((Object)"Failed to pagination Activation Module.");
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Failed to pagination Module", (Throwable)e);
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
    }
}

