/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.server.CarbonLaunchExtension;
import org.wso2.carbon.server.util.JarInfo;
import org.wso2.carbon.server.util.PatchInfo;
import org.wso2.carbon.server.util.PatchUtils;
import org.wso2.carbon.server.util.Utils;

public class PatchInstaller
implements CarbonLaunchExtension {
    private static Log log = LogFactory.getLog(PatchInstaller.class);

    @Override
    public void perform() {
        File carbonComponentDir = Utils.getCarbonComponentRepo();
        File plugins = new File(carbonComponentDir, "plugins");
        File servicepackDir = new File(carbonComponentDir, "servicepacks");
        File patchesDir = new File(carbonComponentDir, "patches");
        File bundleBackupDir = new File(patchesDir, "patch0000");
        File prePatchedDirFile = new File(PatchUtils.getMetaDirectory(), "prePatchedDir.txt");
        try {
            PatchInfo patchInfo = PatchUtils.processPatches(prePatchedDirFile, servicepackDir, patchesDir);
            boolean changesOnPatches = false;
            if (patchInfo.getRemovedPatchesCount() > 0 || patchInfo.isServicepackUpdated()) {
                log.info((Object)"Patch changes detected ");
                changesOnPatches = true;
                PatchUtils.applyServicepacksAndPatches(servicepackDir, patchesDir, plugins);
            } else {
                Map<String, JarInfo> currentlyPatchedJars = PatchUtils.getJarsInAppliedServicepackAndPatches(servicepackDir, patchesDir);
                boolean patchUpdated = PatchUtils.checkUpdatedJars(currentlyPatchedJars);
                if (patchUpdated) {
                    log.info((Object)"Patch changes detected ");
                    changesOnPatches = true;
                    PatchUtils.applyServicepacksAndPatches(servicepackDir, patchesDir, plugins);
                } else if (patchInfo.getNewPatchesCount() > 0) {
                    changesOnPatches = true;
                    log.info((Object)"Patch changes detected ");
                    if (!bundleBackupDir.exists()) {
                        PatchUtils.applyServicepacksAndPatches(servicepackDir, patchesDir, plugins);
                    } else {
                        Collections.sort(patchInfo.getNewPatches());
                        PatchUtils.copyNewPatches(servicepackDir, patchesDir, patchInfo.getNewPatches().get(0), plugins);
                    }
                }
            }
            Map<String, JarInfo> latestPatchedJar = PatchUtils.getMostLatestJarsInServicepackAndPatches(servicepackDir, patchesDir);
            PatchUtils.checkMD5Checksum(latestPatchedJar, plugins, changesOnPatches);
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while applying patches", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while verifying md5 checksum of patched jars", (Throwable)e);
        }
    }
}

