/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.server.CarbonLaunchExtension;

public class EclipseIniRewriter
implements CarbonLaunchExtension {
    private static Log log = LogFactory.getLog(EclipseIniRewriter.class);
    private static final String CARBON_OSGI_DIR_LOCATION = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "components";

    @Override
    public void perform() {
        File eclipseIni = null;
        String profileName = System.getProperty("profile", "default");
        String profileLocation = CARBON_OSGI_DIR_LOCATION + File.separator + profileName;
        try {
            profileLocation = new File(profileLocation).getCanonicalPath();
        }
        catch (IOException e) {
            log.error((Object)("The directory : " + profileName + "does not exist.."), (Throwable)e);
        }
        eclipseIni = new File(profileLocation + File.separator + "null.ini");
        if (eclipseIni.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing the null.ini file found in " + profileLocation));
            }
            this.rewriteFile(eclipseIni, profileLocation);
            return;
        }
        eclipseIni = new File(profileLocation + File.separator + "eclipse.ini");
        if (eclipseIni.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing the eclispe.ini file found in " + profileLocation));
            }
            this.rewriteFile(eclipseIni, profileLocation);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteFile(File file, String profileLocation) {
        file.delete();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(file));
            pw.write("-install\n");
            pw.write(profileLocation);
            pw.flush();
        }
        catch (IOException e) {
            log.error((Object)("Error while writing to file " + file.getName()), (Throwable)e);
        }
        finally {
            pw.close();
        }
    }
}

