/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.server.CarbonLaunchExtension;
import org.wso2.carbon.server.util.BundleInfoLine;
import org.wso2.carbon.server.util.FileUtils;
import org.wso2.carbon.server.util.Utils;

public class DropinsBundleDeployer
implements CarbonLaunchExtension {
    private static Log log = LogFactory.getLog(DropinsBundleDeployer.class);

    @Override
    public void perform() {
        try {
            String dropinsDirPath = "repository" + File.separator + "components" + File.separator + "dropins";
            String profileName = System.getProperty("profile", "default");
            String bundlesInfoDirPath = "repository" + File.separator + "components" + File.separator + profileName + File.separator + "configuration" + File.separator + "org.eclipse.equinox.simpleconfigurator";
            File dropinsDir = Utils.getBundleDirectory(dropinsDirPath);
            File[] files = dropinsDir.listFiles(new Utils.JarFileFilter());
            if (files == null) {
                return;
            }
            BundleInfoLine[] newBundleInfoLines = this.getNewBundleInfoLines(files);
            File bundlesInfoDir = Utils.getBundleDirectory(bundlesInfoDirPath);
            File bundlesInfoFile = new File(bundlesInfoDir, "bundles.info");
            if (!bundlesInfoFile.exists()) {
                return;
            }
            Map<String, List<BundleInfoLine>> bundleInfoLineMap = this.processBundlesInfoFile(bundlesInfoFile, newBundleInfoLines);
            this.addNewBundleInfoLines(newBundleInfoLines, bundleInfoLineMap);
            this.updateBundlesInfoFile(bundlesInfoFile, bundleInfoLineMap);
        }
        catch (Exception e) {
            log.error((Object)"Error occured while deploying bundles in the dropins directory", (Throwable)e);
        }
    }

    private BundleInfoLine[] getNewBundleInfoLines(File[] bundleFileList) throws Exception {
        ArrayList<BundleInfoLine> bundleInfoArray = new ArrayList<BundleInfoLine>();
        for (File file : bundleFileList) {
            JarFile jarFile = new JarFile(file.getAbsoluteFile());
            if (jarFile.getManifest() == null || jarFile.getManifest().getMainAttributes() == null) {
                log.error((Object)("Invalid Bundle found in the dropins directory: " + file.getName()));
                continue;
            }
            String bundleSymbolicName = jarFile.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
            if (bundleSymbolicName.contains(";")) {
                bundleSymbolicName = bundleSymbolicName.split(";")[0];
            }
            String bundleVersion = jarFile.getManifest().getMainAttributes().getValue("Bundle-Version");
            if (bundleSymbolicName == null || bundleVersion == null) {
                log.error((Object)("Required Bundle manifest headers do not exists: " + file.getAbsoluteFile()));
                continue;
            }
            boolean isFragment = jarFile.getManifest().getMainAttributes().getValue("Fragment-Host") != null;
            bundleInfoArray.add(new BundleInfoLine(bundleSymbolicName, bundleVersion, "../dropins/" + file.getName(), 4, isFragment));
        }
        return bundleInfoArray.toArray(new BundleInfoLine[bundleInfoArray.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<BundleInfoLine>> processBundlesInfoFile(File bundlesInfoFile, BundleInfoLine[] newBundleInfoLines) throws Exception {
        HashMap<String, List<BundleInfoLine>> bundleInfoLineMap = new HashMap<String, List<BundleInfoLine>>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(bundlesInfoFile.getAbsoluteFile()));
            while ((line = reader.readLine()) != null) {
                ArrayList<BundleInfoLine> bundleInfoLineList;
                if (line.startsWith("#")) continue;
                BundleInfoLine bundleInfoLine = BundleInfoLine.getInstance(line);
                if (bundleInfoLine.isFromDropins()) {
                    boolean found = false;
                    for (BundleInfoLine newBundleInfoLine : newBundleInfoLines) {
                        if (!newBundleInfoLine.getBundleSymbolicName().equals(bundleInfoLine.getBundleSymbolicName()) || !newBundleInfoLine.getBundleVersion().equals(bundleInfoLine.getBundleVersion()) || newBundleInfoLine.isFragment() ^ bundleInfoLine.isFragment()) continue;
                        found = true;
                    }
                    if (!found) continue;
                }
                if ((bundleInfoLineList = (ArrayList<BundleInfoLine>)bundleInfoLineMap.get(bundleInfoLine.getBundleSymbolicName())) == null) {
                    bundleInfoLineList = new ArrayList<BundleInfoLine>();
                    bundleInfoLineList.add(bundleInfoLine);
                    bundleInfoLineMap.put(bundleInfoLine.getBundleSymbolicName(), bundleInfoLineList);
                    continue;
                }
                bundleInfoLineList.add(bundleInfoLine);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to close the InputStream " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return bundleInfoLineMap;
    }

    private void addNewBundleInfoLines(BundleInfoLine[] newBundleInfoLines, Map<String, List<BundleInfoLine>> existingBundleInfoLineMap) {
        for (BundleInfoLine newBundleInfoLine : newBundleInfoLines) {
            String symbolicName = newBundleInfoLine.getBundleSymbolicName();
            String version = newBundleInfoLine.getBundleVersion();
            boolean isFragment = newBundleInfoLine.isFragment();
            List<BundleInfoLine> bundleInfoLineList = existingBundleInfoLineMap.get(symbolicName);
            if (bundleInfoLineList == null) {
                bundleInfoLineList = new ArrayList<BundleInfoLine>();
                bundleInfoLineList.add(newBundleInfoLine);
                existingBundleInfoLineMap.put(symbolicName, bundleInfoLineList);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Deploying bundle: " + newBundleInfoLine.getBundlePath()));
                continue;
            }
            boolean found = false;
            for (BundleInfoLine existingBundleInfoLIne : bundleInfoLineList) {
                if (!existingBundleInfoLIne.getBundleVersion().equals(version)) continue;
                if (existingBundleInfoLIne.isFragment() ^ isFragment) {
                    if (existingBundleInfoLIne.getBundlePath().equals(newBundleInfoLine.getBundlePath())) continue;
                    log.warn((Object)("Ignoring the deployment of bundle: " + newBundleInfoLine.getBundlePath() + ", because it is already available in the system: " + existingBundleInfoLIne.getBundlePath() + ". Bundle-SymbolicName and Bundle-Version headers are identical "));
                    found = true;
                    break;
                }
                if (existingBundleInfoLIne.getBundlePath().equals(newBundleInfoLine.getBundlePath())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deploying bundle: " + newBundleInfoLine.getBundlePath()));
                    }
                    found = true;
                    break;
                }
                log.warn((Object)("Ignoring the deployment of bundle: " + newBundleInfoLine.getBundlePath() + ", because it is already available in the system: " + existingBundleInfoLIne.getBundlePath() + ". Bundle-SymbolicName and Bundle-Version headers are identical "));
                found = true;
                break;
            }
            if (found) continue;
            bundleInfoLineList.add(newBundleInfoLine);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Deploying bundle: " + newBundleInfoLine.getBundlePath()));
        }
    }

    private void updateBundlesInfoFile(File bundlesInfoFile, Map<String, List<BundleInfoLine>> bundleInfoLineMap) throws Exception {
        BufferedWriter writer = null;
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            if (tempDir == null || tempDir.length() == 0) {
                throw new Exception("java.io.tmpdir property is null. Cannot proceed.");
            }
            String tempBundlesInfoDirPath = tempDir + File.separator + "bundles_info_" + UUID.randomUUID().toString();
            String tempBundlesInfoFilePath = tempBundlesInfoDirPath + File.separator + "bundles.info";
            File tempBundlesInfoDir = new File(tempBundlesInfoDirPath);
            boolean created = tempBundlesInfoDir.mkdir();
            if (!created) {
                throw new IOException("Failed to create the directory: " + tempBundlesInfoFilePath);
            }
            writer = new BufferedWriter(new FileWriter(tempBundlesInfoFilePath, true));
            Object[] keyArray = bundleInfoLineMap.keySet().toArray(new String[bundleInfoLineMap.keySet().size()]);
            Arrays.sort(keyArray);
            for (Object key : keyArray) {
                List<BundleInfoLine> bundleInfoLineList = bundleInfoLineMap.get(key);
                for (BundleInfoLine bundleInfoLine : bundleInfoLineList) {
                    writer.write(bundleInfoLine.toString());
                    writer.newLine();
                }
            }
            writer.flush();
            FileUtils.copyFile(new File(tempBundlesInfoFilePath), bundlesInfoFile, true);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while updating the bundles.info file.", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("Unable to close the OutputStream " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

