/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.naming.SelectorContext;
import org.wso2.carbon.context.CarbonContext;

public class CarbonSelectorContext
extends SelectorContext {
    private Context carbonInitialContext;

    public CarbonSelectorContext(Hashtable<String, Object> env, boolean initialContext, Context carbonInitialContext) {
        super(env, initialContext);
        this.carbonInitialContext = carbonInitialContext;
    }

    public Object lookup(Name name) throws NamingException {
        if (this.isSubTenantRequest(name)) {
            return this.getTenantCarbonSelectorContext(name);
        }
        try {
            return super.lookup(name);
        }
        catch (NamingException ex) {
            return this.carbonInitialContext.lookup(name);
        }
    }

    public Object lookup(String name) throws NamingException {
        if (this.isSubTenantRequest(name)) {
            return this.getTenantCarbonSelectorContext(name);
        }
        try {
            return super.lookup(name);
        }
        catch (NamingException ex) {
            return this.carbonInitialContext.lookup(name);
        }
    }

    public Object lookupLink(Name name) throws NamingException {
        if (this.isSubTenantRequest(name)) {
            return this.getTenantCarbonSelectorContext(name);
        }
        try {
            return super.lookupLink(name);
        }
        catch (NamingException ex) {
            return this.carbonInitialContext.lookupLink(name);
        }
    }

    public Object lookupLink(String name) throws NamingException {
        if (this.isSubTenantRequest(name)) {
            return this.getTenantCarbonSelectorContext(name);
        }
        try {
            return super.lookupLink(name);
        }
        catch (NamingException ex) {
            return this.carbonInitialContext.lookupLink(name);
        }
    }

    private boolean isSubTenantRequest(Name name) {
        return this.isSubTenantRequest(name.get(0));
    }

    private boolean isSubTenantRequest(String name) {
        int tID = CarbonContext.getCurrentContext().getTenantId();
        return tID > 0 && name.equals(String.valueOf(tID));
    }

    private Object getTenantCarbonSelectorContext(Name name) throws NamingException {
        return this.getTenantCarbonSelectorContext(name.get(0));
    }

    private Object getTenantCarbonSelectorContext(String name) throws NamingException {
        Context tenantSubContext = (Context)this.carbonInitialContext.lookup(name);
        return new CarbonSelectorContext(this.env, this.initialContext, tenantSubContext);
    }
}

