/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.kerberos;

import javax.crypto.SecretKey;

public class KrbSession {
    private final String thumbPrintEncoded;
    private String clientPrincipalName;
    private String serverPrincipalName;
    private final SecretKey sessionKey;
    private String serviceTicket;

    public KrbSession(String thumbPrintEncoded, SecretKey sessionKey) {
        this.thumbPrintEncoded = thumbPrintEncoded;
        this.sessionKey = sessionKey;
    }

    public void setClientPrincipalName(String clientPrincipalName) {
        this.clientPrincipalName = clientPrincipalName;
    }

    public void setServerPrincipalName(String serverPrincipalName) {
        this.serverPrincipalName = serverPrincipalName;
    }

    public void setServiceTicket(String serviceTicket) {
        this.serviceTicket = serviceTicket;
    }

    public String getClientPrincipalName() {
        return this.clientPrincipalName;
    }

    public String getServerPrincipalName() {
        return this.serverPrincipalName;
    }

    public String getServiceTicket() {
        return this.serviceTicket;
    }

    public SecretKey getSessionKey() {
        return this.sessionKey;
    }

    public String getThumbPrintEncoded() {
        return this.thumbPrintEncoded;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof KrbSession) {
            KrbSession session = (KrbSession)object;
            return session.getThumbPrintEncoded().equals(this.thumbPrintEncoded);
        }
        return false;
    }

    public int hashCode() {
        return this.thumbPrintEncoded.hashCode();
    }

    public String getPrincipalKey() {
        return this.createPrincipalKey(this.clientPrincipalName, this.serverPrincipalName);
    }

    private String createPrincipalKey(String clientPrincipalName, String serverPrincipalName) {
        return clientPrincipalName + "-" + serverPrincipalName;
    }
}

