/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.transaction.UserTransaction;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSMessageSender {
    private static final Log log = LogFactory.getLog(JMSMessageSender.class);
    private Connection connection = null;
    private Session session = null;
    private MessageProducer producer = null;
    private Destination destination = null;
    private int cacheLevel = 1;
    private boolean jmsSpec11 = true;
    private Boolean isQueue = null;

    public JMSMessageSender(Connection connection, Session session, MessageProducer producer, Destination destination, int cacheLevel, boolean jmsSpec11, Boolean isQueue) {
        this.connection = connection;
        this.session = session;
        this.producer = producer;
        this.destination = destination;
        this.cacheLevel = cacheLevel;
        this.jmsSpec11 = jmsSpec11;
        this.isQueue = isQueue;
    }

    public JMSMessageSender(JMSConnectionFactory jmsConnectionFactory, String targetAddress) {
        boolean isQueue;
        this.cacheLevel = jmsConnectionFactory.getCacheLevel();
        this.jmsSpec11 = jmsConnectionFactory.isJmsSpec11();
        this.connection = jmsConnectionFactory.getConnection();
        this.session = jmsConnectionFactory.getSession(this.connection);
        boolean bl = isQueue = jmsConnectionFactory.isQueue() == null ? true : jmsConnectionFactory.isQueue();
        this.destination = jmsConnectionFactory.getSharedDestination() == null ? jmsConnectionFactory.getDestination(JMSUtils.getDestination(targetAddress), isQueue ? "queue" : "topic") : jmsConnectionFactory.getSharedDestination();
        this.producer = jmsConnectionFactory.getMessageProducer(this.connection, this.session, this.destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void send(Message message, MessageContext msgCtx) {
        block64: {
            boolean sendingSuccessful;
            Boolean rollbackOnly;
            Boolean jtaCommit;
            block63: {
                jtaCommit = this.getBooleanProperty(msgCtx, "JTA_COMMIT_AFTER_SEND");
                rollbackOnly = this.getBooleanProperty(msgCtx, "SET_ROLLBACK_ONLY");
                Boolean persistent = this.getBooleanProperty(msgCtx, "JMS_DELIVERY_MODE");
                Integer priority = this.getIntegerProperty(msgCtx, "JMS_PRIORITY");
                Integer timeToLive = this.getIntegerProperty(msgCtx, "JMS_TIME_TO_LIVE");
                if (rollbackOnly != null && rollbackOnly.booleanValue()) {
                    jtaCommit = Boolean.FALSE;
                }
                if (persistent != null) {
                    try {
                        this.producer.setDeliveryMode(2);
                    }
                    catch (JMSException e) {
                        this.handleException("Error setting JMS Producer for PERSISTENT delivery", (Exception)((Object)e));
                    }
                }
                if (priority != null) {
                    try {
                        this.producer.setPriority(priority.intValue());
                    }
                    catch (JMSException e) {
                        this.handleException("Error setting JMS Producer priority to : " + priority, (Exception)((Object)e));
                    }
                }
                if (timeToLive != null) {
                    try {
                        this.producer.setTimeToLive((long)timeToLive.intValue());
                    }
                    catch (JMSException e) {
                        this.handleException("Error setting JMS Producer TTL to : " + timeToLive, (Exception)((Object)e));
                    }
                }
                sendingSuccessful = false;
                if (this.jmsSpec11 || this.isQueue == null) {
                    this.producer.send(message);
                } else if (this.isQueue.booleanValue()) {
                    try {
                        ((QueueSender)this.producer).send(message);
                    }
                    catch (JMSException e) {
                        this.createTempQueueConsumer();
                        ((QueueSender)this.producer).send(message);
                    }
                } else {
                    try {
                        ((TopicPublisher)this.producer).publish(message);
                    }
                    catch (JMSException e) {
                        this.createTempTopicSubscriber();
                        ((TopicPublisher)this.producer).publish(message);
                    }
                }
                String msgId = null;
                try {
                    msgId = message.getJMSMessageID();
                    if (msgId != null) {
                        msgCtx.setProperty("JMS_MESSAGE_ID", (Object)msgId);
                    }
                }
                catch (JMSException ignore) {
                    // empty catch block
                }
                sendingSuccessful = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sent Message Context ID : " + msgCtx.getMessageID() + " with JMS Message ID : " + msgId + " to destination : " + this.producer.getDestination()));
                }
                if (jtaCommit == null) break block63;
                UserTransaction ut = (UserTransaction)msgCtx.getProperty("UserTransaction");
                if (ut != null) {
                    try {
                        if (sendingSuccessful && jtaCommit.booleanValue()) {
                            ut.commit();
                        } else {
                            ut.rollback();
                        }
                        msgCtx.removeProperty("UserTransaction");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " JTA Transaction"));
                        }
                        break block64;
                    }
                    catch (Exception e) {
                        this.handleException("Error committing/rolling back JTA transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, e);
                    }
                }
                break block64;
            }
            try {
                if (this.session.getTransacted()) {
                    if (sendingSuccessful && (rollbackOnly == null || !rollbackOnly.booleanValue())) {
                        this.session.commit();
                    } else {
                        this.session.rollback();
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                }
                break block64;
            }
            catch (JMSException e) {
                this.handleException("Error committing/rolling back local (i.e. session) transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, (Exception)((Object)e));
            }
            break block64;
            catch (JMSException e) {
                block65: {
                    try {
                        log.error((Object)("Error sending message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination), (Throwable)e);
                        if (jtaCommit == null) break block65;
                    }
                    catch (Throwable throwable) {
                        if (jtaCommit != null) {
                            UserTransaction ut = (UserTransaction)msgCtx.getProperty("UserTransaction");
                            if (ut != null) {
                                try {
                                    if (sendingSuccessful && jtaCommit.booleanValue()) {
                                        ut.commit();
                                    } else {
                                        ut.rollback();
                                    }
                                    msgCtx.removeProperty("UserTransaction");
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " JTA Transaction"));
                                    }
                                }
                                catch (Exception e2) {
                                    this.handleException("Error committing/rolling back JTA transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, e2);
                                }
                            }
                        } else {
                            try {
                                if (this.session.getTransacted()) {
                                    if (sendingSuccessful && (rollbackOnly == null || !rollbackOnly.booleanValue())) {
                                        this.session.commit();
                                    } else {
                                        this.session.rollback();
                                    }
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                                }
                            }
                            catch (JMSException e3) {
                                this.handleException("Error committing/rolling back local (i.e. session) transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, (Exception)((Object)e3));
                            }
                        }
                        throw throwable;
                    }
                    UserTransaction ut = (UserTransaction)msgCtx.getProperty("UserTransaction");
                    if (ut == null) break block64;
                    try {
                        if (sendingSuccessful && jtaCommit.booleanValue()) {
                            ut.commit();
                        } else {
                            ut.rollback();
                        }
                        msgCtx.removeProperty("UserTransaction");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " JTA Transaction"));
                        }
                    }
                    catch (Exception e4) {
                        this.handleException("Error committing/rolling back JTA transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, e4);
                    }
                }
                try {
                    if (this.session.getTransacted()) {
                        if (sendingSuccessful && (rollbackOnly == null || !rollbackOnly.booleanValue())) {
                            this.session.commit();
                        } else {
                            this.session.rollback();
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                    }
                }
                catch (JMSException e5) {
                    this.handleException("Error committing/rolling back local (i.e. session) transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, (Exception)((Object)e5));
                }
            }
        }
    }

    public void createTempQueueConsumer() throws JMSException {
        MessageConsumer consumer = ((QueueSession)this.session).createConsumer(this.destination);
        consumer.close();
    }

    public void createTempTopicSubscriber() throws JMSException {
        TopicSubscriber subscriber = ((TopicSession)this.session).createSubscriber((Topic)this.destination);
        subscriber.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.producer != null && this.cacheLevel < 4) {
            try {
                this.producer.close();
            }
            catch (JMSException e) {
                log.error((Object)"Error closing JMS MessageProducer after send", (Throwable)e);
            }
            finally {
                this.producer = null;
            }
        }
        if (this.session != null && this.cacheLevel < 2) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                log.error((Object)"Error closing JMS Session after send", (Throwable)e);
            }
            finally {
                this.session = null;
            }
        }
        if (this.connection != null && this.cacheLevel < 1) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                log.error((Object)"Error closing JMS Connection after send", (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        throw new AxisJMSException(message, e);
    }

    private Boolean getBooleanProperty(MessageContext msgCtx, String name) {
        Object o = msgCtx.getProperty(name);
        if (o != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof String) {
                return Boolean.valueOf((String)o);
            }
        }
        return null;
    }

    private Integer getIntegerProperty(MessageContext msgCtx, String name) {
        Object o = msgCtx.getProperty(name);
        if (o != null) {
            if (o instanceof Integer) {
                return (Integer)o;
            }
            if (o instanceof String) {
                return Integer.parseInt((String)o);
            }
        }
        return null;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public MessageProducer getProducer() {
        return this.producer;
    }

    public Session getSession() {
        return this.session;
    }
}

