/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.AbstractTransportListenerEx;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.event.TransportErrorListener;
import org.apache.axis2.transport.base.event.TransportErrorSource;
import org.apache.axis2.transport.base.event.TransportErrorSourceSupport;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSConnectionFactoryManager;
import org.apache.axis2.transport.jms.JMSEndpoint;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.axis2.transport.jms.ServiceTaskManager;

public class JMSListener
extends AbstractTransportListenerEx<JMSEndpoint>
implements ManagementSupport,
TransportErrorSource {
    public static final String TRANSPORT_NAME = "jms";
    private JMSConnectionFactoryManager connFacManager;
    private final TransportErrorSourceSupport tess = new TransportErrorSourceSupport((Object)this);

    protected void doInit() throws AxisFault {
        this.connFacManager = new JMSConnectionFactoryManager((ParameterInclude)this.getTransportInDescription());
        this.log.info((Object)"JMS Transport Receiver/Listener initialized...");
    }

    protected JMSEndpoint createEndpoint() {
        return new JMSEndpoint(this, this.workerPool);
    }

    protected void startEndpoint(JMSEndpoint endpoint) throws AxisFault {
        ServiceTaskManager stm = endpoint.getServiceTaskManager();
        boolean connected = false;
        int r = 1;
        long retryDuration = 10000L;
        double reconnectionProgressionFactor = 2.0;
        long maxReconnectDuration = 3600000L;
        while (!connected) {
            boolean jmsProviderStarted = this.checkJMSConnection(stm);
            if (jmsProviderStarted) {
                this.log.info((Object)("Connection attempt: " + r + " for JMS Provider for service: " + stm.getServiceName() + " was successful!"));
                connected = true;
                stm.start();
                for (int i = 0; i < 3; ++i) {
                    if (stm.getConsumerCount() > 0) {
                        this.log.info((Object)("Started to listen on destination : " + stm.getDestinationJNDIName() + " of type " + JMSUtils.getDestinationTypeAsString(stm.getDestinationType()) + " for service " + stm.getServiceName()));
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
                this.log.warn((Object)("Polling tasks on destination : " + stm.getDestinationJNDIName() + " of type " + JMSUtils.getDestinationTypeAsString(stm.getDestinationType()) + " for service " + stm.getServiceName() + " have not yet started after 3 seconds .."));
                continue;
            }
            this.log.error((Object)"Unable to continue server startup as it seems the JMS Provider is not yet started. Please start the JMS provider now.");
            retryDuration = (long)((double)retryDuration * reconnectionProgressionFactor);
            this.log.error((Object)("Connection attempt : " + r++ + " for JMS Provider failed. Next retry in " + retryDuration / 1000L + " seconds"));
            if (retryDuration > maxReconnectDuration) {
                retryDuration = maxReconnectDuration;
            }
            try {
                Thread.sleep(retryDuration);
            }
            catch (InterruptedException ignore) {}
        }
    }

    private boolean checkJMSConnection(ServiceTaskManager stm) {
        Connection connection = null;
        Hashtable<String, String> jmsProperties = stm.getJmsProperties();
        try {
            ConnectionFactory jmsConFactory = null;
            try {
                jmsConFactory = JMSUtils.lookup(new InitialContext(stm.getJmsProperties()), ConnectionFactory.class, stm.getConnFactoryJNDIName());
            }
            catch (NamingException e) {
                this.log.error((Object)("Error looking up connection factory : " + stm.getConnFactoryJNDIName() + "using JNDI properties : " + jmsProperties), (Throwable)e);
            }
            connection = JMSUtils.createConnection(jmsConFactory, jmsProperties.get("transport.jms.UserName"), jmsProperties.get("transport.jms.Password"), stm.isJmsSpec11(), stm.isQueue(), stm.isSubscriptionDurable(), stm.getDurableSubscriberClientId());
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        return connection != null;
    }

    protected void stopEndpoint(JMSEndpoint endpoint) {
        ServiceTaskManager stm = endpoint.getServiceTaskManager();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stopping listening on destination : " + stm.getDestinationJNDIName() + " for service : " + stm.getServiceName()));
        }
        stm.stop();
        this.log.info((Object)("Stopped listening for JMS messages to service : " + endpoint.getServiceName()));
    }

    public JMSConnectionFactory getConnectionFactory(AxisService service) {
        Parameter conFacParam = service.getParameter("transport.jms.ConnectionFactory");
        if (conFacParam != null) {
            return this.connFacManager.getJMSConnectionFactory((String)conFacParam.getValue());
        }
        return this.connFacManager.getJMSConnectionFactory("default");
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            for (JMSEndpoint endpoint : this.getEndpoints()) {
                endpoint.getServiceTaskManager().pause();
            }
            this.state = 2;
            this.log.info((Object)"Listener paused");
        }
        catch (AxisJMSException e) {
            this.log.error((Object)"At least one service could not be paused", (Throwable)e);
        }
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        try {
            for (JMSEndpoint endpoint : this.getEndpoints()) {
                endpoint.getServiceTaskManager().resume();
            }
            this.state = 1;
            this.log.info((Object)"Listener resumed");
        }
        catch (AxisJMSException e) {
            this.log.error((Object)"At least one service could not be resumed", (Throwable)e);
        }
    }

    public void maintenenceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.stop();
            this.state = 0;
            this.log.info((Object)("Listener shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (Exception e) {
            this.handleException("Error shutting down the listener for maintenence", e);
        }
    }

    public void addErrorListener(TransportErrorListener listener) {
        this.tess.addErrorListener(listener);
    }

    public void removeErrorListener(TransportErrorListener listener) {
        this.tess.removeErrorListener(listener);
    }

    void error(AxisService service, Throwable ex) {
        this.tess.error(service, ex);
    }

    public void clearActiveConnections() {
        this.log.error((Object)"Not Implemented.");
    }
}

