/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.XMLProcessorUtils;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;
import org.wso2.carbon.user.core.tracker.UserStoreManagerRegistry;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class UserStoreConfigXMLProcessor {
    private static final Log log = LogFactory.getLog(UserStoreConfigXMLProcessor.class);
    private SecretResolver secretResolver;
    private String filePath = null;
    private static BundleContext bundleContext;

    public UserStoreConfigXMLProcessor(String path) {
        this.filePath = path;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        UserStoreConfigXMLProcessor.bundleContext = bundleContext;
    }

    public RealmConfiguration buildUserStoreConfigurationFromFile() throws UserStoreException {
        try {
            OMElement realmElement = this.getRealmElement();
            RealmConfiguration realmConfig = this.buildUserStoreConfiguration(realmElement);
            return realmConfig;
        }
        catch (Exception e) {
            String message = "Error while building user store manager from file";
            log.error((Object)message, (Throwable)e);
            throw new UserStoreException(message, e);
        }
    }

    public RealmConfiguration buildUserStoreConfiguration(OMElement userStoreElement) throws org.wso2.carbon.user.api.UserStoreException {
        RealmConfiguration realmConfig = null;
        String userStoreClass = null;
        Map<String, String> userStoreProperties = null;
        boolean passwordsExternallyManaged = false;
        XMLProcessorUtils xmlProcessorUtils = new XMLProcessorUtils();
        realmConfig = new RealmConfiguration();
        String[] fileNames = this.filePath.split(File.separator);
        String fileName = fileNames[fileNames.length - 1].replace(".xml", "").replace("_", ".");
        RealmConfiguration primaryRealm = UserStoreMgtDSComponent.getRealmService().getBootstrapRealmConfiguration();
        userStoreClass = userStoreElement.getAttributeValue(new QName("class"));
        userStoreProperties = this.getChildPropertyElements(userStoreElement, this.secretResolver);
        if (!userStoreProperties.get("DomainName").equalsIgnoreCase(fileName)) {
            throw new UserStoreException("File name is required to be the user store domain name(eg.: wso2.com-->wso2_com.xml).");
        }
        if (!xmlProcessorUtils.isValidDomain(fileName, true)) {
            throw new UserStoreException("Invalid domain name provided");
        }
        if (!xmlProcessorUtils.isMandatoryFieldsProvided(userStoreProperties, UserStoreManagerRegistry.getUserStoreProperties(userStoreClass).getMandatoryProperties())) {
            throw new UserStoreException("A required mandatory field is missing.");
        }
        String sIsPasswordExternallyManaged = userStoreProperties.get("PasswordsExternallyManaged");
        if (null != sIsPasswordExternallyManaged && !sIsPasswordExternallyManaged.trim().equals("")) {
            passwordsExternallyManaged = Boolean.parseBoolean(sIsPasswordExternallyManaged);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"External password management is disabled.");
        }
        Map<String, String> multipleCredentialsProperties = this.getMultipleCredentialsProperties(userStoreElement);
        realmConfig.setUserStoreClass(userStoreClass);
        realmConfig.setAuthorizationManagerClass(primaryRealm.getAuthorizationManagerClass());
        realmConfig.setEveryOneRoleName("Internal/" + primaryRealm.getEveryOneRoleName());
        realmConfig.setUserStoreProperties(userStoreProperties);
        realmConfig.setPasswordsExternallyManaged(passwordsExternallyManaged);
        realmConfig.setAuthzProperties(primaryRealm.getAuthzProperties());
        realmConfig.setRealmProperties(primaryRealm.getRealmProperties());
        realmConfig.setPasswordsExternallyManaged(primaryRealm.isPasswordsExternallyManaged());
        realmConfig.addMultipleCredentialProperties(userStoreClass, multipleCredentialsProperties);
        if (realmConfig.getUserStoreProperty("MaxUserNameListLength") == null) {
            realmConfig.getUserStoreProperties().put("MaxUserNameListLength", "100");
        }
        if (realmConfig.getUserStoreProperty("ReadOnly") == null) {
            realmConfig.getUserStoreProperties().put("ReadOnly", "false");
        }
        return realmConfig;
    }

    private Map<String, String> getChildPropertyElements(OMElement omElement, SecretResolver secretResolver) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator ite = omElement.getChildrenWithName(new QName("Property"));
        while (ite.hasNext()) {
            OMElement propElem = (OMElement)ite.next();
            String propName = propElem.getAttributeValue(new QName("name"));
            String propValue = propElem.getText();
            if (secretResolver != null && secretResolver.isInitialized()) {
                if (secretResolver.isTokenProtected("UserManager.Configuration.Property." + propName)) {
                    propValue = secretResolver.resolve("UserManager.Configuration.Property." + propName);
                }
                if (secretResolver.isTokenProtected("UserStoreManager.Property." + propName)) {
                    propValue = secretResolver.resolve("UserStoreManager.Property." + propName);
                }
            }
            map.put(propName.trim(), propValue.trim());
        }
        return map;
    }

    private Map<String, String> getMultipleCredentialsProperties(OMElement omElement) {
        HashMap<String, String> map = new HashMap<String, String>();
        OMElement multipleCredentialsEl = omElement.getFirstChildWithName(new QName("MultipleCredentials"));
        if (multipleCredentialsEl != null) {
            Iterator ite = multipleCredentialsEl.getChildrenWithLocalName("Credential");
            while (ite.hasNext()) {
                Object OMObj = ite.next();
                if (!(OMObj instanceof OMElement)) continue;
                OMElement credsElem = (OMElement)OMObj;
                String credsType = credsElem.getAttributeValue(new QName("type"));
                String credsClassName = credsElem.getText();
                map.put(credsType.trim(), credsClassName.trim());
            }
        }
        return map;
    }

    public static OMElement serialize(RealmConfiguration realmConfig) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement userStoreManagerElement = factory.createOMElement(new QName("UserStoreManager"));
        UserStoreConfigXMLProcessor.addPropertyElements(factory, userStoreManagerElement, realmConfig.getUserStoreClass(), realmConfig.getUserStoreProperties());
        return userStoreManagerElement;
    }

    private static void addPropertyElements(OMFactory factory, OMElement parent, String className, Map<String, String> properties) {
        if (className != null) {
            parent.addAttribute("class", className, null);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            OMElement propElem = factory.createOMElement(new QName("Property"));
            OMAttribute propAttr = factory.createOMAttribute("name", null, name);
            propElem.addAttribute(propAttr);
            propElem.setText(value);
            parent.addChild((OMNode)propElem);
        }
    }

    private OMElement getRealmElement() throws XMLStreamException, IOException, UserStoreException {
        StAXOMBuilder builder = null;
        InputStream inStream = null;
        inStream = new FileInputStream(this.filePath);
        try {
            inStream = CarbonUtils.replaceSystemVariablesInXml((InputStream)inStream);
            builder = new StAXOMBuilder(inStream);
            OMElement documentElement = builder.getDocumentElement();
            this.setSecretResolver(documentElement);
            OMElement oMElement = documentElement;
            return oMElement;
        }
        catch (CarbonException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            inStream.close();
        }
    }

    public void setSecretResolver(OMElement rootElement) {
        this.secretResolver = SecretResolverFactory.create((OMElement)rootElement, (boolean)true);
    }
}

