/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.io.File;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.config.UserStoreConfigXMLProcessor;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;
import org.wso2.carbon.user.core.service.RealmService;

public class UserStoreDeploymentManager {
    private static Log log = LogFactory.getLog(UserStoreDeploymentManager.class);

    public void deploy(String absoluteFilePath) throws DeploymentException {
        UserStoreConfigXMLProcessor userStoreXMLProcessor = new UserStoreConfigXMLProcessor(absoluteFilePath);
        File userMgtConfigFile = new File(absoluteFilePath);
        try {
            RealmConfiguration realmConfiguration = userStoreXMLProcessor.buildUserStoreConfigurationFromFile();
            RealmService realmService = UserStoreMgtDSComponent.getRealmService();
            UserRealm userRealm = null;
            AbstractUserStoreManager primaryUSM = null;
            String[] filePathSegments = absoluteFilePath.split(File.separator);
            if (filePathSegments[filePathSegments.length - 2].equals("userstores")) {
                if (filePathSegments[filePathSegments.length - 4].equals("tenants")) {
                    int tenantId = Integer.parseInt(filePathSegments[filePathSegments.length - 3]);
                    realmConfiguration.setTenantId(tenantId);
                    userRealm = (UserRealm)realmService.getTenantUserRealm(tenantId);
                    this.setSecondaryUserStore(userRealm.getRealmConfiguration(), realmConfiguration);
                    primaryUSM = (AbstractUserStoreManager)userRealm.getUserStoreManager();
                    primaryUSM.addSecondaryUserStoreManager(realmConfiguration, userRealm);
                } else {
                    this.setSecondaryUserStore(realmService.getBootstrapRealmConfiguration(), realmConfiguration);
                    userRealm = realmService.getBootstrapRealm();
                    primaryUSM = (AbstractUserStoreManager)userRealm.getUserStoreManager();
                    primaryUSM.addSecondaryUserStoreManager(realmConfiguration, userRealm);
                }
                log.info((Object)("Realm configuration of tenant:" + CarbonContext.getCurrentContext().getTenantId() + "  modified with " + absoluteFilePath));
            }
        }
        catch (Exception ex) {
            throw new DeploymentException("The deployment of " + userMgtConfigFile.getName() + " is not valid.", (Throwable)ex);
        }
    }

    private void setSecondaryUserStore(RealmConfiguration parent, RealmConfiguration child) {
        while (parent.getSecondaryRealmConfig() != null) {
            parent = parent.getSecondaryRealmConfig();
        }
        parent.setSecondaryRealmConfig(child);
    }

    public void undeploy(String fileName) throws DeploymentException {
        String[] fileNames = fileName.split(File.separator);
        String domainName = fileNames[fileNames.length - 1].replace(".xml", "").replace("_", ".");
        Boolean isDisabled = false;
        try {
            int tenantId = CarbonContext.getCurrentContext().getTenantId();
            org.wso2.carbon.user.api.UserRealm tenantRealm = CarbonContext.getCurrentContext().getUserRealm();
            RealmConfiguration realmConfig = tenantRealm.getRealmConfiguration();
            AbstractUserStoreManager userStoreManager = (AbstractUserStoreManager)tenantRealm.getUserStoreManager();
            while (realmConfig.getSecondaryRealmConfig() != null) {
                RealmConfiguration secondaryRealm = realmConfig.getSecondaryRealmConfig();
                if (secondaryRealm.getUserStoreProperty("DomainName").equalsIgnoreCase(domainName)) {
                    String disabled = secondaryRealm.getUserStoreProperty("Disabled");
                    if (disabled != null) {
                        isDisabled = Boolean.parseBoolean(disabled);
                    }
                    realmConfig.setSecondaryRealmConfig(secondaryRealm.getSecondaryRealmConfig());
                    log.info((Object)("User store: " + domainName + " of tenant:" + tenantId + " is removed from realm chain."));
                    break;
                }
                realmConfig = realmConfig.getSecondaryRealmConfig();
            }
            if (!isDisabled.booleanValue()) {
                userStoreManager.removeSecondaryUserStoreManager(domainName);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage());
            throw new DeploymentException("Error occurred at undeploying " + domainName + " from tenant:" + CarbonContext.getCurrentContext().getTenantId(), (Throwable)ex);
        }
    }

    public RealmConfiguration getUserStoreConfiguration(String absoluteFilePath) throws UserStoreException {
        UserStoreConfigXMLProcessor userStoreXMLProcessor = new UserStoreConfigXMLProcessor(absoluteFilePath);
        return userStoreXMLProcessor.buildUserStoreConfigurationFromFile();
    }
}

