/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.admin.api.indexing.IContentBasedSearchService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.service.SearchResultsBean;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.registry.indexing.utils.IndexingUtils;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class ContentBasedSearchService
extends RegistryAbstractAdmin
implements IContentBasedSearchService {
    private static final Log log = LogFactory.getLog(ContentBasedSearchService.class);
    private String solrServerUrl;

    public String getSolrUrl(int tenantId) throws IOException, FileNotFoundException, RegistryException {
        if (this.solrServerUrl == null) {
            this.solrServerUrl = IndexingUtils.getSolrUrl();
        }
        return this.solrServerUrl;
    }

    public SearchResultsBean getContentSearchResults(String searchQuery) throws AxisFault {
        try {
            UserRegistry registry = (UserRegistry)this.getRootRegistry();
            return this.searchContent(searchQuery, registry);
        }
        catch (Exception e) {
            log.error((Object)("Error " + e.getMessage() + "at the content search back end component."), (Throwable)e);
            return new SearchResultsBean();
        }
    }

    public SearchResultsBean getAttributeSearchResults(String[][] attributes) throws AxisFault {
        try {
            HashMap<String, String> map = new HashMap<String, String>(attributes.length);
            UserRegistry registry = (UserRegistry)this.getRootRegistry();
            for (String[] mapping : attributes) {
                map.put(mapping[0], mapping[1]);
            }
            return this.searchByAttribute(map, registry);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while getting the attribute search result.", (Throwable)e);
            return new SearchResultsBean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResultsBean searchContentInternal(String searchQuery, Map<String, String> attributes, UserRegistry registry) throws IndexerException, RegistryException {
        SolrDocumentList results;
        SearchResultsBean resultsBean = new SearchResultsBean();
        SolrClient client = SolrClient.getInstance();
        SolrDocumentList solrDocumentList = results = attributes.size() > 0 ? client.query(registry.getTenantId(), attributes) : client.query(searchQuery, registry.getTenantId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("result received " + results));
        }
        ArrayList<ResourceData> filteredResults = new ArrayList<ResourceData>();
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext != null && PaginationUtils.isPaginationHeadersExist((MessageContext)messageContext)) {
            try {
                String[] paginatedPaths;
                PaginationContext paginationContext = PaginationUtils.initPaginationContext((MessageContext)messageContext);
                ArrayList<String> authorizedPathList = new ArrayList<String>();
                for (SolrDocument solrDocument : results) {
                    if (paginationContext.getLimit() > 0 && authorizedPathList.size() == paginationContext.getLimit()) break;
                    String path = this.getPathFromId((String)solrDocument.getFirstValue("id"));
                    if (!this.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get")) continue;
                    authorizedPathList.add(path);
                }
                String[] authorizedPaths = authorizedPathList.toArray(new String[authorizedPathList.size()]);
                int start = paginationContext.getStart();
                int count = paginationContext.getCount();
                int rowCount = authorizedPaths.length;
                PaginationUtils.setRowCount((MessageContext)messageContext, (String)Integer.toString(rowCount));
                int startIndex = start == 1 ? 0 : start;
                if (rowCount < start + count) {
                    paginatedPaths = new String[rowCount - startIndex];
                    System.arraycopy(authorizedPaths, startIndex, paginatedPaths, 0, rowCount - startIndex);
                } else {
                    paginatedPaths = new String[count];
                    System.arraycopy(authorizedPaths, startIndex, paginatedPaths, 0, count);
                }
                for (String path : paginatedPaths) {
                    ResourceData resourceData = this.loadResourceByPath(registry, path);
                    if (resourceData == null) continue;
                    filteredResults.add(resourceData);
                }
            }
            finally {
                PaginationContext.destroy();
            }
        } else {
            for (SolrDocument solrDocument : results) {
                ResourceData resourceData;
                String path = this.getPathFromId((String)solrDocument.getFirstValue("id"));
                if (!this.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get") || (resourceData = this.loadResourceByPath(registry, path)) == null) continue;
                filteredResults.add(resourceData);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("filtered results " + filteredResults + " for user " + registry.getUserName()));
        }
        resultsBean.setResourceDataList(filteredResults.toArray(new ResourceData[filteredResults.size()]));
        return resultsBean;
    }

    public SearchResultsBean searchContent(String searchQuery, UserRegistry registry) throws IndexerException, RegistryException {
        return this.searchContentInternal(searchQuery, Collections.<String, String>emptyMap(), registry);
    }

    public SearchResultsBean searchByAttribute(Map<String, String> attributes, UserRegistry registry) throws IndexerException, RegistryException {
        return this.searchContentInternal(null, attributes, registry);
    }

    public void restartIndexing() throws RegistryException {
        IndexingManager manager = IndexingManager.getInstance();
        manager.restartIndexing();
    }

    private String getPathFromId(String id) {
        return id.substring(0, id.lastIndexOf("tenantId"));
    }

    private boolean isAuthorized(UserRegistry registry, String resourcePath, String action) throws RegistryException {
        UserRealm userRealm = registry.getUserRealm();
        String userName = ContentBasedSearchService.getLoggedInUserName();
        try {
            if (!userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, action)) {
                return false;
            }
        }
        catch (UserStoreException e) {
            throw new RegistryException("Error at Authorizing " + resourcePath + " with user " + userName + ":" + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private ResourceData loadResourceByPath(UserRegistry registry, String path) throws RegistryException {
        Resource child;
        ResourceData resourceData = new ResourceData();
        resourceData.setResourcePath(path);
        if (path != null) {
            if ("/".equals(path)) {
                resourceData.setName("root");
            } else {
                String[] parts = path.split("/");
                resourceData.setName(parts[parts.length - 1]);
            }
        }
        try {
            child = registry.get(path);
        }
        catch (RegistryException e) {
            log.debug((Object)("Failed to load resource from path which is returned from Solr search" + e.getMessage()));
            return null;
        }
        resourceData.setResourceType(child instanceof Collection ? "collection" : "resource");
        resourceData.setAuthorUserName(child.getAuthorUserName());
        resourceData.setDescription(child.getDescription());
        resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
        Calendar createdDateTime = Calendar.getInstance();
        createdDateTime.setTime(child.getCreatedTime());
        resourceData.setCreatedOn(createdDateTime);
        CommonUtil.populateAverageStars((ResourceData)resourceData);
        child.discard();
        return resourceData;
    }

    public static String getLoggedInUserName() {
        return PrivilegedCarbonContext.getCurrentContext().getUsername();
    }
}

