/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.indexer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.solr.common.SolrException;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.solr.IndexDocument;

public class MSExcelIndexer
implements Indexer {
    public static final Log log = LogFactory.getLog(MSExcelIndexer.class);

    @Override
    public IndexDocument getIndexedDocument(AsyncIndexer.File2Index fileData) throws SolrException {
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new ByteArrayInputStream(fileData.data));
            ExcelExtractor extractor = new ExcelExtractor(fs);
            String excelText = extractor.getText();
            return new IndexDocument(fileData.path, excelText, null);
        }
        catch (IOException e) {
            String msg = "Failed to write to the index";
            log.error((Object)msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
    }
}

