/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.registry.indexing.utils.IndexingUtils;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class IndexingHandler
extends Handler {
    private static Log log = LogFactory.getLog(AsyncIndexer.class);
    private static volatile AsyncIndexer asyncIndexer;
    private String indexingUrl;

    public Resource get(RequestContext requestContext) throws RegistryException {
        return null;
    }

    public void put(RequestContext requestContext) throws RegistryException {
        if (this.isIndexable(requestContext)) {
            return;
        }
        this.submitFileForIndexing(this.getIndexer(), requestContext.getResource(), requestContext.getResourcePath().getPath(), null);
    }

    public String move(RequestContext requestContext) throws RegistryException {
        if (this.isExecutingMountedHandlerChain(requestContext)) {
            return super.move(requestContext);
        }
        String oldPath = requestContext.getSourcePath();
        String newPath = requestContext.getTargetPath();
        int tenantId = CurrentSession.getTenantId();
        try {
            this.deleteFromIndex(oldPath, tenantId);
        }
        catch (SolrException e) {
            log.error((Object)"Could not delete file for Solr server", (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)"Could not delete file for Solr server", (Throwable)e);
        }
        Resource resource = requestContext.getRegistry().get(oldPath);
        this.submitFileForIndexing(this.getIndexer(), resource, newPath, null);
        return super.move(requestContext);
    }

    private void deleteFromIndex(String oldPath, int tenantId) throws RegistryException {
        this.getIndexer().getClient().deleteFromIndex(oldPath, tenantId);
    }

    public String rename(RequestContext requestContext) throws RegistryException {
        if (this.isExecutingMountedHandlerChain(requestContext)) {
            return super.rename(requestContext);
        }
        String oldPath = requestContext.getSourcePath();
        String newPath = requestContext.getTargetPath();
        int tenantId = CurrentSession.getTenantId();
        try {
            this.deleteFromIndex(oldPath, tenantId);
        }
        catch (SolrException e) {
            log.error((Object)"Could not delete file for Solr server", (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)"Could not delete file for Solr server", (Throwable)e);
        }
        Resource resource = requestContext.getRegistry().get(oldPath);
        this.submitFileForIndexing(this.getIndexer(), resource, newPath, null);
        return super.rename(requestContext);
    }

    public String copy(RequestContext requestContext) throws RegistryException {
        if (this.isExecutingMountedHandlerChain(requestContext)) {
            return super.rename(requestContext);
        }
        String oldPath = requestContext.getSourcePath();
        String newPath = requestContext.getTargetPath();
        Resource resource = requestContext.getRegistry().get(oldPath);
        this.submitFileForIndexing(this.getIndexer(), resource, newPath, null);
        return super.copy(requestContext);
    }

    private boolean isIndexable(RequestContext requestContext) {
        return this.isExecutingMountedHandlerChain(requestContext) || requestContext.getResource() == null || requestContext.getResource().getMediaType() == null || requestContext.getResource() instanceof Collection;
    }

    private boolean isExecutingMountedHandlerChain(RequestContext requestContext) {
        return requestContext.getRegistry().getRegistryContext() == null || requestContext.getRegistry().getRegistryContext().isClone();
    }

    public Collection searchContent(RequestContext requestContext) throws RegistryException {
        String searchQuery = requestContext.getKeywords();
        UserRegistry registry = CurrentSession.getUserRegistry();
        ArrayList<String> filteredResults = new ArrayList<String>();
        try {
            SolrClient client = SolrClient.getInstance();
            SolrDocumentList results = client.query(searchQuery, CurrentSession.getTenantId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("result received " + results));
            }
            int i = 0;
            while ((long)i < results.getNumFound()) {
                SolrDocument solrDocument = (SolrDocument)results.get(i);
                String path = this.getPathFromId((String)solrDocument.getFirstValue("id"));
                if (this.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get")) {
                    filteredResults.add(path);
                }
                ++i;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("filtered results " + filteredResults + " for user " + registry.getUserName()));
            }
        }
        catch (IndexerException e) {
            log.error((Object)"Unable to do Content Search", (Throwable)e);
        }
        String[] resourcePaths = filteredResults.toArray(new String[filteredResults.size()]);
        CollectionImpl searchResults = new CollectionImpl();
        searchResults.setContent((Object)resourcePaths);
        return searchResults;
    }

    private String getPathFromId(String id) {
        return id.substring(0, id.lastIndexOf("tenantId"));
    }

    private boolean isAuthorized(UserRegistry registry, String resourcePath, String action) throws RegistryException {
        UserRealm userRealm = registry.getUserRealm();
        String userName = this.getLoggedInUserName();
        try {
            if (!userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, action)) {
                return false;
            }
        }
        catch (UserStoreException e) {
            throw new RegistryException("Error while authorizing " + resourcePath + " with user " + userName + ":" + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private String getLoggedInUserName() {
        return PrivilegedCarbonContext.getCurrentContext().getUsername();
    }

    public void importResource(RequestContext requestContext) throws RegistryException {
        if (this.isIndexable(requestContext)) {
            return;
        }
        this.submitFileForIndexing(this.getIndexer(), requestContext.getResource(), requestContext.getResourcePath().getPath(), requestContext.getSourceURL());
    }

    public void delete(RequestContext requestContext) throws RegistryException {
        final String id = requestContext.getResourcePath().getPath();
        final int tenantId = CurrentSession.getTenantId();
        new Thread(new Runnable(){
            int tid;
            {
                this.tid = tenantId;
            }

            @Override
            public void run() {
                try {
                    IndexingHandler.this.deleteFromIndex(id, this.tid);
                }
                catch (SolrException e) {
                    log.error((Object)"Could not delete file for Solr server", (Throwable)e);
                }
                catch (RegistryException e) {
                    log.error((Object)"Could not delete file for Solr server", (Throwable)e);
                }
            }
        }).start();
    }

    public void putChild(RequestContext requestContext) throws RegistryException {
    }

    public void importChild(RequestContext requestContext) throws RegistryException {
    }

    public String getIndexingUrl() {
        return this.indexingUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncIndexer getIndexer() throws RegistryException {
        try {
            if (asyncIndexer == null) {
                IndexingHandler indexingHandler = this;
                synchronized (indexingHandler) {
                    if (asyncIndexer == null) {
                        asyncIndexer = null;
                        new Thread(asyncIndexer).start();
                    }
                }
            }
            return asyncIndexer;
        }
        catch (SolrException e) {
            throw new RegistryException(e.getMessage(), (Throwable)e);
        }
    }

    private void submitFileForIndexing(AsyncIndexer indexer, Resource resource, String path, String sourceURL) {
        String mediaType = resource.getMediaType();
        if (mediaType == null && path != null) {
            try {
                mediaType = MediaTypesUtils.getMediaType((String)RegistryUtils.getResourceName((String)path));
            }
            catch (RegistryException ignored) {
                // empty catch block
            }
        }
        if (mediaType == null || IndexingManager.getInstance().getIndexerForMediaType(mediaType) == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Submitting file " + path + " for Indexing"));
        }
        try {
            String lcName = resource.getProperty("registry.LC.name");
            String lcState = lcName != null ? resource.getProperty("registry.lifecycle." + lcName + ".state") : null;
            indexer.addFile(new AsyncIndexer.File2Index(IndexingUtils.getByteContent(resource, sourceURL), mediaType, path, CurrentSession.getTenantId(), lcName, lcState));
        }
        catch (RegistryException e) {
            log.error((Object)"An error occurred while submitting file for indexing", (Throwable)e);
        }
    }

    public void setIndexingUrl(String indexingUrl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Indexing Url Set to " + indexingUrl));
        }
        this.indexingUrl = indexingUrl;
    }
}

