/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.core.operations;

import java.io.File;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.p2.engine.phases.Sizing;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.wso2.carbon.feature.mgt.core.operations.ProfileChangeOperation;
import org.wso2.carbon.feature.mgt.core.util.SizingPhaseSet;

public class InstallOperation
extends ProfileChangeOperation {
    public InstallOperation(String actionType) {
        super(actionType);
    }

    @Override
    public ProfileChangeRequest generateProfileChangeRequest(IProfile profile, MultiStatus status, IProgressMonitor monitor) {
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        String carbonHome = System.getProperty("carbon.home");
        String cacheLocation = carbonHome + File.separator + "repository" + File.separator + "components";
        request.setProfileProperty("org.eclipse.equinox.p2.cache", cacheLocation);
        request.setProfileProperty("org.eclipse.equinox.simpleconfigurator.useReference", Boolean.TRUE.toString());
        for (IInstallableUnit iu : this.iusToInstall) {
            Set alreadyInstalled;
            if (Boolean.toString(true).equals(iu.getProperty("org.eclipse.equinox.p2.type.patch"))) {
                request.setInstallableUnitInclusionRules(iu, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
            }
            if ((alreadyInstalled = profile.query(QueryUtil.createIUQuery((String)iu.getId()), (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet()).size() > 0) {
                IInstallableUnit installedIU = (IInstallableUnit)alreadyInstalled.iterator().next();
                int compareTo = iu.getVersion().compareTo((Object)installedIU.getVersion());
                if (compareTo > 0) {
                    boolean lockedForUpdate = false;
                    String value = profile.getInstallableUnitProperty(installedIU, "org.eclipse.equinox.p2.type.lock");
                    if (value != null) {
                        boolean bl = lockedForUpdate = (Integer.parseInt(value) & 2) == 2;
                    }
                    if (lockedForUpdate) {
                        status.merge((IStatus)new Status(2, "temp", 10013, installedIU.getId() + "-" + installedIU.getVersion() + " will be ignored because it is already installed, " + "and updates are not permitted.", null));
                        continue;
                    }
                    request.addInstallableUnits(new IInstallableUnit[]{iu});
                    request.removeInstallableUnits(new IInstallableUnit[]{installedIU});
                    status.merge((IStatus)new Status(2, "temp", 10013, installedIU.getId() + "-" + installedIU.getVersion() + " is already installed, so an update will be performed instead.", null));
                    if (Boolean.toString(true).equals(profile.getInstallableUnitProperty(installedIU, "org.eclipse.equinox.p2.type.root"))) continue;
                    request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
                    continue;
                }
                if (compareTo < 0) {
                    status.merge((IStatus)new Status(2, "temp", 10004, installedIU.getId() + "-" + installedIU.getVersion() + " will be ignored because a newer version is already installed.", null));
                    continue;
                }
                if (Boolean.toString(true).equals(profile.getInstallableUnitProperty(installedIU, "org.eclipse.equinox.p2.type.root"))) {
                    status.merge((IStatus)new Status(2, "temp", 10005, installedIU.getId() + "-" + installedIU.getVersion() + " will be ignored because it is already installed.", null));
                    continue;
                }
                status.merge((IStatus)new Status(2, "temp", 10006, installedIU.getId() + "-" + installedIU.getVersion() + " is already present because other installed software requires it.  " + "It will be added to the installed software list.", null));
                request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
                continue;
            }
            if (Boolean.toString(true).equals(iu.getProperty("org.eclipse.equinox.p2.type.category"))) continue;
            request.addInstallableUnits(new IInstallableUnit[]{iu});
            request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
        }
        return request;
    }

    @Override
    public long getSize(IProvisioningPlan provisioningPlan, IProfile profile, IEngine engine, ProvisioningContext context, IProgressMonitor monitor) {
        SizingPhaseSet set;
        IStatus status;
        if (provisioningPlan == null) {
            return -3L;
        }
        if (((ProvisioningPlan)provisioningPlan).getOperands().length == 0) {
            return 0L;
        }
        long installPlanSize = 0L;
        if (provisioningPlan.getInstallerPlan() != null && (status = engine.perform(provisioningPlan, (IPhaseSet)(set = new SizingPhaseSet(new Sizing(100))), null)).isOK()) {
            installPlanSize = set.getSizing().getDiskSize();
        }
        if ((status = engine.perform(provisioningPlan, (IPhaseSet)(set = new SizingPhaseSet(new Sizing(100))), null)).isOK()) {
            return installPlanSize + set.getSizing().getDiskSize();
        }
        return -2L;
    }

    @Override
    public MultiStatus getInitialStatus() {
        return new MultiStatus("org.wso2.carbon.feature.mgt.core", 10001, "Your original install request has been modified.", null);
    }
}

