/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util;

import java.util.HashMap;
import java.util.Map;
import org.opensaml.util.URLBuilder;

public final class SimpleURLCanonicalizer {
    private static Map<String, Integer> schemePortMap = new HashMap<String, Integer>();

    private SimpleURLCanonicalizer() {
    }

    public static void registerSchemePortMapping(String scheme, Integer port) {
        if (scheme == null || port == null) {
            throw new IllegalArgumentException("Scheme and port may not be null");
        }
        schemePortMap.put(scheme.toLowerCase(), port);
    }

    public static void deregisterSchemePortMapping(String scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme may not be null");
        }
        schemePortMap.remove(scheme.toLowerCase());
    }

    public static Integer getRegisteredPort(String scheme) {
        return schemePortMap.get(scheme.toLowerCase());
    }

    public static String canonicalize(String url) {
        URLBuilder urlBuilder = new URLBuilder(url);
        SimpleURLCanonicalizer.canonicalize(urlBuilder);
        return urlBuilder.buildURL();
    }

    private static void canonicalize(URLBuilder url) {
        if (url.getScheme() != null) {
            url.setScheme(url.getScheme().toLowerCase());
            String scheme = url.getScheme();
            Integer port = SimpleURLCanonicalizer.getRegisteredPort(scheme);
            if (port != null && port.intValue() == url.getPort()) {
                url.setPort(0);
            }
        }
        if (url.getHost() != null) {
            url.setHost(url.getHost().toLowerCase());
        }
    }

    static {
        SimpleURLCanonicalizer.registerSchemePortMapping("ftp", 23);
        SimpleURLCanonicalizer.registerSchemePortMapping("http", 80);
        SimpleURLCanonicalizer.registerSchemePortMapping("https", 443);
    }
}

