/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.tools;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import org.jaggeryjs.jaggery.core.ScriptReader;
import org.jaggeryjs.jaggery.core.manager.CommandLineManager;
import org.jaggeryjs.jaggery.tools.ShellUtilityService;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.mozilla.javascript.ScriptableObject;

public final class CommandLineExecutor {
    private static PrintStream out = System.out;

    private CommandLineExecutor() {
    }

    public static void parseJaggeryScript(String fileURL) {
        try {
            RhinoEngine.enterGlobalContext();
            FileInputStream fstream = new FileInputStream(fileURL);
            RhinoEngine engine = CommandLineManager.getCommandLineEngine();
            ScriptableObject scope = engine.getRuntimeScope();
            JaggeryContext jaggeryContext = new JaggeryContext();
            jaggeryContext.setTenantId("0");
            jaggeryContext.setEngine(engine);
            jaggeryContext.setScope(scope);
            jaggeryContext.addProperty("jaggery.output.stream", (Object)System.out);
            RhinoEngine.putContextProperty((Object)"jaggeryContext", (Object)jaggeryContext);
            ScriptReader source = new ScriptReader((InputStream)new BufferedInputStream(fstream));
            out.println("\n");
            ShellUtilityService.initializeUtilityServices();
            engine.exec((Reader)source, scope, null);
            ShellUtilityService.destroyUtilityServices();
            out.flush();
            out.println("\n");
        }
        catch (Exception e) {
            out.println("\n");
            out.println("Error: " + e.getMessage());
            out.println("\n");
        }
    }

    public static void parseJaggeryExpression(String expression) {
        try {
            RhinoEngine.enterGlobalContext();
            RhinoEngine engine = CommandLineManager.getCommandLineEngine();
            ScriptableObject scope = engine.getRuntimeScope();
            JaggeryContext jaggeryContext = new JaggeryContext();
            jaggeryContext.setTenantId("0");
            jaggeryContext.setEngine(engine);
            jaggeryContext.setScope(scope);
            jaggeryContext.addProperty("jaggery.output.stream", (Object)out);
            RhinoEngine.putContextProperty((Object)"jaggeryContext", (Object)jaggeryContext);
            ShellUtilityService.initializeUtilityServices();
            engine.exec((Reader)new StringReader(expression), scope, null);
            ShellUtilityService.destroyUtilityServices();
            out.flush();
        }
        catch (Exception e) {
            out.println("Error: " + e.getMessage());
        }
    }
}

