/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast.wka;

import com.hazelcast.config.Config;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.ServerStatus;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastCarbonClusterImpl;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastUtil;
import org.wso2.carbon.core.clustering.hazelcast.util.MemberUtils;

public class WKABasedMembershipScheme
implements HazelcastMembershipScheme {
    private static final Log log = LogFactory.getLog(WKABasedMembershipScheme.class);
    private Map<String, Parameter> parameters;
    private String primaryDomain;
    private List<org.apache.axis2.clustering.Member> wkaMembers = new ArrayList<org.apache.axis2.clustering.Member>();
    private final List<ClusteringMessage> messageBuffer;
    private NetworkConfig nwConfig;
    private IMap<String, org.apache.axis2.clustering.Member> allMembers;
    private volatile HazelcastInstance primaryHazelcastInstance;
    private Member localMember;
    private boolean areWellKnownMembersAvailable = true;
    private HazelcastCarbonClusterImpl carbonCluster;

    @Override
    public void setPrimaryHazelcastInstance(HazelcastInstance primaryHazelcastInstance) {
        this.primaryHazelcastInstance = primaryHazelcastInstance;
    }

    @Override
    public void setCarbonCluster(HazelcastCarbonClusterImpl hazelcastCarbonCluster) {
        this.carbonCluster = hazelcastCarbonCluster;
    }

    @Override
    public void setLocalMember(Member localMember) {
        this.localMember = localMember;
    }

    public WKABasedMembershipScheme(Map<String, Parameter> parameters, String primaryDomain, List<org.apache.axis2.clustering.Member> wkaMembers, Config config, List<ClusteringMessage> messageBuffer) {
        this.parameters = parameters;
        this.primaryDomain = primaryDomain;
        this.wkaMembers = wkaMembers;
        this.messageBuffer = messageBuffer;
        this.nwConfig = config.getNetworkConfig();
    }

    public void init() throws ClusteringFault {
        this.nwConfig.getJoin().getMulticastConfig().setEnabled(false);
        TcpIpConfig tcpIpConfig = this.nwConfig.getJoin().getTcpIpConfig();
        tcpIpConfig.setEnabled(true);
        this.configureWKAParameters();
        for (org.apache.axis2.clustering.Member wkaMember : this.wkaMembers) {
            if (this.isLocalMember(wkaMember)) continue;
            if (MemberUtils.canConnect(wkaMember)) {
                MemberUtils.addMember(wkaMember, tcpIpConfig);
                this.areWellKnownMembersAvailable = true;
                continue;
            }
            this.areWellKnownMembersAvailable = false;
            return;
        }
    }

    private boolean isLocalMember(org.apache.axis2.clustering.Member member) {
        return member.getHostName().equals(this.nwConfig.getPublicAddress()) && member.getPort() == this.nwConfig.getPort();
    }

    private void startWKAMemberReconnectionTask(org.apache.axis2.clustering.Member wkaMember) {
        new Thread(new WKAMemberAdder(wkaMember)).start();
    }

    public boolean areWellKnownMembersAvailable() {
        return this.areWellKnownMembersAvailable;
    }

    private void configureWKAParameters() throws ClusteringFault {
        Parameter connTimeout = this.getParameter("connTimeout");
        if (connTimeout != null) {
            this.nwConfig.getJoin().getTcpIpConfig().setConnectionTimeoutSeconds(Integer.parseInt(((String)connTimeout.getValue()).trim()));
        }
    }

    public Parameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public void joinGroup() throws ClusteringFault {
        this.primaryHazelcastInstance.getCluster().addMembershipListener((MembershipListener)new WKAMembershipListener());
        this.allMembers = MemberUtils.getMembersMap(this.primaryHazelcastInstance, this.primaryDomain);
        this.allMembers.addEntryListener((EntryListener)new MemberEntryListener(), true);
        for (org.apache.axis2.clustering.Member member : this.allMembers.values()) {
            InetSocketAddress inetSocketAddress = this.localMember.getInetSocketAddress();
            if (member.getHostName().equals(inetSocketAddress.getHostName()) || member.getPort() == inetSocketAddress.getPort()) continue;
            MemberUtils.addMember(member, this.nwConfig.getJoin().getTcpIpConfig());
        }
    }

    private class MemberEntryListener
    implements EntryListener<String, org.apache.axis2.clustering.Member> {
        private MemberEntryListener() {
        }

        public void entryAdded(EntryEvent<String, org.apache.axis2.clustering.Member> entryEvent) {
            MemberUtils.addMember((org.apache.axis2.clustering.Member)entryEvent.getValue(), WKABasedMembershipScheme.this.nwConfig.getJoin().getTcpIpConfig());
        }

        public void entryRemoved(EntryEvent<String, org.apache.axis2.clustering.Member> entryEvent) {
        }

        public void entryUpdated(EntryEvent<String, org.apache.axis2.clustering.Member> stringMemberEntryEvent) {
        }

        public void entryEvicted(EntryEvent<String, org.apache.axis2.clustering.Member> stringMemberEntryEvent) {
        }
    }

    private class WKAMembershipListener
    implements MembershipListener {
        private WKAMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            if (WKABasedMembershipScheme.this.primaryHazelcastInstance.getCluster().getLocalMember().equals(member)) {
                return;
            }
            WKABasedMembershipScheme.this.carbonCluster.memberAdded(member);
            HazelcastUtil.sendMessagesToMember(WKABasedMembershipScheme.this.messageBuffer, member, WKABasedMembershipScheme.this.carbonCluster);
            log.info((Object)("Member joined [" + member.getUuid() + "]: " + member.getInetSocketAddress().toString()));
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            Member hazelcastMember = membershipEvent.getMember();
            String uuid = hazelcastMember.getUuid();
            log.info((Object)("Member left [" + uuid + "]: " + hazelcastMember.getInetSocketAddress().toString()));
            org.apache.axis2.clustering.Member member = (org.apache.axis2.clustering.Member)WKABasedMembershipScheme.this.allMembers.get((Object)membershipEvent.getMember().getUuid());
            if (member == null) {
                return;
            }
            boolean isWKAMember = false;
            for (org.apache.axis2.clustering.Member wkaMember : WKABasedMembershipScheme.this.wkaMembers) {
                if (!wkaMember.getHostName().equals(member.getHostName()) || wkaMember.getPort() != member.getPort()) continue;
                log.info((Object)("WKA member " + member + " left cluster. Starting reconnection task..."));
                isWKAMember = true;
                String memberStr = member.getHostName() + ":" + member.getPort();
                WKABasedMembershipScheme.this.nwConfig.getJoin().getTcpIpConfig().getMembers().remove(memberStr);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                WKABasedMembershipScheme.this.startWKAMemberReconnectionTask(member);
                break;
            }
            WKABasedMembershipScheme.this.carbonCluster.memberRemoved(hazelcastMember);
            if (!isWKAMember) {
                WKABasedMembershipScheme.this.allMembers.remove((Object)uuid);
            }
        }
    }

    private class WKAMemberAdder
    implements Runnable {
        private org.apache.axis2.clustering.Member wkaMember;

        private WKAMemberAdder(org.apache.axis2.clustering.Member wkaMember) {
            this.wkaMember = wkaMember;
        }

        @Override
        public void run() {
            try {
                while (!MemberUtils.canConnect(this.wkaMember)) {
                    if (ServerStatus.getCurrentStatus().equals("SHUTTING_DOWN")) {
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {}
                }
                MemberUtils.addMember(this.wkaMember, WKABasedMembershipScheme.this.nwConfig.getJoin().getTcpIpConfig());
                WKABasedMembershipScheme.this.primaryHazelcastInstance.getLifecycleService().restart();
            }
            catch (Exception e) {
                log.error((Object)"Error while trying to reconnect WKA member", (Throwable)e);
            }
        }
    }
}

