/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.clustering.management.GroupManagementCommand;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.clustering.hazelcast.util.MemberUtils;

public class HazelcastGroupManagementAgent
implements GroupManagementAgent {
    private static final Log log = LogFactory.getLog(HazelcastGroupManagementAgent.class);
    private static final String PORT_MAPPING_PREFIX = "port.mapping.";
    private String description;
    private IMap<String, org.apache.axis2.clustering.Member> members;
    private List<org.apache.axis2.clustering.Member> connectedMembers = new CopyOnWriteArrayList<org.apache.axis2.clustering.Member>();
    private String localMemberUUID;
    private String domain;
    private String subDomain;
    private ITopic<GroupManagementCommand> groupManagementTopic;
    private int groupMgtPort;
    private TcpIpConfig tcpIpConfig;

    public void init(Config primaryHazelcastConfig, ConfigurationContext configurationContext) {
        NetworkConfig primaryNwConfig = primaryHazelcastConfig.getNetworkConfig();
        Config config = new Config();
        config.setInstanceName(this.domain);
        NetworkConfig groupNwConfig = config.getNetworkConfig();
        groupNwConfig.setPublicAddress(primaryNwConfig.getPublicAddress());
        if (primaryNwConfig.getPort() == this.groupMgtPort) {
            throw new IllegalArgumentException("group_mgt_port for the " + this.domain + " is the same as the primary localMemberPort. Please set a different value");
        }
        groupNwConfig.setPort(this.groupMgtPort);
        MulticastConfig primaryMulticastConfig = primaryNwConfig.getJoin().getMulticastConfig();
        MulticastConfig groupMulticastConfig = groupNwConfig.getJoin().getMulticastConfig();
        groupMulticastConfig.setEnabled(primaryMulticastConfig.isEnabled());
        groupNwConfig.getJoin().getTcpIpConfig().setEnabled(primaryNwConfig.getJoin().getTcpIpConfig().isEnabled());
        config.setLicenseKey(primaryHazelcastConfig.getLicenseKey());
        config.setManagementCenterConfig(primaryHazelcastConfig.getManagementCenterConfig());
        if (primaryMulticastConfig.isEnabled()) {
            groupMulticastConfig.setMulticastPort(primaryMulticastConfig.getMulticastPort());
            groupMulticastConfig.setMulticastGroup(primaryMulticastConfig.getMulticastGroup());
            groupMulticastConfig.setMulticastTimeoutSeconds(primaryMulticastConfig.getMulticastTimeoutSeconds());
            groupMulticastConfig.setMulticastTimeToLive(primaryMulticastConfig.getMulticastTimeToLive());
        }
        this.tcpIpConfig = groupNwConfig.getJoin().getTcpIpConfig();
        GroupConfig groupConfig = config.getGroupConfig();
        groupConfig.setName(this.domain);
        config.setProperties(primaryHazelcastConfig.getProperties());
        HazelcastInstance hazelcastInstance = Hazelcast.getHazelcastInstanceByName((String)this.domain);
        if (hazelcastInstance == null) {
            hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
        }
        hazelcastInstance.getCluster().addMembershipListener((MembershipListener)new GroupMembershipListener());
        this.localMemberUUID = hazelcastInstance.getCluster().getLocalMember().getUuid();
        org.apache.axis2.clustering.Member localMember = MemberUtils.getLocalMember(this.domain, groupNwConfig.getPublicAddress(), this.groupMgtPort);
        log.info((Object)("Group management local member for domain [" + this.domain + "],sub-domain [" + this.subDomain + "] UUID: " + this.localMemberUUID + ". " + localMember));
        MemberUtils.getMembersMap(hazelcastInstance, this.domain).put((Object)this.localMemberUUID, (Object)localMember);
        this.members = MemberUtils.getMembersMap(hazelcastInstance, this.domain);
        this.members.addEntryListener((EntryListener)new MemberEntryListener(), true);
        for (org.apache.axis2.clustering.Member member : this.members.values()) {
            this.connectMember(member);
        }
        this.groupManagementTopic = hazelcastInstance.getTopic("$" + this.domain + ".group.mgt.cmd.topic");
        this.groupManagementTopic.addMessageListener((MessageListener)new GroupManagementCommandListener(configurationContext));
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setSubDomain(String subDomain) {
        this.subDomain = subDomain;
    }

    public void setGroupMgtPort(int groupMgtPort) {
        this.groupMgtPort = groupMgtPort;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void applicationMemberAdded(org.apache.axis2.clustering.Member member) {
    }

    public void applicationMemberRemoved(org.apache.axis2.clustering.Member member) {
    }

    public List<org.apache.axis2.clustering.Member> getMembers() {
        return this.connectedMembers;
    }

    public void send(GroupManagementCommand groupManagementCommand) throws ClusteringFault {
        this.groupManagementTopic.publish((Object)groupManagementCommand);
    }

    private void connectMember(org.apache.axis2.clustering.Member member) {
        if (!member.getDomain().equals(this.domain) || !this.subDomain.equals(member.getProperties().get("subDomain"))) {
            return;
        }
        if (!this.connectedMembers.contains(member)) {
            Thread th = new Thread(new MemberAdder(member));
            th.setPriority(10);
            th.start();
        }
    }

    private static class GroupManagementCommandListener
    implements MessageListener<GroupManagementCommand> {
        private ConfigurationContext configurationContext;

        private GroupManagementCommandListener(ConfigurationContext configurationContext) {
            this.configurationContext = configurationContext;
        }

        public void onMessage(Message<GroupManagementCommand> message) {
            GroupManagementCommand command = (GroupManagementCommand)message.getMessageObject();
            try {
                command.execute(this.configurationContext);
            }
            catch (ClusteringFault e) {
                log.error((Object)("Cannot execute GroupManagementCommand" + command), (Throwable)e);
            }
        }
    }

    private class MemberAdder
    implements Runnable {
        private final org.apache.axis2.clustering.Member member;

        private MemberAdder(org.apache.axis2.clustering.Member member) {
            this.member = member;
        }

        @Override
        public void run() {
            if (HazelcastGroupManagementAgent.this.connectedMembers.contains(this.member)) {
                return;
            }
            if (this.canConnect(this.member)) {
                if (!HazelcastGroupManagementAgent.this.connectedMembers.contains(this.member)) {
                    HazelcastGroupManagementAgent.this.connectedMembers.add(this.member);
                    MemberUtils.addMember(this.member, HazelcastGroupManagementAgent.this.tcpIpConfig);
                }
                log.info((Object)("Application member " + this.member + " joined application cluster"));
            } else {
                log.error((Object)("Could not add application member " + this.member));
            }
        }

        private boolean canConnect(org.apache.axis2.clustering.Member member) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying to connect to member " + member + "..."));
            }
            for (int retries = 30; retries > 0; --retries) {
                try {
                    InetAddress addr = InetAddress.getByName(member.getHostName());
                    ArrayList<String> mappedPorts = new ArrayList<String>();
                    Properties memberProperties = member.getProperties();
                    for (String property : memberProperties.stringPropertyNames()) {
                        if (!property.contains(HazelcastGroupManagementAgent.PORT_MAPPING_PREFIX)) continue;
                        mappedPorts.add(memberProperties.getProperty(property));
                    }
                    for (String portStr : mappedPorts) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Mapped Port=" + portStr));
                        }
                        int port = Integer.parseInt(portStr);
                        InetSocketAddress httpSockaddr = new InetSocketAddress(addr, port);
                        new Socket().connect(httpSockaddr, 10000);
                    }
                    int httpPort = member.getHttpPort();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("HTTP Port=" + httpPort));
                    }
                    if (httpPort != -1) {
                        InetSocketAddress httpSockaddr = new InetSocketAddress(addr, httpPort);
                        new Socket().connect(httpSockaddr, 10000);
                    }
                    int httpsPort = member.getHttpsPort();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("HTTPS Port=" + httpsPort));
                    }
                    if (httpsPort != -1) {
                        InetSocketAddress httpsSockaddr = new InetSocketAddress(addr, httpsPort);
                        new Socket().connect(httpsSockaddr, 10000);
                    }
                    return httpPort != -1 || httpsPort != -1;
                }
                catch (IOException e) {
                    String msg;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"", (Throwable)e);
                    }
                    if (!(msg = e.getMessage()).contains("Connection refused") && !msg.contains("connect timed out")) {
                        log.error((Object)("Cannot connect to member " + member), (Throwable)e);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    continue;
                }
            }
            return false;
        }
    }

    private class MemberEntryListener
    implements EntryListener<String, org.apache.axis2.clustering.Member> {
        private MemberEntryListener() {
        }

        public void entryAdded(EntryEvent<String, org.apache.axis2.clustering.Member> entryEvent) {
            if (((String)entryEvent.getKey()).equals(HazelcastGroupManagementAgent.this.localMemberUUID)) {
                return;
            }
            org.apache.axis2.clustering.Member member = (org.apache.axis2.clustering.Member)entryEvent.getValue();
            HazelcastGroupManagementAgent.this.connectMember(member);
        }

        public void entryRemoved(EntryEvent<String, org.apache.axis2.clustering.Member> entryEvent) {
            HazelcastGroupManagementAgent.this.connectedMembers.remove(entryEvent.getValue());
        }

        public void entryUpdated(EntryEvent<String, org.apache.axis2.clustering.Member> entryEvent) {
        }

        public void entryEvicted(EntryEvent<String, org.apache.axis2.clustering.Member> stringObjectEntryEvent) {
        }
    }

    private class GroupMembershipListener
    implements MembershipListener {
        private GroupMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            log.info((Object)("Member joined [" + member.getUuid() + "]: " + member.getInetSocketAddress().toString()));
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            log.info((Object)("Member left [" + member.getUuid() + "]: " + member.getInetSocketAddress().toString()));
            org.apache.axis2.clustering.Member removed = (org.apache.axis2.clustering.Member)HazelcastGroupManagementAgent.this.members.remove((Object)membershipEvent.getMember().getUuid());
            HazelcastGroupManagementAgent.this.connectedMembers.remove(removed);
        }
    }
}

