/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.management.DefaultGroupManagementAgent;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.clustering.management.NodeManager;
import org.apache.axis2.clustering.state.StateManager;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.caching.impl.DistributedMapProvider;
import org.wso2.carbon.core.ServerStatus;
import org.wso2.carbon.core.clustering.api.CarbonCluster;
import org.wso2.carbon.core.clustering.api.ClusterMessage;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastCarbonClusterImpl;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastClusterMessageListener;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastControlCommandListener;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastDistributedMapProvider;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastGroupManagementAgent;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.ParameterAdapter;
import org.wso2.carbon.core.clustering.hazelcast.aws.AWSBasedMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.multicast.MulticastBasedMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.util.MemberUtils;
import org.wso2.carbon.core.clustering.hazelcast.wka.WKABasedMembershipScheme;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;

public class HazelcastClusteringAgent
extends ParameterAdapter
implements ClusteringAgent {
    private static final Log log = LogFactory.getLog(HazelcastClusteringAgent.class);
    public static final String DEFAULT_SUB_DOMAIN = "__$default";
    private Config primaryHazelcastConfig;
    private HazelcastInstance primaryHazelcastInstance;
    private HazelcastMembershipScheme membershipScheme;
    private ConfigurationContext configurationContext;
    private ITopic<ClusteringMessage> clusteringMessageTopic;
    private List<ClusteringMessage> sentMsgsBuffer = new CopyOnWriteArrayList<ClusteringMessage>();
    private Map<String, Long> recdMsgsBuffer = new ConcurrentHashMap<String, Long>();
    private List<Member> wkaMembers;
    private final Map<String, Map<String, GroupManagementAgent>> groupManagementAgents = new HashMap<String, Map<String, GroupManagementAgent>>();
    private boolean clusterManagementMode;
    private String primaryDomain;

    public void init() throws ClusteringFault {
        Parameter licenseKey;
        MemberUtils.init(this.parameters, this.configurationContext);
        this.primaryHazelcastConfig = new Config();
        this.setHazelcastProperties();
        Parameter managementCenterURL = this.getParameter("mgtCenterURL");
        if (managementCenterURL != null) {
            this.primaryHazelcastConfig.getManagementCenterConfig().setEnabled(true).setUrl((String)managementCenterURL.getValue());
        }
        if ((licenseKey = this.getParameter("licenseKey")) != null) {
            this.primaryHazelcastConfig.setLicenseKey((String)licenseKey.getValue());
        }
        this.primaryDomain = this.getClusterDomain();
        this.primaryHazelcastConfig.setInstanceName(this.primaryDomain + ".instance");
        log.info((Object)("Cluster domain: " + this.primaryDomain));
        GroupConfig groupConfig = this.primaryHazelcastConfig.getGroupConfig();
        groupConfig.setName(this.primaryDomain);
        Parameter memberPassword = this.getParameter("groupPassword");
        if (memberPassword != null) {
            groupConfig.setPassword((String)memberPassword.getValue());
        }
        NetworkConfig nwConfig = this.primaryHazelcastConfig.getNetworkConfig();
        Parameter localMemberHostParam = this.getParameter("localMemberHost");
        String localMemberHost = "";
        if (localMemberHostParam != null) {
            localMemberHost = ((String)localMemberHostParam.getValue()).trim();
        } else {
            try {
                localMemberHost = Utils.getIpAddress();
            }
            catch (SocketException e) {
                log.error((Object)"Could not set local member host", (Throwable)e);
            }
        }
        nwConfig.setPublicAddress(localMemberHost);
        int localMemberPort = 4000;
        Parameter localMemberPortParam = this.getParameter("localMemberPort");
        if (localMemberPortParam != null) {
            localMemberPort = Integer.parseInt(((String)localMemberPortParam.getValue()).trim());
        }
        nwConfig.setPort(localMemberPort);
        this.configureMembershipScheme(nwConfig);
        MapConfig mapConfig = new MapConfig("carbon-map-config");
        mapConfig.setEvictionPolicy("NONE");
        if (licenseKey != null) {
            mapConfig.setStorageType(MapConfig.StorageType.OFFHEAP);
        }
        this.primaryHazelcastConfig.addMapConfig(mapConfig);
        if (this.clusterManagementMode) {
            for (Map.Entry<String, Map<String, GroupManagementAgent>> entry : this.groupManagementAgents.entrySet()) {
                for (GroupManagementAgent agent : entry.getValue().values()) {
                    if (!(agent instanceof HazelcastGroupManagementAgent)) continue;
                    ((HazelcastGroupManagementAgent)agent).init(this.primaryHazelcastConfig, this.configurationContext);
                }
            }
        }
        long start = System.currentTimeMillis();
        this.primaryHazelcastInstance = Hazelcast.newHazelcastInstance((Config)this.primaryHazelcastConfig);
        log.info((Object)("Hazelcast initialized in " + (System.currentTimeMillis() - start) + "ms"));
        HazelcastCarbonClusterImpl hazelcastCarbonCluster = new HazelcastCarbonClusterImpl(this.primaryHazelcastInstance);
        this.membershipScheme.setPrimaryHazelcastInstance(this.primaryHazelcastInstance);
        this.membershipScheme.setCarbonCluster(hazelcastCarbonCluster);
        this.clusteringMessageTopic = this.primaryHazelcastInstance.getTopic("$clustering.message.topic");
        this.clusteringMessageTopic.addMessageListener((MessageListener)new HazelcastClusterMessageListener(this.configurationContext, this.recdMsgsBuffer, this.sentMsgsBuffer));
        ITopic controlCommandTopic = this.primaryHazelcastInstance.getTopic("$control.$command.$topic");
        controlCommandTopic.addMessageListener((MessageListener)new HazelcastControlCommandListener(this.configurationContext));
        com.hazelcast.core.Member localMember = this.primaryHazelcastInstance.getCluster().getLocalMember();
        this.membershipScheme.setLocalMember(localMember);
        this.membershipScheme.joinGroup();
        localMember = this.primaryHazelcastInstance.getCluster().getLocalMember();
        localMember.getInetSocketAddress().getPort();
        Member carbonLocalMember = MemberUtils.getLocalMember(this.primaryDomain, localMember.getInetSocketAddress().getAddress().getHostAddress(), localMember.getInetSocketAddress().getPort());
        log.info((Object)("Local member: [" + localMember.getUuid() + "] - " + carbonLocalMember));
        ITopic replayedMsgs = this.primaryHazelcastInstance.getTopic("$ReplayMessageQueue:" + localMember.getUuid());
        replayedMsgs.addMessageListener((MessageListener)new MessageListener<ClusterMessage>(){

            public void onMessage(Message<ClusterMessage> clusterMessage) {
                ClusterMessage msg = (ClusterMessage)clusterMessage.getMessageObject();
                if (!HazelcastClusteringAgent.this.recdMsgsBuffer.containsKey(msg.getUuid())) {
                    log.info((Object)("Received replayed message: " + msg.getUuid()));
                    msg.execute();
                    HazelcastClusteringAgent.this.recdMsgsBuffer.put(msg.getUuid(), System.currentTimeMillis());
                }
            }
        });
        if (carbonLocalMember.getProperties().get("subDomain") == null) {
            carbonLocalMember.getProperties().put("subDomain", DEFAULT_SUB_DOMAIN);
        }
        MemberUtils.getMembersMap(this.primaryHazelcastInstance, this.primaryDomain).put((Object)localMember.getUuid(), (Object)carbonLocalMember);
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        bundleContext.registerService(DistributedMapProvider.class, (Object)new HazelcastDistributedMapProvider(this.primaryHazelcastInstance), null);
        bundleContext.registerService(HazelcastInstance.class, (Object)this.primaryHazelcastInstance, null);
        bundleContext.registerService(CarbonCluster.class, (Object)hazelcastCarbonCluster, null);
        ScheduledExecutorService msgCleanupScheduler = Executors.newScheduledThreadPool(1);
        msgCleanupScheduler.scheduleWithFixedDelay(new ClusterMessageCleanupTask(), 2L, 2L, TimeUnit.MINUTES);
        log.info((Object)"Cluster initialization completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHazelcastProperties() {
        String hazelcastPropsFileName = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "conf" + File.separator + "hazelcast.properties";
        Properties hazelcastProperties = new Properties();
        hazelcastProperties.setProperty("hazelcast.max.no.heartbeat.seconds", "600");
        hazelcastProperties.setProperty("hazelcast.max.no.master.confirmation.seconds", "900");
        if (new File(hazelcastPropsFileName).exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(hazelcastPropsFileName);
                hazelcastProperties.load(fileInputStream);
            }
            catch (IOException e) {
                log.error((Object)("Cannot load properties from file " + hazelcastPropsFileName), (Throwable)e);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Cannot close file " + hazelcastPropsFileName), (Throwable)e);
                    }
                }
            }
        }
        this.primaryHazelcastConfig.setProperties(hazelcastProperties);
    }

    private String getClusterDomain() {
        Parameter domainParam = this.getParameter("domain");
        String domain = domainParam != null ? (String)domainParam.getValue() : "apache.axis2.domain";
        return domain;
    }

    private void configureMembershipScheme(NetworkConfig nwConfig) throws ClusteringFault {
        String scheme = this.getMembershipScheme();
        log.info((Object)("Using " + scheme + " based membership management scheme"));
        if (scheme.equals("wka")) {
            this.membershipScheme = new WKABasedMembershipScheme(this.parameters, this.primaryDomain, this.wkaMembers, this.primaryHazelcastConfig, this.sentMsgsBuffer);
            this.membershipScheme.init();
            WKABasedMembershipScheme wkaBasedMembershipScheme = (WKABasedMembershipScheme)this.membershipScheme;
            long start = System.currentTimeMillis();
            while (!wkaBasedMembershipScheme.areWellKnownMembersAvailable() && !ServerStatus.getCurrentStatus().equals("SHUTTING_DOWN")) {
                if (System.currentTimeMillis() - start > 60000L) {
                    log.warn((Object)"Waiting for all well-known members to become available");
                    start = System.currentTimeMillis();
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                this.membershipScheme.init();
            }
        } else if (scheme.equals("multicast")) {
            this.membershipScheme = new MulticastBasedMembershipScheme(this.parameters, this.primaryDomain, nwConfig.getJoin().getMulticastConfig(), this.sentMsgsBuffer);
            this.membershipScheme.init();
        } else if (scheme.equals("aws")) {
            this.membershipScheme = new AWSBasedMembershipScheme(this.parameters, this.primaryDomain, nwConfig.getJoin().getAwsConfig());
            this.membershipScheme.init();
        } else {
            String msg = "Invalid membership scheme '" + scheme + "'. Supported schemes are multicast & wka";
            log.error((Object)msg);
            throw new ClusteringFault(msg);
        }
    }

    private String getMembershipScheme() throws ClusteringFault {
        Parameter membershipSchemeParam = this.getParameter("membershipScheme");
        String mbrScheme = "multicast";
        if (membershipSchemeParam != null) {
            mbrScheme = ((String)membershipSchemeParam.getValue()).trim();
        }
        if (!(mbrScheme.equals("multicast") || mbrScheme.equals("wka") || mbrScheme.equals("aws"))) {
            String msg = "Invalid membership scheme '" + mbrScheme + "'. Supported schemes are " + "multicast" + ", " + "wka" + " & " + "aws";
            log.error((Object)msg);
            throw new ClusteringFault(msg);
        }
        return mbrScheme;
    }

    public void stop() {
        Hazelcast.shutdownAll();
    }

    public StateManager getStateManager() {
        return null;
    }

    @Deprecated
    public NodeManager getNodeManager() {
        return null;
    }

    public void setStateManager(StateManager stateManager) {
        throw new UnsupportedOperationException("setStateManager is not supported");
    }

    @Deprecated
    public void setNodeManager(NodeManager nodeManager) {
        throw new UnsupportedOperationException("setNodeManager is no longer supported");
    }

    public void shutdown() throws ClusteringFault {
        try {
            Hazelcast.shutdownAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void setMembers(List<Member> wkaMembers) {
        this.wkaMembers = wkaMembers;
    }

    public List<Member> getMembers() {
        return this.wkaMembers;
    }

    public int getAliveMemberCount() {
        return MemberUtils.getMembersMap(this.primaryHazelcastInstance, this.primaryDomain).size();
    }

    public void addGroupManagementAgent(GroupManagementAgent agent, String applicationDomain) {
        this.addGroupManagementAgent(agent, applicationDomain, null);
    }

    public void addGroupManagementAgent(GroupManagementAgent groupManagementAgent, String applicationDomain, String applicationSubDomain, int groupMgtPort) {
        this.addGroupManagementAgent(groupManagementAgent, applicationDomain, applicationSubDomain);
        groupManagementAgent.setGroupMgtPort(groupMgtPort);
    }

    public void resetGroupManagementAgent(String applicationDomain, String applicationSubDomain) {
        if (this.groupManagementAgents.containsKey(applicationDomain) && this.groupManagementAgents.get(applicationDomain).containsKey(applicationSubDomain)) {
            GroupManagementAgent agent = this.groupManagementAgents.get(applicationDomain).get(applicationSubDomain);
            Iterator iterator = agent.getMembers().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove all members of group management agent of cluster domain " + applicationDomain + " and sub domain " + applicationSubDomain));
            }
            if (agent instanceof DefaultGroupManagementAgent) {
                MembershipManager manager = ((DefaultGroupManagementAgent)agent).getMembershipManager();
                manager.removeAllMembers();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remove all members of Membership Manager of group management agent of cluster domain " + applicationDomain + " and sub domain " + applicationSubDomain));
                }
            }
        }
        log.info((Object)("Resetting group management agent of cluster domain " + applicationDomain + " and sub domain " + applicationSubDomain));
    }

    public void addGroupManagementAgent(GroupManagementAgent agent, String applicationDomain, String applicationSubDomain) {
        if (applicationSubDomain == null) {
            applicationSubDomain = DEFAULT_SUB_DOMAIN;
        }
        log.info((Object)("Managing group application domain:" + applicationDomain + ", sub-domain:" + applicationSubDomain + " using agent " + agent.getClass()));
        if (!this.groupManagementAgents.containsKey(applicationDomain)) {
            this.groupManagementAgents.put(applicationDomain, new HashMap());
        }
        agent.setDomain(applicationDomain);
        agent.setSubDomain(applicationSubDomain);
        this.groupManagementAgents.get(applicationDomain).put(applicationSubDomain, agent);
        this.clusterManagementMode = true;
    }

    public GroupManagementAgent getGroupManagementAgent(String applicationDomain) {
        return this.getGroupManagementAgent(applicationDomain, null);
    }

    public GroupManagementAgent getGroupManagementAgent(String applicationDomain, String applicationSubDomain) {
        Map<String, GroupManagementAgent> groupManagementAgentMap;
        if (applicationSubDomain == null) {
            applicationSubDomain = DEFAULT_SUB_DOMAIN;
        }
        if ((groupManagementAgentMap = this.groupManagementAgents.get(applicationDomain)) != null) {
            return groupManagementAgentMap.get(applicationSubDomain);
        }
        return null;
    }

    public Set<String> getDomains() {
        return this.groupManagementAgents.keySet();
    }

    public boolean isCoordinator() {
        return false;
    }

    public List<ClusteringCommand> sendMessage(ClusteringMessage clusteringMessage, boolean isSync) throws ClusteringFault {
        if (!this.sentMsgsBuffer.contains(clusteringMessage)) {
            this.sentMsgsBuffer.add(clusteringMessage);
        }
        if (this.clusteringMessageTopic != null) {
            this.clusteringMessageTopic.publish((Object)clusteringMessage);
        }
        return new ArrayList<ClusteringCommand>();
    }

    private class ClusterMessageCleanupTask
    implements Runnable {
        private static final int MAX_MESSAGES_TO_PROCESS = 5000;
        private static final int MAX_MESSAGE_LIFETIME = 300000;

        private ClusterMessageCleanupTask() {
        }

        @Override
        public void run() {
            int messagesProcessed = 0;
            for (ClusteringMessage clusteringMessage : HazelcastClusteringAgent.this.sentMsgsBuffer) {
                if (System.currentTimeMillis() - clusteringMessage.getTimestamp() >= 300000L) {
                    HazelcastClusteringAgent.this.sentMsgsBuffer.remove(clusteringMessage);
                }
                if (++messagesProcessed < 5000) continue;
                break;
            }
            messagesProcessed = 0;
            for (Map.Entry entry : HazelcastClusteringAgent.this.recdMsgsBuffer.entrySet()) {
                if (System.currentTimeMillis() - (Long)entry.getValue() >= 300000L) {
                    HazelcastClusteringAgent.this.recdMsgsBuffer.remove(entry.getKey());
                }
                if (++messagesProcessed < 5000) continue;
                break;
            }
        }
    }
}

