/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.ui.CarbonSSOSessionManager;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonUILoginUtil;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.SecuredComponentEntryHttpContext;
import org.wso2.carbon.ui.UIResourceRegistry;
import org.wso2.carbon.ui.deployment.beans.CarbonUIDefinitions;
import org.wso2.carbon.ui.deployment.beans.Context;
import org.wso2.carbon.ui.internal.CarbonUIServiceComponent;

public class CarbonSecuredHttpContext
extends SecuredComponentEntryHttpContext {
    public static final String LOGGED_USER = "logged-user";
    public static final String CARBON_AUTHNETICATOR = "CarbonAuthenticator";
    private static final Log log = LogFactory.getLog(CarbonSecuredHttpContext.class);
    private Bundle bundle = null;
    private HashMap<String, String> httpUrlsToBeByPassed = new HashMap();
    private HashMap<String, String> urlsToBeByPassed = new HashMap();
    private String defaultHomePage;
    private Context defaultContext;

    public CarbonSecuredHttpContext(Bundle bundle, String s, UIResourceRegistry uiResourceRegistry, Registry registry) {
        super(bundle, s, uiResourceRegistry);
        this.registry = registry;
        this.bundle = bundle;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Matcher matcher;
        String sessionId;
        HttpSession session;
        String requestedURI = request.getRequestURI();
        CarbonUIAuthenticator authenticator = CarbonUILoginUtil.getAuthenticator(request);
        CarbonSSOSessionManager ssoSessionManager = CarbonSSOSessionManager.getInstance();
        requestedURI = ssoSessionManager.getRequestedUrl(request, authenticator);
        boolean authenticated = false;
        try {
            session = request.getSession();
            sessionId = session.getId();
            Boolean authenticatedObj = (Boolean)session.getAttribute("authenticated");
            if (authenticatedObj != null) {
                authenticated = authenticatedObj;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Is authenticated " + authenticated));
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)"No session exits");
            return false;
        }
        String context = request.getContextPath();
        if ("/".equals(context)) {
            context = "";
        }
        if ((matcher = CarbonUILoginUtil.getTenantEnabledUriPattern().matcher(requestedURI)).matches()) {
            log.debug((Object)("Tenant webapp request " + requestedURI));
            return CarbonUILoginUtil.escapeTenantWebAppRequests(authenticated, response, requestedURI, context);
        }
        if (requestedURI.indexOf("//") == 0) {
            requestedURI = requestedURI.substring(1);
        }
        if (this.httpUrlsToBeByPassed.isEmpty()) {
            this.populatehttpUrlsToBeByPassed();
        }
        if (requestedURI.equals(context) || requestedURI.equals(context + "/")) {
            return this.handleRequestOnContext(request, response);
        }
        String tempUrl = requestedURI;
        CarbonUILoginUtil.addNewContext(requestedURI);
        int val = -1;
        val = this.allowNonSecuredContent(requestedURI, request, response, authenticated, authenticator);
        if (val != 2) {
            if (val == 1) {
                log.debug((Object)("Skipping security check for non secured content. " + requestedURI));
                return true;
            }
            log.debug((Object)("Security check failed for the resource " + requestedURI));
            return false;
        }
        if (requestedURI.endsWith(".jar") || requestedURI.endsWith(".class")) {
            log.debug((Object)("Skipping authentication for .jar files and .class file." + requestedURI));
            return true;
        }
        String resourceURI = requestedURI.replaceFirst("/carbon/", "../");
        if (log.isDebugEnabled()) {
            log.debug((Object)("CarbonSecuredHttpContext -> handleSecurity() requestURI:" + requestedURI + " id:" + sessionId + " resourceURI:" + resourceURI));
        }
        if (this.urlsToBeByPassed.isEmpty()) {
            this.populateUrlsToBeBypassed();
        }
        if (this.isCurrentUrlToBePassed(request, session, resourceURI)) {
            return true;
        }
        String indexPageURL = CarbonUIUtil.getIndexPageURL(session.getServletContext(), request.getSession());
        indexPageURL = CarbonUILoginUtil.getIndexPageUrlFromCookie(requestedURI, indexPageURL, request);
        indexPageURL = CarbonUILoginUtil.getCustomIndexPage(request, indexPageURL);
        val = CarbonUILoginUtil.handleLoginPageRequest(requestedURI, request, response, authenticated, context, indexPageURL = this.updateIndexPageWithHomePage(indexPageURL));
        if (val != 2) {
            return val == 1;
        }
        if (ssoSessionManager.skipAuthentication(request)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping security checks for authenticator defined URL " + requestedURI));
            }
            return true;
        }
        requestedURI = CarbonUILoginUtil.getForcedSignOutRequestedURI(requestedURI, request);
        String contextPath = request.getContextPath().equals("") || request.getContextPath().equals("/") ? "" : request.getContextPath();
        String tenantDomain = (String)session.getAttribute("tenantDomain");
        if (tenantDomain != null && !tenantDomain.equals("carbon.super")) {
            contextPath = contextPath + "/t/" + tenantDomain;
        }
        String httpLogin = request.getParameter("gsHttpRequest");
        boolean skipLoginPage = false;
        if (authenticator != null && authenticator.skipLoginPage() && requestedURI.indexOf("login_action.jsp") < 0 && (requestedURI.endsWith("/carbon/") || requestedURI.indexOf("/registry/atom") == -1 && requestedURI.endsWith("/carbon"))) {
            request.getSession().setAttribute("skipLoginPage", (Object)"true");
        }
        if (request.getSession().getAttribute("skipLoginPage") != null && "true".equals((String)request.getSession().getAttribute("skipLoginPage"))) {
            skipLoginPage = true;
        }
        if (requestedURI.indexOf("login_action.jsp") > -1 && authenticator != null) {
            return CarbonUILoginUtil.handleLogin(authenticator, request, response, session, authenticated, contextPath, indexPageURL, httpLogin);
        }
        if (requestedURI.indexOf("logout_action.jsp") > 1) {
            return CarbonUILoginUtil.handleLogout(authenticator, request, response, session, authenticated, contextPath, indexPageURL, httpLogin);
        }
        if (requestedURI.endsWith("/carbon/")) {
            if (skipLoginPage) {
                response.sendRedirect(contextPath + indexPageURL + "?skipLoginPage=true");
            } else {
                response.sendRedirect(contextPath + indexPageURL);
            }
            return false;
        }
        if (requestedURI.indexOf("/registry/atom") == -1 && requestedURI.endsWith("/carbon")) {
            if (skipLoginPage) {
                response.sendRedirect(contextPath + indexPageURL + "?skipLoginPage=true");
            } else {
                response.sendRedirect(contextPath + indexPageURL);
            }
            return false;
        }
        if (CarbonUILoginUtil.letRequestedUrlIn(requestedURI, tempUrl)) {
            return true;
        }
        if (requestedURI.endsWith(".jsp") && authenticated) {
            return true;
        }
        if (!authenticated) {
            if (requestedURI.endsWith("ajaxprocessor.jsp")) {
                return true;
            }
            return CarbonUILoginUtil.saveOriginalUrl(authenticator, request, response, session, skipLoginPage, contextPath, indexPageURL, requestedURI);
        }
        if (request.getSession().isNew()) {
            if (skipLoginPage) {
                response.sendRedirect(contextPath + "/carbon/admin/login_action.jsp");
            } else {
                response.sendRedirect(contextPath + "/carbon/admin/login.jsp");
            }
            return false;
        }
        return true;
    }

    private String updateIndexPageWithHomePage(String indexPageURL) {
        if (this.defaultHomePage == null) {
            this.defaultHomePage = (String)CarbonUIUtil.getProductParam("WSO2CarbondefaultHomePage");
        }
        if (this.defaultHomePage != null && this.defaultHomePage.trim().length() > 0 && indexPageURL.contains("/carbon/admin/index.jsp") && !(indexPageURL = this.defaultHomePage).startsWith("/")) {
            indexPageURL = "/" + indexPageURL;
        }
        return indexPageURL;
    }

    private boolean isCurrentUrlToBePassed(HttpServletRequest request, HttpSession session, String resourceURI) {
        if (!this.urlsToBeByPassed.isEmpty() && this.urlsToBeByPassed.containsKey(resourceURI)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("By passing authentication check for URI : " + resourceURI));
            }
            String contextPath = request.getContextPath();
            String backendServerURL = request.getParameter("backendURL");
            if (backendServerURL == null) {
                backendServerURL = CarbonUIUtil.getServerURL(session.getServletContext(), request.getSession());
            }
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            backendServerURL = backendServerURL.replace("${carbon.context}", contextPath);
            session.setAttribute("ServerURL", (Object)backendServerURL);
            return true;
        }
        return false;
    }

    private void populateUrlsToBeBypassed() {
        CarbonUIDefinitions carbonUIDefinitions;
        ServiceReference reference;
        if (this.bundle != null && this.urlsToBeByPassed.isEmpty() && (reference = this.bundle.getBundleContext().getServiceReference(CarbonUIDefinitions.class.getName())) != null && (carbonUIDefinitions = (CarbonUIDefinitions)this.bundle.getBundleContext().getService(reference)) != null) {
            this.urlsToBeByPassed = carbonUIDefinitions.getUnauthenticatedUrls();
        }
    }

    private int allowNonSecuredContent(String requestedURI, HttpServletRequest request, HttpServletResponse response, boolean authenticated, CarbonUIAuthenticator authenticator) throws IOException {
        if (!request.isSecure() && !requestedURI.endsWith(".html")) {
            String adminConsoleURL;
            if (requestedURI.endsWith(".css") || requestedURI.endsWith(".gif") || requestedURI.endsWith(".GIF") || requestedURI.endsWith(".jpg") || requestedURI.endsWith(".JPG") || requestedURI.endsWith(".png") || requestedURI.endsWith(".PNG") || requestedURI.endsWith(".xsl") || requestedURI.endsWith(".xslt") || requestedURI.endsWith(".js") || requestedURI.endsWith(".ico") || requestedURI.endsWith("/filedownload") || requestedURI.endsWith("/fileupload") || requestedURI.contains("/fileupload/") || requestedURI.contains("admin/jsp/WSRequestXSSproxy_ajaxprocessor.jsp") || requestedURI.contains("registry/atom") || requestedURI.contains("registry/tags") || requestedURI.contains("gadgets/") || requestedURI.contains("registry/resource")) {
                return 1;
            }
            String resourceURI = requestedURI.replaceFirst("/carbon/", "../");
            if (this.httpUrlsToBeByPassed.containsKey(resourceURI)) {
                if (!authenticated) {
                    try {
                        Cookie[] cookies = request.getCookies();
                        if (cookies != null) {
                            for (Cookie cookie : cookies) {
                                if (!cookie.getName().equals("wso2.carbon.rememberme") || authenticator == null) continue;
                                try {
                                    authenticator.authenticateWithCookie(request);
                                }
                                catch (AuthenticationException ignored) {
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug((Object)ignored);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        throw new IOException(e.getMessage(), e);
                    }
                }
                return 1;
            }
            String enableHTTPAdminConsole = CarbonUIServiceComponent.getServerConfiguration().getFirstProperty("EnableHTTPAdminConsole");
            if ((enableHTTPAdminConsole == null || "false".equalsIgnoreCase(enableHTTPAdminConsole.trim())) && (adminConsoleURL = CarbonUIUtil.getAdminConsoleURL(request)) != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Request came to admin console via http.Forwarding to : " + adminConsoleURL));
                }
                response.sendRedirect(adminConsoleURL);
                return 0;
            }
        }
        return 2;
    }

    private boolean handleRequestOnContext(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug((Object)"Handling request on context");
        if (this.defaultContext != null && !"".equals(this.defaultContext.getContextName()) && !"null".equals(this.defaultContext.getContextName())) {
            String adminConsoleURL = CarbonUIUtil.getAdminConsoleURL(request);
            int index = adminConsoleURL.lastIndexOf("carbon");
            String defaultContextUrl = adminConsoleURL.substring(0, index) + this.defaultContext.getContextName() + "/";
            response.sendRedirect(defaultContextUrl);
        } else {
            response.sendRedirect("carbon");
        }
        return false;
    }

    private void populatehttpUrlsToBeByPassed() {
        CarbonUIDefinitions carbonUIDefinitions;
        ServiceReference reference;
        if (this.bundle != null && this.httpUrlsToBeByPassed.isEmpty() && this.defaultContext == null && (reference = this.bundle.getBundleContext().getServiceReference(CarbonUIDefinitions.class.getName())) != null && (carbonUIDefinitions = (CarbonUIDefinitions)this.bundle.getBundleContext().getService(reference)) != null) {
            this.httpUrlsToBeByPassed = carbonUIDefinitions.getHttpUrls();
            if (carbonUIDefinitions.getContexts().containsKey("default-context")) {
                this.defaultContext = carbonUIDefinitions.getContexts().get("default-context");
            }
        }
    }
}

