/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.caching.impl.DistributedMapProvider;
import org.wso2.carbon.caching.impl.MapEntryListener;

public class HazelcastDistributedMapProvider
implements DistributedMapProvider {
    private HazelcastInstance hazelcastInstance;

    public HazelcastDistributedMapProvider(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public <K, V> Map<K, V> getMap(String mapName, MapEntryListener entryListener) {
        return new DistMap(mapName, entryListener);
    }

    private class DistMap<K, V>
    implements Map<K, V> {
        private Map<K, V> map;

        public DistMap(String mapName, final MapEntryListener entryListener) {
            this.map = HazelcastDistributedMapProvider.this.hazelcastInstance.getMap(mapName);
            if (entryListener != null) {
                ((IMap)this.map).addEntryListener(new EntryListener<K, V>(){

                    public void entryAdded(EntryEvent<K, V> kvEntryEvent) {
                        entryListener.entryAdded(kvEntryEvent.getKey());
                    }

                    public void entryRemoved(EntryEvent<K, V> kvEntryEvent) {
                        entryListener.entryRemoved(kvEntryEvent.getKey());
                    }

                    public void entryUpdated(EntryEvent<K, V> kvEntryEvent) {
                        entryListener.entryUpdated(kvEntryEvent.getKey());
                    }

                    public void entryEvicted(EntryEvent<K, V> kvEntryEvent) {
                        entryListener.entryRemoved(kvEntryEvent.getKey());
                    }
                }, false);
            }
        }

        @Override
        public int size() {
            if (!HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return 0;
            }
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return !HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning() || this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning() && this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning() && this.map.containsValue(value);
        }

        @Override
        public V get(Object key) {
            if (!HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return null;
            }
            return this.map.get(key);
        }

        @Override
        public V put(K key, V value) {
            if (!HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.map.put(key, value);
            }
            return value;
        }

        @Override
        public V remove(Object key) {
            if (!HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.map.remove(key);
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            if (!HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                this.map.putAll(m);
            }
        }

        @Override
        public void clear() {
            if (!HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                this.map.clear();
            }
        }

        @Override
        public Set<K> keySet() {
            if (!HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.map.keySet();
            }
            return new LinkedHashSet();
        }

        @Override
        public Collection<V> values() {
            if (!HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.map.values();
            }
            return new ArrayList();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (!HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.map.entrySet();
            }
            return new LinkedHashSet<Map.Entry<K, V>>();
        }
    }
}

