/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.common.spi.DataSourceReader;
import org.wso2.carbon.ndatasource.core.DataSourceMetaInfo;
import org.wso2.carbon.ndatasource.core.DataSourceRepository;
import org.wso2.carbon.ndatasource.core.SystemDataSourcesConfiguration;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;
import org.wso2.carbon.utils.CarbonUtils;

public class DataSourceManager {
    private static Log log = LogFactory.getLog(DataSourceManager.class);
    private static DataSourceManager instance = new DataSourceManager();
    private Map<Integer, DataSourceRepository> dsRepoMap;
    private Map<String, DataSourceReader> dsReaders = new HashMap<String, DataSourceReader>();
    private Map<Integer, Boolean> userDSRepoInitMap;

    public DataSourceManager() {
        this.dsRepoMap = new ConcurrentHashMap<Integer, DataSourceRepository>();
        this.userDSRepoInitMap = new ConcurrentHashMap<Integer, Boolean>();
    }

    public static DataSourceManager getInstance() {
        return instance;
    }

    public DataSourceRepository getDataSourceRepository() throws DataSourceException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        return this.getDataSourceRepository(tenantId);
    }

    private synchronized DataSourceRepository getDataSourceRepository(int tenantId) throws DataSourceException {
        DataSourceRepository dsRepo = this.dsRepoMap.get(tenantId);
        if (dsRepo == null) {
            dsRepo = new DataSourceRepository(tenantId);
            this.dsRepoMap.put(tenantId, dsRepo);
        }
        return dsRepo;
    }

    private synchronized void removeDataSourceRepository(int tenantId) {
        this.dsRepoMap.remove(tenantId);
        this.userDSRepoInitMap.remove(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Data source repository removed for tenant: " + tenantId));
        }
    }

    public void initTenant(int tenantId) throws DataSourceException {
        if (!this.isDSRepoUserDSInitialized(tenantId)) {
            this.getDataSourceRepository(tenantId).initRepository();
            this.userDSRepoInitMap.put(tenantId, true);
        }
    }

    private synchronized boolean isDSRepoUserDSInitialized(int tenantId) {
        Boolean result = this.userDSRepoInitMap.get(tenantId);
        return result != null ? result : false;
    }

    public void unloadTenant(int tenantId) throws DataSourceException {
        this.getDataSourceRepository(tenantId).unregisterAllUserDataSources();
        this.removeDataSourceRepository(tenantId);
    }

    public List<String> getDataSourceTypes() throws DataSourceException {
        if (this.dsReaders == null) {
            throw new DataSourceException("The data source readers are not initialized yet");
        }
        return new ArrayList<String>(this.dsReaders.keySet());
    }

    public DataSourceReader getDataSourceReader(String dsType) throws DataSourceException {
        if (this.dsReaders == null) {
            throw new DataSourceException("The data source readers are not initialized yet");
        }
        return this.dsReaders.get(dsType);
    }

    private void addDataSourceProviders(List<String> providers) throws DataSourceException {
        if (providers == null) {
            return;
        }
        for (String provider : providers) {
            try {
                DataSourceReader tmpReader = (DataSourceReader)Class.forName(provider).newInstance();
                this.dsReaders.put(tmpReader.getType(), tmpReader);
            }
            catch (Exception e) {
                throw new DataSourceException("Error in loading data source provider: " + e.getMessage(), e);
            }
        }
    }

    public void initSystemDataSources() throws DataSourceException {
        try {
            String dataSourcesDir = CarbonUtils.getCarbonConfigDirPath() + File.separator + "datasources";
            File masterDSFile = new File(dataSourcesDir + File.separator + "master-datasources.xml");
            if (masterDSFile.exists()) {
                this.initSystemDataSource(masterDSFile);
            }
            File dataSourcesFolder = new File(dataSourcesDir);
            for (File sysDSFile : dataSourcesFolder.listFiles()) {
                if (!sysDSFile.getName().endsWith("-datasources.xml") || sysDSFile.getName().equals("master-datasources.xml")) continue;
                this.initSystemDataSource(sysDSFile);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in initializing system data sources: " + e.getMessage(), e);
        }
    }

    private void initSystemDataSource(File sysDSFile) throws DataSourceException {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SystemDataSourcesConfiguration.class});
            Document doc = DataSourceUtils.convertToDocument(sysDSFile);
            DataSourceUtils.secureResolveDocument(doc, true);
            SystemDataSourcesConfiguration sysDS = (SystemDataSourcesConfiguration)ctx.createUnmarshaller().unmarshal((Node)doc);
            this.addDataSourceProviders(sysDS.getProviders());
            DataSourceRepository dsRepo = this.getDataSourceRepository(-1234);
            for (DataSourceMetaInfo dsmInfo : sysDS.getDataSources()) {
                dsmInfo.setSystem(true);
                dsRepo.addDataSource(dsmInfo);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in initializing system data sources at '" + sysDSFile.getAbsolutePath() + "' - " + e.getMessage(), e);
        }
    }
}

