/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.webapp.mgt.WebApplication;

public class WebApplicationsHolder {
    private File webappsDir;
    private Map<String, WebApplication> startedWebapps = new ConcurrentHashMap<String, WebApplication>();
    private Map<String, WebApplication> stoppedWebapps = new ConcurrentHashMap<String, WebApplication>();
    private Map<String, WebApplication> faultyWebapps = new ConcurrentHashMap<String, WebApplication>();
    private Map<String, String> appVersionMap = new ConcurrentHashMap<String, String>();

    public WebApplicationsHolder(File webappsDir) {
        this.webappsDir = webappsDir;
    }

    public Map<String, WebApplication> getStartedWebapps() {
        return this.startedWebapps;
    }

    public Map<String, WebApplication> getFaultyWebapps() {
        return this.faultyWebapps;
    }

    public Map<String, WebApplication> getStoppedWebapps() {
        return this.stoppedWebapps;
    }

    public void stopWebapp(WebApplication webapp) throws CarbonException {
        boolean stopped = webapp.stop();
        if (stopped) {
            String fileName = webapp.getWebappFile().getName();
            this.startedWebapps.remove(fileName);
            this.stoppedWebapps.put(fileName, webapp);
        }
    }

    public void undeployWebapp(WebApplication webapp) throws CarbonException {
        webapp.undeploy();
        String fileName = webapp.getWebappFile().getName();
        this.startedWebapps.remove(fileName);
        this.stoppedWebapps.remove(fileName);
        this.faultyWebapps.remove(fileName);
    }

    public File getWebappsDir() {
        return this.webappsDir;
    }

    public Map<String, String> getAppVersionMap() {
        return this.appVersionMap;
    }
}

