/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.feed;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.iri.IRISyntaxException;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Person;
import org.apache.abdera.parser.stax.util.FOMHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.feed.EntryHostObject;
import org.jaggeryjs.hostobjects.file.FileHostObject;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.xml.XMLObject;

public class FeedHostObject
extends ScriptableObject {
    private static Feed feed;
    private static SyndFeed rssFeed;
    private static FeedHostObject feedHostObject;
    private static Abdera abdera;
    private static Entry entry;
    private static final String HOST_OBJECT_NAME = "Feed";
    private static boolean isRssFeed;
    private static Log log;
    public static Context ctx;

    public String getClassName() {
        return HOST_OBJECT_NAME;
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        int argsCount = args.length;
        if (argsCount > 2) {
            HostObjectUtil.invalidNumberOfArgs((String)HOST_OBJECT_NAME, (String)HOST_OBJECT_NAME, (int)argsCount, (boolean)true);
        }
        Abdera abdera = new Abdera();
        Factory factory = abdera.getFactory();
        feed = factory.newFeed();
        feedHostObject = new FeedHostObject();
        ctx = cx;
        if (argsCount == 0) {
            return feedHostObject;
        }
        if (argsCount == 1) {
            if (!(args[0] instanceof String)) {
                HostObjectUtil.invalidArgsError((String)HOST_OBJECT_NAME, (String)HOST_OBJECT_NAME, (String)"1", (String)"string", (Object)args[0], (boolean)true);
            }
            FeedHostObject.jsFunction_getFeed(cx, null, args, null);
        }
        return feedHostObject;
    }

    public Scriptable feedConstructor() {
        Abdera abdera = new Abdera();
        Factory factory = abdera.getFactory();
        feed = factory.newFeed();
        return this;
    }

    public static synchronized void jsFunction_getFeed(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        if (arguments.length != 1) {
            throw new ScriptException("Invalid parameter");
        }
        if (arguments[0] instanceof String) {
            feed = null;
            URL url = null;
            try {
                url = new URL((String)arguments[0]);
                feed = (Feed)Abdera.getNewParser().parse(url.openStream()).getRoot();
                isRssFeed = false;
            }
            catch (ClassCastException e) {
                XmlReader reader = null;
                try {
                    reader = new XmlReader(url);
                    rssFeed = new SyndFeedInput().build((Reader)reader);
                    isRssFeed = true;
                    for (SyndEntry entry : rssFeed.getEntries()) {
                    }
                }
                catch (IOException e1) {
                    throw new ScriptException((Exception)e1);
                }
                catch (Exception e1) {
                    throw new ScriptException(e1);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e1) {
                            throw new ScriptException((Exception)e1);
                        }
                    }
                }
            }
            catch (IRISyntaxException e) {
                throw new ScriptException((Exception)((Object)e));
            }
            catch (MalformedURLException e) {
                throw new ScriptException((Exception)e);
            }
            catch (IOException e) {
                throw new ScriptException((Exception)e);
            }
        } else {
            throw new ScriptException("Invalid parameter, It is must to be a String");
        }
    }

    public void jsSet_id(Object id) {
        if (id instanceof String) {
            feed.setId((String)id);
        } else {
            feed.setId(FOMHelper.generateUuid());
        }
    }

    public String jsGet_id() {
        if (feed != null) {
            return feed.getId().toASCIIString();
        }
        return null;
    }

    public String jsGet_author() {
        String author = isRssFeed ? rssFeed.getAuthor().toString() : feed.getAuthor().toString();
        return author;
    }

    public void jsSet_author(Object author) {
        feed.addAuthor(String.valueOf(author));
    }

    public void jsSet_authors(Object author) {
        if (author instanceof String) {
            feed.addAuthor((String)author);
        }
        if (author instanceof NativeArray) {
            NativeArray authorsPropertyArray = (NativeArray)author;
            for (Object o1 : authorsPropertyArray.getIds()) {
                int index = (Integer)o1;
                String name = authorsPropertyArray.get(index, null).toString();
                feed.addAuthor(name);
            }
        }
    }

    public NativeArray jsGet_authors() {
        NativeArray nativeArray = (NativeArray)ctx.newArray((Scriptable)this, 0);
        if (isRssFeed) {
            List list = rssFeed.getAuthors();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                String element = (String)list.get(i);
                nativeArray.put(i, (Scriptable)nativeArray, (Object)element);
            }
            return nativeArray;
        }
        if (feed != null) {
            List list = feed.getAuthors();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Person element = (Person)list.get(i);
                nativeArray.put(i, (Scriptable)nativeArray, (Object)element.getName());
            }
            return nativeArray;
        }
        return null;
    }

    public void jsSet_updated(Object updated) throws ScriptException {
        Date date = updated instanceof Date ? (Date)updated : (Date)Context.jsToJava((Object)updated, Date.class);
        if (date == null) {
            throw new ScriptException("Invalid parameter");
        }
        feed.setUpdated(date);
    }

    public Scriptable jsGet_updated() {
        if (feed != null) {
            Scriptable js = ctx.newObject((Scriptable)this, "Date", new Object[]{feed.getUpdated().getTime()});
            return js;
        }
        return null;
    }

    public String jsGet_title() {
        String title = isRssFeed ? rssFeed.getTitle().toString() : feed.getTitle();
        return title;
    }

    public void jsSet_title(Object title) {
        if (title instanceof XMLObject) {
            feed.setTitleAsXhtml(title.toString());
        } else {
            feed.setTitle(String.valueOf(title));
        }
    }

    public void jsSet_rights(Object rights) {
        if (rights instanceof XMLObject) {
            feed.setRightsAsXhtml(rights.toString());
        } else {
            feed.setRights(String.valueOf(rights));
        }
    }

    public String jsGet_rights() {
        if (feed != null) {
            return feed.getRights();
        }
        return null;
    }

    public void jsSet_icon(Object iconUrl) {
        if (iconUrl instanceof String) {
            feed.setIcon(iconUrl.toString());
        }
    }

    public String jsGet_icon() {
        if (feed != null) {
            if (feed.getIcon() == null) {
                return null;
            }
            return feed.getIcon().getPath();
        }
        return null;
    }

    public void jsSet_category(Object category) {
        feed.addCategory(String.valueOf(category));
    }

    public NativeArray jsGet_category() {
        if (feed != null) {
            NativeArray nativeArray = (NativeArray)ctx.newArray((Scriptable)this, 0);
            List list = feed.getCategories();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Category element = (Category)list.get(i);
                nativeArray.put(i, (Scriptable)nativeArray, (Object)element.getAttributeValue("term"));
            }
            return nativeArray;
        }
        return null;
    }

    public void jsSet_contributors(Object contributor) {
        if (contributor instanceof String) {
            entry.addContributor((String)contributor);
        }
        if (contributor instanceof NativeArray) {
            NativeArray contributorsPropertyArray = (NativeArray)contributor;
            for (Object o1 : contributorsPropertyArray.getIds()) {
                int index = (Integer)o1;
                String contributorName = contributorsPropertyArray.get(index, null).toString();
                feed.addContributor(contributorName);
            }
        }
    }

    public NativeArray jsGet_contributors() {
        if (feed != null) {
            NativeArray nativeArray = (NativeArray)ctx.newArray((Scriptable)this, 0);
            List list = feed.getContributors();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Person element = (Person)list.get(i);
                nativeArray.put(i, (Scriptable)nativeArray, (Object)element.getName());
            }
            return nativeArray;
        }
        return null;
    }

    public void jsSet_links(Object link) {
        if (link instanceof String) {
            feed.addLink((String)link);
        }
        if (link instanceof NativeArray) {
            NativeArray linksPropertyArray = (NativeArray)link;
            for (Object o1 : linksPropertyArray.getIds()) {
                int index = (Integer)o1;
                String linkStr = linksPropertyArray.get(index, null).toString();
                feed.addLink(linkStr);
            }
        }
    }

    public NativeArray jsGet_links() {
        if (feed != null) {
            NativeArray nativeArray = (NativeArray)ctx.newArray((Scriptable)this, 0);
            List list = feed.getLinks();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Link element = (Link)list.get(i);
                nativeArray.put(i, (Scriptable)nativeArray, (Object)element.getHref().toString());
            }
            return nativeArray;
        }
        return null;
    }

    public String jsGet_language() {
        String language = feed.getLanguage();
        return language;
    }

    public void jsSet_language(Object language) {
        if (language instanceof String) {
            feed.setLanguage(language.toString());
        }
    }

    public String jsGet_logo() throws ScriptException {
        String logoStr = null;
        IRI logo = feed.getLogo();
        if (logo == null) {
            return null;
        }
        try {
            logoStr = logo.toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new ScriptException((Exception)e);
        }
        catch (URISyntaxException e) {
            throw new ScriptException((Exception)e);
        }
        return logoStr;
    }

    public void jsSet_logo(Object logo) {
        if (logo instanceof String) {
            feed.setLogo(logo.toString());
        }
    }

    public String jsGet_alternateLink() {
        String alternateLink = feed.getAlternateLink().toString();
        return alternateLink;
    }

    public EntryHostObject[] jsGet_entries() throws ScriptException {
        Context cx = Context.getCurrentContext();
        EntryHostObject[] retEntries = null;
        List tempEntries = null;
        tempEntries = isRssFeed ? rssFeed.getEntries() : feed.getEntries();
        Iterator tempEntryIterator = tempEntries.iterator();
        ArrayList<EntryHostObject> convertedEntries = new ArrayList<EntryHostObject>();
        while (tempEntryIterator.hasNext()) {
            Entry currentEntry = (Entry)tempEntryIterator.next();
            EntryHostObject newAtomEntry = (EntryHostObject)cx.newObject((Scriptable)feedHostObject, "Entry", new Object[0]);
            newAtomEntry.setEntry(currentEntry);
            convertedEntries.add(newAtomEntry);
        }
        retEntries = new EntryHostObject[convertedEntries.size()];
        convertedEntries.toArray(retEntries);
        return retEntries;
    }

    public void jsSet_entries(Object entryList) throws ScriptException {
        if (entryList instanceof NativeArray) {
            NativeArray fields = (NativeArray)entryList;
            for (Object o : fields.getIds()) {
                int index = (Integer)o;
                Object nativeObject = fields.get(index, null);
                this.addEntry(nativeObject);
            }
        } else {
            throw new ScriptException("Invalid parameter");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEntry(Object entryObject) throws ScriptException {
        abdera = new Abdera();
        Factory factory = abdera.getFactory();
        entry = factory.newEntry();
        if (entryObject instanceof EntryHostObject) {
            EntryHostObject entryHostObject = (EntryHostObject)((Object)entryObject);
            entry = entryHostObject.getEntry();
            feed.addEntry(entry);
            return;
        } else if (entryObject instanceof NativeObject) {
            try {
                Object rights;
                Object publishedProperty;
                Object linksProperty;
                Object idProperty;
                Object contributorsProperty;
                Object content;
                Object categoriesProperty;
                Object categoryProperty;
                Object authorsProperty;
                NativeObject nativeObject;
                NativeObject scriptableObject = nativeObject = (NativeObject)entryObject;
                Object authorProperty = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"author");
                if (authorProperty instanceof String) {
                    entry.addAuthor((String)authorProperty);
                }
                if ((authorsProperty = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"authors")) instanceof NativeArray) {
                    NativeArray authorsPropertyArray = (NativeArray)authorsProperty;
                    for (Object o1 : authorsPropertyArray.getIds()) {
                        int indexx = (Integer)o1;
                        String name = authorsPropertyArray.get(indexx, null).toString();
                        entry.addAuthor(name);
                    }
                }
                if ((categoryProperty = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"category")) instanceof String) {
                    entry.addCategory((String)categoryProperty);
                }
                if ((categoriesProperty = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"categories")) instanceof NativeArray) {
                    NativeArray categoriesPropertyArray = (NativeArray)categoriesProperty;
                    for (Object o1 : categoriesPropertyArray.getIds()) {
                        int indexC = (Integer)o1;
                        String name = categoriesPropertyArray.get(indexC, null).toString();
                        entry.addCategory(name);
                    }
                }
                if ((content = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"content")) instanceof XMLObject) {
                    entry.setContentAsXhtml(content.toString());
                } else {
                    if (!(content instanceof String)) throw new ScriptException("Unsupported Content");
                    entry.setContent(content.toString());
                }
                Object contributorProperty = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"contributor");
                if (contributorProperty instanceof String) {
                    entry.addContributor(contributorProperty.toString());
                }
                if ((contributorsProperty = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"contributors")) instanceof NativeArray) {
                    NativeArray contributorsPropertyArray = (NativeArray)contributorsProperty;
                    for (Object o1 : contributorsPropertyArray.getIds()) {
                        int index = (Integer)o1;
                        String name = contributorsPropertyArray.get(index, null).toString();
                        entry.addContributor(name);
                    }
                }
                if ((idProperty = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"id")) instanceof String) {
                    entry.setId((String)idProperty);
                } else {
                    entry.setId(FOMHelper.generateUuid());
                }
                Object linkProperty = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"link");
                if (linkProperty instanceof String) {
                    entry.addLink((String)linkProperty);
                }
                if ((linksProperty = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"links")) instanceof NativeArray) {
                    NativeArray linksPropertyArray = (NativeArray)contributorsProperty;
                    for (Object o1 : linksPropertyArray.getIds()) {
                        int index = (Integer)o1;
                        String name = linksPropertyArray.get(index, null).toString();
                        entry.addLink(name);
                    }
                }
                if ((publishedProperty = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"published")) instanceof String) {
                    if (publishedProperty.equals("now")) {
                        entry.setPublished(new Date(System.currentTimeMillis()));
                    } else {
                        entry.setPublished(publishedProperty.toString());
                    }
                }
                if ((rights = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"rights")) instanceof XMLObject) {
                    entry.setRightsAsXhtml(rights.toString());
                } else if (rights instanceof String) {
                    entry.setRights(rights.toString());
                }
                Object summary = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"summary");
                if (summary instanceof XMLObject) {
                    entry.setSummaryAsXhtml(summary.toString());
                } else if (summary instanceof String) {
                    entry.setSummary(summary.toString());
                }
                Object title = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"title");
                if (title instanceof XMLObject) {
                    entry.setTitleAsXhtml(title.toString());
                } else {
                    if (!(title instanceof String)) throw new ScriptException("An Entry MUST have a title.");
                    entry.setTitle(title.toString());
                }
                Object updated = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"updated");
                if (!(updated instanceof String)) return;
                if (updated.equals("now")) {
                    entry.setUpdated(new Date(System.currentTimeMillis()));
                    return;
                }
                entry.setUpdated((String)updated);
                return;
            }
            catch (IRISyntaxException e) {
                throw new ScriptException((Exception)((Object)e));
            }
        } else {
            if (entryObject instanceof EntryHostObject) return;
            throw new ScriptException("Invalid parameter");
        }
    }

    public String jsFunction_toString() {
        String feedString = null;
        feedString = isRssFeed ? rssFeed.toString() : feed.toString();
        return feedString;
    }

    public Scriptable jsFunction_toXML() {
        Context cx = Context.getCurrentContext();
        if (feed != null) {
            Object[] objects = new Object[]{feed.toString()};
            Scriptable xmlHostObject = cx.newObject((Scriptable)this, "XML", objects);
            return xmlHostObject;
        }
        return null;
    }

    public static Scriptable jsFunction_writeTo(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        FeedHostObject feedObject = (FeedHostObject)thisObj;
        OutputStreamWriter outputStreamWriter = null;
        try {
            if (arguments[0] instanceof String) {
                FileHostObject fileHostObject = (FileHostObject)cx.newObject((Scriptable)feedObject, "File", arguments);
                outputStreamWriter = new OutputStreamWriter(fileHostObject.getOutputStream());
                feed.writeTo((Writer)outputStreamWriter);
                outputStreamWriter.flush();
            } else if (arguments[0] instanceof FileHostObject) {
                FileHostObject fileHostObject = (FileHostObject)arguments[0];
                outputStreamWriter = new OutputStreamWriter(fileHostObject.getOutputStream());
                feed.writeTo((Writer)outputStreamWriter);
                outputStreamWriter.flush();
            } else {
                throw new ScriptException("Invalid parameter");
            }
            FeedHostObject feedHostObject = feedObject;
            return feedHostObject;
        }
        catch (IOException e) {
            throw new ScriptException((Exception)e);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error closing the stream", (Throwable)e);
                }
            }
        }
    }

    static {
        log = LogFactory.getLog(FeedHostObject.class);
    }
}

