/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyImporter {
    private static Log log = LogFactory.getLog(KeyImporter.class);

    public static void main(String[] args) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Importing certificate ...");
        }
        if (args.length != 5) {
            throw new Exception("Incorrect number of parameters");
        }
        FileOutputStream fileOutputStream = null;
        try {
            String sourceStorePath = args[0];
            String sourceStorePass = args[1];
            String keyAlias = args[2];
            String targetStorePath = args[3];
            String targetStorePass = args[4];
            KeyStore sourceStore = KeyStore.getInstance("JKS");
            FileInputStream fis = new FileInputStream(new File(sourceStorePath).getAbsolutePath());
            sourceStore.load(fis, sourceStorePass.toCharArray());
            Certificate cert = sourceStore.getCertificateChain(keyAlias)[0];
            KeyStore targetStore = KeyStore.getInstance("JKS");
            File targetStoreFile = new File(targetStorePath);
            if (targetStoreFile.exists()) {
                targetStore.load(new FileInputStream(targetStoreFile.getAbsolutePath()), targetStorePass.toCharArray());
            } else {
                targetStore.load(null, null);
            }
            targetStore.setCertificateEntry(keyAlias, cert);
            fileOutputStream = new FileOutputStream(new File(targetStorePath).getAbsolutePath());
            targetStore.store(fileOutputStream, targetStorePass.toCharArray());
            fis.close();
            fileOutputStream.flush();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Importing certificate ... DONE !");
            }
        }
        catch (Exception e) {
            log.error((Object)"Importing of key failed");
            throw e;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }
}

