/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.server.util.FileUtils;
import org.wso2.carbon.server.util.JarInfo;
import org.wso2.carbon.server.util.PatchInfo;
import org.wso2.carbon.server.util.Utils;

public class PatchUtils {
    private static final Log patchLog = LogFactory.getLog(PatchUtils.class);
    private static final Log consoleLog = LogFactory.getLog((String)(PatchUtils.class.getName() + ".console"));
    private static File bundleBackupDir;
    private static Set<String> servicepackPatchedList;
    private static List<String> previousPatchDirNames;

    public static void applyServicepacksAndPatches(File servicepackDir, File patchesDir, File pluginsDir) throws IOException {
        bundleBackupDir = new File(patchesDir, "patch0000");
        boolean alreadyBackedUp = bundleBackupDir.exists();
        if (!alreadyBackedUp) {
            FileUtils.copyDirectory(pluginsDir, bundleBackupDir);
            patchLog.info((Object)"Backed up plugins to patch0000");
            consoleLog.info((Object)"Backed up plugins to patch0000");
        }
        patchLog.info((Object)"Applying patches ...");
        PatchUtils.copyServicepacksAndPatches(servicepackDir, patchesDir, pluginsDir, alreadyBackedUp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyServicepacksAndPatches(File servicepackDir, File source, File target, boolean alreadyBackedUp) throws IOException {
        Object[] files = source.listFiles(PatchUtils.getPatchFileNameFilter());
        Arrays.sort(files);
        File patchDirLogFile = new File(PatchUtils.getMetaDirectory(), "prePatchedDir.txt");
        BufferedWriter bufWriter = new BufferedWriter(new FileWriter(patchDirLogFile));
        if (alreadyBackedUp) {
            patchLog.info((Object)"restoring bundle backup directory");
            FileUtils.copyDirectory(bundleBackupDir, target);
        }
        PatchUtils.copyLatestServicepack(servicepackDir, target, bufWriter);
        try {
            for (Object file : files) {
                if (!((File)file).isDirectory() || servicepackPatchedList.contains(((File)file).getName())) continue;
                if (!((File)file).equals(bundleBackupDir)) {
                    File[] patchFiles = ((File)file).listFiles();
                    patchLog.info((Object)("Applying - " + ((File)file).getName()));
                    for (File patch : patchFiles) {
                        String patchFileName = PatchUtils.verifyBundleFileName(patch);
                        File copiedFile = new File(target, patchFileName);
                        FileUtils.copyFile(patch, copiedFile, true);
                        try {
                            patchLog.info((Object)("Patched " + patch.getName() + "(MD5:" + PatchUtils.getMD5ChecksumHexString(patch) + ")"));
                        }
                        catch (Exception e) {
                            patchLog.error((Object)("Error occurred while generating md5 checksum for " + patch.getName()));
                        }
                    }
                }
                try {
                    bufWriter.write(((File)file).getName());
                    bufWriter.newLine();
                }
                catch (IOException e) {
                    patchLog.error((Object)("Error occurred while writing " + ((File)file).getName() + " directory name to " + patchDirLogFile.getName()));
                }
            }
        }
        finally {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                patchLog.error((Object)"Error occurred while closing patch directory log file Buffered Writer");
            }
        }
    }

    public static void copyLatestServicepack(File source, File target, BufferedWriter bufWriter) {
        Object[] servicepackFiles = source.listFiles(PatchUtils.getPatchFileNameFilter());
        if (servicepackFiles != null && servicepackFiles.length > 0) {
            Arrays.sort(servicepackFiles);
            Object latestServicepack = servicepackFiles[servicepackFiles.length - 1];
            if (((File)latestServicepack).isDirectory()) {
                File servicepackLibs = FileUtils.getFile((File)latestServicepack, "lib");
                patchLog.info((Object)("Start applying - " + ((File)latestServicepack).getName()));
                File[] patchFiles = servicepackLibs.listFiles();
                if (patchFiles != null) {
                    for (File patch : patchFiles) {
                        try {
                            String patchFileName = PatchUtils.verifyBundleFileName(patch);
                            File copiedFile = new File(target, patchFileName);
                            FileUtils.copyFile(patch, copiedFile, true);
                            try {
                                patchLog.info((Object)("Patched " + patch.getName() + "(MD5:" + PatchUtils.getMD5ChecksumHexString(patch) + ")"));
                            }
                            catch (Exception e) {
                                patchLog.error((Object)("Error occurred while generating md5 checksum for " + patch.getName()));
                            }
                        }
                        catch (IOException e) {
                            patchLog.error((Object)("Error occurred while applying servicepack " + latestServicepack));
                        }
                    }
                }
                try {
                    bufWriter.write(((File)latestServicepack).getName());
                    bufWriter.newLine();
                }
                catch (IOException e) {
                    patchLog.error((Object)("Error occurred while writing " + ((File)latestServicepack).getName() + " to " + "prePatchedDir.txt"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyNewPatches(File servicepackDir, File patchesDir, String mostRecentPatch, File pluginsDir) throws IOException {
        Object[] files = patchesDir.listFiles(PatchUtils.getPatchFileNameFilter());
        Arrays.sort(files);
        File patchDirLogFile = new File(PatchUtils.getMetaDirectory(), "prePatchedDir.txt");
        BufferedWriter bufWriter = new BufferedWriter(new FileWriter(patchDirLogFile));
        List<String> patchApplyingOrder = PatchUtils.getPatchApplyingOrder(servicepackDir, patchesDir);
        for (String appliedPatch : patchApplyingOrder) {
            if (mostRecentPatch.equalsIgnoreCase(appliedPatch)) break;
            try {
                bufWriter.write(appliedPatch);
                bufWriter.newLine();
            }
            catch (IOException e) {
                patchLog.error((Object)("Error occurred while updating " + appliedPatch + " directory name to " + patchDirLogFile.getName()));
            }
        }
        try {
            for (Object file : files) {
                if (!((File)file).isDirectory() || ((File)file).getName().compareTo(mostRecentPatch) < 0) continue;
                File[] patchFiles = ((File)file).listFiles();
                patchLog.info((Object)("Applying - " + ((File)file).getName()));
                for (File patch : patchFiles) {
                    String patchFileName = PatchUtils.verifyBundleFileName(patch);
                    File copiedFile = new File(pluginsDir, patchFileName);
                    FileUtils.copyFile(patch, copiedFile, true);
                    try {
                        patchLog.info((Object)("Patched " + patch.getName() + "(MD5:" + PatchUtils.getMD5ChecksumHexString(patch) + ")"));
                    }
                    catch (Exception e) {
                        patchLog.error((Object)("Error occurred while generating md5 checksum for " + patch.getName()));
                    }
                }
                try {
                    bufWriter.write(((File)file).getName());
                    bufWriter.newLine();
                }
                catch (IOException e) {
                    patchLog.error((Object)("Error occurred while writing " + ((File)file).getName() + " directory name to " + patchDirLogFile.getName()));
                }
            }
        }
        finally {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                patchLog.error((Object)"Error occurred while closing patch directory log file Buffered Writer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PatchInfo processPatches(File patchDirLogFile, File servicepackDir, File patchesDir) throws IOException {
        patchLog.info((Object)"Checking for patch changes ...");
        BufferedReader bufReader = null;
        PatchInfo patchInfo = new PatchInfo();
        previousPatchDirNames = new ArrayList<String>();
        List<String> patchApplyingOrder = PatchUtils.getPatchApplyingOrder(servicepackDir, patchesDir);
        try {
            if (patchDirLogFile.exists()) {
                bufReader = new BufferedReader(new FileReader(patchDirLogFile));
                previousPatchDirNames = FileUtils.readLinesToList(bufReader);
                if (previousPatchDirNames != null) {
                    PatchUtils.checkForPatchChanges(patchApplyingOrder, previousPatchDirNames, patchInfo);
                }
            } else {
                if (patchApplyingOrder != null) {
                    for (String patchFile : patchApplyingOrder) {
                        if (patchFile.equals("patch0000")) continue;
                        patchInfo.addNewPatches(patchFile);
                        if (patchFile.startsWith("servicepack")) {
                            patchLog.info((Object)("New service pack available - " + patchFile));
                            continue;
                        }
                        patchLog.info((Object)("New patch available - " + patchFile));
                    }
                }
                if (!patchDirLogFile.createNewFile()) {
                    patchLog.error((Object)("Error occurred while creating patch directory log file " + patchDirLogFile.getAbsolutePath()));
                }
            }
            if (!patchInfo.isPatchesChanged()) {
                patchLog.info((Object)"No new patch or service pack detected, server will start without applying patches ");
            }
            PatchInfo patchInfo2 = patchInfo;
            return patchInfo2;
        }
        finally {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    patchLog.error((Object)"Error occurred while closing patch directory log file Buffered Reader");
                }
            }
        }
    }

    public static Map<String, JarInfo> getMostLatestJarsInServicepackAndPatches(File servicepackDir, File parentPatchDir) throws Exception {
        HashMap<String, JarInfo> latestPatchedJars = new HashMap<String, JarInfo>();
        Object[] servicepackList = servicepackDir.listFiles(PatchUtils.getPatchFileNameFilter());
        if (servicepackList != null && servicepackList.length > 0) {
            Arrays.sort(servicepackList);
            Object latestServicepack = servicepackList[servicepackList.length - 1];
            if (((File)latestServicepack).isDirectory()) {
                File libDir = FileUtils.getFile((File)latestServicepack, "lib");
                PatchUtils.collectLatestJars(libDir, latestPatchedJars);
            }
        }
        PatchUtils.getLatestJarsInPatches(parentPatchDir, servicepackPatchedList, latestPatchedJars);
        return latestPatchedJars;
    }

    private static void getLatestJarsInPatches(File parentPatchDir, Set<String> servicepackPatches, Map<String, JarInfo> latestPatchedJars) throws Exception {
        Object[] patchList = parentPatchDir.listFiles(PatchUtils.getPatchFileNameFilter());
        if (patchList != null) {
            Arrays.sort(patchList);
            for (Object file : patchList) {
                if (!((File)file).isDirectory() || servicepackPatches.contains(((File)file).getName()) || ((File)file).getName().equals("patch0000")) continue;
                PatchUtils.collectLatestJars((File)file, latestPatchedJars);
            }
        }
    }

    private static void collectLatestJars(File jarDirectory, Map<String, JarInfo> latestPatchedJars) throws Exception {
        File[] patchFiles = jarDirectory.listFiles();
        if (patchFiles != null) {
            for (File patch : patchFiles) {
                String verifiedName = PatchUtils.verifyBundleFileName(patch);
                latestPatchedJars.put(verifiedName, new JarInfo(verifiedName, patch.getAbsolutePath()));
            }
        }
    }

    public static Map<String, JarInfo> getJarsInAppliedServicepackAndPatches(File servicepackDir, File parentPatchDir) throws Exception {
        HashMap<String, JarInfo> currentlyPatchedJars = new HashMap<String, JarInfo>();
        if (previousPatchDirNames.size() > 0) {
            Object[] servicepackList;
            if (previousPatchDirNames.get(0).startsWith("s") && (servicepackList = servicepackDir.listFiles(PatchUtils.getPatchFileNameFilter())) != null && servicepackList.length > 0) {
                Arrays.sort(servicepackList);
                for (Object servicepack : servicepackList) {
                    if (!((File)servicepack).getName().equalsIgnoreCase(previousPatchDirNames.get(0))) continue;
                    if (!((File)servicepack).isDirectory()) break;
                    File libDir = FileUtils.getFile((File)servicepack, "lib");
                    PatchUtils.collectLatestJars(libDir, currentlyPatchedJars);
                    break;
                }
            }
            PatchUtils.getJarsInPreviouslyAppliedPatches(parentPatchDir, servicepackPatchedList, currentlyPatchedJars, previousPatchDirNames);
        }
        return currentlyPatchedJars;
    }

    private static void getJarsInPreviouslyAppliedPatches(File parentPatchDir, Set<String> servicepackPatches, Map<String, JarInfo> latestPatchedJars, List<String> previousPatchDirNames) throws Exception {
        Object[] patchList = parentPatchDir.listFiles(PatchUtils.getPatchFileNameFilter());
        if (patchList != null) {
            Arrays.sort(patchList);
            for (Object file : patchList) {
                if (!((File)file).isDirectory() || servicepackPatches.contains(((File)file).getName()) || !previousPatchDirNames.contains(((File)file).getName()) || ((File)file).getName().equals("patch0000")) continue;
                PatchUtils.collectLatestJars((File)file, latestPatchedJars);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkMD5Checksum(Map<String, JarInfo> latestPatchedJar, File plugins, boolean applyPatches) throws Exception {
        patchLog.info((Object)"Patch verification started");
        if (applyPatches) {
            consoleLog.info((Object)"Patch verification started");
        }
        ArrayList<String> warningList = new ArrayList<String>();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(PatchUtils.getMetaDirectory(), "prePatchedJARs.txt")));
        try {
            for (Map.Entry<String, JarInfo> entry : latestPatchedJar.entrySet()) {
                File file = FileUtils.getFile(plugins, entry.getKey());
                if (entry.getValue().getMd5SumValue() == null) {
                    entry.getValue().setMd5SumValue(PatchUtils.getMD5ChecksumHexString(entry.getValue().getPath()));
                }
                String md5OfPatchedJar = entry.getValue().getMd5SumValue();
                bufferedWriter.write(entry.getKey() + ":" + entry.getValue().getMd5SumValue());
                bufferedWriter.newLine();
                if (file == null) {
                    warningList.add(entry.getKey() + "(MD5: " + md5OfPatchedJar + ") has been patched with " + PatchUtils.getPatchedDirName(entry.getValue().getPath()) + ", but not applied");
                    continue;
                }
                String md5OfPluginJar = PatchUtils.getMD5ChecksumHexString(file);
                if (md5OfPluginJar.equals(md5OfPatchedJar)) continue;
                warningList.add(entry.getKey() + "(MD5: " + md5OfPatchedJar + ") has been patched with " + PatchUtils.getPatchedDirName(entry.getValue().getPath()) + ", but not applied");
            }
            if (warningList.size() > 0) {
                patchLog.warn((Object)"Problems found during patch verification. See below for details:");
                for (String warningMessage : warningList) {
                    patchLog.warn((Object)warningMessage);
                }
                patchLog.warn((Object)"Patch verification completed with warnings.");
                consoleLog.warn((Object)("Patch verification completed with warnings. Please see  " + PatchUtils.getPatchesLogsFile().getAbsolutePath() + " for more details"));
            } else {
                patchLog.info((Object)"Patch verification successfully completed without encountering any issues");
                if (applyPatches) {
                    consoleLog.info((Object)"Patch verification successfully completed without encountering any issues.");
                }
            }
        }
        finally {
            bufferedWriter.close();
        }
    }

    private static String getMD5ChecksumHexString(String filePath) throws Exception {
        return PatchUtils.getMD5ChecksumHexString(new File(filePath));
    }

    private static String getMD5ChecksumHexString(File file) throws Exception {
        byte[] _bytes = PatchUtils.createChecksum(file, "MD5");
        StringBuilder sb = new StringBuilder();
        for (byte _byte : _bytes) {
            sb.append(String.format("%02x", _byte & 0xFF));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] createChecksum(File file, String type) throws Exception {
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance(type);
        FileInputStream fis = new FileInputStream(file);
        try {
            int numRead;
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
        }
        finally {
            ((InputStream)fis).close();
        }
        return complete.digest();
    }

    private static String getPatchedDirName(String pathToPatchJar) {
        int endIndex = pathToPatchJar.lastIndexOf(File.separator);
        int beginIndex = pathToPatchJar.substring(0, endIndex).lastIndexOf(File.separator);
        return pathToPatchJar.substring(beginIndex + 1, endIndex);
    }

    private static void checkForPatchChanges(List<String> patchApplyOrder, List<String> prePatchedDirNames, PatchInfo patchInfo) throws IOException {
        boolean checkPrePatch;
        int prePatchedDirNamesCount = prePatchedDirNames.size();
        boolean bl = checkPrePatch = prePatchedDirNamesCount > 0;
        if (checkPrePatch && patchApplyOrder.size() > 0) {
            if (patchApplyOrder.get(0).startsWith("s") && prePatchedDirNames.get(0).startsWith("s")) {
                int spackDiff = patchApplyOrder.get(0).compareTo(prePatchedDirNames.get(0));
                if (spackDiff != 0) {
                    patchLog.info((Object)(prePatchedDirNames.get(0) + " has been reverted"));
                    patchInfo.addRemovedPatches(patchApplyOrder.get(0));
                    patchLog.info((Object)("New service pack available - " + patchApplyOrder.get(0)));
                    patchInfo.setServicepackUpdated(true);
                }
                prePatchedDirNames.remove(0);
                patchApplyOrder.remove(0);
            } else if (patchApplyOrder.get(0).startsWith("s")) {
                patchLog.info((Object)("New service pack available - " + patchApplyOrder.get(0)));
                patchInfo.setServicepackUpdated(true);
                patchApplyOrder.remove(0);
            } else if (prePatchedDirNames.get(0).startsWith("s")) {
                patchLog.info((Object)(prePatchedDirNames.get(0) + " has been reverted"));
                patchInfo.addRemovedPatches(patchApplyOrder.get(0));
                prePatchedDirNames.remove(0);
            }
        } else if (checkPrePatch) {
            if (prePatchedDirNames.get(0).startsWith("s")) {
                patchLog.info((Object)(prePatchedDirNames.get(0) + " has been reverted"));
                patchInfo.addRemovedPatches(patchApplyOrder.get(0));
                prePatchedDirNames.remove(0);
            }
        } else if (patchApplyOrder.size() > 0 && patchApplyOrder.get(0).startsWith("s")) {
            patchLog.info((Object)("New service pack available - " + patchApplyOrder.get(0)));
            patchInfo.setServicepackUpdated(true);
            patchApplyOrder.remove(0);
        }
        int i = 0;
        int j = 0;
        while (i < patchApplyOrder.size() && j < prePatchedDirNames.size()) {
            int diff = patchApplyOrder.get(i).compareTo(prePatchedDirNames.get(j));
            if (diff == 0) {
                ++i;
                ++j;
                continue;
            }
            if (diff > 0) {
                patchLog.info((Object)(prePatchedDirNames.get(j) + " has been reverted"));
                patchInfo.addRemovedPatches(prePatchedDirNames.get(j));
                ++j;
                continue;
            }
            patchLog.info((Object)("New patch available - " + patchApplyOrder.get(i)));
            patchInfo.addNewPatches(patchApplyOrder.get(i));
            ++i;
        }
        while (i < patchApplyOrder.size()) {
            patchLog.info((Object)("New patch available - " + patchApplyOrder.get(i)));
            patchInfo.addNewPatches(patchApplyOrder.get(i));
            ++i;
        }
        while (j < prePatchedDirNames.size()) {
            patchLog.info((Object)(prePatchedDirNames.get(j) + " has been reverted"));
            patchInfo.addRemovedPatches(prePatchedDirNames.get(j));
            ++j;
        }
    }

    private static List<String> getPatchApplyingOrder(File servicepackDir, File patchesDir) {
        servicepackPatchedList = new HashSet<String>();
        ArrayList<String> patchApplyingList = new ArrayList<String>();
        PatchUtils.getServiepackPatchOrder(servicepackDir, patchApplyingList);
        Object[] patches = patchesDir.listFiles(PatchUtils.getPatchFileNameFilter());
        if (patches != null) {
            Arrays.sort(patches);
            for (Object patch : patches) {
                if (!((File)patch).isDirectory() || servicepackPatchedList.contains(((File)patch).getName())) continue;
                patchApplyingList.add(((File)patch).getName());
            }
        }
        return patchApplyingList;
    }

    private static void getServiepackPatchOrder(File servicepackDir, List<String> patchApplyingList) {
        Object[] servicepacks = servicepackDir.listFiles(PatchUtils.getPatchFileNameFilter());
        if (servicepacks != null && servicepacks.length > 0) {
            Arrays.sort(servicepacks);
            Object latestServicepack = servicepacks[servicepacks.length - 1];
            if (((File)latestServicepack).isDirectory()) {
                patchApplyingList.add(((File)latestServicepack).getName());
                try {
                    File servicepackPatchesFile = FileUtils.getFile((File)latestServicepack, "servicepack_patches.txt");
                    BufferedReader bufReader = new BufferedReader(new FileReader(servicepackPatchesFile));
                    List<String> patchesInServicepack = FileUtils.readLinesToList(bufReader);
                    servicepackPatchedList.addAll(patchesInServicepack);
                }
                catch (IOException e) {
                    patchLog.error((Object)("Error occurred while reading " + latestServicepack + " patch file : " + "servicepack_patches.txt"), (Throwable)e);
                }
            }
        }
    }

    private static String verifyBundleFileName(File file) throws IOException {
        String newFileName = file.getName();
        if (file.getName().endsWith(".jar")) {
            JarFile jar = new JarFile(file);
            Attributes attributes = jar.getManifest().getMainAttributes();
            String name = attributes.getValue("Bundle-SymbolicName");
            String version = attributes.getValue("Bundle-Version");
            if (name != null && version != null) {
                int index = name.indexOf(";");
                if (index != -1) {
                    name = name.substring(0, index);
                }
                String bundleFileName = name + "_" + version + ".jar";
                if (!file.getName().equals(bundleFileName)) {
                    newFileName = bundleFileName;
                }
            }
        }
        return newFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkUpdatedJars(Map<String, JarInfo> latestPatchedJar) throws Exception {
        File jarsFile = new File(PatchUtils.getMetaDirectory(), "prePatchedJARs.txt");
        if (jarsFile.exists()) {
            Map<String, String> prePatchedJarsWithMD5;
            BufferedReader bufReader = new BufferedReader(new FileReader(jarsFile));
            try {
                prePatchedJarsWithMD5 = FileUtils.readJarsWithMD5(bufReader);
            }
            finally {
                bufReader.close();
            }
            for (Map.Entry<String, JarInfo> jarInfoEntry : latestPatchedJar.entrySet()) {
                if (prePatchedJarsWithMD5.containsKey(jarInfoEntry.getKey())) {
                    String md5ofJar = PatchUtils.getMD5ChecksumHexString(jarInfoEntry.getValue().getPath());
                    jarInfoEntry.getValue().setMd5SumValue(md5ofJar);
                    if (md5ofJar.equals(prePatchedJarsWithMD5.get(jarInfoEntry.getKey()))) continue;
                    patchLog.info((Object)(jarInfoEntry.getKey() + " has been updated"));
                    return true;
                }
                patchLog.info((Object)(jarInfoEntry.getKey() + " has been added"));
                return true;
            }
        }
        return false;
    }

    public static File getPatchesLogsFile() {
        return new File(Utils.getCarbonRepoPath() + File.separator + "logs" + File.separator + "patches.log");
    }

    public static File getMetaDirectory() {
        File metaDir = new File(Utils.getCarbonRepoPath() + File.separator + "components" + File.separator + "patches" + File.separator + ".metadata");
        if (!metaDir.exists() && !metaDir.mkdirs()) {
            patchLog.warn((Object)("Error while creating meta data directory in " + metaDir.getAbsolutePath()));
        }
        return metaDir;
    }

    public static FilenameFilter getPatchFileNameFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("patch") || name.startsWith("servicepack");
            }
        };
    }
}

