/*
 * Decompiled with CFR 0.152.
 */
package org.h2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.upgrade.DbUpgrade;
import org.h2.util.StringUtils;

public class Driver
implements java.sql.Driver {
    private static final Driver INSTANCE = new Driver();
    private static volatile boolean registered;

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        try {
            if (properties == null) {
                properties = new Properties();
            }
            if (!this.acceptsURL(string)) {
                return null;
            }
            boolean bl = StringUtils.toUpperEnglish(string).indexOf(";NO_UPGRADE=TRUE") >= 0;
            string = StringUtils.replaceAllIgnoreCase(string, ";NO_UPGRADE=TRUE", "");
            if (DbUpgrade.areV1dot1ClassesPresent()) {
                if (bl) {
                    Connection connection = DbUpgrade.connectWithOldVersion(string, properties);
                    if (connection != null) {
                        return connection;
                    }
                } else {
                    DbUpgrade.upgrade(string, properties);
                }
            }
            return new JdbcConnection(string, properties);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    @Override
    public boolean acceptsURL(String string) {
        return string != null && string.startsWith("jdbc:h2:");
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    public static synchronized Driver load() {
        try {
            if (!registered) {
                registered = true;
                DriverManager.registerDriver(INSTANCE);
            }
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
        return INSTANCE;
    }

    public static synchronized void unload() {
        try {
            if (registered) {
                registered = false;
                DriverManager.deregisterDriver(INSTANCE);
            }
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
    }

    static {
        Driver.load();
    }
}

