/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.function.DocValues;

class QueryDocValues
extends DocValues {
    final Query q;
    final IndexReader reader;
    final Weight weight;
    final float defVal;
    Scorer scorer;
    int scorerDoc;
    int lastDocRequested = Integer.MAX_VALUE;

    public QueryDocValues(IndexReader reader, Query q, float defVal, Weight w) throws IOException {
        this.reader = reader;
        this.q = q;
        this.defVal = defVal;
        this.weight = w != null ? w : q.weight(new IndexSearcher(reader));
    }

    public float floatVal(int doc) {
        try {
            if (doc < this.lastDocRequested) {
                this.scorer = this.weight.scorer(this.reader, true, false);
                if (this.scorer == null) {
                    return this.defVal;
                }
                this.scorerDoc = -1;
            }
            this.lastDocRequested = doc;
            if (this.scorerDoc < doc) {
                this.scorerDoc = this.scorer.advance(doc);
            }
            if (this.scorerDoc > doc) {
                return this.defVal;
            }
            return this.scorer.score();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "caught exception in QueryDocVals(" + this.q + ") doc=" + doc, (Throwable)e);
        }
    }

    public int intVal(int doc) {
        return (int)this.floatVal(doc);
    }

    public long longVal(int doc) {
        return (long)this.floatVal(doc);
    }

    public double doubleVal(int doc) {
        return this.floatVal(doc);
    }

    public String strVal(int doc) {
        return Float.toString(this.floatVal(doc));
    }

    public String toString(int doc) {
        return "query(" + this.q + ",def=" + this.defVal + ")=" + this.floatVal(doc);
    }
}

