/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.manager;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.core.ScriptReader;
import org.jaggeryjs.jaggery.core.manager.CommonManager;
import org.jaggeryjs.jaggery.core.manager.JaggerySecurityDomain;
import org.jaggeryjs.jaggery.core.plugins.WebAppFileManager;
import org.jaggeryjs.scriptengine.cache.ScriptCachingContext;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.engine.JavaScriptProperty;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.engine.RhinoTopLevel;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.security.RhinoSecurityController;
import org.jaggeryjs.scriptengine.security.RhinoSecurityDomain;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class WebAppManager {
    private static final Log log = LogFactory.getLog(WebAppManager.class);
    public static final String CORE_MODULE_NAME = "core";
    public static final String SERVLET_RESPONSE = "webappmanager.servlet.response";
    public static final String SERVLET_REQUEST = "webappmanager.servlet.request";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_CHAR_ENCODING = "UTF-8";
    public static final String JAGGERY_MODULES_DIR = "modules";
    public static final String WS_REQUEST_PATH = "requestURI";
    public static final String WS_SERVLET_CONTEXT = "/websocket";
    private static final String SHARED_JAGGERY_CONTEXT = "shared.jaggery.context";
    private static final Map<String, List<String>> timeouts = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> intervals = new HashMap<String, List<String>>();
    private static boolean isWebSocket = false;

    public static RhinoEngine getEngine() throws ScriptException {
        return CommonManager.getInstance().getEngine();
    }

    public static void include(org.mozilla.javascript.Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "include";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)"RhinoTopLevel", (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)"RhinoTopLevel", (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        Stack<String> includesCallstack = CommonManager.getCallstack(jaggeryContext);
        String parent = (String)includesCallstack.lastElement();
        String fileURL = (String)args[0];
        if (CommonManager.isHTTP(fileURL) || CommonManager.isHTTP(parent)) {
            CommonManager.include(cx, thisObj, args, funObj);
            return;
        }
        WebAppManager.executeScript(jaggeryContext, jaggeryContext.getScope(), fileURL, false, false, false);
    }

    public static void include_once(org.mozilla.javascript.Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "include_once";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)"RhinoTopLevel", (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)"RhinoTopLevel", (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        Stack<String> includesCallstack = CommonManager.getCallstack(jaggeryContext);
        String parent = (String)includesCallstack.lastElement();
        String fileURL = (String)args[0];
        if (CommonManager.isHTTP(fileURL) || CommonManager.isHTTP(parent)) {
            CommonManager.include_once(cx, thisObj, args, funObj);
            return;
        }
        WebAppManager.executeScript(jaggeryContext, jaggeryContext.getScope(), fileURL, false, false, true);
    }

    public static void print(org.mozilla.javascript.Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        if (!isWebSocket) {
            JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
            HttpServletResponse servletResponse = (HttpServletResponse)jaggeryContext.getProperty(SERVLET_RESPONSE);
            if (servletResponse.getContentType() == null) {
                servletResponse.setContentType(DEFAULT_CONTENT_TYPE);
            }
            if (servletResponse.getCharacterEncoding() == null) {
                servletResponse.setCharacterEncoding(DEFAULT_CHAR_ENCODING);
            }
            CommonManager.print(cx, thisObj, args, funObj);
        }
    }

    public static String setTimeout(org.mozilla.javascript.Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        JaggeryContext context = CommonManager.getJaggeryContext();
        ServletContext servletContext = (ServletContext)context.getProperty("jaggery.servlet.context");
        String contextPath = servletContext.getContextPath();
        String taskId = RhinoTopLevel.setTimeout((org.mozilla.javascript.Context)cx, (Scriptable)thisObj, (Object[])args, (Function)funObj);
        List<String> taskIds = timeouts.get(contextPath);
        if (taskIds == null) {
            taskIds = new ArrayList<String>();
            timeouts.put(contextPath, taskIds);
        }
        taskIds.add(taskId);
        return taskId;
    }

    public static String setInterval(org.mozilla.javascript.Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        JaggeryContext context = CommonManager.getJaggeryContext();
        ServletContext servletContext = (ServletContext)context.getProperty("jaggery.servlet.context");
        String contextPath = servletContext.getContextPath();
        String taskId = RhinoTopLevel.setInterval((org.mozilla.javascript.Context)cx, (Scriptable)thisObj, (Object[])args, (Function)funObj);
        List<String> taskIds = intervals.get(contextPath);
        if (taskIds == null) {
            taskIds = new ArrayList<String>();
            intervals.put(contextPath, taskIds);
        }
        taskIds.add(taskId);
        return taskId;
    }

    public static void clearTimeout(org.mozilla.javascript.Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        JaggeryContext context = CommonManager.getJaggeryContext();
        ServletContext servletContext = (ServletContext)context.getProperty("jaggery.servlet.context");
        String contextPath = servletContext.getContextPath();
        RhinoTopLevel.clearTimeout((org.mozilla.javascript.Context)cx, (Scriptable)thisObj, (Object[])args, (Function)funObj);
        List<String> taskIds = timeouts.get(contextPath);
        taskIds.remove(String.valueOf(args[0]));
    }

    public static void clearInterval(org.mozilla.javascript.Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        JaggeryContext context = CommonManager.getJaggeryContext();
        ServletContext servletContext = (ServletContext)context.getProperty("jaggery.servlet.context");
        String contextPath = servletContext.getContextPath();
        RhinoTopLevel.clearTimeout((org.mozilla.javascript.Context)cx, (Scriptable)thisObj, (Object[])args, (Function)funObj);
        List<String> taskIds = intervals.get(contextPath);
        taskIds.remove(String.valueOf(args[0]));
    }

    private static ScriptableObject executeScript(JaggeryContext jaggeryContext, ScriptableObject scope, String fileURL, final boolean isJSON, boolean isBuilt, boolean isIncludeOnce) throws ScriptException {
        Stack<String> includesCallstack = CommonManager.getCallstack(jaggeryContext);
        Map<String, Boolean> includedScripts = CommonManager.getIncludes(jaggeryContext);
        ServletContext context = (ServletContext)jaggeryContext.getProperty("jaggery.servlet.context");
        String parent = (String)includesCallstack.lastElement();
        String[] keys = WebAppManager.getKeys(context.getContextPath(), parent, fileURL);
        fileURL = WebAppManager.getNormalizedScriptPath(keys);
        if (includesCallstack.search(fileURL) != -1) {
            return scope;
        }
        if (isIncludeOnce && includedScripts.get(fileURL) != null) {
            return scope;
        }
        RhinoEngine engine = jaggeryContext.getEngine();
        ScriptReader source = isBuilt ? new ScriptReader(context.getResourceAsStream(fileURL)){

            @Override
            protected void build() throws IOException {
                try {
                    this.sourceReader = isJSON ? new StringReader("(" + HostObjectUtil.streamToString((InputStream)this.sourceIn) + ")") : new StringReader(HostObjectUtil.streamToString((InputStream)this.sourceIn));
                }
                catch (ScriptException e) {
                    throw new IOException(e);
                }
            }
        } : new ScriptReader(context.getResourceAsStream(fileURL));
        ScriptCachingContext sctx = new ScriptCachingContext(jaggeryContext.getTenantId(), keys[0], keys[1], keys[2]);
        sctx.setSecurityDomain((RhinoSecurityDomain)new JaggerySecurityDomain(fileURL, context));
        long lastModified = WebAppManager.getScriptLastModified(context, fileURL);
        sctx.setSourceModifiedTime(lastModified);
        includedScripts.put(fileURL, true);
        includesCallstack.push(fileURL);
        if (isJSON) {
            scope = (ScriptableObject)engine.eval((Reader)source, scope, sctx);
        } else {
            engine.exec((Reader)source, scope, sctx);
        }
        includesCallstack.pop();
        return scope;
    }

    private static String getNormalizedScriptPath(String[] keys) {
        return "/".equals(keys[1]) ? keys[2] : keys[1] + keys[2];
    }

    public static ScriptableObject require(org.mozilla.javascript.Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, IOException {
        String functionName = "require";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)"RhinoTopLevel", (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)"RhinoTopLevel", (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        String moduleId = (String)args[0];
        int dotIndex = moduleId.lastIndexOf(".");
        if (moduleId.length() == dotIndex + 1) {
            String msg = "Invalid file path for require method : " + moduleId;
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        Map requiredModules = (Map)jaggeryContext.getProperty("jaggery.required.modules");
        ScriptableObject object = (ScriptableObject)requiredModules.get(moduleId);
        if (object != null) {
            return object;
        }
        if (dotIndex == -1) {
            object = CommonManager.require(cx, thisObj, args, funObj);
            WebAppManager.initModule(cx, jaggeryContext, moduleId, object);
        } else {
            object = (ScriptableObject)cx.newObject(thisObj);
            object.setPrototype(thisObj);
            object.setParentScope(thisObj);
            String ext = moduleId.substring(dotIndex + 1);
            if (ext.equalsIgnoreCase("json")) {
                object = WebAppManager.executeScript(jaggeryContext, object, moduleId, true, true, false);
            } else if (ext.equalsIgnoreCase("js")) {
                object = WebAppManager.executeScript(jaggeryContext, object, moduleId, false, true, false);
            } else if (ext.equalsIgnoreCase("jag")) {
                object = WebAppManager.executeScript(jaggeryContext, object, moduleId, false, false, false);
            } else {
                String msg = "Unsupported file type for require() method : ." + ext;
                log.error((Object)msg);
                throw new ScriptException(msg);
            }
        }
        requiredModules.put(moduleId, object);
        return object;
    }

    public static void initModule(org.mozilla.javascript.Context cx, JaggeryContext context, String module, ScriptableObject object) {
        if (CORE_MODULE_NAME.equals(module)) {
            WebAppManager.defineProperties(cx, context, object);
        }
    }

    public static JaggeryContext sharedJaggeryContext(ServletContext ctx) {
        return (JaggeryContext)ctx.getAttribute(SHARED_JAGGERY_CONTEXT);
    }

    public static JaggeryContext clonedJaggeryContext(ServletContext context) {
        JaggeryContext shared = WebAppManager.sharedJaggeryContext(context);
        RhinoEngine engine = shared.getEngine();
        ScriptableObject sharedScope = shared.getScope();
        org.mozilla.javascript.Context cx = org.mozilla.javascript.Context.getCurrentContext();
        ScriptableObject instanceScope = (ScriptableObject)cx.newObject((Scriptable)sharedScope);
        instanceScope.setPrototype((Scriptable)sharedScope);
        instanceScope.setParentScope(null);
        JaggeryContext clone = new JaggeryContext();
        clone.setEngine(engine);
        clone.setTenantId(shared.getTenantId());
        clone.setScope(instanceScope);
        clone.addProperty("jaggery.servlet.context", shared.getProperty("jaggery.servlet.context"));
        clone.addProperty("hostobject.log.loglevel", shared.getProperty("hostobject.log.loglevel"));
        clone.addProperty("hostobjects.file.filemanager", shared.getProperty("hostobjects.file.filemanager"));
        clone.addProperty("jaggery.core.manager", shared.getProperty("jaggery.core.manager"));
        clone.addProperty("jaggery.included.scripts", new HashMap());
        clone.addProperty("jaggery.includes.callstack", new Stack());
        clone.addProperty("jaggery.required.modules", new HashMap());
        return clone;
    }

    public static void deploy(Context context) throws ScriptException {
        ServletContext ctx = context.getServletContext();
        JaggeryContext sharedContext = new JaggeryContext();
        org.mozilla.javascript.Context cx = org.mozilla.javascript.Context.getCurrentContext();
        CommonManager.initContext(sharedContext);
        sharedContext.addProperty("jaggery.servlet.context", (Object)ctx);
        sharedContext.addProperty("hostobjects.file.filemanager", (Object)new WebAppFileManager(ctx));
        sharedContext.addProperty("jaggery.required.modules", new HashMap());
        String logLevel = (String)ctx.getAttribute("hostobject.log.loglevel");
        if (logLevel != null) {
            sharedContext.addProperty("hostobject.log.loglevel", (Object)logLevel);
        }
        ScriptableObject sharedScope = sharedContext.getScope();
        JavaScriptProperty application = new JavaScriptProperty("application");
        application.setValue((Object)cx.newObject((Scriptable)sharedScope, "Application", new Object[]{ctx}));
        application.setAttribute(1);
        RhinoEngine.defineProperty((ScriptableObject)sharedScope, (JavaScriptProperty)application);
        ctx.setAttribute(SHARED_JAGGERY_CONTEXT, (Object)sharedContext);
    }

    public static void undeploy(Context context) {
        String contextPath = context.getServletContext().getContextPath();
        List<String> taskIds = timeouts.get(contextPath);
        if (taskIds != null) {
            for (String taskId : taskIds) {
                try {
                    log.debug((Object)("clearTimeout : " + taskId));
                    RhinoTopLevel.clearTimeout((String)taskId);
                }
                catch (ScriptException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if ((taskIds = intervals.get(contextPath)) != null) {
            for (String taskId : taskIds) {
                try {
                    log.debug((Object)("clearInterval : " + taskId));
                    RhinoTopLevel.clearInterval((String)taskId);
                }
                catch (ScriptException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        log.debug((Object)("Releasing resources of : " + context.getServletContext().getContextPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String scriptPath = WebAppManager.getScriptPath(request);
        InputStream sourceIn = request.getServletContext().getResourceAsStream(scriptPath);
        if (sourceIn == null) {
            response.sendError(404, request.getRequestURI());
            return;
        }
        RhinoEngine engine = null;
        try {
            engine = CommonManager.getInstance().getEngine();
            org.mozilla.javascript.Context cx = engine.enterContext();
            ServletOutputStream out = response.getOutputStream();
            JaggeryContext context = WebAppManager.createJaggeryContext(cx, (OutputStream)out, scriptPath, request, response);
            context.addProperty("hostobjects.file.filemanager", (Object)new WebAppFileManager(request.getServletContext()));
            CommonManager.getInstance().getEngine().exec((Reader)new ScriptReader(sourceIn), context.getScope(), WebAppManager.getScriptCachingContext(request, scriptPath));
        }
        catch (ScriptException e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            response.sendError(500, msg);
        }
        finally {
            if (engine != null) {
                RhinoEngine.exitContext();
            }
        }
    }

    public static String getScriptPath(HttpServletRequest request) {
        String url = request.getServletPath();
        Map urlMappings = (Map)request.getServletContext().getAttribute("jaggery.urls.map");
        if (urlMappings == null) {
            return url;
        }
        String path = url.equals("/") ? WebAppManager.getPath(urlMappings, url) : WebAppManager.resolveScriptPath(new ArrayList<String>(Arrays.asList(url.substring(1).split("/", -1))), urlMappings);
        return path == null ? url : path;
    }

    private static String resolveScriptPath(List<String> parts, Map<String, Object> map) {
        String part = parts.remove(0);
        if (parts.isEmpty()) {
            return WebAppManager.getPath(map, part);
        }
        Object obj = map.get(part);
        if (obj == null) {
            return WebAppManager.getPath(map, "/");
        }
        if (obj instanceof Map) {
            return WebAppManager.resolveScriptPath(parts, (Map)obj);
        }
        return null;
    }

    private static String getPath(Map<String, Object> map, String part) {
        Object obj;
        Object object = obj = "/".equals(part) ? null : map.get(part);
        if (obj == null) {
            obj = map.get("/");
            if (obj != null) {
                return (String)obj;
            }
            obj = map.get("*");
            String path = (String)obj;
            if (path != null && path.endsWith("*")) {
                return path.substring(0, path.length() - 1) + part;
            }
            return path;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        map = (Map)obj;
        if ((obj = map.get("/")) != null) {
            return (String)obj;
        }
        obj = map.get("*");
        return (String)obj;
    }

    private static void defineProperties(org.mozilla.javascript.Context cx, JaggeryContext context, ScriptableObject scope) {
        JavaScriptProperty request = new JavaScriptProperty("request");
        HttpServletRequest servletRequest = (HttpServletRequest)context.getProperty(SERVLET_REQUEST);
        request.setValue((Object)cx.newObject((Scriptable)scope, "Request", new Object[]{servletRequest}));
        request.setAttribute(1);
        RhinoEngine.defineProperty((ScriptableObject)scope, (JavaScriptProperty)request);
        JavaScriptProperty response = new JavaScriptProperty("response");
        HttpServletResponse servletResponse = (HttpServletResponse)context.getProperty(SERVLET_RESPONSE);
        response.setValue((Object)cx.newObject((Scriptable)scope, "Response", new Object[]{servletResponse}));
        response.setAttribute(1);
        RhinoEngine.defineProperty((ScriptableObject)scope, (JavaScriptProperty)response);
        JavaScriptProperty session = new JavaScriptProperty("session");
        session.setValue((Object)cx.newObject((Scriptable)scope, "Session", new Object[]{servletRequest.getSession()}));
        session.setAttribute(1);
        RhinoEngine.defineProperty((ScriptableObject)scope, (JavaScriptProperty)session);
        JavaScriptProperty application = new JavaScriptProperty("application");
        ServletContext servletConext = (ServletContext)context.getProperty("jaggery.servlet.context");
        application.setValue((Object)cx.newObject((Scriptable)scope, "Application", new Object[]{servletConext}));
        application.setAttribute(1);
        RhinoEngine.defineProperty((ScriptableObject)scope, (JavaScriptProperty)application);
        if (WebAppManager.isWebSocket((ServletRequest)servletRequest)) {
            JavaScriptProperty websocket = new JavaScriptProperty("webSocket");
            websocket.setValue((Object)cx.newObject((Scriptable)scope, "WebSocket", new Object[0]));
            websocket.setAttribute(1);
            RhinoEngine.defineProperty((ScriptableObject)scope, (JavaScriptProperty)websocket);
        }
    }

    private static JaggeryContext createJaggeryContext(org.mozilla.javascript.Context cx, OutputStream out, String scriptPath, HttpServletRequest request, HttpServletResponse response) {
        ServletContext servletContext = request.getServletContext();
        JaggeryContext context = WebAppManager.clonedJaggeryContext(servletContext);
        CommonManager.setJaggeryContext(context);
        context.addProperty(SERVLET_REQUEST, (Object)request);
        context.addProperty(SERVLET_RESPONSE, (Object)response);
        CommonManager.getCallstack(context).push(scriptPath);
        CommonManager.getIncludes(context).put(scriptPath, true);
        context.addProperty("jaggery.output.stream", (Object)out);
        WebAppManager.defineProperties(cx, context, context.getScope());
        return context;
    }

    protected static ScriptCachingContext getScriptCachingContext(HttpServletRequest request, String scriptPath) throws ScriptException {
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        String tenantId = jaggeryContext.getTenantId();
        String[] parts = WebAppManager.getKeys(request.getContextPath(), scriptPath, scriptPath);
        ScriptCachingContext sctx = new ScriptCachingContext(tenantId, parts[0], parts[1], parts[2]);
        ServletContext servletContext = request.getServletContext();
        sctx.setSecurityDomain((RhinoSecurityDomain)new JaggerySecurityDomain(WebAppManager.getNormalizedScriptPath(parts), servletContext));
        long lastModified = WebAppManager.getScriptLastModified(servletContext, scriptPath);
        sctx.setSourceModifiedTime(lastModified);
        return sctx;
    }

    public static String[] getKeys(String context, String parent, String scriptPath) {
        context = context.equals("") ? "/" : context;
        String normalizedScriptPath = scriptPath.startsWith("/") ? FilenameUtils.normalize((String)scriptPath, (boolean)true) : FilenameUtils.normalize((String)(FilenameUtils.getFullPath((String)parent) + scriptPath), (boolean)true);
        String path = FilenameUtils.getFullPath((String)normalizedScriptPath);
        path = path.equals("/") ? path : path.substring(0, path.length() - 1);
        normalizedScriptPath = "/" + FilenameUtils.getName((String)normalizedScriptPath);
        return new String[]{context, path, normalizedScriptPath};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getScriptLastModified(ServletContext context, String scriptPath) throws ScriptException {
        long result = -1L;
        URLConnection uc = null;
        try {
            URL scriptUrl = context.getResource(WebAppManager.canonicalURI(scriptPath));
            if (scriptUrl == null) {
                String msg = "Requested resource " + scriptPath + " cannot be found";
                log.error((Object)msg);
                throw new ScriptException(msg);
            }
            uc = scriptUrl.openConnection();
            result = uc instanceof JarURLConnection ? ((JarURLConnection)uc).getJarEntry().getTime() : uc.getLastModified();
        }
        catch (IOException e) {
            log.warn((Object)("Error getting last modified time for " + scriptPath), (Throwable)e);
            result = -1L;
        }
        finally {
            if (uc != null) {
                try {
                    uc.getInputStream().close();
                }
                catch (IOException e) {
                    log.error((Object)("Error closing input stream for script " + scriptPath), (Throwable)e);
                }
            }
        }
        return result;
    }

    private static String canonicalURI(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int len = s.length();
        int pos = 0;
        block4: while (pos < len) {
            char c = s.charAt(pos);
            if (WebAppManager.isPathSeparator(c)) {
                while (pos + 1 < len && WebAppManager.isPathSeparator(s.charAt(pos + 1))) {
                    ++pos;
                }
                if (pos + 1 < len && s.charAt(pos + 1) == '.') {
                    if (pos + 2 >= len) break;
                    switch (s.charAt(pos + 2)) {
                        case '/': 
                        case '\\': {
                            pos += 2;
                            continue block4;
                        }
                        case '.': {
                            int separatorPos;
                            if (pos + 3 >= len || !WebAppManager.isPathSeparator(s.charAt(pos + 3))) break;
                            pos += 3;
                            for (separatorPos = result.length() - 1; separatorPos >= 0 && !WebAppManager.isPathSeparator(result.charAt(separatorPos)); --separatorPos) {
                            }
                            if (separatorPos < 0) continue block4;
                            result.setLength(separatorPos);
                            continue block4;
                        }
                    }
                }
            }
            result.append(c);
            ++pos;
        }
        return result.toString();
    }

    private static boolean isPathSeparator(char c) {
        return c == '/' || c == '\\';
    }

    public static boolean isWebSocket(ServletRequest request) {
        isWebSocket = "websocket".equals(((HttpServletRequest)request).getHeader("Upgrade"));
        return "websocket".equals(((HttpServletRequest)request).getHeader("Upgrade"));
    }

    static {
        try {
            String jaggeryDir = System.getProperty("jaggery.home");
            if (jaggeryDir == null) {
                jaggeryDir = System.getProperty("carbon.home");
            }
            if (jaggeryDir == null) {
                log.error((Object)"Unable to find jaggery.home or carbon.home system properties");
            }
            String modulesDir = jaggeryDir + File.separator + JAGGERY_MODULES_DIR;
            CommonManager.getInstance().initialize(modulesDir, new RhinoSecurityController(){

                protected void updatePermissions(PermissionCollection permissions, RhinoSecurityDomain securityDomain) {
                    JaggerySecurityDomain domain = (JaggerySecurityDomain)securityDomain;
                    ServletContext context = domain.getServletContext();
                    String docBase = context.getRealPath("/");
                    if (!docBase.endsWith(File.separator)) {
                        permissions.add(new FilePermission(docBase, "read"));
                        docBase = docBase + File.separator;
                    } else {
                        permissions.add(new FilePermission(docBase.substring(0, docBase.length() - 1), "read"));
                    }
                    docBase = docBase + "-";
                    permissions.add(new FilePermission(docBase, "read"));
                }
            });
        }
        catch (ScriptException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

