/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.oauth;

import com.google.gson.Gson;
import java.util.Arrays;
import org.jaggeryjs.hostobjects.oauth.GenericOAuth10aApi;
import org.jaggeryjs.hostobjects.oauth.GenericOAuth20Api;
import org.jaggeryjs.hostobjects.oauth.ProviderConfig;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class OAuthHostObject
extends ScriptableObject {
    private static final String hostObjectName = "OAuthProvider";
    private static final Token EMPTY_TOKEN = null;
    private String apiKey;
    private String apiSecret;
    private String protectedResource;
    private OAuthService oauthService;
    private Token requestToken;
    private Token accessToken;
    private OAuthRequest oauthRequest;
    private Verifier verifier;
    private Response response;
    private OAuthVersion oAuthVersion;

    public String getClassName() {
        return hostObjectName;
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        OAuthHostObject oauthho = new OAuthHostObject();
        if (args.length == 1) {
            if (args[0] != Context.getUndefinedValue() && args[0] instanceof NativeObject) {
                Gson gson = new Gson();
                NativeObject config = (NativeObject)args[0];
                ProviderConfig providerConfig = (ProviderConfig)gson.fromJson(HostObjectUtil.serializeJSON((Object)config), ProviderConfig.class);
                if (providerConfig.getApi_key() == null || providerConfig.getApi_secret() == null || providerConfig.getAccess_token_url() == null || providerConfig.getAuthorization_url() == null || providerConfig.getOAuth_version() == null) {
                    throw new ScriptException("API configuration not specified");
                }
                oauthho.apiKey = providerConfig.getApi_key();
                oauthho.apiSecret = providerConfig.getApi_secret();
                if ((double)providerConfig.getOAuth_version().floatValue() == 1.0) {
                    if (providerConfig.getRequest_token_url() == null) {
                        throw new ScriptException("API configuration not specified");
                    }
                    oauthho.oAuthVersion = OAuthVersion.OAUTH1;
                    GenericOAuth10aApi oauth10aApi = new GenericOAuth10aApi();
                    oauth10aApi.setAccessTokenEndpoint(providerConfig.getAccess_token_url());
                    oauth10aApi.setAuthorizationUrl(providerConfig.getAuthorization_url());
                    oauth10aApi.setRequestTokenEndpoint(providerConfig.getRequest_token_url());
                    oauthho.oauthService = new ServiceBuilder().provider((Api)oauth10aApi).apiKey(oauthho.apiKey).apiSecret(oauthho.apiSecret).build();
                } else if ((double)providerConfig.getOAuth_version().floatValue() == 2.0) {
                    if (providerConfig.getCallback_url() == null) {
                        throw new ScriptException("API configuration not specified");
                    }
                    oauthho.oAuthVersion = OAuthVersion.OAUTH2;
                    GenericOAuth20Api oauth20Api = new GenericOAuth20Api();
                    oauth20Api.setAccessTokenEP(providerConfig.getAccess_token_url());
                    oauth20Api.setAuthorizeUrl(providerConfig.getAuthorization_url());
                    oauthho.oauthService = new ServiceBuilder().provider((Api)oauth20Api).apiKey(oauthho.apiKey).apiSecret(oauthho.apiSecret).build();
                }
            }
            return oauthho;
        }
        throw new ScriptException("API configuration not specified");
    }

    public static String jsFunction_getAuthorizationUrl(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        OAuthHostObject oauthho = (OAuthHostObject)thisObj;
        if (oauthho.oAuthVersion == OAuthVersion.OAUTH1) {
            oauthho.requestToken = oauthho.oauthService.getRequestToken();
            return oauthho.oauthService.getAuthorizationUrl(oauthho.requestToken);
        }
        if (oauthho.oAuthVersion == OAuthVersion.OAUTH2) {
            return oauthho.oauthService.getAuthorizationUrl(EMPTY_TOKEN);
        }
        return null;
    }

    public static Response jsFunction_sendOAuthRequest(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        OAuthHostObject oauthho = (OAuthHostObject)thisObj;
        Verb verb = Verb.GET;
        if (args.length >= 3) {
            if (args[0] == Context.getUndefinedValue() || !(args[0] instanceof NativeJavaObject)) {
                throw new ScriptException("Invalid Access Token");
            }
            oauthho.accessToken = (Token)Context.jsToJava((Object)args[0], Token.class);
            if (args[1] != Context.getUndefinedValue() && args[1] instanceof String) {
                String inputVerb = (String)args[1];
                if ("GET".equals(inputVerb.toUpperCase())) {
                    verb = Verb.GET;
                } else if ("PUT".equals(inputVerb.toUpperCase())) {
                    verb = Verb.PUT;
                } else if ("POST".equals(inputVerb.toUpperCase())) {
                    verb = Verb.POST;
                } else if ("DELETE".equals(inputVerb.toUpperCase())) {
                    verb = Verb.DELETE;
                }
            } else {
                throw new ScriptException("Invalid Verb");
            }
            if (args[2] == Context.getUndefinedValue() || !(args[2] instanceof String)) {
                throw new ScriptException("Invalid URL");
            }
            oauthho.protectedResource = (String)args[2];
            oauthho.oauthRequest = new OAuthRequest(verb, oauthho.protectedResource);
            if (args.length == 4 && args[3] != Context.getUndefinedValue() && args[3] instanceof Scriptable) {
                String[] ids;
                Scriptable queryJsonString = (Scriptable)args[3];
                for (String id : ids = (String[])Arrays.copyOf(queryJsonString.getIds(), queryJsonString.getIds().length, String[].class)) {
                    String value = ((Scriptable)args[3]).get(id, (Scriptable)cx.initStandardObjects()).toString();
                    oauthho.oauthRequest.addQuerystringParameter(id, value);
                }
            }
            oauthho.oauthService.signRequest(oauthho.accessToken, oauthho.oauthRequest);
            oauthho.response = oauthho.oauthRequest.send();
            return oauthho.response;
        }
        throw new ScriptException("Required properties not provided, Request cannot be built");
    }

    public static Token jsFunction_getAccessToken(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        OAuthHostObject oauthho = (OAuthHostObject)thisObj;
        if (args.length == 1 && args[0] != Context.getUndefinedValue() && args[0] instanceof String) {
            oauthho.verifier = new Verifier((String)args[0]);
            return oauthho.oauthService.getAccessToken(oauthho.requestToken, oauthho.verifier);
        }
        throw new ScriptException("Illegal argument for the verifier : Add the code given from Provider");
    }

    static enum OAuthVersion {
        OAUTH1,
        OAUTH2;

    }
}

