/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.tcp.TCPOutTransportInfo;

public class TCPTransportSender
extends AbstractTransportSender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(MessageContext msgContext, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        if (targetEPR != null) {
            Map<String, String> params = this.getURLParameters(targetEPR);
            int timeout = -1;
            if (params.containsKey("timeout")) {
                timeout = Integer.parseInt(params.get("timeout"));
            }
            Socket socket = this.openTCPConnection(targetEPR, timeout);
            msgContext.setProperty("transport.tcp.outputSocket", socket);
            try {
                this.writeMessageOut(msgContext, socket.getOutputStream());
                if (!msgContext.getOptions().isUseSeparateListener() && !msgContext.isServerSide()) {
                    this.waitForReply(msgContext, socket, params.get("contentType"));
                }
            }
            catch (IOException e) {
                this.handleException("Error while sending a TCP request", e);
            }
        } else if (outTransportInfo != null && outTransportInfo instanceof TCPOutTransportInfo) {
            TCPOutTransportInfo outInfo = (TCPOutTransportInfo)outTransportInfo;
            try {
                this.writeMessageOut(msgContext, outInfo.getSocket().getOutputStream());
            }
            catch (IOException e) {
                this.handleException("Error while sending a TCP response", e);
            }
            finally {
                this.closeConnection(outInfo.getSocket());
            }
        }
    }

    private void writeMessageOut(MessageContext msgContext, OutputStream outputStream) throws AxisFault, IOException {
        MessageFormatter messageFormatter = BaseUtils.getMessageFormatter(msgContext);
        OMOutputFormat format = BaseUtils.getOMOutputFormat(msgContext);
        messageFormatter.writeTo(msgContext, format, outputStream, true);
    }

    @Override
    public void cleanup(MessageContext msgContext) throws AxisFault {
        Object socketObj = msgContext.getProperty("transport.tcp.outputSocket");
        if (socketObj != null) {
            this.closeConnection((Socket)socketObj);
        }
    }

    private void waitForReply(MessageContext msgContext, Socket socket, String contentType) throws AxisFault {
        if (!(msgContext.getAxisOperation() instanceof OutInAxisOperation) && msgContext.getProperty("piggybackMessage") == null) {
            return;
        }
        if (contentType == null) {
            contentType = "text/xml";
        }
        try {
            MessageContext responseMsgCtx = this.createResponseMessageContext(msgContext);
            SOAPEnvelope envelope = TransportUtils.createSOAPMessage(msgContext, socket.getInputStream(), contentType);
            responseMsgCtx.setEnvelope(envelope);
            AxisEngine.receive(responseMsgCtx);
        }
        catch (Exception e) {
            this.handleException("Error while processing response", e);
        }
    }

    private Map<String, String> getURLParameters(String url) throws AxisFault {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            URI tcpUrl = new URI(url);
            String query = tcpUrl.getQuery();
            if (query != null) {
                String[] paramStrings;
                for (String p : paramStrings = query.split("&")) {
                    int index = p.indexOf(61);
                    params.put(p.substring(0, index), p.substring(index + 1));
                }
            }
            return params;
        }
        catch (URISyntaxException e) {
            this.handleException("Malformed tcp url", e);
            return null;
        }
    }

    private Socket openTCPConnection(String url, int timeout) throws AxisFault {
        try {
            URI tcpUrl = new URI(url);
            if (!tcpUrl.getScheme().equals("tcp")) {
                throw new Exception("Invalid protocol prefix : " + tcpUrl.getScheme());
            }
            InetSocketAddress address = new InetSocketAddress(tcpUrl.getHost(), tcpUrl.getPort());
            Socket socket = new Socket();
            if (timeout != -1) {
                socket.setSoTimeout(timeout);
            }
            socket.connect(address);
            return socket;
        }
        catch (Exception e) {
            this.handleException("Error while opening TCP connection to : " + url, e);
            return null;
        }
    }

    private void closeConnection(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            this.log.error((Object)"Error while closing a TCP socket", (Throwable)e);
        }
    }
}

