/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.RealmCache;
import org.wso2.carbon.user.core.common.UserStoreDeploymentManager;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantCache;
import org.wso2.carbon.user.core.tenant.TenantCacheEntry;
import org.wso2.carbon.user.core.tenant.TenantIdKey;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.DBUtils;

public class JDBCTenantManager
implements TenantManager {
    DataSource dataSource;
    private static Log log = LogFactory.getLog(TenantManager.class);
    protected BundleContext bundleContext;
    private Map tenantDomainIdMap = new ConcurrentHashMap();
    private Map tenantIdDomainMap = new ConcurrentHashMap();
    protected TenantCache tenantCacheManager = TenantCache.getInstance();

    public JDBCTenantManager(OMElement omElement, Map<String, Object> properties) throws Exception {
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            throw new Exception("Data Source is null");
        }
        this.tenantCacheManager.clear();
    }

    public JDBCTenantManager(DataSource dataSource, String superTenantDomain) {
        this.dataSource = dataSource;
    }

    public int addTenant(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        int id = 0;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "INSERT INTO UM_TENANT (UM_DOMAIN_NAME,UM_EMAIL, UM_CREATED_DATE, UM_USER_CONFIG) VALUES(?,?,?,?)";
            String dbProductName = dbConnection.getMetaData().getDatabaseProductName();
            prepStmt = dbConnection.prepareStatement(sqlStmt, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"UM_ID")});
            prepStmt.setString(1, tenant.getDomain().toLowerCase());
            prepStmt.setString(2, tenant.getEmail());
            Date createdTime = tenant.getCreatedDate();
            long createdTimeMs = createdTime == null ? System.currentTimeMillis() : createdTime.getTime();
            prepStmt.setTimestamp(3, new Timestamp(createdTimeMs));
            String realmConfigString = RealmConfigXMLProcessor.serialize(tenant.getRealmConfig()).toString();
            ByteArrayInputStream is = new ByteArrayInputStream(realmConfigString.getBytes());
            prepStmt.setBinaryStream(4, (InputStream)is, ((InputStream)is).available());
            prepStmt.executeUpdate();
            result = prepStmt.getGeneratedKeys();
            if (result.next()) {
                id = result.getInt(1);
            }
            dbConnection.commit();
        }
        catch (Exception e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in adding tenant with tenant domain: " + tenant.getDomain().toLowerCase() + ".";
                log.error((Object)msg);
                throw new UserStoreException(e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return id;
    }

    public void updateTenant(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        this.tenantCacheManager.clearCacheEntry(new TenantIdKey(tenant.getId()));
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "UPDATE UM_TENANT SET UM_DOMAIN_NAME=?, UM_EMAIL=?, UM_CREATED_DATE=? WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, tenant.getDomain().toLowerCase());
            prepStmt.setString(2, tenant.getEmail());
            Date createdTime = tenant.getCreatedDate();
            long createdTimeMs = createdTime == null ? System.currentTimeMillis() : createdTime.getTime();
            prepStmt.setTimestamp(3, new Timestamp(createdTimeMs));
            prepStmt.setInt(4, tenant.getId());
            prepStmt.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in updating tenant with tenant domain: " + tenant.getDomain().toLowerCase() + ".";
                log.error((Object)msg);
                throw new UserStoreException(e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTenantRealmConfig(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        PreparedStatement prepStmt;
        Connection dbConnection;
        block16: {
            dbConnection = null;
            prepStmt = null;
            try {
                dbConnection = this.getDBConnection();
                String realmConfigString = null;
                if (tenant.getRealmConfig() == null || (realmConfigString = RealmConfigXMLProcessor.serialize(tenant.getRealmConfig()).toString()) == null || realmConfigString.trim().length() <= 0) break block16;
                String sqlStmt = "UPDATE UM_TENANT SET UM_USER_CONFIG=? WHERE UM_ID=?";
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                ByteArrayInputStream is = null;
                try {
                    is = new ByteArrayInputStream(realmConfigString.getBytes());
                    prepStmt.setBinaryStream(1, (InputStream)is, ((InputStream)is).available());
                    prepStmt.setInt(2, tenant.getId());
                    prepStmt.executeUpdate();
                    dbConnection.commit();
                    this.tenantCacheManager.clearCacheEntry(new TenantIdKey(tenant.getId()));
                    RealmCache.getInstance().clearFromCache(tenant.getId(), "primary");
                }
                catch (IOException e) {
                    log.error((Object)"Error occurs while reading realm configuration", (Throwable)e);
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e) {
                            log.error((Object)e);
                        }
                    }
                }
            }
            catch (SQLException e) {
                try {
                    DatabaseUtil.rollBack(dbConnection);
                    String msg = "Error in updating tenant realm configuration with tenant domain: " + tenant.getDomain().toLowerCase() + ".";
                    log.error((Object)msg);
                    throw new UserStoreException(e);
                }
                catch (Throwable throwable) {
                    DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                    throw throwable;
                }
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    public Tenant getTenant(int tenantId) throws UserStoreException {
        TenantCacheEntry entry = (TenantCacheEntry)this.tenantCacheManager.getValueFromCache(new TenantIdKey(tenantId));
        if (entry != null && entry.getTenant() != null) {
            return (Tenant)((Object)entry.getTenant());
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        Tenant tenant = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE, UM_CREATED_DATE, UM_USER_CONFIG FROM UM_TENANT WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            result = prepStmt.executeQuery();
            if (result.next()) {
                int id = result.getInt("UM_ID");
                String domain = result.getString("UM_DOMAIN_NAME");
                String email = result.getString("UM_EMAIL");
                boolean active = result.getBoolean("UM_ACTIVE");
                Date createdDate = new Date(result.getTimestamp("UM_CREATED_DATE").getTime());
                InputStream is = result.getBinaryStream("UM_USER_CONFIG");
                RealmConfigXMLProcessor processor = new RealmConfigXMLProcessor();
                RealmConfiguration realmConfig = processor.buildRealmConfiguration(is);
                realmConfig.setTenantId(id);
                tenant = new Tenant();
                tenant.setId(id);
                tenant.setDomain(domain);
                tenant.setEmail(email);
                tenant.setCreatedDate(createdDate);
                tenant.setActive(active);
                tenant.setRealmConfig(realmConfig);
                tenant.setAdminName(realmConfig.getAdminUserName());
                this.tenantCacheManager.addToCache(new TenantIdKey(id), new TenantCacheEntry<Tenant>(tenant));
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenant with tenant id: " + tenantId + ".";
                log.error((Object)msg);
                throw new UserStoreException(e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return tenant;
    }

    public Tenant[] getAllTenants() throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        ArrayList<Tenant> tenantList = new ArrayList<Tenant>();
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE FROM UM_TENANT ORDER BY UM_ID";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            result = prepStmt.executeQuery();
            while (result.next()) {
                int id = result.getInt("UM_ID");
                String domain = result.getString("UM_DOMAIN_NAME");
                String email = result.getString("UM_EMAIL");
                boolean active = result.getBoolean("UM_ACTIVE");
                Date createdDate = new Date(result.getTimestamp("UM_CREATED_DATE").getTime());
                Tenant tenant = new Tenant();
                tenant.setId(id);
                tenant.setDomain(domain);
                tenant.setEmail(email);
                tenant.setActive(active);
                tenant.setCreatedDate(createdDate);
                tenantList.add(tenant);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenants.";
                log.error((Object)msg);
                throw new UserStoreException(e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return tenantList.toArray(new Tenant[tenantList.size()]);
    }

    public String getDomain(int tenantId) throws UserStoreException {
        if (tenantId == -1234) {
            return "carbon.super";
        }
        if (tenantId == -1) {
            return null;
        }
        String tenantDomain = (String)this.tenantIdDomainMap.get(tenantId);
        if (tenantDomain != null) {
            return tenantDomain;
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_DOMAIN_NAME FROM UM_TENANT WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            result = prepStmt.executeQuery();
            if (result.next()) {
                tenantDomain = result.getString("UM_DOMAIN_NAME");
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenant with tenant id: " + tenantId + ".";
                log.error((Object)msg);
                throw new UserStoreException(e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        if (tenantDomain != null && !tenantDomain.isEmpty() && tenantId != -1) {
            this.tenantIdDomainMap.put(tenantId, tenantDomain);
        }
        return tenantDomain;
    }

    public Tenant[] getAllTenantsForTenantDomainStr(String tenantDomain) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        ArrayList<Tenant> tenantList = new ArrayList<Tenant>();
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE FROM UM_TENANT WHERE UM_DOMAIN_NAME like ?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, "%" + tenantDomain.toLowerCase() + "%");
            result = prepStmt.executeQuery();
            while (result.next()) {
                int id = result.getInt("UM_ID");
                String domain = result.getString("UM_DOMAIN_NAME");
                String email = result.getString("UM_EMAIL");
                boolean active = result.getBoolean("UM_ACTIVE");
                Date createdDate = new Date(result.getTimestamp("UM_CREATED_DATE").getTime());
                Tenant tenant = new Tenant();
                tenant.setId(id);
                tenant.setDomain(domain);
                tenant.setEmail(email);
                tenant.setActive(active);
                tenant.setCreatedDate(createdDate);
                tenantList.add(tenant);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenants.";
                log.error((Object)msg);
                throw new UserStoreException(e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return tenantList.toArray(new Tenant[tenantList.size()]);
    }

    public int getTenantId(String tenantDomain) throws UserStoreException {
        if (tenantDomain != null) {
            tenantDomain = tenantDomain.toLowerCase();
        }
        if ("carbon.super".equals(tenantDomain)) {
            return -1234;
        }
        if (tenantDomain == null) {
            return -1;
        }
        Integer tenantId = (Integer)this.tenantDomainIdMap.get(tenantDomain);
        if (tenantId != null) {
            return tenantId;
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        tenantId = -1;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_ID FROM UM_TENANT WHERE UM_DOMAIN_NAME=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, tenantDomain);
            result = prepStmt.executeQuery();
            if (result.next()) {
                tenantId = result.getInt("UM_ID");
            }
            dbConnection.commit();
            if (tenantDomain != null && !tenantDomain.isEmpty() && tenantId != -1) {
                this.tenantDomainIdMap.put(tenantDomain, tenantId);
            }
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenant id with tenant domain: " + tenantDomain + ".";
                log.error((Object)msg, (Throwable)e);
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return tenantId;
    }

    public void activateTenant(int tenantId) throws UserStoreException {
        this.tenantCacheManager.clearCacheEntry(new TenantIdKey(tenantId));
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "UPDATE UM_TENANT SET UM_ACTIVE='1' WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            prepStmt.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in activating the tenant with tenant id: " + tenantId + ".";
                log.error((Object)msg, (Throwable)e);
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    public void deactivateTenant(int tenantId) throws UserStoreException {
        this.tenantIdDomainMap.remove(tenantId);
        this.tenantCacheManager.clearCacheEntry(new TenantIdKey(tenantId));
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "UPDATE UM_TENANT SET UM_ACTIVE='0' WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            prepStmt.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in deactivating the tenant with tenant id: " + tenantId + ".";
                log.error((Object)msg);
                throw new UserStoreException(e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    public boolean isTenantActive(int tenantId) throws UserStoreException {
        PreparedStatement prepStmt;
        Connection dbConnection;
        block6: {
            if (tenantId == -1234) {
                return true;
            }
            dbConnection = null;
            prepStmt = null;
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_ACTIVE FROM UM_TENANT WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            ResultSet result = prepStmt.executeQuery();
            if (!result.next()) break block6;
            boolean bl = result.getBoolean("UM_ACTIVE");
            DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
            return bl;
        }
        try {
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenant status with tenant id: " + tenantId + ".";
                log.error((Object)msg);
                throw new UserStoreException(e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
        return false;
    }

    public void deleteTenant(int tenantId) throws UserStoreException {
        this.tenantIdDomainMap.remove(tenantId);
        this.tenantCacheManager.clearCacheEntry(new TenantIdKey(tenantId));
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "DELETE FROM UM_TENANT WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            prepStmt.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in deleting the tenant with tenant id: " + tenantId + ".";
                log.error((Object)msg, (Throwable)e);
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void initializeExistingPartitions() {
    }

    private Connection getDBConnection() throws SQLException {
        Connection dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
        dbConnection.setAutoCommit(false);
        return dbConnection;
    }

    @Override
    public String getSuperTenantDomain() throws UserStoreException {
        return "carbon.super";
    }

    public String[] getAllTenantDomainStrOfUser(String username) throws org.wso2.carbon.user.api.UserStoreException {
        throw new UnsupportedOperationException("Operation getAllTenantDomainStrOfUse is unsupported ");
    }

    private void setSecondaryUserStoreConfig(RealmConfiguration realmConfiguration, int tenantId) throws UserStoreException {
        RealmConfiguration lastRealm = realmConfiguration;
        if (realmConfiguration != null) {
            while (lastRealm.getSecondaryRealmConfig() != null) {
                lastRealm = lastRealm.getSecondaryRealmConfig();
            }
            String configPath = CarbonUtils.getCarbonTenantsDirPath() + File.separator + tenantId + File.separator + "userstores";
            File userStores = new File(configPath);
            UserStoreDeploymentManager userStoreDeploymentManager = new UserStoreDeploymentManager();
            File[] files = userStores.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File userStores, String name) {
                    return name.toLowerCase().endsWith(".xml");
                }
            });
            if (files != null) {
                for (File file : files) {
                    RealmConfiguration newRealmConfig = userStoreDeploymentManager.getUserStoreConfiguration(file.getAbsolutePath());
                    if (newRealmConfig != null) {
                        lastRealm.setSecondaryRealmConfig(newRealmConfig);
                        lastRealm = lastRealm.getSecondaryRealmConfig();
                        continue;
                    }
                    log.error((Object)("Error while creating realm configuration from file " + file.getAbsolutePath()));
                }
            }
        }
    }
}

