/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.authorization.AuthorizationCache;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.common.AbstractUserOperationEventListener;
import org.wso2.carbon.user.core.common.RoleContext;
import org.wso2.carbon.user.core.common.UserRolesCache;
import org.wso2.carbon.user.core.common.UserStore;
import org.wso2.carbon.user.core.dto.RoleDTO;
import org.wso2.carbon.user.core.hybrid.HybridRoleManager;
import org.wso2.carbon.user.core.internal.UMListenerServiceComponent;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.listener.UserStoreManagerConfigurationListener;
import org.wso2.carbon.user.core.listener.UserStoreManagerListener;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.system.SystemUserRoleManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public abstract class AbstractUserStoreManager
implements UserStoreManager {
    private static Log log = LogFactory.getLog(AbstractUserStoreManager.class);
    protected int tenantId;
    protected DataSource dataSource = null;
    protected RealmConfiguration realmConfig = null;
    protected ClaimManager claimManager = null;
    protected UserRealm userRealm = null;
    protected HybridRoleManager hybridRoleManager = null;
    protected UserRolesCache userRolesCache = null;
    protected SystemUserRoleManager systemUserRoleManager = null;
    protected boolean readGroupsEnabled = false;
    protected boolean writeGroupsEnabled = false;
    private UserStoreManager secondaryUserStoreManager;
    private boolean userRolesCacheEnabled = true;
    private String cacheIdentifier;
    private boolean replaceEscapeCharactersAtUserLogin = true;
    private Map<String, UserStoreManager> userStoreManagerHolder = new HashMap<String, UserStoreManager>();
    private Map<String, Integer> maxUserListCount = null;
    private Map<String, Integer> maxRoleListCount = null;
    private List<UserStoreManagerConfigurationListener> listener = new ArrayList<UserStoreManagerConfigurationListener>();
    private static final String MAX_LIST_LENGTH = "100";
    protected static final String TRUE_VALUE = "true";
    protected static final String FALSE_VALUE = "false";

    protected abstract Map<String, String> getUserPropertyValues(String var1, String[] var2, String var3) throws UserStoreException;

    protected abstract boolean doCheckExistingRole(String var1) throws UserStoreException;

    protected abstract RoleContext createRoleContext(String var1) throws UserStoreException;

    protected abstract boolean doCheckExistingUser(String var1) throws UserStoreException;

    protected abstract String[] getUserListFromProperties(String var1, String var2, String var3) throws UserStoreException;

    protected abstract boolean doAuthenticate(String var1, Object var2) throws UserStoreException;

    protected abstract void doAddUser(String var1, Object var2, String[] var3, Map<String, String> var4, String var5, boolean var6) throws UserStoreException;

    protected abstract void doUpdateCredential(String var1, Object var2, Object var3) throws UserStoreException;

    protected abstract void doUpdateCredentialByAdmin(String var1, Object var2) throws UserStoreException;

    protected abstract void doDeleteUser(String var1) throws UserStoreException;

    protected abstract void doSetUserClaimValue(String var1, String var2, String var3, String var4) throws UserStoreException;

    protected abstract void doSetUserClaimValues(String var1, Map<String, String> var2, String var3) throws UserStoreException;

    protected abstract void doDeleteUserClaimValue(String var1, String var2, String var3) throws UserStoreException;

    protected abstract void doDeleteUserClaimValues(String var1, String[] var2, String var3) throws UserStoreException;

    protected abstract void doUpdateUserListOfRole(String var1, String[] var2, String[] var3) throws UserStoreException;

    protected abstract void doUpdateRoleListOfUser(String var1, String[] var2, String[] var3) throws UserStoreException;

    protected String[] doGetInternalRoleListOfUser(String userName, String filter) throws UserStoreException {
        return this.hybridRoleManager.getHybridRoleListOfUser(userName, filter);
    }

    protected abstract String[] doGetExternalRoleListOfUser(String var1, String var2) throws UserStoreException;

    protected abstract String[] doGetSharedRoleListOfUser(String var1, String var2, String var3) throws UserStoreException;

    protected abstract void doAddRole(String var1, String[] var2, boolean var3) throws UserStoreException;

    protected abstract void doDeleteRole(String var1) throws UserStoreException;

    protected abstract void doUpdateRoleName(String var1, String var2) throws UserStoreException;

    protected abstract String[] doGetRoleNames(String var1, int var2) throws UserStoreException;

    protected abstract String[] doListUsers(String var1, int var2) throws UserStoreException;

    protected abstract String[] doGetDisplayNamesForInternalRole(String[] var1) throws UserStoreException;

    @Override
    public final boolean authenticate(String userName, Object credential) throws UserStoreException {
        if (userName == null || credential == null) {
            log.error((Object)"Authentication failure. Either Username or Password is null");
            return false;
        }
        int index = userName != null ? userName.indexOf("/") : -1;
        boolean domainProvided = index > 0;
        return this.authenticate(userName, credential, domainProvided);
    }

    protected boolean authenticate(String userName, Object credential, boolean domainProvided) throws UserStoreException {
        String domain;
        boolean authenticated = false;
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().authenticate(userStore.getDomainFreeName(), credential, domainProvided);
        }
        for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
            if (userStoreManagerListener.authenticate(userName, credential, this)) continue;
            return true;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPreAuthenticate(userName, credential, this)) continue;
            return false;
        }
        try {
            authenticated = this.doAuthenticate(userName, credential);
        }
        catch (Exception e) {
            log.error((Object)e);
            authenticated = false;
        }
        if (authenticated && (domain = UserCoreUtil.getDomainName(this.realmConfig)) != null) {
            UserCoreUtil.setDomainInThreadLocal(domain.toUpperCase());
        }
        if (!authenticated && !domainProvided && this.getSecondaryUserStoreManager() != null) {
            authenticated = ((AbstractUserStoreManager)this.getSecondaryUserStoreManager()).authenticate(userName, credential, domainProvided);
            return authenticated;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPostAuthenticate(userName, authenticated, this)) continue;
            return false;
        }
        if (log.isDebugEnabled() && !authenticated) {
            log.debug((Object)"Authentication failure. Wrong username or password is provided.");
        }
        return authenticated;
    }

    @Override
    public final String getUserClaimValue(String userName, String claim, String profileName) throws UserStoreException {
        if (!this.isExistingUser(userName)) {
            return null;
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().getUserClaimValue(userStore.getDomainFreeName(), claim, profileName);
        }
        Map<String, String> finalValues = this.doGetUserClaimValues(userName, new String[]{claim}, userStore.getDomainName(), profileName);
        String value = null;
        if (finalValues != null) {
            value = finalValues.get(claim);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            list.add(value);
        }
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            AbstractUserOperationEventListener newListener;
            if (listener instanceof AbstractUserOperationEventListener && !(newListener = (AbstractUserOperationEventListener)listener).doPostGetUserClaimValue(userName, claim, list, profileName, this)) break;
        }
        return value;
    }

    @Override
    public final Claim[] getUserClaimValues(String userName, String profileName) throws UserStoreException {
        String[] claims;
        if (!this.isExistingUser(userName)) {
            return null;
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().getUserClaimValues(userStore.getDomainFreeName(), profileName);
        }
        if (profileName == null || profileName.trim().length() == 0) {
            profileName = "default";
        }
        try {
            claims = this.claimManager.getAllClaimUris();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        Map<String, String> values = this.getUserClaimValues(userName, claims, profileName);
        Claim[] finalValues = new Claim[values.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String displayTag;
            Claim claim = new Claim();
            claim.setValue(entry.getValue());
            claim.setClaimUri(entry.getKey());
            try {
                displayTag = this.claimManager.getClaim(entry.getKey()).getDisplayTag();
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            claim.setDisplayTag(displayTag);
            finalValues[i] = claim;
            ++i;
        }
        return finalValues;
    }

    @Override
    public final Map<String, String> getUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().getUserClaimValues(userStore.getDomainFreeName(), claims, profileName);
        }
        Map<String, String> finalValues = this.doGetUserClaimValues(userName, claims, userStore.getDomainName(), profileName);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            AbstractUserOperationEventListener newListener;
            if (listener instanceof AbstractUserOperationEventListener && !(newListener = (AbstractUserOperationEventListener)listener).doPostGetUserClaimValues(userName, claims, profileName, finalValues, this)) break;
        }
        return finalValues;
    }

    @Override
    public final String[] getUserList(String claim, String claimValue, String profileName) throws UserStoreException {
        String property;
        try {
            String domainName = this.getRealmConfiguration().getUserStoreProperty("DomainName");
            if (domainName != null && !domainName.isEmpty() && !domainName.equals("PRIMARY")) {
                property = this.claimManager.getAttributeName(domainName, claim);
                if (property == null) {
                    property = this.claimManager.getAttributeName(claim);
                }
            } else {
                property = this.claimManager.getAttributeName(claim);
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        if (property == null) {
            throw new UserStoreException("Claim " + claim + " is not defined for " + this.getMyDomainName());
        }
        String[] userList = this.getUserListFromProperties(property, claimValue, profileName);
        if ((userList == null || userList.length < 1) && this.getSecondaryUserStoreManager() != null) {
            if (log.isDebugEnabled()) {
                String currentDomain = this.getMyDomainName();
                String childDomain = ((AbstractUserStoreManager)this.getSecondaryUserStoreManager()).getMyDomainName();
                log.debug((Object)("No users found in: " + currentDomain + " Looking in the secondary user store " + childDomain));
            }
            userList = ((AbstractUserStoreManager)this.getSecondaryUserStoreManager()).getUserList(claim, claimValue, profileName);
        } else if (this.getSecondaryUserStoreManager() != null) {
            ArrayList<String> usersWithDomain = new ArrayList<String>();
            for (String user : userList) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found user: " + user));
                }
                String domainName = this.getMyDomainName();
                String nameWithDomain = UserCoreUtil.addDomainToName(user, domainName);
                usersWithDomain.add(nameWithDomain);
            }
            return usersWithDomain.toArray(new String[usersWithDomain.size()]);
        }
        return userList;
    }

    @Override
    public final void updateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().updateCredential(userStore.getDomainFreeName(), newCredential, oldCredential);
            return;
        }
        if (this.isReadOnly()) {
            throw new UserStoreException("Invalid operation. User store is read only");
        }
        for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
            if (userStoreManagerListener.updateCredential(userName, newCredential, oldCredential, this)) continue;
            return;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPreUpdateCredential(userName, newCredential, oldCredential, this)) continue;
            return;
        }
        boolean isAuth = this.doAuthenticate(userName, oldCredential);
        if (isAuth) {
            this.doUpdateCredential(userName, newCredential, oldCredential);
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (listener.doPostUpdateCredential(userName, newCredential, this)) continue;
                return;
            }
            return;
        }
        throw new UserStoreException("Old credential does not match with the existing credentials.");
    }

    @Override
    public final void updateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().updateCredentialByAdmin(userStore.getDomainFreeName(), newCredential);
            return;
        }
        if (this.isReadOnly()) {
            throw new UserStoreException("Invalid operation. User store is read only");
        }
        for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
            if (userStoreManagerListener.updateCredentialByAdmin(userName, newCredential, this)) continue;
            return;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            StringBuffer credBuff;
            if (newCredential == null) {
                credBuff = new StringBuffer();
                if (!userOperationEventListener.doPreUpdateCredentialByAdmin(userName, newCredential, this)) {
                    return;
                }
                newCredential = credBuff.toString();
                continue;
            }
            if (!(newCredential instanceof String)) continue;
            credBuff = new StringBuffer((String)newCredential);
            if (!userOperationEventListener.doPreUpdateCredentialByAdmin(userName, credBuff, this)) {
                return;
            }
            newCredential = credBuff.toString();
        }
        this.doUpdateCredentialByAdmin(userName, newCredential);
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPostUpdateCredentialByAdmin(userName, newCredential, this)) continue;
            return;
        }
    }

    protected String getClaimAtrribute(String claimURI, String identifier, String domainName) throws org.wso2.carbon.user.api.UserStoreException {
        domainName = domainName == null || domainName.isEmpty() ? (identifier.indexOf("/") > -1 ? identifier.split("/")[0] : this.realmConfig.getUserStoreProperty("DomainName")) : domainName;
        String attributeName = null;
        if (domainName != null && !domainName.equals("PRIMARY")) {
            attributeName = this.claimManager.getAttributeName(domainName, claimURI);
        }
        if (attributeName == null || attributeName.isEmpty()) {
            attributeName = this.claimManager.getAttributeName(claimURI);
        }
        return attributeName != null ? attributeName : claimURI;
    }

    @Override
    public final void deleteUser(String userName) throws UserStoreException {
        String loggedInUser = CarbonContext.getCurrentContext().getUsername();
        if (loggedInUser != null && loggedInUser.equals(userName)) {
            log.debug((Object)("User " + userName + " tried to delete him/her self"));
            throw new UserStoreException("Cannot delete logged in user");
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().deleteUser(userStore.getDomainFreeName());
            return;
        }
        if (UserCoreUtil.isPrimaryAdminUser(userName, this.realmConfig)) {
            throw new UserStoreException("Cannot delete admin user");
        }
        if (UserCoreUtil.isRegistryAnnonymousUser(userName)) {
            throw new UserStoreException("Cannot delete anonymous user");
        }
        if (this.isReadOnly()) {
            throw new UserStoreException("Invalid operation. User store is read only");
        }
        for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
            if (userStoreManagerListener.deleteUser(userName, this)) continue;
            return;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPreDeleteUser(userName, this)) continue;
            return;
        }
        if (!this.doCheckExistingUser(userName)) {
            throw new UserStoreException("Cannot delete user who is not exist");
        }
        this.hybridRoleManager.deleteUser(UserCoreUtil.addDomainToName(userName, this.getMyDomainName()));
        this.doDeleteUser(userName);
        this.clearUserRolesCache(UserCoreUtil.addDomainToName(userName, this.getMyDomainName()));
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPostDeleteUser(userName, this)) continue;
            return;
        }
    }

    @Override
    public final void setUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().setUserClaimValue(userStore.getDomainFreeName(), claimURI, claimValue, profileName);
            return;
        }
        if (this.isReadOnly()) {
            throw new UserStoreException("Invalid operation. User store is read only");
        }
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreSetUserClaimValue(userName, claimURI, claimValue, profileName, this)) continue;
            return;
        }
        this.doSetUserClaimValue(userName, claimURI, claimValue, profileName);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostSetUserClaimValue(userName, this)) continue;
            return;
        }
    }

    @Override
    public final void setUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().setUserClaimValues(userStore.getDomainFreeName(), claims, profileName);
            return;
        }
        if (this.isReadOnly()) {
            throw new UserStoreException("Invalid operation. User store is read only");
        }
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreSetUserClaimValues(userName, claims, profileName, this)) continue;
            return;
        }
        this.doSetUserClaimValues(userName, claims, profileName);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostSetUserClaimValues(userName, claims, profileName, this)) continue;
            return;
        }
    }

    @Override
    public final void deleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().deleteUserClaimValue(userStore.getDomainFreeName(), claimURI, profileName);
            return;
        }
        if (this.isReadOnly()) {
            throw new UserStoreException("Invalid operation. User store is read only");
        }
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreDeleteUserClaimValue(userName, claimURI, profileName, this)) continue;
            return;
        }
        this.doDeleteUserClaimValue(userName, claimURI, profileName);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostDeleteUserClaimValue(userName, this)) continue;
            return;
        }
    }

    @Override
    public final void deleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().deleteUserClaimValues(userStore.getDomainFreeName(), claims, profileName);
            return;
        }
        if (this.isReadOnly()) {
            throw new UserStoreException("Invalid operation. User store is read only");
        }
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreDeleteUserClaimValues(userName, claims, profileName, this)) continue;
            return;
        }
        this.doDeleteUserClaimValues(userName, claims, profileName);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostDeleteUserClaimValues(userName, this)) continue;
            return;
        }
    }

    @Override
    public final void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        String message;
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().addUser(userStore.getDomainFreeName(), credential, roleList, claims, profileName, requirePasswordChange);
            return;
        }
        if (userStore.isSystemStore()) {
            this.systemUserRoleManager.addSystemUser(userName, credential, roleList);
            return;
        }
        if (this.isReadOnly()) {
            throw new UserStoreException("Invalid operation. User store is read only");
        }
        if (userName.indexOf("/") > 0) {
            userName = userStore.getDomainFreeName();
            roleList = UserCoreUtil.removeDomainFromNames(roleList);
        }
        for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
            if (userStoreManagerListener.addUser(userName, credential, roleList, claims, profileName, this)) continue;
            return;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            StringBuffer credBuff;
            if (credential == null) {
                credBuff = new StringBuffer();
                if (!userOperationEventListener.doPreAddUser(userName, credBuff, roleList, claims, profileName, this)) {
                    return;
                }
                credential = credBuff.toString();
                continue;
            }
            if (!(credential instanceof String)) continue;
            credBuff = new StringBuffer((String)credential);
            if (!userOperationEventListener.doPreAddUser(userName, credBuff, roleList, claims, profileName, this)) {
                return;
            }
            credential = credBuff.toString();
        }
        if (!this.checkUserNameValid(userStore.getDomainFreeName())) {
            message = "Username " + userStore.getDomainFreeName() + " is not valid. User name must be a non null string with following format, ";
            String string = this.realmConfig.getUserStoreProperty("UsernameJavaRegEx");
            throw new UserStoreException(message + string);
        }
        if (!this.checkUserPasswordValid(credential)) {
            message = "Credential not valid. Credential must be a non null string with following format, ";
            String string = this.realmConfig.getUserStoreProperty("PasswordJavaRegEx");
            throw new UserStoreException(message + string);
        }
        if (this.doCheckExistingUser(userStore.getDomainFreeName())) {
            throw new UserStoreException("Username '" + userName + "' already exists in the system. Please pick another username.");
        }
        ArrayList<String> internalRoles = new ArrayList<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (roleList != null) {
            for (String role : roleList) {
                String domain;
                if (role == null || role.trim().length() <= 0) continue;
                int index = role.indexOf("/");
                if (index > 0 && "Internal".equalsIgnoreCase(domain = role.substring(0, index))) {
                    internalRoles.add(UserCoreUtil.removeDomainFromName(role));
                    continue;
                }
                arrayList.add(UserCoreUtil.removeDomainFromName(role));
            }
        }
        for (String string : internalRoles) {
            if (this.hybridRoleManager.isExistingRole(string)) continue;
            throw new UserStoreException("Internal role is not exist : " + string);
        }
        for (String string : arrayList) {
            if (this.doCheckExistingRole(string)) continue;
            throw new UserStoreException("External role is not exist : " + string);
        }
        if (claims != null) {
            for (Map.Entry entry : claims.entrySet()) {
                ClaimMapping claimMapping = null;
                try {
                    claimMapping = (ClaimMapping)this.claimManager.getClaimMapping((String)entry.getKey());
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    String errorMessage = "Error in obtaining claim mapping for persisting user attributes.";
                    throw new UserStoreException(errorMessage, e);
                }
                if (claimMapping != null) continue;
                String errorMessage = "Invalid claim uri has been provided.";
                throw new UserStoreException(errorMessage);
            }
        }
        this.doAddUser(userName, credential, arrayList.toArray(new String[arrayList.size()]), claims, profileName, requirePasswordChange);
        if (internalRoles.size() > 0) {
            this.hybridRoleManager.updateHybridRoleListOfUser(userName, null, internalRoles.toArray(new String[internalRoles.size()]));
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPostAddUser(userName, credential, roleList, claims, profileName, this)) continue;
            return;
        }
    }

    @Override
    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        this.addUser(userName, credential, roleList, claims, profileName, false);
    }

    @Override
    public final void updateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        UserStore userStore;
        String primaryDomain = this.getMyDomainName();
        if (primaryDomain != null) {
            primaryDomain = primaryDomain + "/";
        }
        if (deletedUsers != null && deletedUsers.length > 0) {
            Arrays.sort(deletedUsers);
            if (UserCoreUtil.isPrimaryAdminRole(roleName, this.realmConfig)) {
                for (int i = 0; i < deletedUsers.length; ++i) {
                    if (!deletedUsers[i].equalsIgnoreCase(this.realmConfig.getAdminUserName()) && !(primaryDomain + deletedUsers[i]).equalsIgnoreCase(this.realmConfig.getAdminUserName())) continue;
                    throw new UserStoreException("Cannot remove Admin user from Admin role");
                }
            }
        }
        if ((userStore = this.getUserStore(roleName)).isHybridRole()) {
            if (UserCoreUtil.isEveryoneRole(roleName, this.realmConfig)) {
                throw new UserStoreException("Cannot update everyone role");
            }
            this.hybridRoleManager.updateUserListOfHybridRole(userStore.getDomainFreeName(), deletedUsers, newUsers);
            this.clearUserRolesCacheByTenant(this.tenantId);
            return;
        }
        if (userStore.isSystemStore()) {
            this.systemUserRoleManager.updateUserListOfSystemRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedUsers), UserCoreUtil.removeDomainFromNames(newUsers));
            return;
        }
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().updateUserListOfRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedUsers), UserCoreUtil.removeDomainFromNames(newUsers));
            return;
        }
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreUpdateUserListOfRole(roleName, deletedUsers, newUsers, this)) continue;
            return;
        }
        if (deletedUsers != null && deletedUsers.length > 0 || newUsers != null && newUsers.length > 0) {
            if (!this.isReadOnly() && this.writeGroupsEnabled) {
                this.doUpdateUserListOfRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedUsers), UserCoreUtil.removeDomainFromNames(newUsers));
            } else {
                throw new UserStoreException("Read-only user store.Roles cannot be added or modfified");
            }
        }
        this.clearUserRolesCacheByTenant(this.tenantId);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostUpdateUserListOfRole(roleName, deletedUsers, newUsers, this)) continue;
            return;
        }
    }

    @Override
    public final void updateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        String domain;
        UserStore userStore;
        String primaryDomain = this.realmConfig.getUserStoreProperty("DomainName");
        if (primaryDomain != null) {
            primaryDomain = primaryDomain + "/";
        }
        if (deletedRoles != null && deletedRoles.length > 0) {
            Arrays.sort(deletedRoles);
            if (UserCoreUtil.isPrimaryAdminUser(userName, this.realmConfig)) {
                for (int i = 0; i < deletedRoles.length; ++i) {
                    if (!deletedRoles[i].equalsIgnoreCase(this.realmConfig.getAdminRoleName()) && !(primaryDomain + deletedRoles[i]).equalsIgnoreCase(this.realmConfig.getAdminRoleName())) continue;
                    throw new UserStoreException("Cannot remove Admin user from Admin role");
                }
            }
        }
        if ((userStore = this.getUserStore(userName)).isRecurssive()) {
            userStore.getUserStoreManager().updateRoleListOfUser(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedRoles), UserCoreUtil.removeDomainFromNames(newRoles));
            return;
        }
        if (userStore.isSystemStore()) {
            this.systemUserRoleManager.updateSystemRoleListOfUser(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedRoles), UserCoreUtil.removeDomainFromNames(newRoles));
            return;
        }
        if (userName.indexOf("/") > 0) {
            userName = userStore.getDomainFreeName();
            deletedRoles = UserCoreUtil.removeDomainFromNames(deletedRoles);
            newRoles = UserCoreUtil.removeDomainFromNames(newRoles);
        }
        ArrayList<String> internalRoleDel = new ArrayList<String>();
        ArrayList<String> internalRoleNew = new ArrayList<String>();
        ArrayList<String> roleDel = new ArrayList<String>();
        ArrayList<String> roleNew = new ArrayList<String>();
        if (deletedRoles != null && deletedRoles.length > 0) {
            for (String deleteRole : deletedRoles) {
                if (UserCoreUtil.isEveryoneRole(deleteRole, this.realmConfig)) {
                    throw new UserStoreException("Everyone role cannot be updated");
                }
                domain = null;
                int index1 = deleteRole.indexOf("/");
                if (index1 > 0) {
                    domain = deleteRole.substring(0, index1);
                }
                if ("Internal".equalsIgnoreCase(domain) || this.isReadOnly()) {
                    internalRoleDel.add(UserCoreUtil.removeDomainFromName(deleteRole));
                    continue;
                }
                roleDel.add(UserCoreUtil.removeDomainFromName(deleteRole));
            }
            deletedRoles = roleDel.toArray(new String[roleDel.size()]);
        }
        if (newRoles != null && newRoles.length > 0) {
            for (String newRole : newRoles) {
                if (UserCoreUtil.isEveryoneRole(newRole, this.realmConfig)) {
                    throw new UserStoreException("Everyone role cannot be updated");
                }
                domain = null;
                int index2 = newRole.indexOf("/");
                if (index2 > 0) {
                    domain = newRole.substring(0, index2);
                }
                if ("Internal".equalsIgnoreCase(domain) || this.isReadOnly()) {
                    internalRoleNew.add(UserCoreUtil.removeDomainFromName(newRole));
                    continue;
                }
                roleNew.add(UserCoreUtil.removeDomainFromName(newRole));
            }
            newRoles = roleNew.toArray(new String[roleNew.size()]);
        }
        if (internalRoleDel.size() > 0 || internalRoleNew.size() > 0) {
            this.hybridRoleManager.updateHybridRoleListOfUser(userStore.getDomainFreeName(), internalRoleDel.toArray(new String[internalRoleDel.size()]), internalRoleNew.toArray(new String[internalRoleNew.size()]));
        }
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreUpdateRoleListOfUser(userName, deletedRoles, newRoles, this)) continue;
            return;
        }
        if (deletedRoles != null && deletedRoles.length > 0 || newRoles != null && newRoles.length > 0) {
            if (!this.isReadOnly() && this.writeGroupsEnabled) {
                this.doUpdateRoleListOfUser(userName, deletedRoles, newRoles);
            } else {
                throw new UserStoreException("Read-only user store. Cannot add/modify roles.");
            }
        }
        this.clearUserRolesCache(UserCoreUtil.addDomainToName(userName, this.getMyDomainName()));
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostUpdateRoleListOfUser(userName, deletedRoles, newRoles, this)) continue;
            return;
        }
    }

    @Override
    public final void updateRoleName(String roleName, String newRoleName) throws UserStoreException {
        UserStore userStoreNew;
        if (UserCoreUtil.isPrimaryAdminRole(newRoleName, this.realmConfig)) {
            throw new UserStoreException("Cannot rename admin role");
        }
        if (UserCoreUtil.isEveryoneRole(newRoleName, this.realmConfig)) {
            throw new UserStoreException("Cannot rename everyone role");
        }
        UserStore userStore = this.getUserStore(roleName);
        if (!UserCoreUtil.canRoleBeRenamed(userStore, userStoreNew = this.getUserStore(newRoleName), this.realmConfig)) {
            throw new UserStoreException("The role cannot be renamed");
        }
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().updateRoleName(userStore.getDomainFreeName(), userStoreNew.getDomainFreeName());
            return;
        }
        if (userStore.isHybridRole()) {
            this.hybridRoleManager.updateHybridRoleName(userStore.getDomainFreeName(), userStoreNew.getDomainFreeName());
            this.userRealm.getAuthorizationManager().resetPermissionOnUpdateRole(userStore.getDomainAwareName(), userStoreNew.getDomainAwareName());
            this.clearUserRolesCacheByTenant(this.tenantId);
            return;
        }
        if (this.isExistingRole(newRoleName)) {
            throw new UserStoreException("Role name: " + newRoleName + " in the system. Please pick another role name.");
        }
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreUpdateRoleName(roleName, newRoleName, this)) continue;
            return;
        }
        if (this.isReadOnly() || !this.writeGroupsEnabled) {
            throw new UserStoreException("Read-only UserStoreManager. Roles cannot be added or modified.");
        }
        this.doUpdateRoleName(userStore.getDomainFreeName(), userStoreNew.getDomainFreeName());
        this.userRealm.getAuthorizationManager().resetPermissionOnUpdateRole(userStore.getDomainAwareName(), userStoreNew.getDomainAwareName());
        this.clearUserRolesCacheByTenant(this.tenantId);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostUpdateRoleName(roleName, newRoleName, this)) continue;
            return;
        }
    }

    public boolean isExistingRole(String roleName, boolean shared) throws org.wso2.carbon.user.api.UserStoreException {
        if (shared) {
            return this.isExistingShareRole(roleName);
        }
        return this.isExistingRole(roleName);
    }

    @Override
    public boolean isExistingRole(String roleName) throws UserStoreException {
        UserStore userStore = this.getUserStore(roleName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().isExistingRole(userStore.getDomainFreeName());
        }
        if (userStore.isSystemStore()) {
            return this.systemUserRoleManager.isExistingRole(userStore.getDomainFreeName());
        }
        if (userStore.isHybridRole()) {
            boolean exist = this.hybridRoleManager.isExistingRole(userStore.getDomainFreeName());
            if (exist) {
                return true;
            }
            if (!this.readGroupsEnabled) {
                return false;
            }
        }
        roleName = userStore.getDomainFreeName();
        if (this.isSharedGroupEnabled() && roleName.contains("@")) {
            return false;
        }
        boolean isExisting = this.doCheckExistingRole(roleName);
        if (!(isExisting || !this.isReadOnly() && this.readGroupsEnabled)) {
            isExisting = this.hybridRoleManager.isExistingRole(roleName);
        }
        if (!isExisting && this.systemUserRoleManager.isExistingRole(roleName)) {
            isExisting = true;
        }
        return isExisting;
    }

    public boolean isExistingShareRole(String roleName) throws UserStoreException {
        UserStoreManager manager = this.getUserStoreWithSharedRoles();
        if (manager == null) {
            throw new UserStoreException("Share Groups are not supported by this realm");
        }
        return ((AbstractUserStoreManager)manager).doCheckExistingRole(roleName);
    }

    public void updateUsersOfSharedRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        UserStoreManager manager = this.getUserStoreWithSharedRoles();
        if (manager == null) {
            throw new UserStoreException("Share Groups are not supported by this realm");
        }
        ((AbstractUserStoreManager)manager).doUpdateUserListOfRole(roleName, deletedUsers, newUsers);
    }

    public String[] getSharedRolesOfUser(String userName, String tenantDomain, String filter) throws UserStoreException {
        UserStore userStore = this.getUserStore(userName);
        AbstractUserStoreManager manager = userStore.getUserStoreManager();
        if (!manager.isSharedGroupEnabled()) {
            throw new UserStoreException("Share Groups are not supported by user store");
        }
        String[] sharedRoles = manager.doGetSharedRoleListOfUser(userStore.getDomainFreeName(), tenantDomain, filter);
        return UserCoreUtil.removeDomainFromNames(sharedRoles);
    }

    public String[] getUsersOfSharedRole(String roleName, String filter) throws UserStoreException {
        UserStoreManager manager = this.getUserStoreWithSharedRoles();
        if (manager == null) {
            throw new UserStoreException("Share Groups are not supported by this realm");
        }
        String[] users = ((AbstractUserStoreManager)manager).doGetUserListOfRole(roleName, filter);
        return UserCoreUtil.removeDomainFromNames(users);
    }

    public String[] getSharedRoleNames(String tenantDomain, String filter, int maxItemLimit) throws UserStoreException {
        UserStoreManager manager = this.getUserStoreWithSharedRoles();
        if (manager == null) {
            throw new UserStoreException("Share Groups are not supported by this realm");
        }
        String[] sharedRoles = null;
        try {
            sharedRoles = ((AbstractUserStoreManager)manager).doGetSharedRoleNames(tenantDomain, filter, maxItemLimit);
        }
        catch (UserStoreException e) {
            throw new UserStoreException("Error while retrieving shared roles", (Throwable)((Object)e));
        }
        return UserCoreUtil.removeDomainFromNames(sharedRoles);
    }

    public String[] getSharedRoleNames(String filter, int maxItemLimit) throws UserStoreException {
        UserStoreManager manager = this.getUserStoreWithSharedRoles();
        if (manager == null) {
            throw new UserStoreException("Share Groups are not supported by this realm");
        }
        String[] sharedRoles = null;
        try {
            sharedRoles = ((AbstractUserStoreManager)manager).doGetSharedRoleNames(null, filter, maxItemLimit);
        }
        catch (UserStoreException e) {
            throw new UserStoreException("Error while retrieving shared roles", (Throwable)((Object)e));
        }
        return UserCoreUtil.removeDomainFromNames(sharedRoles);
    }

    public void addInternalRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permission) throws UserStoreException {
        this.doAddInternalRole(roleName, userList, permission);
    }

    private UserStoreManager getUserStoreWithSharedRoles() throws UserStoreException {
        UserStoreManager sharedRoleManager = null;
        if (this.isSharedGroupEnabled()) {
            return this;
        }
        for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
            UserStoreManager manager = entry.getValue();
            if (manager == null || !((AbstractUserStoreManager)manager).isSharedGroupEnabled()) continue;
            if (sharedRoleManager != null) {
                throw new UserStoreException("There can not be more than one user store that supportshared groups");
            }
            sharedRoleManager = manager;
        }
        return sharedRoleManager;
    }

    public boolean isUserInRole(String userName, String roleName) throws UserStoreException {
        String[] internalRoles;
        if (roleName == null || roleName.trim().length() == 0 || userName == null || userName.trim().length() == 0) {
            return false;
        }
        if ("system/wso2.anonymous.role".equalsIgnoreCase(roleName) && "wso2.anonymous.user".equalsIgnoreCase(userName)) {
            return true;
        }
        if (!"wso2.anonymous.user".equalsIgnoreCase(userName) && this.realmConfig.getEveryOneRoleName().equalsIgnoreCase(roleName) && !this.systemUserRoleManager.isExistingSystemUser(UserCoreUtil.removeDomainFromName(userName))) {
            return true;
        }
        String[] roles = null;
        try {
            roles = this.getRoleListOfUserFromCache(this.tenantId, userName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (roles != null && UserCoreUtil.isContain(roleName, roles)) {
            return true;
        }
        String modifiedUserName = "isUserHasTheRole" + userName;
        try {
            roles = this.getRoleListOfUserFromCache(this.tenantId, modifiedUserName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (roles != null && UserCoreUtil.isContain(roleName, roles)) {
            return true;
        }
        if ("Internal".equalsIgnoreCase(UserCoreUtil.extractDomainFromName(roleName)) && UserCoreUtil.isContain(roleName, internalRoles = this.doGetInternalRoleListOfUser(userName, "*"))) {
            this.addToIsUserHasRole(modifiedUserName, roleName, roles);
            return true;
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().isUserInRole(userStore.getDomainFreeName(), roleName);
        }
        if (userStore.isSystemStore()) {
            return this.systemUserRoleManager.isUserInRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromName(roleName));
        }
        if (this.realmConfig.isPrimary() && roleName.equalsIgnoreCase(this.realmConfig.getAdminRoleName()) && userName.equalsIgnoreCase(this.realmConfig.getAdminUserName())) {
            return true;
        }
        String roleDomainName = UserCoreUtil.extractDomainFromName(roleName);
        String roleDomainNameForForest = this.realmConfig.getUserStoreProperty("GroupSearchDomains");
        if (roleDomainNameForForest != null && roleDomainNameForForest.trim().length() > 0) {
            String[] values;
            for (String value : values = roleDomainNameForForest.split("#")) {
                if (value == null || value.trim().equalsIgnoreCase(roleDomainName)) continue;
                return false;
            }
        } else if (!userStore.getDomainName().equalsIgnoreCase(roleDomainName)) {
            return false;
        }
        boolean success = false;
        if (this.readGroupsEnabled) {
            success = this.doCheckIsUserInRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromName(roleName));
        }
        if (success) {
            this.addToIsUserHasRole(modifiedUserName, roleName, roles);
        }
        return success;
    }

    public abstract boolean doCheckIsUserInRole(String var1, String var2) throws UserStoreException;

    private void addToIsUserHasRole(String userName, String roleName, String[] currentRoles) {
        ArrayList<Object> roles = currentRoles != null ? new ArrayList<String>(Arrays.asList(currentRoles)) : new ArrayList<String>();
        roles.add(roleName);
        this.addToUserRolesCache(this.tenantId, UserCoreUtil.addDomainToName(userName, this.getMyDomainName()), roles.toArray(new String[roles.size()]));
    }

    @Override
    public boolean isExistingUser(String userName) throws UserStoreException {
        if (UserCoreUtil.isRegistrySystemUser(userName)) {
            return true;
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().isExistingUser(userStore.getDomainFreeName());
        }
        if (userStore.isSystemStore()) {
            this.systemUserRoleManager.isExistingSystemUser(userName);
        }
        return this.doCheckExistingUser(userStore.getDomainFreeName());
    }

    @Override
    public final String[] listUsers(String filter, int maxItemLimit) throws UserStoreException {
        int index = filter.indexOf("/");
        if (index > 0) {
            String domain = filter.substring(0, index);
            UserStoreManager secManager = this.getSecondaryUserStoreManager(domain);
            if (secManager != null) {
                filter = filter.substring(index + 1);
                if (secManager instanceof AbstractUserStoreManager) {
                    return ((AbstractUserStoreManager)secManager).doListUsers(filter, maxItemLimit);
                }
            }
        } else if (index == 0) {
            return this.doListUsers(filter.substring(index + 1), maxItemLimit);
        }
        String[] userList = this.doListUsers(filter, maxItemLimit);
        String primaryDomain = this.realmConfig.getUserStoreProperty("DomainName");
        if (this.getSecondaryUserStoreManager() != null) {
            for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
                UserStoreManager storeManager;
                if (entry.getKey().equalsIgnoreCase(primaryDomain) || !((storeManager = entry.getValue()) instanceof AbstractUserStoreManager)) continue;
                try {
                    String[] secondUserList = ((AbstractUserStoreManager)storeManager).doListUsers(filter, maxItemLimit);
                    userList = UserCoreUtil.combineArrays(userList, secondUserList);
                }
                catch (UserStoreException ex) {
                    log.error((Object)ex);
                }
            }
        }
        return userList;
    }

    @Override
    public final String[] getUserListOfRole(String roleName) throws UserStoreException {
        String[] userNames = new String[]{};
        if (!this.isExistingRole(roleName)) {
            return userNames;
        }
        UserStore userStore = this.getUserStore(roleName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().getUserListOfRole(userStore.getDomainFreeName());
        }
        if (userStore.isSystemStore()) {
            return this.systemUserRoleManager.getUserListOfSystemRole(userStore.getDomainFreeName());
        }
        String[] userNamesInHybrid = new String[]{};
        if (userStore.isHybridRole()) {
            userNamesInHybrid = this.hybridRoleManager.getUserListOfHybridRole(userStore.getDomainFreeName());
            ArrayList<String> finalNameList = new ArrayList<String>();
            String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
            if (userNamesInHybrid != null && userNamesInHybrid.length > 0) {
                if (displayNameAttribute != null && displayNameAttribute.trim().length() > 0) {
                    for (String userName : userNamesInHybrid) {
                        String[] displayNames;
                        String domainName = UserCoreUtil.extractDomainFromName(userName);
                        if (domainName == null || domainName.trim().length() == 0) {
                            finalNameList.add(userName);
                        }
                        UserStoreManager userManager = this.userStoreManagerHolder.get(domainName);
                        userName = UserCoreUtil.removeDomainFromName(userName);
                        if (userManager == null) continue;
                        for (String displayName : displayNames = ((AbstractUserStoreManager)userManager).doGetDisplayNamesForInternalRole(new String[]{userName})) {
                            String nameWithDomain = UserCoreUtil.addDomainToName(displayName, domainName);
                            finalNameList.add(nameWithDomain);
                        }
                    }
                } else {
                    return userNamesInHybrid;
                }
            }
            return finalNameList.toArray(new String[finalNameList.size()]);
        }
        if (this.readGroupsEnabled) {
            userNames = this.doGetUserListOfRole(roleName, "*");
        }
        return userNames;
    }

    @Override
    public String[] getRoleListOfUser(String userName) throws UserStoreException {
        String[] roleNames = null;
        if (!this.isExistingUser(userName)) {
            return new String[0];
        }
        try {
            roleNames = this.getRoleListOfUserFromCache(this.tenantId, userName);
            if (roleNames != null) {
                return roleNames;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().getRoleListOfUser(userStore.getDomainFreeName());
        }
        if (userStore.isSystemStore()) {
            return this.systemUserRoleManager.getSystemRoleListOfUser(userStore.getDomainFreeName());
        }
        roleNames = this.doGetRoleListOfUser(userName, "*");
        this.addToUserRolesCache(this.tenantId, UserCoreUtil.addDomainToName(userName, this.getMyDomainName()), roleNames);
        return roleNames;
    }

    public ClaimManager getClaimManager() {
        return this.claimManager;
    }

    public void addRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions, boolean isSharedRole) throws org.wso2.carbon.user.api.UserStoreException {
        UserStore userStore = this.getUserStore(roleName);
        if (isSharedRole && !this.isSharedGroupEnabled()) {
            throw new org.wso2.carbon.user.api.UserStoreException("User store doesn't support shared user roles functionality");
        }
        if (userStore.isHybridRole()) {
            this.doAddInternalRole(userStore.getDomainFreeName(), userList, permissions);
            return;
        }
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().addRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(userList), permissions, isSharedRole);
            return;
        }
        if (roleName.indexOf("/") > 0) {
            roleName = userStore.getDomainFreeName();
            userList = UserCoreUtil.removeDomainFromNames(userList);
        }
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreAddRole(roleName, userList, permissions, this)) continue;
            return;
        }
        if (this.isReadOnly()) {
            throw new UserStoreException("Cannot add role to Read Only user store unless it is primary");
        }
        if (!this.isRoleNameValid(roleName)) {
            String regEx = this.realmConfig.getUserStoreProperty("RolenameJavaRegEx");
            throw new UserStoreException("Role name not valid. Role name must be a non null string with following format, " + regEx);
        }
        if (this.doCheckExistingRole(roleName)) {
            throw new UserStoreException("Role name: " + roleName + " in the system. Please pick another role name.");
        }
        String roleWithDomain = null;
        if (this.isReadOnly() || !this.writeGroupsEnabled) {
            throw new UserStoreException("Role cannot be added. User store is read only or cannot write groups.");
        }
        this.doAddRole(roleName, userList, isSharedRole);
        roleWithDomain = UserCoreUtil.addDomainToName(roleName, this.getMyDomainName());
        if (permissions != null) {
            for (org.wso2.carbon.user.api.Permission permission : permissions) {
                String resourceId = permission.getResourceId();
                String action = permission.getAction();
                if (resourceId == null || resourceId.trim().length() == 0) continue;
                if (action == null || action.trim().length() == 0) {
                    action = "read";
                }
                this.userRealm.getAuthorizationManager().authorizeRole(roleWithDomain, resourceId, action);
            }
        }
        if (userList != null && userList.length > 0) {
            this.clearUserRolesCacheByTenant(this.tenantId);
        }
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostAddRole(roleName, userList, permissions, this)) continue;
            return;
        }
    }

    public boolean isSharedGroupEnabled() {
        String value = this.realmConfig.getUserStoreProperty("SharedGroupEnabled");
        try {
            return this.realmConfig.isPrimary() && !this.isReadOnly() && TRUE_VALUE.equalsIgnoreCase(value);
        }
        catch (UserStoreException e) {
            log.error((Object)e);
            return false;
        }
    }

    protected void filterSharedRoles(List<String> sharedRoles, String tenantDomain) {
        if (tenantDomain != null) {
            Iterator<String> i = sharedRoles.iterator();
            while (i.hasNext()) {
                String role = i.next();
                if (role.indexOf(tenantDomain) <= -1) continue;
                i.remove();
            }
        }
    }

    @Override
    public final void deleteRole(String roleName) throws UserStoreException {
        if (UserCoreUtil.isPrimaryAdminRole(roleName, this.realmConfig)) {
            throw new UserStoreException("Cannot delete admin role");
        }
        if (UserCoreUtil.isEveryoneRole(roleName, this.realmConfig)) {
            throw new UserStoreException("Cannot delete everyone role");
        }
        UserStore userStore = this.getUserStore(roleName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().deleteRole(userStore.getDomainFreeName());
            return;
        }
        if (userStore.isHybridRole()) {
            this.hybridRoleManager.deleteHybridRole(userStore.getDomainFreeName());
            this.clearUserRolesCacheByTenant(this.tenantId);
            return;
        }
        if (!this.doCheckExistingRole(roleName)) {
            throw new UserStoreException("Can not delete non exiting role");
        }
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreDeleteRole(roleName, this)) continue;
            return;
        }
        if (this.isReadOnly() || !this.writeGroupsEnabled) {
            throw new UserStoreException("Role cannot be deleted. User store is read only or cannot write groups.");
        }
        this.doDeleteRole(roleName);
        this.userRealm.getAuthorizationManager().clearRoleAuthorization(roleName);
        this.clearUserRolesCacheByTenant(this.tenantId);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostDeleteRole(roleName, this)) continue;
            return;
        }
    }

    private UserStore getUserStore(String user) throws UserStoreException {
        String domain;
        int index = user.indexOf("/");
        UserStore userStore = new UserStore();
        String domainFreeName = null;
        if (index > 0) {
            domain = user.substring(0, index);
            UserStoreManager secManager = this.getSecondaryUserStoreManager(domain);
            domainFreeName = user.substring(index + 1);
            if (secManager != null) {
                userStore.setUserStoreManager((AbstractUserStoreManager)secManager);
                userStore.setDomainAwareName(user);
                userStore.setDomainFreeName(domainFreeName);
                userStore.setDomainName(domain);
                userStore.setRecurssive(true);
                return userStore;
            }
            if (!domain.equalsIgnoreCase(this.getMyDomainName())) {
                if ("Internal".equalsIgnoreCase(domain)) {
                    userStore.setHybridRole(true);
                } else if ("SYSTEM".equalsIgnoreCase(domain)) {
                    userStore.setSystemStore(true);
                } else {
                    throw new UserStoreException("Invalid Domain Name");
                }
            }
        }
        domain = UserCoreUtil.getDomainName(this.realmConfig);
        userStore.setUserStoreManager(this);
        if (index > 0) {
            userStore.setDomainAwareName(user);
            userStore.setDomainFreeName(domainFreeName);
        } else {
            userStore.setDomainAwareName(domain + "/" + user);
            userStore.setDomainFreeName(user);
        }
        userStore.setRecurssive(false);
        userStore.setDomainName(domain);
        return userStore;
    }

    @Override
    public final UserStoreManager getSecondaryUserStoreManager() {
        return this.secondaryUserStoreManager;
    }

    @Override
    public final UserStoreManager getSecondaryUserStoreManager(String userDomain) {
        if (userDomain == null) {
            return null;
        }
        return this.userStoreManagerHolder.get(userDomain.toUpperCase());
    }

    @Override
    public final void setSecondaryUserStoreManager(UserStoreManager secondaryUserStoreManager) {
        this.secondaryUserStoreManager = secondaryUserStoreManager;
    }

    @Override
    public final void addSecondaryUserStoreManager(String userDomain, UserStoreManager userStoreManager) {
        if (userDomain != null) {
            this.userStoreManagerHolder.put(userDomain.toUpperCase(), userStoreManager);
        }
    }

    @Override
    public final String[] getAllSecondaryRoles() throws UserStoreException {
        ArrayList roleList = new ArrayList();
        for (UserStoreManager secondary = this.getSecondaryUserStoreManager(); secondary != null; secondary = secondary.getSecondaryUserStoreManager()) {
            String[] roles = secondary.getRoleNames(true);
            if (roles == null || roles.length <= 0) continue;
            Collections.addAll(roleList, roles);
        }
        return roleList.toArray(new String[roleList.size()]);
    }

    public boolean isSCIMEnabled() {
        String scimEnabled = this.realmConfig.getUserStoreProperty("SCIMEnabled");
        if (scimEnabled != null) {
            return Boolean.parseBoolean(scimEnabled);
        }
        return false;
    }

    @Override
    public final String[] getHybridRoles() throws UserStoreException {
        return this.hybridRoleManager.getHybridRoles("*");
    }

    @Override
    public final String[] getRoleNames() throws UserStoreException {
        return this.getRoleNames(false);
    }

    @Override
    public final String[] getRoleNames(boolean noHybridRoles) throws UserStoreException {
        return this.getRoleNames("*", -1, noHybridRoles, true, true);
    }

    protected void doAddInternalRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions) throws UserStoreException {
        if (this.hybridRoleManager.isExistingRole(UserCoreUtil.removeDomainFromName(roleName))) {
            throw new UserStoreException("Role name: " + roleName + " in the system. Please pick another role name.");
        }
        this.hybridRoleManager.addHybridRole(UserCoreUtil.removeDomainFromName(roleName), userList);
        if (permissions != null) {
            for (org.wso2.carbon.user.api.Permission permission : permissions) {
                String resourceId = permission.getResourceId();
                String action = permission.getAction();
                this.userRealm.getAuthorizationManager().authorizeRole(UserCoreUtil.addInternalDomainName(roleName), resourceId, action);
            }
        }
        if (userList != null && userList.length > 0) {
            this.clearUserRolesCacheByTenant(this.tenantId);
        }
    }

    protected abstract String[] doGetSharedRoleNames(String var1, String var2, int var3) throws UserStoreException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String[] getRoleNames(String filter, int maxItemLimit, boolean noInternalRoles, boolean noSystemRole, boolean noSharedRoles) throws UserStoreException {
        int index;
        String[] roleList = new String[]{};
        if (!noInternalRoles) {
            roleList = this.hybridRoleManager.getHybridRoles(UserCoreUtil.removeDomainFromName(filter));
        }
        if (!noSystemRole) {
            String[] systemRoles = this.systemUserRoleManager.getSystemRoles();
            roleList = UserCoreUtil.combineArrays(roleList, systemRoles);
        }
        if ((index = filter.indexOf("/")) > 0) {
            String domain = filter.substring(0, index);
            UserStoreManager secManager = this.getSecondaryUserStoreManager(domain);
            if ("Internal".equalsIgnoreCase(domain)) {
                return new String[0];
            }
            if (secManager == null) throw new UserStoreException("Invalid Domain Name");
            filter = filter.substring(index + 1);
            if (secManager instanceof AbstractUserStoreManager) {
                String[] externalRoles = ((AbstractUserStoreManager)secManager).doGetRoleNames(filter, maxItemLimit);
                return UserCoreUtil.combineArrays(roleList, externalRoles);
            }
        } else if (index == 0) {
            String[] externalRoles = this.doGetRoleNames(filter.substring(index + 1), maxItemLimit);
            return UserCoreUtil.combineArrays(roleList, externalRoles);
        }
        String[] externalRoles = this.doGetRoleNames(filter, maxItemLimit);
        roleList = UserCoreUtil.combineArrays(externalRoles, roleList);
        String primaryDomain = this.getMyDomainName();
        if (this.getSecondaryUserStoreManager() == null) return roleList;
        for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
            UserStoreManager storeManager;
            if (entry.getKey().equalsIgnoreCase(primaryDomain) || !((storeManager = entry.getValue()) instanceof AbstractUserStoreManager)) continue;
            try {
                String[] secondRoleList = ((AbstractUserStoreManager)storeManager).doGetRoleNames(filter, maxItemLimit);
                roleList = UserCoreUtil.combineArrays(roleList, secondRoleList);
            }
            catch (UserStoreException e) {
                log.error((Object)e);
            }
        }
        return roleList;
    }

    private Map<String, String> doGetUserClaimValues(String userName, String[] claims, String domainName, String profileName) throws UserStoreException {
        boolean requireRoles = false;
        boolean requireIntRoles = false;
        boolean requireExtRoles = false;
        String roleClaim = null;
        if (profileName == null || profileName.trim().length() == 0) {
            profileName = "default";
        }
        HashSet<String> propertySet = new HashSet<String>();
        for (String claim : claims) {
            String property = null;
            try {
                property = this.getClaimAtrribute(claim, userName, domainName);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            if (!(property == null || "http://wso2.org/claims/role".equalsIgnoreCase(claim) && "http://wso2.org/claims/role/internal".equalsIgnoreCase(claim) && "http://wso2.org/claims/role/external".equalsIgnoreCase(claim))) {
                propertySet.add(property);
            }
            if ("http://wso2.org/claims/role".equalsIgnoreCase(claim)) {
                requireRoles = true;
                roleClaim = claim;
                continue;
            }
            if ("http://wso2.org/claims/role/internal".equalsIgnoreCase(claim)) {
                requireIntRoles = true;
                roleClaim = claim;
                continue;
            }
            if (!"http://wso2.org/claims/role/external".equalsIgnoreCase(claim)) continue;
            requireExtRoles = true;
            roleClaim = claim;
        }
        String[] properties = propertySet.toArray(new String[propertySet.size()]);
        Map<String, String> uerProperties = this.getUserPropertyValues(userName, properties, profileName);
        ArrayList getAgain = new ArrayList();
        HashMap<String, String> finalValues = new HashMap<String, String>();
        for (String claim : claims) {
            ClaimMapping mapping;
            try {
                mapping = (ClaimMapping)this.claimManager.getClaimMapping(claim);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            if (mapping == null) continue;
            String property = null;
            if (domainName != null) {
                Map attrMap = mapping.getMappedAttributes();
                if (attrMap != null) {
                    String attr = null;
                    attr = (String)attrMap.get(domainName.toUpperCase());
                    property = attr != null ? attr : mapping.getMappedAttribute();
                }
            } else {
                property = mapping.getMappedAttribute();
            }
            String value = uerProperties.get(property);
            if (profileName.equals("default")) {
                if (value == null || value.trim().length() <= 0) continue;
                finalValues.put(claim, value);
                continue;
            }
            if (value == null || value.trim().length() <= 0) continue;
            finalValues.put(claim, value);
        }
        if (getAgain.size() > 0) {
            Map<String, String> mapClaimValues = this.getUserClaimValues(userName, getAgain.toArray(new String[getAgain.size()]), profileName);
            for (Map.Entry<String, String> entry : mapClaimValues.entrySet()) {
                if (entry.getValue() == null) continue;
                finalValues.put(entry.getKey(), entry.getValue());
            }
        }
        String[] roles = null;
        if (requireRoles) {
            roles = this.getRoleListOfUser(userName);
        } else if (requireIntRoles) {
            roles = this.doGetInternalRoleListOfUser(userName, "*");
        } else if (requireExtRoles) {
            String[] sharedRoles;
            ArrayList<String> rolesList = new ArrayList<String>();
            String[] externalRoles = this.doGetExternalRoleListOfUser(userName, "*");
            rolesList.addAll(Arrays.asList(externalRoles));
            if (this.isSharedGroupEnabled() && (sharedRoles = this.doGetSharedRoleListOfUser(userName, null, "*")) != null) {
                rolesList.addAll(Arrays.asList(sharedRoles));
            }
            roles = rolesList.toArray(new String[rolesList.size()]);
        }
        if (roles != null && roles.length > 0) {
            String delim = "";
            StringBuffer roleBf = new StringBuffer();
            for (String role : roles) {
                roleBf.append(delim).append(role);
                delim = ",";
            }
            finalValues.put(roleClaim, roleBf.toString());
        }
        return finalValues;
    }

    protected String getEveryOneRoleName() {
        return this.realmConfig.getEveryOneRoleName();
    }

    protected String getAdminRoleName() {
        return this.realmConfig.getAdminRoleName();
    }

    protected boolean checkUserPasswordValid(Object credential) throws UserStoreException {
        if (credential == null) {
            return false;
        }
        if (!(credential instanceof String)) {
            throw new UserStoreException("Can handle only string type credentials");
        }
        String password = ((String)credential).trim();
        if (password.length() < 1) {
            return false;
        }
        String regularExpression = this.realmConfig.getUserStoreProperty("PasswordJavaRegEx");
        return regularExpression == null || this.isFormatCorrect(regularExpression, password);
    }

    protected boolean checkUserNameValid(String userName) throws UserStoreException {
        if (userName == null || "wso2.system.user".equals(userName)) {
            return false;
        }
        if ((userName = userName.trim()).length() < 1) {
            return false;
        }
        String regularExpression = this.realmConfig.getUserStoreProperty("UsernameJavaRegEx");
        if (MultitenantUtils.isEmailUserName() && (regularExpression = this.realmConfig.getUserStoreProperty("UsernameWithEmailJavaScriptRegEx")) == null) {
            regularExpression = "^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$";
        }
        if (regularExpression != null) {
            regularExpression = regularExpression.trim();
        }
        return regularExpression == null || regularExpression.equals("") || this.isFormatCorrect(regularExpression, userName);
    }

    protected boolean isRoleNameValid(String roleName) {
        if (roleName == null) {
            return false;
        }
        if (roleName.length() < 1) {
            return false;
        }
        String regularExpression = this.realmConfig.getUserStoreProperty("RolenameJavaRegEx");
        return regularExpression == null || this.isFormatCorrect(regularExpression, roleName);
    }

    protected String[] getRoleListOfUserFromCache(int tenantID, String userName) {
        if (this.userRolesCache != null) {
            return this.userRolesCache.getRolesListOfUser(this.cacheIdentifier, tenantID, userName);
        }
        return null;
    }

    protected void clearUserRolesCacheByTenant(int tenantID) {
        if (this.userRolesCache != null) {
            this.userRolesCache.clearCacheByTenant(tenantID);
        }
        AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
        authorizationCache.clearCacheByTenant(tenantID);
    }

    protected void clearUserRolesCache(String userName) {
        if (this.userRolesCache != null) {
            this.userRolesCache.clearCacheEntry(this.cacheIdentifier, this.tenantId, userName);
        }
        AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
        authorizationCache.clearCacheByUser(this.tenantId, userName);
    }

    protected void addToUserRolesCache(int tenantID, String userName, String[] roleList) {
        if (this.userRolesCache != null) {
            this.userRolesCache.addToCache(this.cacheIdentifier, tenantID, userName, roleList);
            AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
            authorizationCache.clearCacheByTenant(tenantID);
        }
    }

    protected void initUserRolesCache() {
        String userRolesCacheEnabledString = this.realmConfig.getUserStoreProperty("UserRolesCacheEnabled");
        String userCoreCacheIdentifier = this.realmConfig.getUserStoreProperty("UserCoreCacheIdentifier");
        this.cacheIdentifier = userCoreCacheIdentifier != null && userCoreCacheIdentifier.trim().length() > 0 ? userCoreCacheIdentifier : "defaultCacheDomain";
        if (userRolesCacheEnabledString != null && !userRolesCacheEnabledString.equals("")) {
            this.userRolesCacheEnabled = Boolean.parseBoolean(userRolesCacheEnabledString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User Roles Cache is configured to:" + userRolesCacheEnabledString));
            }
        } else if (log.isDebugEnabled()) {
            log.info((Object)("User Roles Cache is not configured. Default value: " + this.userRolesCacheEnabled + " is taken."));
        }
        if (this.userRolesCacheEnabled) {
            int timeOut = 5;
            String timeOutString = this.realmConfig.getUserStoreProperty("UserCoreCacheTimeOut");
            if (timeOutString != null) {
                timeOut = Integer.parseInt(timeOutString);
            }
            this.userRolesCache = UserRolesCache.getInstance();
            this.userRolesCache.setTimeOut(timeOut);
        }
    }

    private boolean isFormatCorrect(String regularExpression, String attribute) {
        Pattern p2 = Pattern.compile(regularExpression);
        Matcher m2 = p2.matcher(attribute);
        return m2.matches();
    }

    protected String replaceEscapeCharacters(String userName) {
        String replaceEscapeCharactersAtUserLoginString;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Replacing excape characters in " + userName));
        }
        if ((replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin")) != null) {
            this.replaceEscapeCharactersAtUserLogin = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters at userlogin is condifured to: " + replaceEscapeCharactersAtUserLoginString));
            }
            if (this.replaceEscapeCharactersAtUserLogin) {
                return userName.replaceAll("\\\\", "\\\\\\\\");
            }
        }
        return userName;
    }

    public RoleDTO[] getAllSecondaryRoleDTOs() throws UserStoreException {
        ArrayList roleList = new ArrayList();
        for (UserStoreManager secondary = this.getSecondaryUserStoreManager(); secondary != null; secondary = secondary.getSecondaryUserStoreManager()) {
            String domain = secondary.getRealmConfiguration().getUserStoreProperty("DomainName");
            String[] roles = secondary.getRoleNames(true);
            if (roles == null || roles.length <= 0) continue;
            Collections.addAll(roleList, UserCoreUtil.convertRoleNamesToRoleDTO(roles, domain));
        }
        return roleList.toArray(new RoleDTO[roleList.size()]);
    }

    public void addSystemRole(String roleName, String[] userList, Permission[] permissions) throws UserStoreException {
        if (!this.isRoleNameValid(roleName)) {
            String regEx = this.realmConfig.getUserStoreProperty("RolenameJavaRegEx");
            throw new UserStoreException("Role name not valid. Role name must be a non null string with following format, " + regEx);
        }
        if (this.systemUserRoleManager.isExistingRole(roleName)) {
            throw new UserStoreException("Role name: " + roleName + " in the system. Please pick another role name.");
        }
        this.systemUserRoleManager.addSystemRole(roleName, userList);
    }

    protected abstract String[] doGetUserListOfRole(String var1, String var2) throws UserStoreException;

    public final String[] doGetRoleListOfUser(String userName, String filter) throws UserStoreException {
        String[] internalRoles = this.doGetInternalRoleListOfUser(userName, filter);
        String[] modifiedExternalRoleList = new String[]{};
        if (this.readGroupsEnabled) {
            String[] sharedRoles;
            ArrayList<String> roles = new ArrayList<String>();
            String[] externalRoles = this.doGetExternalRoleListOfUser(userName, "*");
            roles.addAll(Arrays.asList(externalRoles));
            if (this.isSharedGroupEnabled() && (sharedRoles = this.doGetSharedRoleListOfUser(userName, null, "*")) != null) {
                roles.addAll(Arrays.asList(sharedRoles));
            }
            modifiedExternalRoleList = UserCoreUtil.addDomainToNames(roles.toArray(new String[roles.size()]), this.getMyDomainName());
        }
        String[] roleList = UserCoreUtil.combine(internalRoles, Arrays.asList(modifiedExternalRoleList));
        return roleList;
    }

    public final String[] getHybridRoles(String filter) throws UserStoreException {
        return this.hybridRoleManager.getHybridRoles(filter);
    }

    protected List<String> getMappingAttributeList(List<String> claimList) throws UserStoreException {
        ArrayList<String> attributeList = null;
        Iterator<String> claimIter = null;
        attributeList = new ArrayList<String>();
        if (claimList == null) {
            return attributeList;
        }
        claimIter = claimList.iterator();
        while (claimIter.hasNext()) {
            try {
                attributeList.add(this.claimManager.getAttributeName(claimIter.next()));
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
        }
        return attributeList;
    }

    protected void doInitialSetup() throws UserStoreException {
        this.systemUserRoleManager = new SystemUserRoleManager(this.dataSource, this.tenantId);
        this.hybridRoleManager = new HybridRoleManager(this.dataSource, this.tenantId, this.realmConfig, this.userRealm);
    }

    protected void doInitialUserAdding() throws UserStoreException {
        String systemUser = UserCoreUtil.removeDomainFromName("wso2.anonymous.user");
        String systemRole = UserCoreUtil.removeDomainFromName("system/wso2.anonymous.role");
        if (!this.systemUserRoleManager.isExistingSystemUser(systemUser)) {
            this.systemUserRoleManager.addSystemUser(systemUser, UserCoreUtil.getPolicyFriendlyRandomPassword(systemUser), null);
        }
        if (!this.systemUserRoleManager.isExistingRole(systemRole)) {
            this.systemUserRoleManager.addSystemRole(systemRole, new String[]{systemUser});
        }
        if (!this.hybridRoleManager.isExistingRole(UserCoreUtil.removeDomainFromName(this.realmConfig.getEveryOneRoleName()))) {
            this.hybridRoleManager.addHybridRole(UserCoreUtil.removeDomainFromName(this.realmConfig.getEveryOneRoleName()), null);
        }
    }

    protected boolean isInitSetupDone() throws UserStoreException {
        boolean isInitialSetUp = false;
        String systemUser = UserCoreUtil.removeDomainFromName("wso2.anonymous.user");
        String systemRole = UserCoreUtil.removeDomainFromName("system/wso2.anonymous.role");
        if (this.systemUserRoleManager.isExistingSystemUser(systemUser)) {
            isInitialSetUp = true;
        }
        if (this.systemUserRoleManager.isExistingRole(systemRole)) {
            isInitialSetUp = true;
        }
        return isInitialSetUp;
    }

    protected void addInitialAdminData(boolean addAdmin, boolean initialSetup) throws UserStoreException {
        String message;
        String message2;
        boolean isInternalRole;
        String adminRoleName;
        String adminUserName;
        block52: {
            if (this.realmConfig.getAdminRoleName() == null || this.realmConfig.getAdminUserName() == null) {
                log.error((Object)"Admin user name or role name is not valid. Please provide valid values.");
                throw new UserStoreException("Admin user name or role name is not valid. Please provide valid values.");
            }
            adminUserName = UserCoreUtil.removeDomainFromName(this.realmConfig.getAdminUserName());
            adminRoleName = UserCoreUtil.removeDomainFromName(this.realmConfig.getAdminRoleName());
            boolean userExist = false;
            boolean roleExist = false;
            isInternalRole = false;
            try {
                if (Boolean.parseBoolean(this.getRealmConfiguration().getUserStoreProperty("ReadGroups"))) {
                    roleExist = this.doCheckExistingRole(adminRoleName);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!roleExist) {
                try {
                    roleExist = this.hybridRoleManager.isExistingRole(adminRoleName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (roleExist) {
                    isInternalRole = true;
                }
            }
            try {
                userExist = this.doCheckExistingUser(adminUserName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!userExist) {
                if (this.isReadOnly()) {
                    message2 = "Admin user can not be created in primary user store. User store is read only. Please pick a user name which is exist in the primary user store as Admin user";
                    if (initialSetup) {
                        throw new UserStoreException(message2);
                    }
                    if (log.isDebugEnabled()) {
                        log.error((Object)message2);
                    }
                } else if (addAdmin) {
                    try {
                        this.doAddUser(adminUserName, this.realmConfig.getAdminPassword(), null, null, null, false);
                    }
                    catch (Exception e) {
                        message = "Admin user has not been created. Error occurs while creating Admin user in primary user store.";
                        if (initialSetup) {
                            throw new UserStoreException(message, e);
                        }
                        if (log.isDebugEnabled()) {
                            log.error((Object)message, (Throwable)e);
                        }
                    }
                } else if (initialSetup) {
                    message2 = "Admin user can not be created in primary user store. Add-Admin has been set to false. Please pick a User name which is exist in the primary user store as Admin user";
                    if (initialSetup) {
                        throw new UserStoreException(message2);
                    }
                    if (log.isDebugEnabled()) {
                        log.error((Object)message2);
                    }
                }
            }
            if (!roleExist) {
                if (addAdmin) {
                    if (!this.isReadOnly() && this.writeGroupsEnabled) {
                        try {
                            this.doAddRole(adminRoleName, new String[]{adminUserName}, false);
                        }
                        catch (org.wso2.carbon.user.api.UserStoreException e) {
                            message = "Admin role has not been created. Error occurs while creating Admin role in primary user store.";
                            if (initialSetup) {
                                throw new UserStoreException(message, e);
                            }
                            if (log.isDebugEnabled()) {
                                log.error((Object)message, (Throwable)e);
                            }
                            break block52;
                        }
                    }
                    try {
                        this.hybridRoleManager.addHybridRole(adminRoleName, new String[]{adminUserName});
                        isInternalRole = true;
                    }
                    catch (Exception e) {
                        message = "Admin role has not been created. Error occurs while creating Admin role in primary user store.";
                        if (initialSetup) {
                            throw new UserStoreException(message, e);
                        }
                        if (log.isDebugEnabled()) {
                            log.error((Object)message, (Throwable)e);
                        }
                        break block52;
                    }
                }
                message2 = "Admin role can not be created in primary user store. Add-Admin has been set to false. Please pick a Role name which is exist in the primary user store as Admin Role";
                if (initialSetup) {
                    throw new UserStoreException(message2);
                }
                if (log.isDebugEnabled()) {
                    log.error((Object)message2);
                }
            }
        }
        if (isInternalRole) {
            block53: {
                if (!this.hybridRoleManager.isUserInRole(adminUserName, adminRoleName)) {
                    try {
                        this.hybridRoleManager.updateHybridRoleListOfUser(adminUserName, null, new String[]{adminRoleName});
                    }
                    catch (Exception e) {
                        message = "Admin user has not been assigned to Admin role. Error while assignment is done";
                        if (initialSetup) {
                            throw new UserStoreException(message, e);
                        }
                        if (!log.isDebugEnabled()) break block53;
                        log.error((Object)message, (Throwable)e);
                    }
                }
            }
            this.realmConfig.setAdminRoleName(UserCoreUtil.addInternalDomainName(adminRoleName));
        } else if (!this.isReadOnly() && this.writeGroupsEnabled && !this.doCheckIsUserInRole(adminUserName, adminRoleName)) {
            if (addAdmin) {
                try {
                    this.doUpdateRoleListOfUser(adminUserName, null, new String[]{adminRoleName});
                }
                catch (Exception e) {
                    message = "Admin user has not been assigned to Admin role. Error while assignment is done";
                    if (initialSetup) {
                        throw new UserStoreException(message, e);
                    }
                    if (log.isDebugEnabled()) {
                        log.error((Object)message, (Throwable)e);
                    }
                }
            } else {
                message2 = "Admin user can not be assigned to Admin role Add-Admin has been set to false. Please do the assign it in user store level";
                if (initialSetup) {
                    throw new UserStoreException(message2);
                }
                if (log.isDebugEnabled()) {
                    log.error((Object)message2);
                }
            }
        }
        this.doInitialUserAdding();
    }

    public Map<String, Integer> getMaxListCount(String type) throws UserStoreException {
        if (!type.equals("MaxUserNameListLength") && !type.equals("MaxRoleNameListLength")) {
            throw new UserStoreException("Invalid count parameter");
        }
        if (type.equals("MaxUserNameListLength") && this.maxUserListCount != null) {
            return this.maxUserListCount;
        }
        if (type.equals("MaxRoleNameListLength") && this.maxRoleListCount != null) {
            return this.maxRoleListCount;
        }
        HashMap<String, Integer> maxListCount = new HashMap<String, Integer>();
        for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
            UserStoreManager storeManager = entry.getValue();
            if (!(storeManager instanceof AbstractUserStoreManager)) continue;
            String maxConfig = storeManager.getRealmConfiguration().getUserStoreProperty(type);
            if (maxConfig == null) {
                maxConfig = MAX_LIST_LENGTH;
            }
            maxListCount.put(entry.getKey(), Integer.parseInt(maxConfig));
        }
        if (this.realmConfig.getUserStoreProperty("DomainName") == null) {
            String maxConfig = this.realmConfig.getUserStoreProperty(type);
            if (maxConfig == null) {
                maxConfig = MAX_LIST_LENGTH;
            }
            maxListCount.put(null, Integer.parseInt(maxConfig));
        }
        if (type.equals("MaxUserNameListLength")) {
            this.maxUserListCount = maxListCount;
            return this.maxUserListCount;
        }
        if (type.equals("MaxRoleNameListLength")) {
            this.maxRoleListCount = maxListCount;
            return this.maxRoleListCount;
        }
        throw new UserStoreException("Invalid count parameter");
    }

    protected String getMyDomainName() {
        return UserCoreUtil.getDomainName(this.realmConfig);
    }

    protected void persistDomain() throws UserStoreException {
        String domain = UserCoreUtil.getDomainName(this.realmConfig);
        if (domain != null) {
            UserCoreUtil.persistDomain(domain, this.tenantId, this.dataSource);
        }
    }

    public void deletePersistedDomain(String domain) throws UserStoreException {
        if (domain != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting persisted domain " + domain));
            }
            UserCoreUtil.deletePersistedDomain(domain, this.tenantId, this.dataSource);
        }
    }

    public void updatePersistedDomain(String oldDomain, String newDomain) throws UserStoreException {
        if (oldDomain != null && newDomain != null) {
            for (RealmConfiguration realmConfigTmp = this.getRealmConfiguration(); realmConfigTmp != null; realmConfigTmp = realmConfigTmp.getSecondaryRealmConfig()) {
                String domainName = realmConfigTmp.getUserStoreProperty("DomainName");
                if (!newDomain.equalsIgnoreCase(domainName)) continue;
                throw new UserStoreException("Cannot update persisted domain name " + oldDomain + " into " + newDomain + ". New domain name already in use");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Renaming persisted domain " + oldDomain + " to " + newDomain));
            }
            UserCoreUtil.updatePersistedDomain(oldDomain, newDomain, this.tenantId, this.dataSource);
        }
    }

    public boolean isSharedRole(String roleName, String roleNameBase) {
        return this.isSharedGroupEnabled();
    }

    protected boolean isOwnRole(String roleName) {
        return true;
    }

    public void addRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions) throws org.wso2.carbon.user.api.UserStoreException {
        this.addRole(roleName, userList, permissions, false);
    }

    public boolean isOthersSharedRole(String roleName) {
        return false;
    }

    public void notifyListeners(String domainName) {
        for (UserStoreManagerConfigurationListener aListener : this.listener) {
            aListener.propertyChange(domainName);
        }
    }

    public void addChangeListener(UserStoreManagerConfigurationListener newListener) {
        this.listener.add(newListener);
    }

    private UserStoreManager createSecondaryUserStoreManager(RealmConfiguration realmConfig, UserRealm realm) throws UserStoreException {
        realmConfig.setEveryOneRoleName(this.realmConfig.getEveryOneRoleName());
        realmConfig.setAdminUserName(this.realmConfig.getAdminUserName());
        realmConfig.setAdminRoleName(this.realmConfig.getAdminRoleName());
        String className = realmConfig.getUserStoreClass();
        if (className == null) {
            String errmsg = "Unable to add user store. UserStoreManager class name is null.";
            log.error((Object)errmsg);
            throw new UserStoreException(errmsg);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("um.datasource", this.dataSource);
        properties.put("FistStartupCheck", false);
        Class[] initClassOpt1 = new Class[]{RealmConfiguration.class, Map.class, ClaimManager.class, ProfileConfigurationManager.class, UserRealm.class, Integer.class};
        Object[] initObjOpt1 = new Object[]{realmConfig, properties, realm.getClaimManager(), null, realm, this.tenantId};
        Class[] initClassOpt2 = new Class[]{RealmConfiguration.class, Map.class, ClaimManager.class, ProfileConfigurationManager.class, UserRealm.class};
        Object[] initObjOpt2 = new Object[]{realmConfig, properties, realm.getClaimManager(), null, realm};
        Class[] initClassOpt3 = new Class[]{RealmConfiguration.class, Map.class};
        Object[] initObjOpt3 = new Object[]{realmConfig, properties};
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = null;
            Object newObject = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start initializing class with the first option");
            }
            try {
                constructor = clazz.getConstructor(initClassOpt1);
                newObject = constructor.newInstance(initObjOpt1);
                return newObject;
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannont initialize " + className + " using the option 1"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"End initializing class with the first option");
                }
                try {
                    constructor = clazz.getConstructor(initClassOpt2);
                    newObject = constructor.newInstance(initObjOpt2);
                    return newObject;
                }
                catch (NoSuchMethodException e2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cannont initialize " + className + " using the option 2"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"End initializing class with the second option");
                    }
                    try {
                        constructor = clazz.getConstructor(initClassOpt3);
                        newObject = constructor.newInstance(initObjOpt3);
                        return newObject;
                    }
                    catch (NoSuchMethodException e3) {
                        String message = "Cannot initialize " + className + ". Error " + e3.getMessage();
                        log.error((Object)message);
                        throw new UserStoreException(message);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)("Cannot create " + className), e);
            throw new UserStoreException(e.getMessage() + "Type " + e.getClass(), e);
        }
    }

    public void addSecondaryUserStoreManager(RealmConfiguration userStoreRealmConfig, UserRealm realm) throws UserStoreException {
        UserStoreManager manager = this.createSecondaryUserStoreManager(userStoreRealmConfig, realm);
        String domainName = userStoreRealmConfig.getUserStoreProperty("DomainName");
        if (domainName != null) {
            if (this.getSecondaryUserStoreManager(domainName) != null) {
                String errmsg = "Could not initialize new user store manager.Duplicate domain names not allowed.";
                log.error((Object)errmsg);
                throw new UserStoreException(errmsg);
            }
            Boolean isDisabled = false;
            if (userStoreRealmConfig.getUserStoreProperty("Disabled") != null) {
                isDisabled = Boolean.parseBoolean(userStoreRealmConfig.getUserStoreProperty("Disabled"));
                if (isDisabled.booleanValue()) {
                    log.warn((Object)("Secondary user store disabled with domain " + domainName + "."));
                } else {
                    UserStoreManager tmpUserStoreManager = this;
                    while (tmpUserStoreManager.getSecondaryUserStoreManager() != null) {
                        tmpUserStoreManager = tmpUserStoreManager.getSecondaryUserStoreManager();
                    }
                    tmpUserStoreManager.setSecondaryUserStoreManager(manager);
                    this.addSecondaryUserStoreManager(domainName.toUpperCase(), tmpUserStoreManager.getSecondaryUserStoreManager());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("UserStoreManager : " + domainName + "added to the list"));
                    }
                }
            }
        } else {
            log.warn((Object)"Could not initialize new user store manager.  Domain name is not defined");
        }
    }

    public void removeSecondaryUserStoreManager(String userStoreDomainName) throws UserStoreException {
        if (userStoreDomainName == null) {
            throw new UserStoreException("Cannot remove user store. User store domain name is null");
        }
        if ("".equals(userStoreDomainName)) {
            throw new UserStoreException("Cannot remove user store. User store domain name is empty");
        }
        userStoreDomainName = userStoreDomainName.toUpperCase();
        boolean isUSMContainsInMap = false;
        if (this.userStoreManagerHolder.containsKey(userStoreDomainName.toUpperCase())) {
            isUSMContainsInMap = true;
            this.userStoreManagerHolder.remove(userStoreDomainName.toUpperCase());
            if (log.isDebugEnabled()) {
                log.debug((Object)("UserStore: " + userStoreDomainName + " removed from map"));
            }
        }
        boolean isUSMConatainsInChain = false;
        UserStoreManager prevUserStoreManager = this;
        while (prevUserStoreManager.getSecondaryUserStoreManager() != null) {
            UserStoreManager secondaryUSM = prevUserStoreManager.getSecondaryUserStoreManager();
            if (secondaryUSM.getRealmConfiguration().getUserStoreProperty("DomainName").equalsIgnoreCase(userStoreDomainName)) {
                isUSMConatainsInChain = true;
                prevUserStoreManager.setSecondaryUserStoreManager(secondaryUSM.getSecondaryUserStoreManager());
                log.info((Object)("User store: " + userStoreDomainName + " of tenant:" + this.tenantId + " is removed from user store chain."));
                return;
            }
            prevUserStoreManager = secondaryUSM;
        }
        if (!isUSMContainsInMap && isUSMConatainsInChain) {
            throw new UserStoreException("Removed user store manager : " + userStoreDomainName + " didnt exists in userStoreManagerHolder map");
        }
        if (isUSMContainsInMap && !isUSMConatainsInChain) {
            throw new UserStoreException("Removed user store manager : " + userStoreDomainName + " didnt exists in user store manager chain");
        }
    }

    public HybridRoleManager getInternalRoleManager() {
        return this.hybridRoleManager;
    }
}

