/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class BaseIndex
extends SchemaObjectBase
implements Index {
    protected IndexColumn[] indexColumns;
    protected Column[] columns;
    protected int[] columnIds;
    protected Table table;
    protected IndexType indexType;
    protected boolean isMultiVersion;

    protected void initBaseIndex(Table table, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initSchemaObjectBase(table.getSchema(), n, string, "index");
        this.indexType = indexType;
        this.table = table;
        if (indexColumnArray != null) {
            this.indexColumns = indexColumnArray;
            this.columns = new Column[indexColumnArray.length];
            this.columnIds = new int[this.columns.length];
            for (int i = 0; i < this.columns.length; ++i) {
                Column column;
                this.columns[i] = column = indexColumnArray[i].column;
                this.columnIds[i] = column.getColumnId();
            }
        }
    }

    @Override
    public int getRootPageId() {
        return 0;
    }

    @Override
    public abstract void close(Session var1);

    @Override
    public abstract void add(Session var1, Row var2);

    @Override
    public abstract void remove(Session var1, Row var2);

    @Override
    public abstract Cursor find(Session var1, SearchRow var2, SearchRow var3);

    @Override
    public abstract double getCost(Session var1, int[] var2);

    @Override
    public abstract void remove(Session var1);

    @Override
    public abstract void truncate(Session var1);

    @Override
    public abstract boolean canGetFirstOrLast();

    @Override
    public abstract Cursor findFirstOrLast(Session var1, boolean var2);

    @Override
    public abstract boolean needRebuild();

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public DbException getDuplicateKeyException() {
        String string = this.getName() + " ON " + this.table.getSQL() + "(" + this.getColumnListSQL() + ")";
        return DbException.get(23001, string);
    }

    @Override
    public String getPlanSQL() {
        return this.getSQL();
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeIndex(this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw DbException.throwInternalError();
    }

    @Override
    public int getLookupCost(long l) {
        return 2;
    }

    @Override
    public long getCostRangeIndex(int[] nArray, long l) {
        long l2 = l += 1000L;
        long l3 = l;
        int n = 0;
        for (int i = 0; nArray != null && i < this.columns.length; ++i) {
            long l4;
            Column column = this.columns[i];
            int n2 = column.getColumnId();
            int n3 = nArray[n2];
            if ((n3 & 1) == 1) {
                if (i == this.columns.length - 1 && this.getIndexType().isUnique()) {
                    l2 = this.getLookupCost(l) + 1;
                    break;
                }
                l4 = l * (long)(n = 100 - (100 - n) * (100 - column.getSelectivity()) / 100) / 100L;
                if (l4 <= 0L) {
                    l4 = 1L;
                }
            } else {
                if ((n3 & 6) == 6) {
                    l2 = (long)this.getLookupCost(l) + l3 / 4L;
                    break;
                }
                if ((n3 & 2) == 2) {
                    l2 = (long)this.getLookupCost(l) + l3 / 3L;
                    break;
                }
                if ((n3 & 4) != 4) break;
                l2 = l3 / 3L;
                break;
            }
            l3 = Math.max(l / l4, 1L);
            l2 = (long)this.getLookupCost(l) + l3;
        }
        return l2;
    }

    @Override
    public int compareRows(SearchRow searchRow, SearchRow searchRow2) {
        for (int i = 0; i < this.indexColumns.length; ++i) {
            int n = this.columnIds[i];
            Value value = searchRow2.getValue(n);
            if (value == null) {
                return 0;
            }
            int n2 = this.compareValues(searchRow.getValue(n), value, this.indexColumns[i].sortType);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public boolean containsNullAndAllowMultipleNull(SearchRow searchRow) {
        Mode mode = this.database.getMode();
        if (mode.uniqueIndexSingleNull) {
            return false;
        }
        if (mode.uniqueIndexSingleNullExceptAllColumnsAreNull) {
            for (int n : this.columnIds) {
                Value value = searchRow.getValue(n);
                if (value == ValueNull.INSTANCE) continue;
                return false;
            }
            return true;
        }
        for (int n : this.columnIds) {
            Value value = searchRow.getValue(n);
            if (value != ValueNull.INSTANCE) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareKeys(SearchRow searchRow, SearchRow searchRow2) {
        long l;
        long l2 = searchRow.getKey();
        if (l2 == (l = searchRow2.getKey())) {
            if (this.isMultiVersion) {
                int n = searchRow.getVersion();
                int n2 = searchRow2.getVersion();
                return MathUtils.compareInt(n2, n);
            }
            return 0;
        }
        return l2 > l ? 1 : -1;
    }

    private int compareValues(Value value, Value value2, int n) {
        boolean bl;
        boolean bl2 = value == null;
        boolean bl3 = bl = value2 == null;
        if (bl2 || bl) {
            if (bl2 == bl) {
                return 0;
            }
            return SortOrder.compareNull(bl2, bl, n);
        }
        int n2 = this.table.compareTypeSave(value, value2);
        if ((n & 1) != 0) {
            n2 = -n2;
        }
        return n2;
    }

    @Override
    public int getColumnIndex(Column column) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] != column) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getColumnListSQL() {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (IndexColumn indexColumn : this.indexColumns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        return statementBuilder.toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        stringBuilder.append(this.indexType.getSQL());
        stringBuilder.append(' ');
        if (this.table.isHidden()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(string);
        stringBuilder.append(" ON ").append(table.getSQL());
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append('(').append(this.getColumnListSQL()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    @Override
    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void commit(int n, Row row) {
    }

    void setMultiVersion(boolean bl) {
        this.isMultiVersion = bl;
    }

    @Override
    public Row getRow(Session session, long l) {
        throw DbException.getUnsupportedException(this.toString());
    }

    @Override
    public boolean isHidden() {
        return this.table.isHidden();
    }
}

