/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.indexer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.solr.common.SolrException;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.solr.IndexDocument;

public class MSWordIndexer
implements Indexer {
    public static final Log log = LogFactory.getLog(MSWordIndexer.class);

    @Override
    public IndexDocument getIndexedDocument(AsyncIndexer.File2Index fileData) throws SolrException {
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new ByteArrayInputStream(fileData.data));
            WordExtractor extractor = new WordExtractor(fs);
            String wordText = extractor.getText();
            return new IndexDocument(fileData.path, wordText, null);
        }
        catch (IOException e) {
            String msg = "Failed to write to the index";
            log.error((Object)msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
    }
}

