/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSString;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdmodel.common.COSObjectable;

public class COSArray
extends COSBase {
    private List objects = new ArrayList();

    public void add(COSBase object) {
        this.objects.add(object);
    }

    public void add(COSObjectable object) {
        this.objects.add(object.getCOSObject());
    }

    public void add(int i, COSBase object) {
        this.objects.add(i, object);
    }

    public void clear() {
        this.objects.clear();
    }

    public void removeAll(Collection objectsList) {
        this.objects.removeAll(objectsList);
    }

    public void retainAll(Collection objectsList) {
        this.objects.retainAll(objectsList);
    }

    public void addAll(Collection objectsList) {
        this.objects.addAll(objectsList);
    }

    public void addAll(COSArray objectList) {
        if (objectList != null) {
            this.objects.addAll(objectList.objects);
        }
    }

    public void addAll(int i, Collection objectList) {
        this.objects.addAll(i, objectList);
    }

    public void set(int index, COSBase object) {
        this.objects.set(index, object);
    }

    public void set(int index, int intVal) {
        this.objects.set(index, new COSInteger(intVal));
    }

    public void set(int index, COSObjectable object) {
        COSBase base = null;
        if (object != null) {
            base = object.getCOSObject();
        }
        this.objects.set(index, base);
    }

    public COSBase getObject(int index) {
        Object obj = this.objects.get(index);
        if (obj instanceof COSObject) {
            obj = ((COSObject)obj).getObject();
        }
        if (obj instanceof COSNull) {
            obj = null;
        }
        return (COSBase)obj;
    }

    public COSBase get(int index) {
        return (COSBase)this.objects.get(index);
    }

    public int getInt(int index) {
        return this.getInt(index, -1);
    }

    public int getInt(int index, int defaultValue) {
        COSNumber number;
        int retval = defaultValue;
        if (defaultValue < this.size() && (number = (COSNumber)this.get(index)) != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public void setInt(int index, int value) {
        this.set(index, new COSInteger(value));
    }

    public void setName(int index, String name) {
        this.set(index, COSName.getPDFName(name));
    }

    public String getName(int index) {
        return this.getName(index, null);
    }

    public String getName(int index, String defaultValue) {
        COSName name;
        String retval = defaultValue;
        if (index < this.size() && (name = (COSName)this.get(index)) != null) {
            retval = name.getName();
        }
        return retval;
    }

    public void setString(int index, String string) {
        this.set(index, new COSString(string));
    }

    public String getString(int index) {
        return this.getString(index, null);
    }

    public String getString(int index, String defaultValue) {
        COSString string;
        String retval = defaultValue;
        if (index < this.size() && (string = (COSString)this.get(index)) != null) {
            retval = string.getString();
        }
        return retval;
    }

    public int size() {
        return this.objects.size();
    }

    public COSBase remove(int i) {
        return (COSBase)this.objects.remove(i);
    }

    public boolean remove(COSBase o) {
        return this.objects.remove(o);
    }

    public String toString() {
        return "COSArray{" + this.objects + "}";
    }

    public Iterator iterator() {
        return this.objects.iterator();
    }

    public int indexOf(COSBase object) {
        int retval = -1;
        for (int i = 0; retval < 0 && i < this.size(); ++i) {
            if (!this.get(i).equals(object)) continue;
            retval = i;
        }
        return retval;
    }

    public void growToSize(int size) {
        this.growToSize(size, null);
    }

    public void growToSize(int size, COSBase object) {
        while (this.size() < size) {
            this.add(object);
        }
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromArray(this);
    }

    public float[] toFloatArray() {
        float[] retval = new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            retval[i] = ((COSNumber)this.getObject(i)).floatValue();
        }
        return retval;
    }

    public void setFloatArray(float[] value) {
        this.clear();
        for (int i = 0; i < value.length; ++i) {
            this.add(new COSFloat(value[i]));
        }
    }
}

