/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv.bean;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;

public class HeaderColumnNameMappingStrategy
implements MappingStrategy {
    protected String[] header;
    protected PropertyDescriptor[] descriptors;
    protected Class type;

    public void captureHeader(CSVReader reader) throws IOException {
        this.header = reader.readNext();
    }

    public PropertyDescriptor findDescriptor(int col) throws IntrospectionException {
        String columnName = this.getColumnName(col);
        return null != columnName && columnName.trim().length() > 0 ? this.findDescriptor(columnName) : null;
    }

    protected String getColumnName(int col) {
        return null != this.header && col < this.header.length ? this.header[col] : null;
    }

    protected PropertyDescriptor findDescriptor(String name) throws IntrospectionException {
        if (null == this.descriptors) {
            this.descriptors = this.loadDescriptors(this.getType());
        }
        for (int i = 0; i < this.descriptors.length; ++i) {
            PropertyDescriptor desc = this.descriptors[i];
            if (!this.matches(name, desc)) continue;
            return desc;
        }
        return null;
    }

    protected boolean matches(String name, PropertyDescriptor desc) {
        return desc.getName().equals(name);
    }

    protected PropertyDescriptor[] loadDescriptors(Class cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        return beanInfo.getPropertyDescriptors();
    }

    public Object createBean() throws InstantiationException, IllegalAccessException {
        return this.type.newInstance();
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }
}

